/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.settings;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.AColor;
import com.sigrity.acl.AMutableReference;
import com.sigrity.acl.MutableBoolean;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.DbObjectRatio;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.ui.AContextMenu;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.APatternHelpButton;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.settings.SettingsPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class InterfacesPanel
extends JPanel
implements SettingsPanel {
    public static final String Name = "Interfaces";
    protected AddEditDelList<String> mLstPers = new AddEditDelList<String>(){
        {
            this.setCellRenderer(new DefaultListCellRenderer(){
                Color colorNormal;
                Color colorNone = null;
                Font fontNormal;
                Font fontNone;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object val, int idx, boolean isSel, boolean hasFocus) {
                    super.getListCellRendererComponent(list, val, idx, isSel, hasFocus);
                    if (this.colorNone == null) {
                        this.colorNormal = this.getForeground();
                        this.fontNormal = this.getFont();
                        this.colorNone = AColor.withAlpha((Color)this.colorNormal, (int)170);
                        this.fontNone = this.fontNormal.deriveFont(2);
                    }
                    boolean isNone = val instanceof String && ((String)val).isEmpty();
                    this.setForeground(isNone ? this.colorNone : this.colorNormal);
                    this.setFont(isNone ? this.fontNone : this.fontNormal);
                    this.setText((String)(isNone ? "<NONE>" : "" + val));
                    return this;
                }
            });
        }

        @Override
        String add() {
            return this.editor(null);
        }

        @Override
        String edit(String item) {
            return this.editor(item);
        }

        protected String editor(String editVal) {
            final JDialog dlg = new JDialog(UIUtil.getParentWindow((Component)InterfacesPanel.this));
            dlg.setTitle((editVal == null ? "Add" : "Edit") + " Default IO Personality Selector");
            GridBagManager l = GridBagManager.layout((JDialog)dlg);
            l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            l.add("Regex:");
            final JTextField txtRegex = new JTextField(25);
            txtRegex.setToolTipText("Pin personalities with names matching this regular expression will be added as IO personalities to new, top-level interfaces.");
            l.add((Component)txtRegex, (GridBagConstraints)GridBagManager.FILLX.insetRight(0));
            l.add((Component)new APatternHelpButton(), (GridBagConstraints)GridBagManager.LEFT.insetLeft(0));
            l.pop();
            l.newline();
            l.addFillY();
            JLabel lblStatus = l.add("Leave regex empty for <NONE>.");
            Font fontStatus = lblStatus.getFont();
            fontStatus = fontStatus.deriveFont(2);
            lblStatus.setFont(fontStatus);
            lblStatus.setForeground((Color)AColor.withAlpha((Color)lblStatus.getForeground(), (int)170));
            l.addFillX();
            JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            UIUtil.enableEscCloseDefaultMinSize((JDialog)dlg, (AbstractButton)btnCancel, (JButton)btnOk);
            dlg.pack();
            UIUtil.center((Component)dlg);
            final MutableBoolean ok = MutableBoolean.create((boolean)false);
            btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String regex = txtRegex.getText();
                    if (regex.isEmpty()) {
                        if (0 != JOptionPane.showConfirmDialog(txtRegex, "Do you want to add an entry for <NONE>?", "Confirm <NONE>", 0)) {
                            return;
                        }
                    } else {
                        try {
                            AFieldValidator.validateRegex((JTextComponent)txtRegex);
                        }
                        catch (AFieldValidator.AFieldValidationException e1) {
                            return;
                        }
                    }
                    Floorplan.updateDefaultIOPersonalitiesAndRatios((Db)OrbitIO.getCurDb());
                    ok.setValue(true);
                    UIUtil.closeWindow((Window)dlg);
                }
            });
            if (editVal != null) {
                txtRegex.setText(editVal);
            }
            dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            dlg.setVisible(true);
            return ok.getValue() ? txtRegex.getText() : null;
        }
    };
    protected AddEditDelList<String> mLstRatios = new AddEditDelList<String>(){
        protected JCheckBox mCbTolerance;
        protected JTextField mTxtTolerance;

        @Override
        String add() {
            return this.editor(null);
        }

        @Override
        String edit(String item) {
            return this.editor(item);
        }

        protected String editor(String editVal) {
            DbObjectRatio.RatioSpec rs;
            final JDialog dlg = new JDialog(UIUtil.getParentWindow((Component)InterfacesPanel.this));
            dlg.setTitle((editVal == null ? "Add" : "Edit") + " Default Personality Ratio");
            GridBagManager l = GridBagManager.layout((JDialog)dlg);
            l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            l.add("Selectors:");
            final JTextField txtRegexA = (JTextField)l.add((Component)new JTextField(25), (GridBagConstraints)GridBagManager.FILLX);
            l.add(":");
            final JTextField txtRegexB = (JTextField)l.add((Component)new JTextField(25), (GridBagConstraints)GridBagManager.FILLX.insetRight(0));
            l.add((Component)new APatternHelpButton(), (GridBagConstraints)GridBagManager.LEFT.insetLeft(0));
            l.newline();
            l.add("Ratio:");
            final JTextField txtRatioA = (JTextField)l.add((Component)new JTextField(5), (GridBagConstraints)GridBagManager.FILLX);
            l.add(":");
            final JTextField txtRatioB = (JTextField)l.add((Component)new JTextField(5), (GridBagConstraints)GridBagManager.FILLX);
            l.pop();
            l.newline();
            l.push((GridBagConstraints)GridBagManager.LEFT.noInsets());
            this.mCbTolerance = (JCheckBox)l.add((Component)new JCheckBox("Allow tolerance:"));
            this.mTxtTolerance = (JTextField)l.add((Component)new JTextField(5), (GridBagConstraints)GridBagManager.LEFT.insetRight(0));
            l.add("%", (GridBagConstraints)GridBagManager.LEFT);
            l.addFillY();
            l.pop();
            l.addFillY();
            JLabel lblStatus = l.add("Leave selector empty for <NONE>.");
            Font fontStatus = lblStatus.getFont();
            fontStatus = fontStatus.deriveFont(2);
            lblStatus.setFont(fontStatus);
            lblStatus.setForeground((Color)AColor.withAlpha((Color)lblStatus.getForeground(), (int)170));
            l.addFillX();
            JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            UIUtil.enableEscCloseDefaultMinSize((JDialog)dlg, (AbstractButton)btnCancel, (JButton)btnOk);
            dlg.pack();
            dlg.setMinimumSize(dlg.getPreferredSize());
            UIUtil.center((Component)dlg);
            this.mCbTolerance.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.enableControls();
                }
            });
            final AMutableReference result = new AMutableReference();
            btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (!txtRegexA.getText().isEmpty()) {
                            AFieldValidator.validateRegex((JTextComponent)txtRegexA);
                        }
                        if (!txtRegexB.getText().isEmpty()) {
                            AFieldValidator.validateRegex((JTextComponent)txtRegexB);
                        }
                        AFieldValidator.validateInt((JTextField)txtRatioA);
                        AFieldValidator.validateInt((JTextField)txtRatioB);
                        if (mTxtTolerance.isEnabled()) {
                            AFieldValidator.validateDouble((JTextField)mTxtTolerance);
                        }
                    }
                    catch (AFieldValidator.AFieldValidationException e1) {
                        return;
                    }
                    if ((txtRegexA.getText().isEmpty() || txtRegexB.getText().isEmpty()) && 0 != JOptionPane.showConfirmDialog(dlg, "Do you want to add a ratio for <NONE>?", "Confirm <NONE>", 0)) {
                        return;
                    }
                    DbObjectRatio.RatioSpec rs = new DbObjectRatio.RatioSpec(txtRegexA.getText(), txtRegexB.getText(), Integer.parseInt(txtRatioA.getText()), Integer.parseInt(txtRatioB.getText()), Double.valueOf(mTxtTolerance.isEnabled() ? Double.parseDouble(mTxtTolerance.getText()) : 0.0));
                    result.set((Object)rs.toString());
                    UIUtil.closeWindow((Window)dlg);
                }
            });
            if (editVal != null && (rs = DbObjectRatio.RatioSpec.fromString((String)editVal)) != null) {
                txtRegexA.setText(rs.getRegexA());
                txtRegexB.setText(rs.getRegexB());
                txtRatioA.setText("" + rs.getCountA());
                txtRatioB.setText("" + rs.getCountB());
                if (rs.getTolerance() == 0.0) {
                    this.mCbTolerance.setSelected(false);
                    this.mTxtTolerance.setText("");
                } else {
                    this.mCbTolerance.setSelected(true);
                    this.mTxtTolerance.setText("" + rs.getTolerance());
                }
            }
            this.enableControls();
            dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            dlg.setVisible(true);
            return (String)result.get();
        }

        protected void enableControls() {
            this.mTxtTolerance.setEnabled(this.mCbTolerance.isSelected());
        }
    };

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void load() {
        String name;
        String s;
        Settings settings = Settings.getSettings((String)"Floorplans");
        this.mLstPers.getData().clear();
        this.mLstRatios.getData().clear();
        LinkedList<String> data = new LinkedList<String>();
        int i = 0;
        while ((s = (String)settings.getSettingOfClass(name = String.format("IOPinPersonalityRegex%d", i), String.class)) != null) {
            data.add(s);
            ++i;
        }
        Collections.sort(data, AAlphaNumComp.get());
        for (String s2 : data) {
            this.mLstPers.getData().addElement(s2);
        }
        data.clear();
        i = 0;
        while ((s = (String)settings.getSettingOfClass(name = String.format("IOPinPersonalityRatio%d", i), String.class)) != null) {
            data.add(s);
            ++i;
        }
        Collections.sort(data, AAlphaNumComp.get());
        for (String s2 : data) {
            this.mLstRatios.getData().addElement(s2);
        }
    }

    @Override
    public boolean validateInput() {
        return true;
    }

    @Override
    public boolean save() {
        Settings settings = Settings.getSettings((String)"Floorplans");
        settings.removeAll(Settings.Type.User);
        Enumeration<String> persRegexs = this.mLstPers.getData().elements();
        int i = 0;
        while (persRegexs.hasMoreElements()) {
            String name = String.format("IOPinPersonalityRegex%d", i);
            settings.putSetting(name, (Object)persRegexs.nextElement());
            ++i;
        }
        Enumeration<String> persRatios = this.mLstRatios.getData().elements();
        int i2 = 0;
        while (persRatios.hasMoreElements()) {
            String name = String.format("IOPinPersonalityRatio%d", i2);
            settings.putSetting(name, (Object)persRatios.nextElement());
            ++i2;
        }
        settings.save();
        return true;
    }

    public InterfacesPanel() {
        GridBagManager l = GridBagManager.layout((Container)this);
        l.push("New Interface Defaults", (GridBagConstraints)GridBagManager.FILLALL_REMAINX.noInsets());
        Dimension listDim = new Dimension(50, 50);
        JPanel pnlPers = l.push((GridBagConstraints)GridBagManager.FILLALL.noInsets());
        l.add("IO personality selectors:", (GridBagConstraints)GridBagManager.LEFT.insetBottom(0));
        l.newline();
        ((JScrollPane)l.add((Component)new JScrollPane(this.mLstPers), (GridBagConstraints)GridBagManager.FILLALL)).setPreferredSize(listDim);
        l.push((GridBagConstraints)GridBagManager.TOPLEFT.noInsets());
        l.add((Component)UIUtil.makeTinyButton((Action)this.mLstPers.getActionAdd(), (String)"+", (String)"Add", (boolean)false), (GridBagConstraints)GridBagManager.FILLX.insetLeft(0).insetBottom(0));
        l.newline();
        l.add((Component)UIUtil.makeTinyButton((Action)this.mLstPers.getActionEdit(), (String)"\u270e", (String)"Edit", (boolean)false), (GridBagConstraints)GridBagManager.FILLX.insetLeft(0).insetBottom(0).insetTop(0));
        l.newline();
        l.add((Component)UIUtil.makeTinyButton((Action)this.mLstPers.getActionDelete(), (String)"-", (String)"Delete", (boolean)false), (GridBagConstraints)GridBagManager.FILLX.insetLeft(0).insetTop(0));
        l.pop();
        l.pop();
        JPanel pnlRatios = l.push((GridBagConstraints)GridBagManager.FILLALL.noInsets());
        l.add("Ratios:", (GridBagConstraints)GridBagManager.LEFT.insetBottom(0));
        l.newline();
        ((JScrollPane)l.add((Component)new JScrollPane(this.mLstRatios), (GridBagConstraints)GridBagManager.FILLALL)).setPreferredSize(listDim);
        l.push((GridBagConstraints)GridBagManager.TOPLEFT.noInsets());
        l.add((Component)UIUtil.makeTinyButton((Action)this.mLstRatios.getActionAdd(), (String)"+", (String)"Add", (boolean)false), (GridBagConstraints)GridBagManager.FILLX.insetLeft(0).insetBottom(0));
        l.newline();
        l.add((Component)UIUtil.makeTinyButton((Action)this.mLstRatios.getActionEdit(), (String)"\u270e", (String)"Edit", (boolean)false), (GridBagConstraints)GridBagManager.FILLX.insetLeft(0).insetBottom(0).insetTop(0));
        l.newline();
        l.add((Component)UIUtil.makeTinyButton((Action)this.mLstRatios.getActionDelete(), (String)"-", (String)"Delete", (boolean)false), (GridBagConstraints)GridBagManager.FILLX.insetLeft(0).insetTop(0));
        l.pop();
        l.pop();
        ASplitPane sp = new ASplitPane(1, (Component)pnlPers, (Component)pnlRatios){

            @Override
            public void addNotify() {
                super.addNotify();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.setDividerLocation(0.5);
                    }
                });
            }
        };
        l.add((Component)sp, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        sp.setBorder(null);
        l.pop();
    }

    protected abstract class AddEditDelList<T>
    extends JList<T> {
        protected Action mActionAdd = new AbstractAction("Add..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object newVal = AddEditDelList.this.add();
                if (newVal != null) {
                    DefaultListModel data = AddEditDelList.this.getData();
                    data.addElement(newVal);
                    int idx = data.getSize() - 1;
                    AddEditDelList.this.addSelectionInterval(idx, idx);
                    AddEditDelList.this.ensureIndexIsVisible(idx);
                }
            }
        };
        protected Action mActionEdit = new AbstractAction("Edit..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultListModel data = AddEditDelList.this.getData();
                for (int idx : AddEditDelList.this.getSelectedIndices()) {
                    Object item = data.get(idx);
                    Object newVal = AddEditDelList.this.edit(item);
                    if (newVal == null || newVal.equals(item)) continue;
                    data.set(idx, newVal);
                }
            }
        };
        protected Action mActionDelete = new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String confirmMsg;
                int[] indices = AddEditDelList.this.getSelectedIndices();
                if (indices.length > 1 && 0 != JOptionPane.showConfirmDialog(AddEditDelList.this, confirmMsg = String.format("Are you sure you want to delete %d items?", indices.length), "Confirm Delete", 0)) {
                    return;
                }
                DefaultListModel data = AddEditDelList.this.getData();
                for (int i = indices.length - 1; i >= 0; --i) {
                    data.remove(indices[i]);
                }
            }
        };
        protected Action mUpdateAllFloorplans = new AbstractAction("Update All Floorplans"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Floorplan.updateDefaultIOPersonalitiesAndRatios((Db)OrbitIO.getCurDb());
            }
        };

        protected AddEditDelList() {
            this.setModel(new DefaultListModel());
            this.setSelectionMode(2);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.event(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.event(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.event(e);
                }

                protected void event(final MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        new AContextMenu(){
                            {
                                int itemIdx = AddEditDelList.this.locationToIndex(e.getPoint());
                                if (itemIdx >= 0 && !AddEditDelList.this.isSelectedIndex(itemIdx)) {
                                    if ((e.getModifiers() & 2) == 0 && (e.getModifiers() & 1) == 0) {
                                        AddEditDelList.this.clearSelection();
                                    }
                                    AddEditDelList.this.addSelectionInterval(itemIdx, itemIdx);
                                }
                                this.add(AddEditDelList.this.mActionAdd);
                                this.add(AddEditDelList.this.mActionEdit);
                                this.add(AddEditDelList.this.mActionDelete);
                                this.add(AddEditDelList.this.mUpdateAllFloorplans);
                            }
                        }.show(e.getComponent(), e.getX(), e.getY());
                        e.consume();
                    } else if (e.getButton() == 1 && e.getClickCount() == 2) {
                        AddEditDelList.this.mActionEdit.actionPerformed(null);
                    }
                }
            });
            this.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    AddEditDelList.this.enabledActions();
                }
            });
            this.enabledActions();
        }

        abstract T add();

        abstract T edit(T var1);

        public DefaultListModel<T> getData() {
            return (DefaultListModel)this.getModel();
        }

        public Action getActionAdd() {
            return this.mActionAdd;
        }

        public Action getActionEdit() {
            return this.mActionEdit;
        }

        public Action getActionDelete() {
            return this.mActionDelete;
        }

        public Action getActionUpdateAllFloorplans() {
            return this.mUpdateAllFloorplans;
        }

        protected void enabledActions() {
            int selected = this.getSelectedValuesList().size();
            this.mActionEdit.setEnabled(selected == 1);
            this.mActionDelete.setEnabled(selected > 0);
        }
    }
}

