/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.settings;

import com.sigrity.acl.APlatformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.platform.ConfigJvmArgs;
import com.sigrity.acl.ui.ADocumentListener;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.ui.settings.SettingsPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.text.DecimalFormat;
import java.util.Optional;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public class JvmArgumentsPanel
extends JPanel
implements SettingsPanel {
    protected MaxMemorySelector mMaxMem;
    protected JCheckBox mCbDisableGfxAccel = null;

    protected JvmArgumentsPanel() {
        GridBagManager l = GridBagManager.layout((Container)this);
        this.mMaxMem = (MaxMemorySelector)l.addNl((Component)new MaxMemorySelector(), (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
        if (APlatformUtil.isWindowsPlatform()) {
            this.mCbDisableGfxAccel = (JCheckBox)l.addNl((Component)new JCheckBox("Enable graphics acceleration"), (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
            this.mCbDisableGfxAccel.setToolTipText("<html>Enabling accleration can significantly enhance drawing performance but may cause display issues.<br>Please verify that the latest display drivers are installed.");
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void load() {
        this.mMaxMem.loadData();
        if (this.mCbDisableGfxAccel != null) {
            this.mCbDisableGfxAccel.setSelected(ConfigJvmArgs.getConfiguredWinGfxD3d().orElse(true));
        }
    }

    @Override
    public boolean validateInput() {
        try {
            this.mMaxMem.validateData();
            return true;
        }
        catch (AFieldValidator.AFieldValidationException e) {
            return false;
        }
    }

    @Override
    public boolean save() {
        if (!this.mMaxMem.saveData()) {
            return false;
        }
        if (this.mCbDisableGfxAccel != null) {
            Optional newUserVal;
            boolean newVal = this.mCbDisableGfxAccel.isSelected();
            Optional curNonUserVal = ConfigJvmArgs.getConfiguredWinGfxD3dNonUser();
            Optional<Object> optional = curNonUserVal.isPresent() ? ((Boolean)curNonUserVal.get() == newVal ? Optional.empty() : Optional.of(newVal)) : (newUserVal = newVal ? Optional.empty() : Optional.of(newVal));
            if (!ConfigJvmArgs.setConfiguredWinGfxD3dUser(newUserVal)) {
                return false;
            }
        }
        return true;
    }

    public static int getMemMinLimit() {
        return 256;
    }

    public static int getMemMaxLimit() {
        switch (APlatformUtil.getDataModel()) {
            case _32: {
                return 4096;
            }
        }
        return 0x400000;
    }

    public static int getMemWarnLimit() {
        switch (APlatformUtil.getDataModel()) {
            case _32: {
                return 2048;
            }
        }
        return 65536;
    }

    public static String formatMemSizeUser(int mb) {
        DecimalFormat df = new DecimalFormat("#.##");
        if (mb > 0x100000) {
            return String.format("%sTB", df.format((double)mb / 1048576.0));
        }
        if (mb > 1024) {
            return String.format("%sGB", df.format((double)mb / 1024.0));
        }
        return String.format("%dMB", mb);
    }

    protected static class MaxMemorySelector
    extends JPanel {
        protected JCheckBox mCbSetMaxMem;
        protected JTextField mTxtVal;
        protected JLabel mLblMsg;

        public MaxMemorySelector() {
            GridBagManager l = new GridBagManager((Container)this);
            this.mCbSetMaxMem = (JCheckBox)l.add((Component)new JCheckBox("Specify available memory:"), (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
            this.mTxtVal = (JTextField)l.add((Component)new JTextField(6), (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
            l.addFillX();
            l.newline();
            this.mLblMsg = (JLabel)l.add((Component)new JLabel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX.indent().insetTop(0));
            Font msgFont = this.mLblMsg.getFont();
            this.mLblMsg.setFont(msgFont.deriveFont(2, msgFont.getSize2D() - 2.0f));
            this.mCbSetMaxMem.setToolTipText("<html>Deslect to use a default maximum memory value, select to specify the maximum amount of memory the application can use.");
            this.mTxtVal.setToolTipText("<html>The maximum amount of memory available to the application.<br>Setting this value larger than available physical memory can result in slow performance.<br>Setting it too small can result in out-of-memory errors.");
            this.mCbSetMaxMem.addActionListener(e -> this.update());
            this.mTxtVal.getDocument().addDocumentListener((DocumentListener)ADocumentListener.create(e -> this.update()));
            this.setMinimumSize(this.getPreferredSize());
            this.setValue(0);
            this.update();
        }

        public void loadData() {
            this.setValue(ConfigJvmArgs.getConfiguredMaxMemUser().orElse(0));
        }

        public boolean saveData() {
            try {
                this.validateData();
            }
            catch (AFieldValidator.AFieldValidationException e) {
                return false;
            }
            ConfigJvmArgs.setConfiguredMaxMemUser((int)this.getValue());
            return true;
        }

        protected void setValue(int size) {
            this.mCbSetMaxMem.setSelected(size > 0);
            if (size > 0) {
                this.mTxtVal.setText("" + size);
            }
        }

        protected int getValue() {
            if (!this.mCbSetMaxMem.isSelected()) {
                return 0;
            }
            String txt = this.mTxtVal.getText();
            Integer i = AUtil.parseInt((String)txt);
            if (i == null || i < 0) {
                return 0;
            }
            return i;
        }

        protected void update() {
            boolean updateEnabled;
            boolean enabled = this.mCbSetMaxMem.isSelected();
            boolean bl = updateEnabled = enabled != this.mTxtVal.isEnabled();
            if (updateEnabled) {
                this.mTxtVal.setEnabled(enabled);
            }
            if (enabled) {
                String enteredVal = this.mTxtVal.getText();
                if (enteredVal.trim().isEmpty()) {
                    this.setMsg("Specify maximum application memory in MB");
                } else {
                    try {
                        String verifiedVal = AFieldValidator.validateInt((String)enteredVal, (int)JvmArgumentsPanel.getMemMinLimit(), (int)JvmArgumentsPanel.getMemMaxLimit());
                        String memDesc = JvmArgumentsPanel.formatMemSizeUser(Integer.parseInt(verifiedVal));
                        this.setMsg(String.format("Maximum memory: %s", memDesc));
                    }
                    catch (AFieldValidator.AFieldValidationException fve) {
                        this.setMsg(fve.getMessage());
                    }
                }
            } else {
                this.setMsg("Maximum memory will be set based on system configuration");
            }
            if (updateEnabled && !enabled && !ConfigJvmArgs.getConfiguredMaxMemUser().isPresent()) {
                ConfigJvmArgs.getConfiguredMaxMem().ifPresent(nonUserVal -> this.mTxtVal.setText("" + nonUserVal));
            }
        }

        protected void setMsg(String text) {
            text = text == null || text.trim().isEmpty() ? "" : text;
            this.mLblMsg.setText(text);
            this.mLblMsg.setVisible(!text.isEmpty());
        }

        public void validateData() throws AFieldValidator.AFieldValidationException {
            if (this.mCbSetMaxMem.isSelected()) {
                AFieldValidator.validateInt((JTextField)this.mTxtVal, (int)JvmArgumentsPanel.getMemMinLimit(), (int)JvmArgumentsPanel.getMemMaxLimit());
            }
        }
    }

    public static class Factory
    implements SettingsPanel.Factory {
        @Override
        public String getName() {
            return "JVM Startup";
        }

        @Override
        public SettingsPanel createPanel() {
            return new JvmArgumentsPanel();
        }
    }
}

