/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.settings;

import com.google.common.collect.HashBiMap;
import com.sigrity.acl.ALog;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AImageIcon;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.settings.AddInsPanel;
import com.sigrity.orbit.ui.settings.DesignPanel;
import com.sigrity.orbit.ui.settings.DisplayPanel;
import com.sigrity.orbit.ui.settings.EnvUI;
import com.sigrity.orbit.ui.settings.GeneralPanel;
import com.sigrity.orbit.ui.settings.SettingsPanel;
import com.sigrity.orbit.ui.settings.UserInterfacePanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class SettingsUI {
    protected static ArrayList<SettingsPanel.Factory> gPanelFactories = new ArrayList();

    private SettingsUI() {
    }

    public static boolean register(SettingsPanel.Factory f) {
        return gPanelFactories.add(f);
    }

    public static boolean deregister(SettingsPanel.Factory f) {
        return gPanelFactories.remove(f);
    }

    public static void showSettingsDialog(Window owner) {
        SettingsUI.showSettingsDialog(owner, null);
    }

    public static void showSettingsDialog(Window owner, String panelName) {
        SettingsDialog dlg = new SettingsDialog(owner);
        SwingUtilities.invokeLater(() -> dlg.mSettingsPanel.selectPanel(panelName));
        dlg.setVisible(true);
    }

    static {
        SettingsUI.register(new GeneralPanel.Factory());
        SettingsUI.register(new UserInterfacePanel.Factory());
        SettingsUI.register(new DesignPanel.Factory());
        SettingsUI.register(new DisplayPanel.Factory());
        SettingsUI.register(new AddInsPanel.Factory());
        SettingsUI.register(new EnvUI.Factory());
    }

    protected static class SettingsDialog
    extends ADialog {
        protected SettingsMainPanel mSettingsPanel = new SettingsMainPanel();

        public SettingsDialog(Window owner) {
            super(owner, "Preferences");
            this.setModal(true);
            this.setIconImage(new AImageIcon(OrbitIO.getIconFile().getPath()).getImage());
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.addNl((Component)this.mSettingsPanel, (GridBagConstraints)GridBagManager.FILLALL);
            l.newline();
            l.pushFillX();
            JButton btnDetail = new JButton();
            btnDetail.setIcon(OrbitIcons.COG);
            btnDetail.setOpaque(false);
            btnDetail.setContentAreaFilled(false);
            btnDetail.setBorderPainted(false);
            UIUtil.makeSmallButton((JButton)btnDetail);
            btnDetail.addActionListener(e -> {
                try {
                    Desktop.getDesktop().open(Settings.getUserConfDir());
                }
                catch (IOException err) {
                    ALog.logError((Throwable)err, (String)"Cannot open setting directory.", (Object[])new Object[0]);
                }
            });
            l.add((Component)btnDetail, (GridBagConstraints)GridBagManager.LEFT);
            l.addFillX();
            JButton btnOk = new JButton("OK");
            l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
            btnOk.addActionListener(new OkListener());
            JButton btnCancel = new JButton("Cancel");
            l.add((Component)btnCancel, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            this.setSize(800, 600);
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
            UIUtil.center((Component)((Object)this));
            this.setResizable(false);
            this.mSettingsPanel.readSettings();
        }

        public void selectPanel(String name) {
            this.mSettingsPanel.selectPanel(name);
        }

        protected class OkListener
        implements ActionListener {
            protected OkListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SettingsDialog.this.mSettingsPanel.writeSettings()) {
                    return;
                }
                UIUtil.closeWindow((Window)((Object)SettingsDialog.this));
            }
        }
    }

    protected static class SettingsMainPanel
    extends JPanel {
        protected ArrayList<SettingsPanel> mPanels = new ArrayList();
        protected HashBiMap<SettingsPanel, String> mPanel2Name = HashBiMap.create();
        protected JList<String> mSettingList;
        protected JPanel mSettingViewPort;
        protected CardLayout mCard = new CardLayout();
        protected JScrollPane mRight;

        public SettingsMainPanel() {
            GridBagManager l = GridBagManager.layout((Container)this);
            DefaultListModel<String> model = new DefaultListModel<String>();
            this.mSettingList = new JList(model);
            this.mSettingList.setSelectedIndex(0);
            this.mSettingList.addListSelectionListener(e -> this.selectPanel(this.mSettingList.getSelectedValue()));
            this.mSettingViewPort = new JPanel();
            this.mSettingViewPort.setLayout(this.mCard);
            JScrollPane left = new JScrollPane(this.mSettingList);
            this.mRight = new JScrollPane(this.mSettingViewPort);
            JSplitPane split = new JSplitPane(1, left, this.mRight);
            split.setDividerLocation(100);
            l.add((Component)split, (GridBagConstraints)GridBagManager.FILLALL);
            for (SettingsPanel.Factory pf : gPanelFactories) {
                SettingsPanel p = pf.createPanel();
                this.mPanels.add(p);
                this.mPanel2Name.put((Object)p, (Object)pf.getName());
                model.addElement(pf.getName());
                this.mSettingViewPort.add(p.getComponent(), pf.getName());
            }
        }

        public boolean writeSettings() {
            if (!this.validateInput()) {
                return false;
            }
            for (SettingsPanel p : this.mPanels) {
                if (p.save()) continue;
                String msg = String.format("Error saving %s settings.", this.mPanel2Name.get((Object)p));
                JOptionPane.showMessageDialog(this, msg, "Error Saving Preferences", 0);
                return false;
            }
            OrbitIO oio = OrbitIO.getApp();
            if (oio != null) {
                oio.refreshAllViews();
            }
            return true;
        }

        public boolean validateInput() {
            for (SettingsPanel p : this.mPanels) {
                if (p.validateInput()) continue;
                return false;
            }
            return true;
        }

        protected void readSettings() {
            for (SettingsPanel p : this.mPanels) {
                p.load();
            }
        }

        public void selectPanel(String name) {
            if (name == null) {
                name = gPanelFactories.get(0).getName();
            }
            for (SettingsPanel.Factory pf : gPanelFactories) {
                if (!name.equalsIgnoreCase(pf.getName())) continue;
                this.mCard.show(this.mSettingViewPort, pf.getName());
                for (Component child : this.mSettingViewPort.getComponents()) {
                    child.invalidate();
                }
                this.mSettingViewPort.validate();
            }
            this.mRight.getVerticalScrollBar().setValue(0);
            this.validate();
        }
    }
}

