/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.settings;

import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.ui.AButtonGroup;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.NetFilters;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.OrbitIOSettings;
import com.sigrity.orbit.ui.DesignCanvasInfoDisplay;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.settings.SettingsPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;

public class UserInterfacePanel
implements SettingsPanel {
    protected JPanel mPanel = null;
    protected AButtonGroup mBgStartupDir = new AButtonGroup();
    protected JRadioButton mRbStartHome;
    protected JRadioButton mRbStartCurrent;
    protected JRadioButton mRbStartSpecified;
    protected AFileChooserControl mFcStartDir;
    protected JRadioButton mRbDfltHierLevelsAllSubstrates;
    protected JRadioButton mRbDfltHierLevelsSpecifyCount;
    protected JTextField mTxtDfltDevHierLevelCount;
    protected JCheckBox mCbRestoreLastZoom;
    protected JCheckBox mCbEnableSpotlights;
    protected JCheckBox mCbEnableDrawDynConns;
    protected JCheckBox mCbEnableFixBlurryCanvas;
    protected JCheckBox mEnableTabsInPersonalityEditor;
    protected JComboBox<String> mCboDefaultCanvasInfoDisplay;
    protected JComboBox<DeviceTemplate.NetFilter> mCboDefaultNetFilter;
    protected JCheckBox mCbFloatWindowsDefaultPinned;
    protected JCheckBox mCbDboDtlsHideNullHardFields;
    protected JSlider mSlideMouseWheelZoomSpeed;
    protected ActionListener mStartDirChangeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            UserInterfacePanel.this.enableControls();
        }
    };
    protected ActionListener mDfltLevelsChangeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            UserInterfacePanel.this.mTxtDfltDevHierLevelCount.setEnabled(UserInterfacePanel.this.mRbDfltHierLevelsSpecifyCount.isSelected());
        }
    };

    @Override
    public Component getComponent() {
        if (this.mPanel != null) {
            return this.mPanel;
        }
        this.mPanel = new JPanel(){

            @Override
            public void addNotify() {
                super.addNotify();
                AbstractButton selButton = UserInterfacePanel.this.mBgStartupDir.getSelectedButton();
                if (selButton != null) {
                    selButton.requestFocus();
                }
            }
        };
        GridBagManager l = GridBagManager.layout((Container)this.mPanel);
        l.pushFillX("GUI Startup Directory");
        GridBagManager.GridBagConstraintsEx rbc = GridBagManager.LEFT.insets(GridBagManager.LEFT.insets.left, 0);
        this.mRbStartHome = new JRadioButton("Home Directory");
        this.mRbStartHome.setToolTipText(String.format("%s", System.getProperty("user.home")));
        l.addNl((Component)this.mRbStartHome, (GridBagConstraints)rbc);
        this.mRbStartCurrent = new JRadioButton("Working Directory");
        this.mRbStartCurrent.setToolTipText("Use the current working directory when the application is started");
        l.addNl((Component)this.mRbStartCurrent, (GridBagConstraints)rbc);
        this.mRbStartSpecified = new JRadioButton("Specified Directory:");
        this.mRbStartSpecified.setToolTipText("Start in the specified directory");
        l.addNl((Component)this.mRbStartSpecified, (GridBagConstraints)rbc);
        l.pushFillX();
        l.indent();
        this.mFcStartDir = new AFileChooserControl(true);
        l.add((Component)this.mFcStartDir, (GridBagConstraints)GridBagManager.FILLX);
        l.pop();
        this.mBgStartupDir.add(this.mRbStartHome);
        this.mBgStartupDir.add(this.mRbStartCurrent);
        this.mBgStartupDir.add(this.mRbStartSpecified);
        this.mRbStartHome.addActionListener(this.mStartDirChangeListener);
        this.mRbStartCurrent.addActionListener(this.mStartDirChangeListener);
        this.mRbStartSpecified.addActionListener(this.mStartDirChangeListener);
        l.popNl();
        l.pushFillX("Default Hierarchy Explorer Levels");
        this.mRbDfltHierLevelsAllSubstrates = (JRadioButton)l.add((Component)new JRadioButton("Show all substrates"), (GridBagConstraints)rbc.width(0));
        this.mRbDfltHierLevelsAllSubstrates.setToolTipText("Show all substrates by default in device hierarchy tree displays");
        l.newline();
        this.mRbDfltHierLevelsSpecifyCount = (JRadioButton)l.add((Component)new JRadioButton("Specified number of levels:"), (GridBagConstraints)rbc);
        this.mTxtDfltDevHierLevelCount = (JTextField)l.add((Component)new JTextField(2));
        l.addFillX();
        String tip = "Show the specified number of hierarchy levels by default in device hierarchy tree displays";
        this.mTxtDfltDevHierLevelCount.setToolTipText(tip);
        this.mRbDfltHierLevelsSpecifyCount.setToolTipText(tip);
        UIUtil.groupButtons((AbstractButton[])new AbstractButton[]{this.mRbDfltHierLevelsAllSubstrates, this.mRbDfltHierLevelsSpecifyCount});
        this.mRbDfltHierLevelsAllSubstrates.addActionListener(this.mDfltLevelsChangeListener);
        this.mRbDfltHierLevelsSpecifyCount.addActionListener(this.mDfltLevelsChangeListener);
        l.pop();
        l.newline();
        this.mCbRestoreLastZoom = (JCheckBox)l.add((Component)new JCheckBox("Restore last known zoom on design open"), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        l.newline();
        this.mCbEnableSpotlights = (JCheckBox)l.add((Component)new JCheckBox("Enable spotlights where applicable"), (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetTop(0));
        l.newline();
        this.mCbEnableDrawDynConns = (JCheckBox)l.add((Component)new JCheckBox("Enable drawing dynamic connections"), (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetTop(0));
        l.newline();
        this.mEnableTabsInPersonalityEditor = (JCheckBox)l.add((Component)new JCheckBox("Enable Tabs in Personality Editor"), (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetTop(0));
        l.newline();
        this.mCbFloatWindowsDefaultPinned = new JCheckBox("Pin floating windows by default");
        l.add((Component)this.mCbFloatWindowsDefaultPinned, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        this.mCbFloatWindowsDefaultPinned.setToolTipText("Should floating windows close automatically when they lose focus.");
        l.newline();
        this.mCbDboDtlsHideNullHardFields = new JCheckBox("Object details dialog hides null hard fields");
        l.add((Component)this.mCbDboDtlsHideNullHardFields, (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetTop(0));
        this.mCbDboDtlsHideNullHardFields.setToolTipText("Should the Details dialog hide hard fields containing null values by default.");
        l.newline();
        this.mCbEnableFixBlurryCanvas = new JCheckBox("Try to fix blurry canvas in HDPI environment");
        l.add((Component)this.mCbEnableFixBlurryCanvas, (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetTop(0));
        l.newline();
        l.add("Default Canvas Info View:");
        this.mCboDefaultCanvasInfoDisplay = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        this.mCboDefaultCanvasInfoDisplay.addItem(null);
        for (DesignCanvasInfoDisplay.Factory dcidf : DesignCanvasInfoDisplay.getRegistry().getFactories()) {
            this.mCboDefaultCanvasInfoDisplay.addItem(dcidf.getName());
        }
        this.mCboDefaultCanvasInfoDisplay.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    this.setText("<None>");
                } else {
                    this.setText(value.toString());
                }
                return this;
            }
        });
        l.newline();
        l.add("Default Net Filter:");
        this.mCboDefaultNetFilter = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        this.mCboDefaultNetFilter.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                DeviceTemplate.NetFilter nf = (DeviceTemplate.NetFilter)value;
                this.setText(nf.getName());
                this.setToolTipText(nf.getDescription());
                return this;
            }
        });
        for (DeviceTemplate.NetFilter nf : OrbitIO.getOrbitIO().getNetFilters()) {
            this.mCboDefaultNetFilter.addItem(nf);
        }
        l.newline();
        l.pushFillXRemainX();
        JLabel lblMouseWheelZoomSpeed = l.add("Mouse wheel zoom speed:");
        this.mSlideMouseWheelZoomSpeed = new JSlider(1, 100);
        this.mSlideMouseWheelZoomSpeed.setMajorTickSpacing(10);
        this.mSlideMouseWheelZoomSpeed.setMinorTickSpacing(2);
        this.mSlideMouseWheelZoomSpeed.setPaintTicks(true);
        l.add((Component)this.mSlideMouseWheelZoomSpeed, (GridBagConstraints)GridBagManager.FILLX);
        lblMouseWheelZoomSpeed.setLabelFor(this.mSlideMouseWheelZoomSpeed);
        l.newline();
        l.pop();
        l.addFillY();
        return this.mPanel;
    }

    @Override
    public void load() {
        int hierLevels;
        Settings appSettings = Settings.getSettings((String)"App");
        OrbitIOSettings.AppStartDir sd = (OrbitIOSettings.AppStartDir)appSettings.getSetting("GUIStartDir", (Object)OrbitIOSettings.AppStartDir.CWD);
        switch (sd) {
            case USERHOME: {
                this.mBgStartupDir.setSelected(this.mRbStartHome.getModel(), true);
                break;
            }
            case CWD: {
                this.mBgStartupDir.setSelected(this.mRbStartCurrent.getModel(), true);
                break;
            }
            case SPECIFIED: {
                this.mBgStartupDir.setSelected(this.mRbStartSpecified.getModel(), true);
            }
        }
        String dir = (String)appSettings.getSettingOfClass("GUIStartDirSpecified", String.class);
        if (dir != null) {
            this.mFcStartDir.setPath(dir);
        }
        Settings userPrefs = Settings.getSettings((String)"UserPreferences");
        this.mCbRestoreLastZoom.setSelected((Boolean)userPrefs.getSetting("RestoreLastDesignZoomOnOpen", (Object)true));
        this.mCbEnableSpotlights.setSelected((Boolean)userPrefs.getSetting("EnableSpotlights", (Object)false));
        this.mCbEnableDrawDynConns.setSelected((Boolean)userPrefs.getSetting("EnableDrawingDynamicConnections", (Object)true));
        this.mEnableTabsInPersonalityEditor.setSelected((Boolean)userPrefs.getSetting("EnableTabsInPersonalityEditor", (Object)true));
        this.mCbFloatWindowsDefaultPinned.setSelected((Boolean)userPrefs.getSetting("FloatWindowsDefaultPinned", (Object)true));
        this.mCbDboDtlsHideNullHardFields.setSelected((Boolean)userPrefs.getSetting("DboDetailsDlgHideNullHardFields", (Object)false));
        this.mCbEnableFixBlurryCanvas.setSelected((Boolean)userPrefs.getSetting("UserFixHDPI", (Object)false));
        String defNetFilter = (String)userPrefs.getSetting("DefaultNetFilter", (Object)NetFilters.DEFAULT.getName());
        if (defNetFilter != null) {
            this.mCboDefaultNetFilter.setSelectedItem(OrbitIO.getOrbitIO().getNetFilters().getFilter(defNetFilter));
        }
        this.mRbDfltHierLevelsAllSubstrates.setSelected((hierLevels = ((Integer)userPrefs.getSetting("DfltHiearchyExplorerLevels", (Object)-1)).intValue()) < 0);
        this.mRbDfltHierLevelsSpecifyCount.setSelected(hierLevels >= 0);
        if (hierLevels >= 0) {
            this.mTxtDfltDevHierLevelCount.setText("" + hierLevels);
        }
        float zoomSpeed = ((Float)userPrefs.getSetting("MouseWheelZoomSpeed", (Object)Float.valueOf(0.3f))).floatValue();
        double zsv = (double)zoomSpeed * 100.0;
        this.mSlideMouseWheelZoomSpeed.setValue((int)zsv);
        String dfltCanvasInfoDisplaNamey = null;
        DesignCanvasInfoDisplay.Registry registry = DesignCanvasInfoDisplay.getRegistry();
        DesignCanvasInfoDisplay.Factory dfltFactory = registry == null ? null : registry.getDefault();
        dfltCanvasInfoDisplaNamey = dfltFactory == null ? null : dfltFactory.getName();
        String dcidfName = (String)userPrefs.getSettingOfClass("DefaultCanvasDisplayInfo", String.class);
        if (dcidfName == null) {
            dcidfName = dfltCanvasInfoDisplaNamey;
        }
        DesignCanvasInfoDisplay.Factory dcidf = dcidfName == null ? null : DesignCanvasInfoDisplay.getRegistry().getByName(dcidfName);
        this.mCboDefaultCanvasInfoDisplay.setSelectedItem(dcidf == null ? null : dcidf.getName());
        this.enableControls();
        this.mDfltLevelsChangeListener.actionPerformed(null);
    }

    @Override
    public boolean validateInput() {
        try {
            if (this.mBgStartupDir.getSelectedButton() == this.mRbStartSpecified) {
                AFieldValidator.validateDirectoryExists((JTextField)this.mFcStartDir.getTextField());
            }
            if (this.mRbDfltHierLevelsSpecifyCount.isSelected()) {
                AFieldValidator.validateInt((JTextField)this.mTxtDfltDevHierLevelCount, (int)0, (int)Integer.MAX_VALUE);
            }
        }
        catch (AFieldValidator.AFieldValidationException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean save() {
        Settings appSettings = Settings.getSettings((String)"App");
        Settings userPrefs = Settings.getSettings((String)"UserPreferences");
        AbstractButton selStartDirBtn = this.mBgStartupDir.getSelectedButton();
        if (selStartDirBtn == this.mRbStartCurrent) {
            appSettings.putSetting("GUIStartDir", (Object)OrbitIOSettings.AppStartDir.CWD);
        } else if (selStartDirBtn == this.mRbStartHome) {
            appSettings.putSetting("GUIStartDir", (Object)OrbitIOSettings.AppStartDir.USERHOME);
        } else if (selStartDirBtn == this.mRbStartSpecified) {
            appSettings.putSetting("GUIStartDir", (Object)OrbitIOSettings.AppStartDir.SPECIFIED);
            appSettings.putSetting("GUIStartDirSpecified", (Object)this.mFcStartDir.getPath());
        }
        userPrefs.putSetting("RestoreLastDesignZoomOnOpen", (Object)this.mCbRestoreLastZoom.isSelected());
        userPrefs.putSetting("EnableSpotlights", (Object)this.mCbEnableSpotlights.isSelected());
        userPrefs.putSetting("EnableDrawingDynamicConnections", (Object)this.mCbEnableDrawDynConns.isSelected());
        userPrefs.putSetting("EnableTabsInPersonalityEditor", (Object)this.mEnableTabsInPersonalityEditor.isSelected());
        userPrefs.putSetting("FloatWindowsDefaultPinned", (Object)this.mCbFloatWindowsDefaultPinned.isSelected());
        userPrefs.putSetting("DboDetailsDlgHideNullHardFields", (Object)this.mCbDboDtlsHideNullHardFields.isSelected());
        userPrefs.putSetting("UserFixHDPI", (Object)this.mCbEnableFixBlurryCanvas.isSelected());
        AFloatWindow.setPinByDefault(this.mCbFloatWindowsDefaultPinned.isSelected());
        DeviceTemplate.NetFilter nf = (DeviceTemplate.NetFilter)this.mCboDefaultNetFilter.getSelectedItem();
        if (nf != null) {
            userPrefs.putSetting("DefaultNetFilter", (Object)nf.getName());
        }
        if (this.mRbDfltHierLevelsAllSubstrates.isSelected()) {
            userPrefs.putSetting("DfltHiearchyExplorerLevels", (Object)-1);
        } else {
            userPrefs.putSetting("DfltHiearchyExplorerLevels", (Object)AFieldValidator.getInt((JTextField)this.mTxtDfltDevHierLevelCount, (int)-1));
        }
        float speed = (float)this.mSlideMouseWheelZoomSpeed.getValue() / 100.0f;
        userPrefs.putSetting("MouseWheelZoomSpeed", (Object)Float.valueOf(speed));
        Object o = this.mCboDefaultCanvasInfoDisplay.getSelectedItem();
        if (o == null) {
            userPrefs.putSetting("DefaultCanvasDisplayInfo", (Object)"");
        } else {
            userPrefs.putSetting("DefaultCanvasDisplayInfo", (Object)o.toString());
        }
        appSettings.save();
        userPrefs.save();
        this.useImmediately();
        return true;
    }

    protected void useImmediately() {
        DesignCanvas2D.setAppFixBlurry(this.mCbEnableFixBlurryCanvas.isSelected());
    }

    protected void enableControls() {
        this.mFcStartDir.setEnabled(this.mRbStartSpecified.isSelected());
    }

    public static class Factory
    implements SettingsPanel.Factory {
        @Override
        public String getName() {
            return "User Interface";
        }

        @Override
        public SettingsPanel createPanel() {
            return new UserInterfacePanel();
        }
    }
}

