/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.shape_edit;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.ATextField;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.cmd.ShapeCommands;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.partitionTool.PartitionToolMode;
import com.sigrity.orbit.ui.shape_edit.ShapeEditMode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Optional;
import javax.swing.JButton;

public class DeviceShapeEditMode
extends ShapeEditMode<DeviceTemplate> {
    public static final String SettingsSection = DeviceShapeEditMode.class.getName();
    public static final String MODE_NAME = DeviceShapeEditMode.class.getSimpleName();
    ATextField mTxtName;

    public static DeviceShapeEditMode install(DesignView2D view) {
        DeviceShapeEditMode dse = new DeviceShapeEditMode();
        view.setMode(dse);
        return dse;
    }

    public static DeviceShapeEditMode startEdit(DesignView2D view, DevicePath path, boolean showOptionsUI) {
        if (view == null) {
            return null;
        }
        DeviceShapeEditMode dsem = new DeviceShapeEditMode();
        dsem.setShowOptionsUIOnInstall(showOptionsUI);
        view.setMode(dsem);
        dsem.setDevicePath(path);
        return dsem;
    }

    @Override
    public String getSettingsSection() {
        return SettingsSection;
    }

    @Override
    public String getModeName() {
        return MODE_NAME;
    }

    @Override
    public String getCreatedObjectName() {
        return "device";
    }

    @Override
    protected ShapeCommands.HierGeom<DeviceTemplate> findShape(APoint2D loc, boolean useCp) {
        long delta = this.getWorldLen(1);
        if (!useCp) {
            String devPath = this.mDevicePath == null ? null : this.mDevicePath.escapedString();
            ShapeCommands.HierGeom<DeviceTemplate> hgo = ShapeCommands.findDeviceTemplateShapeAtLoc(this.mView.getDb(), loc.getX(), loc.getY(), delta, devPath);
            return hgo;
        }
        String strDPath = this.mDevicePath == null ? "null" : String.format("\"%s\"", this.mDevicePath.escapedString());
        this.clearEditShape(false);
        ShapeCommands.HierGeom hgo = (ShapeCommands.HierGeom)Cp.exec((String)"iseShape = ShapeCommands.findDeviceTemplateShapeAtLoc(curDb(), %dL, %dL, %dL, %s)", (Object[])new Object[]{loc.getX(), loc.getY(), delta, strDPath});
        if (hgo instanceof ShapeCommands.HierGeom) {
            Cp.exec((String)"iseShape = iseShape.getOwnedGeom()", (Object[])new Object[0]);
            this.setDevicePath(hgo.getPath());
        }
        return hgo;
    }

    @Override
    protected ShapeCommands.HierGeom<DeviceTemplate> createOwnedGeom(AGeom geom) {
        ShapeCommands.OwnedGeom og;
        geom = geom.transform(this.mDevicePath.getInverseTransform());
        APoint2D anchor = AGeomUtil.normalizeOrigin((AGeom)geom);
        String anchorPtCmd = anchor.getAsStringArg();
        String geomCmd = geom.getAsStringArg();
        String name = this.mOptionsUI == null ? "" : this.mTxtName.getText();
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mView.getDb(), (String)"Create Shape");){
            Cp.exec((String)"unset(\"iseShape\")", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"iseOwner\")", (Object[])new Object[0]);
            Object iseOwner = Cp.exec((String)"iseOwner = ShapeCommands.createDevice(curDb(), \"%s\", \"%s\", %s, %s)", (Object[])new Object[]{this.mDevicePath.escapedString(), name, anchorPtCmd, geomCmd});
            if (iseOwner != null) {
                Cp.exec((String)"iseShape = ShapeCommands.DeviceTemplateGeom.create(iseOwner.getTemplate())", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"iseOwner\")", (Object[])new Object[0]);
            }
        }
        Object o = Cp.exec((boolean)false, (String)"iseShape", (Object[])new Object[0]);
        ShapeCommands.OwnedGeom ownedGeom = og = o instanceof ShapeCommands.OwnedGeom && ((ShapeCommands.OwnedGeom)o).getOwner() instanceof DeviceTemplate ? (ShapeCommands.OwnedGeom)o : null;
        if (og == null) {
            ALog.logError((Throwable)new RuntimeException(String.format("Unexpected command result %s", o)), (String)"Error creating LayerShape.", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"iseShape\")", (Object[])new Object[0]);
            return null;
        }
        return ShapeCommands.HierGeom.create(this.mDevicePath, og);
    }

    @Override
    protected ShapeEditMode.OptionsUI createOptionsUI() {
        return new ShapeEditMode.OptionsUI(){

            @Override
            protected void initUI() {
                DeviceShapeEditMode.this.mTxtName = this.createTextDisplay();
                super.initUI();
                this.setTitle("Device Shape Editing");
            }

            @Override
            protected void initOwnerOpts(GridBagManager l) {
                l.add("Name:", (GridBagConstraints)GridBagManager.LEFT);
                l.add((Component)DeviceShapeEditMode.this.mTxtName, (GridBagConstraints)GridBagManager.FILLX);
                DeviceShapeEditMode.this.mTxtName.addActionListener(e -> this.updateDeviceName());
                DeviceShapeEditMode.this.mTxtName.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        this.updateDeviceName();
                    }
                });
                l.newline();
            }

            @Override
            protected void loadFootOpts(GridBagManager l) {
                JButton btnPartition = new JButton("Partition");
                btnPartition.setIcon(OrbitIcons.PARTITION_TOOL);
                btnPartition.setToolTipText("Partition a device");
                btnPartition.addActionListener(e -> {
                    if (DeviceShapeEditMode.this.mDevicePath == null) {
                        ALog.logWarn((String)"Please select a device first!");
                    } else {
                        ALog.logInfo((String)"Selected devicepath:%s", (Object[])new Object[]{DeviceShapeEditMode.this.mDevicePath});
                        PartitionToolMode ptm = PartitionToolMode.newInstance(DeviceShapeEditMode.this.mDevicePath);
                        DeviceShapeEditMode.this.mView.setMode(ptm);
                    }
                });
                this.initCmdButton(btnPartition);
                l.add((Component)btnPartition);
            }

            @Override
            public void updateData() {
                super.updateData();
                Optional<Device> oDev = DeviceShapeEditMode.this.getDevice();
                String name = oDev.map(d -> d.getName()).orElse(null);
                if (name == null && DeviceShapeEditMode.this.mState instanceof ShapeEditMode.StateCreate) {
                    ShapeEditMode.StateCreate sc = (ShapeEditMode.StateCreate)DeviceShapeEditMode.this.mState;
                    name = ShapeCommands.getDeviceName(DeviceShapeEditMode.this.mDevicePath == null ? null : DeviceShapeEditMode.this.mDevicePath.getDeviceTemplate(), sc.mShapeType);
                }
                if (name == null) {
                    name = "";
                }
                this.updateText(DeviceShapeEditMode.this.mTxtName, name);
                DeviceShapeEditMode.this.mTxtName.setEditable(!name.isEmpty());
            }

            void updateDeviceName() {
                DeviceTemplate parentT;
                String uiName = DeviceShapeEditMode.this.mTxtName.getText();
                Device device = DeviceShapeEditMode.this.getDevice().orElse(null);
                DeviceTemplate deviceTemplate = parentT = DeviceShapeEditMode.this.mDevicePath == null ? null : DeviceShapeEditMode.this.mDevicePath.getDeviceTemplate();
                if (device != null) {
                    if (!uiName.isEmpty() && !uiName.equals(device.getName())) {
                        if (device.getParent().getChild(uiName) != null) {
                            DeviceShapeEditMode.this.mTxtName.setStatus(ATextField.IconError, "The specified name is already in use");
                        } else {
                            Cp.exec((String)"curDb().getByKeyStr(Device.class, \"%s\").setName(\"%s\")", (Object[])new Object[]{device.getKeyStr(), uiName});
                            DeviceShapeEditMode.this.mTxtName.clearStatus();
                        }
                    }
                } else if (parentT != null && parentT.getChild(uiName) != null) {
                    DeviceShapeEditMode.this.mTxtName.setStatus(ATextField.IconError, "The specified name is already in use");
                } else {
                    DeviceShapeEditMode.this.mTxtName.clearStatus();
                }
            }
        };
    }

    public Optional<Device> getDevice() {
        ShapeCommands.HierGeom hDevT = this.getEditHierShape();
        DevicePath path = hDevT == null ? null : hDevT.getPath();
        Device device = path == null ? null : path.getDevice();
        return Optional.ofNullable(device);
    }
}

