/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.shape_edit;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.cmd.ShapeCommands;
import com.sigrity.orbit.ui.LayerChooser;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.shape_edit.ShapeEditMode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JButton;
import javax.swing.JTextField;

public class ObstacleShapeEditMode
extends ShapeEditMode<Obstacle> {
    public static final String SettingsSection = ObstacleShapeEditMode.class.getName();
    public static final String MODE_NAME = ObstacleShapeEditMode.class.getSimpleName();
    protected Layer mLayer = null;

    public static ObstacleShapeEditMode install(DesignView2D view) {
        ObstacleShapeEditMode osem = new ObstacleShapeEditMode();
        view.setMode(osem);
        return osem;
    }

    public static ObstacleShapeEditMode startEdit(DesignView2D view, DevicePath path, LayerShape shape, boolean showOptionsUI) {
        if (view == null) {
            return null;
        }
        ObstacleShapeEditMode osem = new ObstacleShapeEditMode();
        osem.setShowOptionsUIOnInstall(showOptionsUI);
        view.setMode(osem);
        osem.setDevicePath(path);
        return osem;
    }

    @Override
    public String getSettingsSection() {
        return SettingsSection;
    }

    @Override
    public String getModeName() {
        return MODE_NAME;
    }

    @Override
    public String getCreatedObjectName() {
        return "obstacle";
    }

    @Override
    protected ShapeCommands.HierGeom<Obstacle> findShape(APoint2D loc, boolean useCp) {
        long delta = this.getWorldLen(1);
        if (!useCp) {
            return ShapeCommands.findObstacleShapeAtLoc(this.mView.getDb(), loc.getX(), loc.getY(), delta, this.mDevicePath == null ? null : "" + this.mDevicePath);
        }
        String strDPath = this.mDevicePath == null ? "null" : String.format("\"%s\"", this.mDevicePath);
        this.clearEditShape(false);
        ShapeCommands.HierGeom hgo = (ShapeCommands.HierGeom)Cp.exec((String)"iseShape = ShapeCommands.findObstacleShapeAtLoc(curDb(), %dL, %dL, %dL, %s)", (Object[])new Object[]{loc.getX(), loc.getY(), delta, strDPath});
        if (hgo instanceof ShapeCommands.HierGeom) {
            Cp.exec((String)"iseShape = iseShape.getOwnedGeom()", (Object[])new Object[0]);
            this.setDevicePath(hgo.getPath());
            this.setLayer(((ShapeCommands.ObstacleGeom)hgo.getOwnedGeom()).getLayer());
        }
        return hgo;
    }

    @Override
    protected ShapeCommands.HierGeom<Obstacle> createOwnedGeom(AGeom geom) {
        ShapeCommands.OwnedGeom og;
        geom = geom.transform(this.mDevicePath.getInverseTransform());
        String geomCmd = geom.getAsStringArg();
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mView.getDb(), (String)"Create Shape");){
            Cp.exec((String)"unset(\"iseShape\")", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"iseOwner\")", (Object[])new Object[0]);
            Cp.exec((String)"iseOwner = Obstacle.create(curDb(), Obstacle.ObstacleType.Routing,DevicePath.fromString(curDb(), \"%s\").getDeviceTemplate())", (Object[])new Object[]{this.mDevicePath.toString()});
            Cp.exec((String)"iseShape = ShapeCommands.createObstacleShape(curDb(), iseOwner, \"%s\", %s)", (Object[])new Object[]{this.mLayer.getKeyStr(), geomCmd});
            Cp.exec((String)"unset(\"iseOwner\")", (Object[])new Object[0]);
            DeviceTemplate devT = this.mDevicePath.getDeviceTemplate();
            try (OrbitApp.ChangeWarningSilencer cws = OrbitApp.suppressDbChangeMonitorWarnings();){
                devT.invalidateLayerIndex(this.mLayer);
            }
        }
        Object o = Cp.exec((boolean)false, (String)"iseShape", (Object[])new Object[0]);
        ShapeCommands.OwnedGeom ownedGeom = og = o instanceof ShapeCommands.OwnedGeom && ((ShapeCommands.OwnedGeom)o).getOwner() instanceof Obstacle ? (ShapeCommands.OwnedGeom)o : null;
        if (og == null) {
            ALog.logError((Throwable)new RuntimeException(String.format("Unexpected command result %s", o)), (String)"Error creating LayerShape.", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"iseShape\")", (Object[])new Object[0]);
            return null;
        }
        return ShapeCommands.HierGeom.create(this.mDevicePath, og);
    }

    @Override
    protected void resetShapeOptions() {
        super.resetShapeOptions();
        this.setLayer(null);
    }

    @Override
    public void setDevicePath(DevicePath path) {
        super.setDevicePath(path);
        this.validateSelectedLayer();
    }

    @Override
    protected AGeom createShapeStartingAtPt(Class<? extends AGeom> type, APoint2D pt) {
        if (this.mLayer == null && !this.selectLayer(true)) {
            return null;
        }
        return super.createShapeStartingAtPt(type, pt);
    }

    @Override
    protected ShapeEditMode.OptionsUI createOptionsUI() {
        return new ShapeEditMode.OptionsUI(){
            JTextField mTxtLayer;

            @Override
            protected void initUI() {
                super.initUI();
                this.setTitle("Obstacle Shape Editing");
            }

            @Override
            protected void initOwnerOpts(GridBagManager l) {
                l.add("Layer:", (GridBagConstraints)GridBagManager.LEFT);
                this.mTxtLayer = (JTextField)l.add((Component)this.createTextDisplay(), (GridBagConstraints)GridBagManager.FILLX);
                JButton btnChangeLayer = (JButton)l.add((Component)this.createChangeButton(), (GridBagConstraints)GridBagManager.LEFT);
                btnChangeLayer.addActionListener(e -> ObstacleShapeEditMode.this.selectLayer(false));
                l.newline();
            }

            @Override
            public void updateData() {
                super.updateData();
                String layerName = "";
                if (ObstacleShapeEditMode.this.mLayer != null) {
                    layerName = ObstacleShapeEditMode.this.mLayer.getName();
                }
                this.updateText(this.mTxtLayer, layerName);
            }
        };
    }

    public void setLayer(Layer layer) {
        this.mLayer = layer;
        this.updateOptionsUI();
        if (this.getEditHierShape() == null) {
            return;
        }
        ShapeCommands.ObstacleGeom obsGeom = (ShapeCommands.ObstacleGeom)this.getEditShape();
        if (layer != null && obsGeom.getLayer() != this.mLayer) {
            Cp.exec((String)"ShapeCommands.setObstacleShapeLayer(iseShape, \"%s\")", (Object[])new Object[]{layer.getKeyStr()});
            this.repaintView();
        }
    }

    protected boolean selectLayer(boolean auto) {
        Layer l;
        Substrate s = this.getSubstrate();
        if (s == null) {
            if (auto) {
                return false;
            }
            if (!this.selectDevice(null)) {
                return false;
            }
        }
        if ((s = this.getSubstrate()) == null) {
            return false;
        }
        if (auto) {
            for (Layer l2 : s.getLayers()) {
                if (l2.getType() != Layer.LayerType.Route) continue;
                this.setLayer(l2);
                return true;
            }
            for (Layer l2 : s.getLayers()) {
                switch (l2.getType()) {
                    case Mixed: 
                    case Power: 
                    case Signal: {
                        this.setLayer(l2);
                        return true;
                    }
                }
            }
        }
        if ((l = LayerChooser.getLayer(this.mView, s)) != null) {
            this.setLayer(l);
            return true;
        }
        return false;
    }

    protected boolean validateSelectedLayer() {
        if (this.mLayer == null) {
            return false;
        }
        Substrate s = this.getSubstrate();
        if (s == null) {
            return false;
        }
        if (this.mLayer.getSubstrate() == s) {
            return true;
        }
        this.setLayer(null);
        return false;
    }

    public void selectLoc(APoint2D worldLoc) {
        this.findShape(worldLoc, true);
    }
}

