/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.shape_edit;

import bsh.EvalError;
import com.sigrity.acl.AArrays;
import com.sigrity.acl.ABoolean;
import com.sigrity.acl.AColor;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AStream;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.AOctagon;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.APolyline;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.ATextField;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.cmd.ShapeCommands;
import com.sigrity.orbit.ui.AddVertexUI;
import com.sigrity.orbit.ui.DeviceChooser;
import com.sigrity.orbit.ui.GridChooser;
import com.sigrity.orbit.ui.GridOverlay;
import com.sigrity.orbit.ui.MoveEdgeUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.canvas_modes.SpotLight;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ShapeFactory;
import com.sigrity.orbit.ui.shape_edit.ShapeEditMode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public abstract class ShapeEditMode<T extends DbObject>
extends AbstractViewMode {
    public static final Icon ICON_SHAPE_EDIT = OrbitIcons.SHAPE_EDIT;
    public static final ShapeCommands.SnapAngle DefaultSnapAngle = ShapeCommands.SnapAngle.Orthogonal;
    final Color CURSOR_COLOR = Color.RED;
    final Color CURSOR_COLOR_XOR = Color.WHITE;
    final int CURSOR_LEG_SIZE = 7;
    final Color HIGHLIGHT_COLOR = Color.YELLOW;
    final Color DRAG_COLOR = Color.RED;
    final Color CANDIDATE_COLOR = AColor.withAlpha((Color)Color.WHITE, (int)128);
    final Color CANDIDATE_OUTLINE_COLOR = Color.WHITE;
    protected Stroke StrokeDash = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{4.0f, 3.0f}, 0.0f);
    protected int mOptionalSnappingDist = 32;
    protected OptionsUI mOptionsUI = null;
    protected Overlay mOverlay = null;
    protected DevicePath mDevicePath = null;
    protected NamedGrid mGrid = null;
    protected ShapeCommands.SnapAngle mSnapAngle = (ShapeCommands.SnapAngle)((Object)Settings.get((String)this.getSettingsSection(), (String)"SnapAngle", (Object)((Object)this.getDefaultSnapAngle())));
    protected boolean mShowOptionsUIOnInstall = true;
    protected DesignView2D.ViewMode mEditEndMode = null;
    protected OverlayPainter mPrePaint = null;
    protected OverlayPainter mPostPaint = null;
    protected State mDefaultState;
    protected State mState = null;
    protected APoint2D mCursorPt = null;
    protected JCheckBoxMenuItem mCbShowOptions;
    protected LinkedHashSet<EditListener<T>> mEditListeners = new LinkedHashSet();

    public abstract String getSettingsSection();

    public abstract String getModeName();

    public abstract String getCreatedObjectName();

    protected abstract ShapeCommands.HierGeom<T> findShape(APoint2D var1, boolean var2);

    protected abstract ShapeCommands.HierGeom<T> createOwnedGeom(AGeom var1);

    public ShapeEditMode() {
        this.mDefaultState = this.getDefaultState();
    }

    @Override
    public String getName() {
        return this.getModeName();
    }

    @Override
    public Cursor getCursor() {
        return UIUtil.createCursor((Icon)ICON_SHAPE_EDIT);
    }

    @Override
    public void installMode(DesignView2D view) {
        super.installMode(view);
        this.mOverlay = new Overlay(null);
        view.addOverlay(this.mOverlay);
        this.mOverlay.setCursor(this.getCursor());
        if (this.mShowOptionsUIOnInstall) {
            this.mOptionsUI = this.createOptionsUI();
        }
        Cp.exec((String)"import com.sigrity.orbit.cmd.ShapeCommands", (Object[])new Object[0]);
        this.setState(this.getDefaultState());
    }

    @Override
    public void uninstallMode() {
        this.setState(null);
        if (this.mOverlay != null) {
            this.mView.removeOverlay(this.mOverlay);
            this.mOverlay = null;
        }
        if (this.mOptionsUI != null) {
            UIUtil.closeWindow((Window)((Object)this.mOptionsUI));
        }
        super.uninstallMode();
    }

    public APoint2D getDeviceRelativePt(APoint2D worldPt) {
        if (this.mDevicePath == null) {
            return worldPt;
        }
        return worldPt.transform(ATransformUtil.inverse((AffineTransform)this.mDevicePath.getTransform()));
    }

    public ShapeCommands.OwnedGeom<T> getEditShape() {
        try {
            ShapeCommands.OwnedGeom ls = (ShapeCommands.OwnedGeom)Cp.getCp().getInterpreter().get("iseShape");
            if (ls != null && ls.getDb() != this.mView.getDb()) {
                this.clearEditShape(false);
                return null;
            }
            return ls;
        }
        catch (EvalError e) {
            ALog.logDebug((Throwable)e, (String)"Unexpected error getting current edit shape.", (Object[])new Object[0]);
            return null;
        }
    }

    public ShapeCommands.HierGeom<T> getEditHierShape() {
        ShapeCommands.OwnedGeom<T> ls = this.getEditShape();
        if (ls == null) {
            return null;
        }
        return new ShapeCommands.HierGeom<T>(this.mDevicePath, ls);
    }

    public void notifyEditShapeSet(ShapeCommands.OwnedGeom<T> w) {
        this.fireEditShapeChanged();
    }

    public void clearEditShape() {
        this.clearEditShape(true);
    }

    protected void clearEditShape(boolean checkIfSet) {
        if (!checkIfSet || this.getEditShape() != null) {
            Cp.exec((String)"unset(\"iseShape\")", (Object[])new Object[0]);
            this.fireEditShapeChanged();
        }
    }

    public int getMouseSensivityScreen() {
        return 8;
    }

    public long getMouseSensitivityWorld() {
        return this.getWorldLen(8);
    }

    public void setEndEditMode(DesignView2D.ViewMode mode) {
        this.mEditEndMode = mode;
    }

    public void setShowOptionsUIOnInstall(boolean b) {
        this.mShowOptionsUIOnInstall = b;
    }

    public void setPrePaint(OverlayPainter painter) {
        this.mPrePaint = painter;
    }

    public void setPostPaint(OverlayPainter painter) {
        this.mPostPaint = painter;
    }

    public void setDevicePath(DevicePath path) {
        if (this.mDevicePath != path) {
            this.mDevicePath = path;
            this.mOverlay.setDevicePath(path);
        }
        this.updateOptionsUI();
    }

    public void setGrid(NamedGrid g) {
        this.mGrid = g;
        this.mOverlay.setGrid(g);
        this.updateOptionsUI();
    }

    public ShapeCommands.SnapAngle getDefaultSnapAngle() {
        return DefaultSnapAngle;
    }

    public State getDefaultState() {
        if (this.mDefaultState == null) {
            StateFind stateFind = new StateFind();
            stateFind.setOnComplete(hlsSelected -> {
                StateEdit stateEdit = new StateEdit();
                stateEdit.setOnComplete(hlsc -> this.setState(stateFind));
                stateEdit.setOnCancel(() -> this.setState(stateFind));
                this.setState(stateEdit);
            });
            this.mDefaultState = stateFind;
        }
        return this.mDefaultState;
    }

    public State getCreateShapeState(String geomName, Class<? extends AGeom> geomType) {
        return new StateCreate(geomName, geomType);
    }

    protected void deleteEditShape() {
        ShapeCommands.OwnedGeom<T> ls = this.getEditShape();
        if (ls == null) {
            return;
        }
        Cp.exec((String)"ShapeCommands.deleteShape(iseShape)", (Object[])new Object[0]);
        this.resetShapeOptions();
    }

    protected void resetShapeOptions() {
        this.setGrid(null);
        this.setDevicePath(null);
        this.clearEditShape();
        this.setState(this.getDefaultState());
        this.updateOptionsUI();
    }

    protected void updateOptionsUI() {
        if (this.mOptionsUI != null) {
            this.mOptionsUI.updateData();
        }
    }

    protected Substrate getSubstrate() {
        if (this.mDevicePath != null && !this.mDevicePath.isEmpty()) {
            return this.mDevicePath.getSubstrate();
        }
        return null;
    }

    protected void setState(State state) {
        if (this.mState != null && !this.mState.exit()) {
            return;
        }
        this.mState = null;
        if (state != null && state.enter()) {
            this.mState = state;
        }
        this.updateOptionsUI();
        this.repaintOverlay();
    }

    public NamedGrid getGrid() {
        return this.mGrid;
    }

    public AGrid getAGrid() {
        return this.mGrid == null ? null : this.mGrid.getGrid();
    }

    protected boolean selectDevice(APoint2D byLoc) {
        DevicePath path = null;
        if (byLoc != null) {
            path = this.mView.getDeviceAt(byLoc, "Select Device", true);
        } else {
            DeviceChooser.InitHook ih = new DeviceChooser.InitHook(){

                @Override
                public void initDeviceChooser(DeviceChooser.DCPanel dc) {
                    JPanel cpanel = dc.getCustomTopPanel();
                    cpanel.setVisible(true);
                    GridBagManager l = GridBagManager.layout((Container)cpanel);
                    JCheckBox cbOnlySubstrates = (JCheckBox)l.add((Component)new JCheckBox("Limit to substrates"));
                    cbOnlySubstrates.setSelected(true);
                    l.add((Component)cbOnlySubstrates, (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
                    cbOnlySubstrates.addActionListener(e -> dc.updateAllDevices());
                    dc.setDeviceFilter(d -> !cbOnlySubstrates.isSelected() || d.getIsSubstrate());
                }
            };
            path = DeviceChooser.getDevicePath(this.mView, this.mView.getDb(), ih);
        }
        if (path == null) {
            return false;
        }
        this.setDevicePath(path);
        return true;
    }

    protected boolean selectGrid(boolean auto) {
        NamedGrid grid;
        if (auto) {
            NamedGrid mg;
            Substrate s = this.getSubstrate();
            if (s != null && (mg = NamedGrid.get((Substrate)s, (String)"Manufacturing Grid")) != null) {
                this.setGrid(mg);
                return true;
            }
            this.setGrid(null);
            return true;
        }
        NamedGrid curGrid = this.mGrid;
        if (this.getSubstrate() == null && !this.selectDevice(null)) {
            return false;
        }
        ArrayList<NamedGrid> extraGrids = new ArrayList<NamedGrid>();
        extraGrids.add(NamedGrid.NONE);
        if (curGrid != null && !curGrid.isStored()) {
            extraGrids.add(curGrid);
        }
        if ((grid = GridChooser.getGrid(this.mView, this.getSubstrate(), this.mView.getUnit(), curGrid, extraGrids)) == NamedGrid.NONE) {
            grid = null;
        }
        this.setGrid(grid);
        return true;
    }

    protected void setCursorLoc(APoint2D worldLoc) {
        if (APoint2D.isEqualPoint((APoint2D)this.mCursorPt, (APoint2D)worldLoc)) {
            return;
        }
        this.mCursorPt = worldLoc;
        this.mOverlay.drawCursor(null);
    }

    public APoint2D getCursorLoc() {
        return this.mCursorPt;
    }

    @Override
    public void mouseClicked(DesignView2D.MouseAction e) {
        super.mouseClicked(e);
        if (this.mState != null) {
            this.mState.mouseClick(e);
        }
    }

    @Override
    public void mouseDragged(DesignView2D.MouseAction e) {
        super.mouseDragged(e);
        if (this.mState != null) {
            this.mState.mouseDrag(e);
        }
    }

    @Override
    public void mouseEntered(DesignView2D.MouseAction e) {
        super.mouseEntered(e);
        if (this.mState != null) {
            this.mState.mouseEnter(e);
        }
    }

    @Override
    public void mouseExited(DesignView2D.MouseAction e) {
        super.mouseExited(e);
        if (this.mState != null) {
            this.mState.mouseExit(e);
        }
    }

    @Override
    public void mouseMoved(DesignView2D.MouseAction e) {
        super.mouseMoved(e);
        if (this.mState != null) {
            this.mState.mouseMove(e);
        }
    }

    @Override
    public void mousePressed(DesignView2D.MouseAction e) {
        super.mousePressed(e);
        if (this.mState != null) {
            this.mState.mousePress(e);
        }
    }

    @Override
    public void mouseReleased(DesignView2D.MouseAction e) {
        super.mouseReleased(e);
        if (this.mState != null) {
            this.mState.mouseRelease(e);
        }
    }

    protected boolean autoExitEditing() {
        if (this.mEditEndMode == null) {
            return false;
        }
        DesignView2D.ViewMode m = this.mEditEndMode;
        this.mEditEndMode = null;
        this.mView.setMode(m);
        return true;
    }

    @Override
    protected boolean showContextMenu(JPopupMenu menu, Point loc) {
        int idx;
        if (this.mCbShowOptions == null) {
            this.mCbShowOptions = new JCheckBoxMenuItem("Show Shape Editing Options");
            this.mCbShowOptions.addActionListener(event -> {
                if (this.mOptionsUI == null) {
                    this.mOptionsUI = this.createOptionsUI();
                } else {
                    UIUtil.closeWindow((Window)((Object)this.mOptionsUI));
                }
            });
        }
        this.mCbShowOptions.setSelected(this.mOptionsUI != null);
        int n = idx = menu.getComponentCount() >= 2 ? menu.getComponentCount() - 2 : 0;
        if (idx > 0 && !(menu.getComponent(idx - 1) instanceof JSeparator)) {
            menu.insert(new JSeparator(), idx - 1);
        }
        for (Action a : this.mState.getActions(loc)) {
            menu.insert(a, idx++);
        }
        menu.insert(this.mCbShowOptions, idx++);
        menu.insert(new JSeparator(), idx++);
        this.mState.prepareContexMenu(menu, loc);
        return super.showContextMenu(menu, loc);
    }

    protected void insertContextMenuItem(JPopupMenu menu, Action a) {
        this.insertContextMenuItem(menu, new JMenuItem(a));
    }

    protected void insertContextMenuItem(JPopupMenu menu, JMenuItem mi) {
        long idx = AStream.zipWithIndex(Arrays.asList(menu.getComponents()).stream()).filter(pair -> pair.first == this.mCbShowOptions).map(pair -> (Long)pair.second).findAny().orElse(0L);
        menu.insert(mi, (int)idx + 1);
    }

    protected OptionsUI createOptionsUI() {
        return new OptionsUI();
    }

    public void addEditListener(EditListener<T> l) {
        this.mEditListeners.add(l);
    }

    public boolean removeEditListner(EditListener<T> l) {
        return this.mEditListeners.remove(l);
    }

    public boolean hasEditListener(EditListener<T> l) {
        return this.mEditListeners.contains(l);
    }

    protected void fireEditShapeChanged() {
        ShapeCommands.HierGeom<T> hw = this.getEditHierShape();
        for (EditListener editListener : this.mEditListeners) {
            editListener.editShape(hw);
        }
    }

    protected void drawScreenShape(Graphics2D g, AGeom geom) {
        if (geom instanceof ARect) {
            g.draw(this.getScreenRect((ARect)geom));
        } else if (geom instanceof AOctagon) {
            g.drawPolygon(this.getScreenPolygon((APolygon)geom));
        } else if (geom instanceof APolyline) {
            ((APolyline)geom).getSegments().stream().forEach(seg -> {
                Point p0 = this.getScreenPoint(seg.getP0());
                Point p1 = this.getScreenPoint(seg.getP1());
                g.drawLine(p0.x, p0.y, p1.x, p1.y);
            });
        } else if (geom instanceof APolygon) {
            Polygon poly = this.getScreenPolygon((APolygon)geom);
            if (poly.npoints == 2) {
                g.drawLine(poly.xpoints[0], poly.ypoints[0], poly.xpoints[1], poly.ypoints[1]);
            } else {
                g.drawPolygon(poly);
            }
        } else if (geom instanceof ACircle) {
            g.draw(this.getScreenCircle((ACircle)geom));
        }
    }

    protected void drawEditPointsAndEdges(Graphics2D g, APoint2D[] editPtsWorld) {
        Arrays.stream(editPtsWorld).map(pt -> this.getScreenPoint((APoint2D)pt)).forEach(pt -> ShapeEditMode.drawHandle(g, pt));
        AStream.sliding(Arrays.stream(editPtsWorld), (int)2).forEach(pp -> ShapeEditMode.drawEdge(g, this.getScreenPoint((APoint2D)pp.get(0)), this.getScreenPoint((APoint2D)pp.get(1))));
    }

    protected void fillShape(Graphics2D g, AGeom geom, AffineTransform xform) {
        DesignCanvas2D.XForm screenXform = this.mView.getCanvas().getXForm();
        Shape shape = ShapeFactory.getShape(screenXform, geom, xform, false);
        if (geom instanceof APath) {
            int screenWidth = screenXform.getScreenLength(((APath)geom).getWidth());
            if (screenWidth == 0) {
                screenWidth = 1;
            }
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(screenWidth, 1, 1));
            g.draw(shape);
            g.setStroke(oldStroke);
        } else if (geom instanceof ALine) {
            boolean screenWidth = true;
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke((float)screenWidth, 1, 1));
            g.draw(shape);
            g.setStroke(oldStroke);
        } else {
            g.fill(shape);
        }
    }

    protected void outlineShape(Graphics2D g, AGeom geom, AffineTransform xform) {
        if (geom instanceof ALine) {
            this.fillShape(g, geom, xform);
            return;
        }
        DesignCanvas2D.XForm screenXform = this.mView.getCanvas().getXForm();
        Shape shape = ShapeFactory.getShape(screenXform, geom, xform, false);
        g.draw(shape);
    }

    protected int[] findVertexOrSegment(ShapeCommands.HierGeom<T> hls, Point loc, long maxDist) {
        if (hls == null) {
            return null;
        }
        DesignCanvas2D.XForm screenTransform = this.mView.getCanvas().getXForm();
        int searchDist = this.getScreenLen(maxDist);
        AGeom g = hls.getGeom();
        LinkedList pts = AUtil.linkedList(ShapeEditMode.getGrabPtsScreen(g, hls.getPath().getTransform(), screenTransform));
        Optional optPt = AStream.zipWithIndex(pts.stream()).filter(pt -> ((Point)pt.first).distance(loc) <= (double)searchDist).min((a, b) -> (int)Math.round(((Point)a.first).distance(loc) - ((Point)b.first).distance(loc)));
        if (optPt.isPresent()) {
            return new int[]{(int)((Long)((APair)optPt.get()).second).longValue()};
        }
        boolean addedClosePt = false;
        if (pts.size() > 1 && !((Point)pts.get(0)).equals(pts.get(pts.size() - 1))) {
            pts.add((Point)pts.get(0));
            addedClosePt = true;
        }
        if (g instanceof ACircle) {
            return null;
        }
        Optional optLine = AStream.sliding((Stream)AStream.zipWithIndex(pts.stream()), (int)2).filter(points -> ShapeEditMode.line(points).ptSegDist(loc) <= (double)searchDist).min((ptsA, ptsB) -> (int)Math.round(ShapeEditMode.line(ptsA).ptSegDist(loc) - ShapeEditMode.line(ptsB).ptSegDist(loc)));
        if (optLine.isPresent()) {
            if (addedClosePt && (Long)((APair)((List)optLine.get()).get((int)1)).second == (long)(pts.size() - 1)) {
                ((APair)((List)optLine.get()).get((int)1)).second = 0L;
            }
            return new int[]{(int)((Long)((APair)((List)optLine.get()).get((int)0)).second).longValue(), (int)((Long)((APair)((List)optLine.get()).get((int)1)).second).longValue()};
        }
        return null;
    }

    protected void setEditPointsStatus(APoint2D[] pts) {
        if (pts == null) {
            SwingUtilities.invokeLater(() -> OrbitIO.getApp().getWorkspace().setStatus(""));
        } else {
            Unit unit = this.getView().getUnit();
            String status = String.format("Point%s: %s", pts.length == 1 ? "" : "s", Arrays.stream(pts).map(pt -> pt.toString(unit)).collect(Collectors.joining(", ")));
            SwingUtilities.invokeLater(() -> OrbitIO.getApp().getWorkspace().setStatus(status));
        }
    }

    protected AGeom createShapeStartingAtPt(Class<? extends AGeom> type, APoint2D pt) {
        if (type == ARect.class) {
            return new ARect(pt, pt);
        }
        if (type == APolygon.class) {
            return new APolygon(new APoint2D[]{pt, pt});
        }
        if (type == ACircle.class) {
            return new ACircle(pt, 0L);
        }
        if (type == AOctagon.class) {
            return new AOctagon(0L, pt);
        }
        assert (false);
        return null;
    }

    protected static Line2D line(List<APair<Point, Long>> ptsAndIdxs) {
        return new Line2D.Float((Point2D)ptsAndIdxs.get((int)0).first, (Point2D)ptsAndIdxs.get((int)1).first);
    }

    protected static Point getScreen(APoint2D wp, AffineTransform worldX, DesignCanvas2D.XForm screenX) {
        return screenX.getScreenPt(wp.transform(worldX));
    }

    protected static void drawHandles(Graphics2D g, DesignCanvas2D.XForm screenXform, AGeom geom, AffineTransform xform) {
        for (Rectangle h : ShapeEditMode.getHandles(geom, xform, screenXform)) {
            g.fill(h);
        }
    }

    protected static Rectangle createHandle(Point pt) {
        return new Rectangle(pt.x - 3, pt.y - 3, 7, 7);
    }

    protected static Rectangle createHandle(APoint2D pt, AffineTransform ptX, DesignCanvas2D.XForm screenX) {
        return ShapeEditMode.createHandle(screenX.getScreenPt(pt.transform(ptX)));
    }

    protected static List<Rectangle> getHandles(AGeom geom, AffineTransform geomX, DesignCanvas2D.XForm screenX) {
        return ShapeCommands.getEditPoints(geom).map(p -> ShapeEditMode.createHandle(p, geomX, screenX)).collect(Collectors.toList());
    }

    protected static void drawHandle(Graphics2D g, Point pt) {
        g.fill(ShapeEditMode.createHandle(pt));
    }

    protected static void drawEdge(Graphics2D g, Point pta, Point ptb) {
        g.drawLine(pta.x, pta.y, ptb.x, ptb.y);
    }

    protected static Stream<Point> getGrabPtsScreen(AGeom geom, AffineTransform geomX, DesignCanvas2D.XForm screenX) {
        return ShapeCommands.getEditPoints(geom).map(p -> ShapeEditMode.getScreen(p, geomX, screenX));
    }

    public static Point closest(Point ref, Point ... candidates) {
        return ShapeEditMode.closest(ref, (Stream<Point>)AStream.of((Object[])candidates));
    }

    public static Point closest(Point ref, Stream<Point> candidates) {
        return candidates.map(c -> APair.create((Object)c, (Object)c.distance(ref))).min((a, b) -> ((Double)a.second).compareTo((Double)b.second)).map(p -> (Point)p.first).orElse(ref);
    }

    public static Stream<APoint2D> getOrthoPts(APoint2D a, APoint2D b) {
        if (a.equals((Object)b) || a.horiz(b) || a.vert(b)) {
            return Stream.empty();
        }
        return Stream.of(new APoint2D(a.getX(), b.getY()), new APoint2D(b.getX(), a.getY()));
    }

    public static long intersections(ALine l, APolygon p) {
        return p.getSegments().stream().filter(seg -> ALine.linesIntersect((long)l.getP0().getX(), (long)l.getP0().getY(), (long)l.getP1().getX(), (long)l.getP1().getY(), (long)seg.getP0().getX(), (long)seg.getP0().getY(), (long)seg.getP1().getX(), (long)seg.getP1().getY())).count();
    }

    public static interface EditListener<T extends DbObject> {
        public void editShape(ShapeCommands.HierGeom<T> var1);
    }

    protected class Overlay
    extends GridOverlay {
        protected boolean mSpotlight;
        protected Point mDrawnCursorLoc;

        public Overlay(NamedGrid grid) {
            super(ShapeEditMode.this.mView, null, null);
            this.mSpotlight = (Boolean)Settings.get((String)"UserPreferences", (String)"EnableSpotlights", (Object)false);
            this.mDrawnCursorLoc = null;
        }

        public void setSpotlight(boolean b) {
            this.mSpotlight = b;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (ShapeEditMode.this.isNavigationInProgress()) {
                return;
            }
            if (!(graphics instanceof Graphics2D)) {
                assert (false);
                return;
            }
            Graphics2D g = (Graphics2D)graphics;
            if (ShapeEditMode.this.mPrePaint != null) {
                ShapeEditMode.this.mPrePaint.paintOverlay(g);
            }
            if (this.mSpotlight && this.mDevicePath != null) {
                DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
                ARect viewBounds = this.mView.getViewBounds();
                ARect deviceBounds = this.mDevicePath.getBB();
                SpotLight.spotlight(g, viewBounds, (AGeom)deviceBounds, xform);
            }
            if (ShapeEditMode.this.mState != null) {
                ShapeEditMode.this.mState.paintOverlay(g);
            }
            this.mDrawnCursorLoc = null;
            this.drawCursor(g);
            if (ShapeEditMode.this.mPostPaint != null) {
                ShapeEditMode.this.mPostPaint.paintOverlay(g);
            }
        }

        protected void drawCursor(Graphics2D gIn) {
            Graphics2D g = gIn != null ? gIn : (Graphics2D)this.getGraphics();
            APoint2D clw = ShapeEditMode.this.mCursorPt;
            Point cl = clw == null ? null : this.mView.getCanvas().getXForm().getScreenPt(clw);
            Color oldColor = g.getColor();
            g.setColor(ShapeEditMode.this.CURSOR_COLOR);
            g.setXORMode(ShapeEditMode.this.CURSOR_COLOR_XOR);
            if (this.mDrawnCursorLoc != null && !this.mDrawnCursorLoc.equals(cl)) {
                this.drawCursor(g, this.mDrawnCursorLoc);
                this.mDrawnCursorLoc = null;
            }
            if (cl != null && !cl.equals(this.mDrawnCursorLoc)) {
                this.drawCursor(g, cl);
                this.mDrawnCursorLoc = cl;
            }
            g.setColor(oldColor);
            g.setPaintMode();
            if (gIn == null) {
                g.dispose();
            }
        }

        protected void drawCursor(Graphics2D g, Point loc) {
            g.drawLine(loc.x - 7, loc.y, loc.x - 1, loc.y);
            g.drawLine(loc.x + 1, loc.y, loc.x + 7, loc.y);
            g.drawLine(loc.x, loc.y - 7, loc.x, loc.y - 1);
            g.drawLine(loc.x, loc.y + 1, loc.x, loc.y + 7);
        }
    }

    protected class OptionsUI
    extends AFloatWindow {
        protected JTextField mTxtOwner;
        protected JButton mBtnChangeDevice;
        protected JTextField mTxtGrid;
        protected JComboBox<ShapeCommands.SnapAngle> mCboSnapAngle;
        protected List<com.sigrity.orbit.ui.shape_edit.ShapeEditMode$OptionsUI.ShapeButton> mBtnNewShapes;
        protected JButton mBtnDelete;
        protected JButton mBtnReset;

        protected OptionsUI() {
            super((Window)UIUtil.getAncestorOfType((Component)ShapeEditMode.this.mView.getComponent(), Window.class));
            this.mBtnNewShapes = new LinkedList<com.sigrity.orbit.ui.shape_edit.ShapeEditMode$OptionsUI.ShapeButton>();
            this.mBtnNewShapes.add((com.sigrity.orbit.ui.shape_edit.ShapeEditMode$OptionsUI.ShapeButton)this.createShapeButton("Rectangle", ARect.class));
            this.mBtnNewShapes.add((com.sigrity.orbit.ui.shape_edit.ShapeEditMode$OptionsUI.ShapeButton)this.createShapeButton("Polygon", APolygon.class));
            this.setPinnable(false);
            this.setPinned(true);
            this.setTitle("Shape Editing");
            this.initUI();
            this.pack();
            Point loc = new Point();
            SwingUtilities.convertPointToScreen(loc, ShapeEditMode.this.mView);
            loc.x -= this.getWidth();
            this.setLocation(loc);
            UIUtil.verifyWindowOnScreen((Window)((Object)this));
            this.initListener();
            this.updateData();
            this.setVisible(true);
        }

        protected void initUI() {
            GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
            l.pushFillX();
            l.add("Owner:", (GridBagConstraints)GridBagManager.LEFT);
            this.mTxtOwner = (JTextField)l.add((Component)this.createTextDisplay(), (GridBagConstraints)GridBagManager.FILLX);
            this.mBtnChangeDevice = (JButton)l.add((Component)this.createChangeButton(), (GridBagConstraints)GridBagManager.LEFT);
            this.mBtnChangeDevice.addActionListener(e -> ShapeEditMode.this.selectDevice(null));
            l.newline();
            this.initOwnerOpts(l);
            l.newline();
            JLabel lblGrid = l.add("Grid:", (GridBagConstraints)GridBagManager.LEFT);
            this.mTxtGrid = (JTextField)l.add((Component)this.createTextDisplay(), (GridBagConstraints)GridBagManager.FILLX);
            JButton btnChangeGrid = (JButton)l.add((Component)this.createChangeButton(), (GridBagConstraints)GridBagManager.LEFT);
            btnChangeGrid.addActionListener(e -> ShapeEditMode.this.selectGrid(false));
            lblGrid.setVisible(false);
            this.mTxtGrid.setVisible(false);
            btnChangeGrid.setVisible(false);
            l.newline();
            l.add("Snap:");
            this.mCboSnapAngle = (JComboBox)l.add(new JComboBox<ShapeCommands.SnapAngle>(ShapeCommands.SnapAngle.values()), (GridBagConstraints)GridBagManager.LEFT);
            Font f = this.mCboSnapAngle.getFont();
            this.mCboSnapAngle.setFont(f.deriveFont(f.getSize2D() - 2.0f));
            this.mCboSnapAngle.setSelectedItem((Object)ShapeEditMode.this.mSnapAngle);
            this.mCboSnapAngle.addActionListener(e -> {
                ShapeEditMode.this.mSnapAngle = this.mCboSnapAngle.getItemAt(this.mCboSnapAngle.getSelectedIndex());
                Settings.set((String)OptionsUI.getSettingsSection(), (String)"SnapAngle", (Object)((Object)ShapeEditMode.this.mSnapAngle));
                Settings.save((String)OptionsUI.getSettingsSection());
            });
            l.popNl();
            l.pushFillX();
            for (JToggleButton jToggleButton : this.mBtnNewShapes) {
                GridBagManager.GridBagConstraintsEx c = jToggleButton == this.mBtnNewShapes.get(0) ? GridBagManager.LEFT.insetRight(0) : GridBagManager.LEFT.insetHoriz(0);
                l.add((Component)jToggleButton, (GridBagConstraints)c);
            }
            l.addFillX();
            l.newline();
            l.push((GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            this.loadFootOpts(l);
            this.mBtnDelete = new JButton("Delete");
            this.initCmdButton(this.mBtnDelete);
            this.mBtnDelete.addActionListener(e -> ShapeEditMode.this.deleteEditShape());
            this.mBtnReset = new JButton("Reset");
            this.initCmdButton(this.mBtnReset);
            this.mBtnReset.addActionListener(e -> ShapeEditMode.this.resetShapeOptions());
            l.add((Component)this.mBtnDelete);
            l.add((Component)this.mBtnReset);
            l.popNl();
            l.addFillAll();
        }

        protected void initOwnerOpts(GridBagManager l) {
        }

        protected void loadFootOpts(GridBagManager l) {
        }

        protected ATextField createTextDisplay() {
            ATextField txt = new ATextField(10);
            txt.setEditable(false);
            return txt;
        }

        protected JButton createChangeButton() {
            JButton btn = new JButton("\u2026");
            btn.setFont(this.getFont().deriveFont(this.getFont().getSize2D() - 2.0f));
            btn.setMargin(new Insets(0, 1, 0, 1));
            return btn;
        }

        protected AbstractButton initCmdButton(AbstractButton btn) {
            Font font = btn.getFont();
            font.deriveFont(font.getSize2D() - 2.0f);
            btn.setFont(font);
            UIUtil.makeFootButton((AbstractButton)btn);
            return btn;
        }

        protected void initListener() {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    ShapeEditMode.this.mOptionsUI = null;
                    OptionsUI.this.removeWindowListener(this);
                }
            });
        }

        public void updateData() {
            Design design;
            Db db = ShapeEditMode.this.mView == null ? null : ShapeEditMode.this.mView.getDb();
            Design design2 = design = db == null ? null : Design.getDesign((Db)db, (boolean)false);
            if (design == null) {
                return;
            }
            String devName = "";
            if (ShapeEditMode.this.mDevicePath != null && !ShapeEditMode.this.mDevicePath.isEmpty()) {
                devName = ShapeEditMode.this.mDevicePath.getLast().getName();
            }
            this.updateText(this.mTxtOwner, devName);
            String gridName = "";
            if (ShapeEditMode.this.mGrid != null) {
                gridName = ShapeEditMode.this.mGrid.getDesc(ShapeEditMode.this.mView.getUnit());
            }
            this.updateText(this.mTxtGrid, gridName);
            this.mBtnChangeDevice.setEnabled(ShapeEditMode.this.getEditShape() == null);
            Class<? extends AGeom> type = ShapeEditMode.this.mState instanceof StateCreate ? ((StateCreate)ShapeEditMode.this.mState).getShapeType() : null;
            Iterator<com.sigrity.orbit.ui.shape_edit.ShapeEditMode$OptionsUI.ShapeButton> iterator = this.mBtnNewShapes.iterator();
            while (iterator.hasNext()) {
                ShapeButton sb;
                sb.setSelected((sb = (ShapeButton)iterator.next()).getType() == type);
            }
            this.mBtnDelete.setEnabled(ShapeEditMode.this.getEditShape() != null);
        }

        protected void updateText(JTextComponent txtComp, String newText) {
            if (newText == null) {
                newText = "";
            }
            if (txtComp.getText().equals(newText)) {
                return;
            }
            txtComp.setText(newText);
            txtComp.setCaretPosition(0);
        }

        protected com.sigrity.orbit.ui.shape_edit.ShapeEditMode$OptionsUI.ShapeButton createShapeButton(String name, Class<? extends AGeom> type) {
            return new ShapeButton(name, type);
        }

        public Class<? extends AGeom> getSelShape() {
            for (ShapeButton shapeButton : this.mBtnNewShapes) {
                if (!shapeButton.isSelected()) continue;
                return shapeButton.getType();
            }
            return null;
        }

        protected class ShapeButton
        extends JToggleButton {
            protected String mName;
            protected Class<? extends AGeom> mType;

            public ShapeButton(String name, Class<? extends AGeom> type) {
                this.mName = name;
                this.mType = type;
                this.setIcon(AGeomUtil.getIconForGeom(type, (int)16, (Color)this.getForeground()));
                this.setToolTipText("New " + name);
                this.addActionListener(e -> ShapeEditMode.this.setState(this.isSelected() ? ShapeEditMode.this.getCreateShapeState(this.mName, this.mType) : ShapeEditMode.this.getDefaultState()));
                Font font = this.getFont();
                this.setFont(font.deriveFont(font.getSize2D() - 2.0f));
                this.setMargin(new Insets(2, 2, 2, 2));
            }

            public Class<? extends AGeom> getType() {
                return this.mType;
            }
        }
    }

    protected class StateEdit
    extends State {
        protected Consumer<ShapeCommands.HierGeom<T>> mOnComplete;
        protected Runnable mOnCancel;
        protected int[] mEditVertexIndices;
        protected Point mMouseDown;

        protected StateEdit() {
            this.mEditVertexIndices = null;
            this.mMouseDown = null;
        }

        public void setOnComplete(Consumer<ShapeCommands.HierGeom<T>> c) {
            this.mOnComplete = c;
        }

        public void setOnCancel(Runnable r) {
            this.mOnCancel = r;
        }

        @Override
        public boolean enter() {
            return super.enter();
        }

        @Override
        public boolean exit() {
            return super.exit();
        }

        @Override
        public void paintOverlay(Graphics2D g) {
            super.paintOverlay(g);
            RenderingHints oldRenderingHints = g.getRenderingHints();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color colorOld = g.getColor();
            ShapeCommands.HierGeom editShape = ShapeEditMode.this.getEditHierShape();
            if (editShape != null) {
                this.drawEditShape(g, editShape);
            } else {
                ShapeEditMode.this.setEditPointsStatus(null);
            }
            g.setPaintMode();
            g.setColor(colorOld);
            g.setRenderingHints(oldRenderingHints);
        }

        @Override
        public void mouseMove(DesignView2D.MouseAction e) {
            ShapeEditMode.this.setCursorLoc(ShapeEditMode.this.getWorldPoint(e));
            if (this.mMouseDown == null) {
                this.updateHighlightedHandle(e.getPoint(), ShapeEditMode.this.getMouseSensitivityWorld(), false);
            } else if (this.mEditVertexIndices != null) {
                ShapeEditMode.this.setCursorLoc(ShapeEditMode.this.getWorldPoint(e));
            } else {
                ShapeEditMode.this.setCursorLoc(null);
            }
        }

        @Override
        public void mousePress(DesignView2D.MouseAction e) {
            if (e.isPopupTrigger() || e.getButton() != 1) {
                return;
            }
            if (this.mEditVertexIndices == null) {
                AGeom geom;
                ShapeCommands.HierGeom hg = ShapeEditMode.this.getEditHierShape();
                AGeom aGeom = geom = hg == null ? null : hg.getGeom();
                if (geom != null) {
                    APoint2D cursorLoc = ShapeEditMode.this.getWorldPoint(e.getPoint());
                    if (geom.transform(hg.getPathTransform()).intersects(cursorLoc)) {
                        this.mEditVertexIndices = new int[0];
                    }
                }
            }
            if (this.mEditVertexIndices != null && this.mMouseDown == null) {
                this.mMouseDown = e.getPoint();
                ShapeEditMode.this.mCursorPt = ShapeEditMode.this.getWorldPoint(this.mMouseDown);
                if (this.mEditVertexIndices.length == 0) {
                    ShapeEditMode.this.repaintOverlay();
                }
            }
        }

        @Override
        public void mouseDrag(DesignView2D.MouseAction e) {
            if (this.mEditVertexIndices == null) {
                ShapeEditMode.this.setCursorLoc(null);
            } else {
                ShapeEditMode.this.setCursorLoc(ShapeEditMode.this.getWorldPoint(e.getPoint()));
                ShapeEditMode.this.repaintOverlay();
            }
        }

        @Override
        public void mouseRelease(DesignView2D.MouseAction e) {
            if (this.mMouseDown == null || ShapeEditMode.this.mCursorPt == null) {
                return;
            }
            ShapeCommands.HierGeom editShape = ShapeEditMode.this.getEditHierShape();
            if (editShape == null) {
                assert (false);
                return;
            }
            AGeom editGeom = editShape.getGeom();
            if (editGeom != null && this.mEditVertexIndices != null) {
                if (this.mEditVertexIndices.length == 0) {
                    APoint2D xlate = ShapeEditMode.this.getDeviceRelativePt(ShapeEditMode.this.mCursorPt).sub(ShapeEditMode.this.getDeviceRelativePt(ShapeEditMode.this.getWorldPoint(this.mMouseDown)));
                    if (!xlate.isOrigin()) {
                        Cp.exec((String)"ShapeCommands.moveShape(iseShape, %dL, %dL)", (Object[])new Object[]{xlate.getX(), xlate.getY()});
                        ShapeEditMode.this.setCursorLoc(null);
                        this.mMouseDown = null;
                        ShapeEditMode.this.repaintView();
                    }
                    return;
                }
                AffineTransform hierX = editShape.getPathTransform();
                if (editGeom instanceof ACircle) {
                    APoint2D devRelPt = ShapeEditMode.this.getDeviceRelativePt(ShapeEditMode.this.mCursorPt);
                    Cp.exec((String)"ShapeCommands.moveEditPoint(iseShape, %d, %dL, %dL)", (Object[])new Object[]{this.mEditVertexIndices[0], devRelPt.getX(), devRelPt.getY()});
                } else {
                    APoint2D[] grabPtsWorld = (APoint2D[])ShapeCommands.getEditPoints(editGeom).map(pt -> pt.transform(hierX)).toArray(APoint2D[]::new);
                    APoint2D[] editPtsWorld = (APoint2D[])Arrays.stream(this.mEditVertexIndices).mapToObj(idx -> grabPtsWorld[idx]).toArray(APoint2D[]::new);
                    ShapeCommands.NeighborPoints snapPts = this.getSnapNeighbors(editShape);
                    APoint2D xlate = ShapeEditMode.this.mCursorPt.sub(ShapeEditMode.this.getWorldPoint(this.mMouseDown));
                    Optional<APair<Integer, APoint2D>> newPt = ShapeCommands.move(editPtsWorld, xlate, snapPts, ShapeEditMode.this.mSnapAngle);
                    Stream<APoint2D> devRelPts = Arrays.stream(editPtsWorld).map(pt -> ShapeEditMode.this.getDeviceRelativePt((APoint2D)pt));
                    try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)ShapeEditMode.this.getDb(), (String)"Edit shape");){
                        AStream.zip(Arrays.stream(this.mEditVertexIndices).boxed(), devRelPts).forEach(idxPt -> Cp.exec((String)"ShapeCommands.moveEditPoint(iseShape, %d, %dL, %dL)", (Object[])new Object[]{idxPt.first, ((APoint2D)idxPt.second).getX(), ((APoint2D)idxPt.second).getY()}));
                        newPt.ifPresent(idxPt -> {
                            int idx = (Integer)idxPt.first == 0 ? this.mEditVertexIndices[0] : this.mEditVertexIndices[1] + 1;
                            APoint2D pt = ShapeEditMode.this.getDeviceRelativePt((APoint2D)idxPt.second);
                            Cp.exec((String)"ShapeCommands.insertVertex(iseShape, %d, %dL, %dL)", (Object[])new Object[]{idx, pt.getX(), pt.getY()});
                        });
                    }
                }
                ShapeEditMode.this.setCursorLoc(null);
                ShapeEditMode.this.repaintView();
            }
            this.mMouseDown = null;
            ShapeEditMode.this.repaintOverlay();
        }

        @Override
        public void prepareContexMenu(JPopupMenu menu, Point loc) {
            AGeom geom;
            super.prepareContexMenu(menu, loc);
            if (ShapeEditMode.this.getEditShape() == null) {
                return;
            }
            if (this.mEditVertexIndices != null && this.mEditVertexIndices.length == 1) {
                AGeom geom2 = ShapeEditMode.this.getEditShape().getGeom();
                if (geom2 instanceof APolygon || geom2 instanceof ARect) {
                    ShapeEditMode.this.insertContextMenuItem(menu, new AbstractAction("Delete Vertex"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Object res = Cp.exec((String)"ShapeCommands.deleteVertex(iseShape, %d)", (Object[])new Object[]{StateEdit.this.mEditVertexIndices[0]});
                            if (ABoolean.of((Object)res)) {
                                StateEdit.this.mEditVertexIndices = null;
                                ShapeEditMode.this.repaintView();
                            }
                        }
                    });
                }
            } else if (this.mEditVertexIndices != null && this.mEditVertexIndices.length == 2 && ((geom = ShapeEditMode.this.getEditShape().getGeom()) instanceof APolygon || geom instanceof ARect)) {
                ShapeEditMode.this.insertContextMenuItem(menu, new AbstractAction("Split Edge"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Object res = Cp.exec((String)"ShapeCommands.addVertex(iseShape, %d)", (Object[])new Object[]{StateEdit.this.mEditVertexIndices[0]});
                        if (res instanceof Integer && (Integer)res >= 0) {
                            ShapeEditMode.this.repaintView();
                        }
                    }
                });
                ShapeEditMode.this.insertContextMenuItem(menu, new AbstractAction("Split Edge Parametrically"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AddVertexUI.createDlg(OrbitIO.getMainWindow(), OrbitApp.getCurDb(), ShapeEditMode.this.getEditShape(), StateEdit.this.mEditVertexIndices[0]);
                    }
                });
                ShapeEditMode.this.insertContextMenuItem(menu, new AbstractAction("Split All Edges"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)ShapeEditMode.this.getDb(), (String)"Split All Edges");){
                            int n = geom.toPoly().getPointCount();
                            for (int i = 0; i < n; ++i) {
                                int j = i * 2;
                                Cp.exec((String)"ShapeCommands.addVertex(iseShape, %d)", (Object[])new Object[]{j});
                            }
                            ShapeEditMode.this.repaintView();
                        }
                    }
                });
                ShapeEditMode.this.insertContextMenuItem(menu, new AbstractAction("Move Edge Parametrically"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ShapeCommands.HierGeom editShape = ShapeEditMode.this.getEditHierShape();
                        MoveEdgeUI.createDlg(OrbitIO.getMainWindow(), OrbitApp.getCurDb(), editShape, StateEdit.this.mEditVertexIndices, StateEdit.this.getSnapNeighbors(editShape), ShapeEditMode.this.mSnapAngle);
                    }
                });
            }
        }

        protected void drawEditShape(Graphics2D g, ShapeCommands.HierGeom<T> editShape) {
            AGeom editGeom;
            AGeom aGeom = editGeom = editShape == null ? null : editShape.getGeom();
            if (editGeom == null) {
                return;
            }
            g.setColor(Color.CYAN);
            g.setXORMode(Color.WHITE);
            ShapeEditMode.this.fillShape(g, editGeom, editShape.getPathTransform());
            g.setColor(Color.RED);
            DesignCanvas2D.XForm scrnX = ShapeEditMode.this.mView.getCanvas().getXForm();
            AffineTransform hierX = editShape.getPathTransform();
            ShapeEditMode.drawHandles(g, scrnX, editGeom, hierX);
            if (this.mEditVertexIndices == null) {
                ShapeEditMode.this.setEditPointsStatus(null);
                return;
            }
            g.setPaintMode();
            g.setColor(ShapeEditMode.this.HIGHLIGHT_COLOR);
            APoint2D[] grabPtsWorld = (APoint2D[])ShapeCommands.getEditPoints(editGeom).map(pt -> pt.transform(hierX)).toArray(APoint2D[]::new);
            if (this.mEditVertexIndices.length == 0) {
                this.drawShapeMoving(g, editGeom, grabPtsWorld);
                return;
            }
            APoint2D[] editPtsWorld = (APoint2D[])Arrays.stream(this.mEditVertexIndices).mapToObj(idx -> grabPtsWorld[idx]).toArray(APoint2D[]::new);
            if (this.mMouseDown == null || ShapeEditMode.this.mCursorPt == null) {
                ShapeEditMode.this.drawEditPointsAndEdges(g, editPtsWorld);
                ShapeEditMode.this.setEditPointsStatus(editPtsWorld);
            } else {
                this.drawVerticesMoving(g, editShape, editGeom, hierX, editPtsWorld);
            }
        }

        protected void drawVerticesMoving(Graphics2D g, ShapeCommands.HierGeom<T> editShape, AGeom editGeom, AffineTransform hierX, APoint2D[] editPtsWorld) {
            g.setColor(ShapeEditMode.this.DRAG_COLOR);
            if (editGeom instanceof ACircle) {
                ACircle origCircle = (ACircle)editGeom;
                origCircle = origCircle.transform(hierX);
                long newRadius = origCircle.getC().distance(ShapeEditMode.this.mCursorPt);
                ACircle dragCircle = new ACircle(origCircle.getC(), newRadius);
                g.draw(ShapeEditMode.this.getScreenCircle(dragCircle));
            } else {
                APoint2D xlate = ShapeEditMode.this.mCursorPt.sub(ShapeEditMode.this.getWorldPoint(this.mMouseDown));
                ShapeCommands.NeighborPoints neighborPts = this.getSnapNeighbors(editShape);
                Optional<APair<Integer, APoint2D>> newPt = ShapeCommands.move(editPtsWorld, xlate, neighborPts, ShapeEditMode.this.mSnapAngle);
                Arrays.stream(editPtsWorld).map(pt -> ShapeEditMode.this.getScreenPoint((APoint2D)pt)).forEach(pt -> ShapeEditMode.drawHandle(g, pt));
                if (newPt.isPresent()) {
                    ShapeEditMode.drawHandle(g, ShapeEditMode.this.getScreenPoint((APoint2D)newPt.get().getSecond()));
                }
                ShapeEditMode.this.setEditPointsStatus(editPtsWorld);
                Stream<APoint2D> edgePts = Arrays.stream(editPtsWorld);
                if (newPt.isPresent() && (Integer)newPt.get().first == 0) {
                    edgePts = Stream.concat(Stream.of((APoint2D)newPt.get().second), edgePts);
                } else if (neighborPts.first != null) {
                    edgePts = Stream.concat(Stream.of((APoint2D)neighborPts.first), edgePts);
                }
                if (newPt.isPresent() && (Integer)newPt.get().first > 0) {
                    edgePts = Stream.concat(edgePts, Stream.of((APoint2D)newPt.get().second));
                } else if (neighborPts.second != null) {
                    edgePts = Stream.concat(edgePts, Stream.of((APoint2D)neighborPts.second));
                }
                AStream.sliding(edgePts, (int)2).forEach(pp -> ShapeEditMode.drawEdge(g, ShapeEditMode.this.getScreenPoint((APoint2D)pp.get(0)), ShapeEditMode.this.getScreenPoint((APoint2D)pp.get(1))));
            }
        }

        protected void drawShapeMoving(Graphics2D g, AGeom editGeom, APoint2D[] grabPtsWorld) {
            if (this.mMouseDown == null && ShapeEditMode.this.mCursorPt == null) {
                return;
            }
            ShapeCommands.HierGeom hls = ShapeEditMode.this.getEditHierShape();
            if (hls == null) {
                assert (false);
                return;
            }
            APoint2D xlate = ShapeEditMode.this.mCursorPt.sub(ShapeEditMode.this.getWorldPoint(this.mMouseDown));
            AffineTransform xform = hls.getPathTransform();
            if (!xlate.isOrigin()) {
                xform = ATransformUtil.concat((AffineTransform)AffineTransform.getTranslateInstance(xlate.getX(), xlate.getY()), (AffineTransform)xform);
            }
            Arrays.stream(grabPtsWorld).map(pt -> pt.add(xlate)).map(pt -> ShapeEditMode.this.getScreenPoint((APoint2D)pt)).forEach(pt -> ShapeEditMode.drawHandle(g, pt));
            ShapeEditMode.this.outlineShape(g, editGeom, xform);
        }

        protected ShapeCommands.NeighborPoints getSnapNeighbors(ShapeCommands.HierGeom<T> editShape) {
            AGeom editGeom;
            AGeom aGeom = editGeom = editShape == null ? null : editShape.getGeom();
            if (editGeom == null || this.mEditVertexIndices == null || this.mEditVertexIndices.length < 1) {
                return new ShapeCommands.NeighborPoints(null, false, null, false);
            }
            AffineTransform hierX = editShape.getPathTransform();
            Object[] grabPtsWorld = (APoint2D[])ShapeCommands.getEditPoints(editGeom).map(pt -> pt.transform(hierX)).toArray(APoint2D[]::new);
            boolean wrapAtEnds = !(editGeom instanceof ALine);
            APoint2D before = (APoint2D)AArrays.getPreviousItem((Object[])grabPtsWorld, (int)this.mEditVertexIndices[0], (boolean)wrapAtEnds);
            APoint2D after = (APoint2D)AArrays.getNextItem((Object[])grabPtsWorld, (int)this.mEditVertexIndices[this.mEditVertexIndices.length - 1], (boolean)wrapAtEnds);
            Object firstEditPt = grabPtsWorld[this.mEditVertexIndices[0]];
            Object lastEditPt = grabPtsWorld[this.mEditVertexIndices[this.mEditVertexIndices.length - 1]];
            boolean beforeColinear = before.colinear((APoint2D)firstEditPt, (APoint2D)lastEditPt);
            boolean afterColinear = after.colinear((APoint2D)firstEditPt, (APoint2D)lastEditPt);
            return new ShapeCommands.NeighborPoints(before, beforeColinear, after, afterColinear);
        }

        protected void updateHighlightedHandle(Point point, long searchDist, boolean select) {
            ShapeCommands.HierGeom ho = ShapeEditMode.this.getEditHierShape();
            if (ho == null) {
                return;
            }
            int[] indices = ShapeEditMode.this.findVertexOrSegment(ho, point, searchDist);
            if (!Arrays.equals(this.mEditVertexIndices, indices)) {
                this.mEditVertexIndices = indices;
                ShapeEditMode.this.repaintOverlay();
            }
        }
    }

    protected class StateCreate
    extends State {
        protected boolean mUninstallClearsEditState;
        protected APoint2D mPreviousPt;
        protected AGeom mCurShape;
        protected String mShapeName;
        protected Class<? extends AGeom> mShapeType;

        public StateCreate(String name, Class<? extends AGeom> type) {
            this.mUninstallClearsEditState = true;
            this.mPreviousPt = null;
            this.mCurShape = null;
            this.mShapeName = name;
            this.mShapeType = type;
        }

        public String getShapeName() {
            return this.mShapeName;
        }

        public Class<? extends AGeom> getShapeType() {
            return this.mShapeType;
        }

        @Override
        public boolean enter() {
            String extraMsg = this.mShapeType.equals(APolygon.class) ? ", double-click to complete" : "";
            ShapeEditMode.this.informUser("Click to start a new %s%s", new Object[]{this.getShapeName(), extraMsg});
            return super.enter();
        }

        @Override
        public boolean exit() {
            ShapeEditMode.this.informUser(null, new Object[0]);
            this.mCurShape = null;
            if (this.mUninstallClearsEditState) {
                ShapeEditMode.this.clearEditShape();
                ShapeEditMode.this.setCursorLoc(null);
            }
            return super.exit();
        }

        @Override
        public void mouseMove(DesignView2D.MouseAction e) {
            APoint2D worldPt = ShapeEditMode.this.getWorldPoint(e);
            if (worldPt == null) {
                return;
            }
            if (this.mPreviousPt != null && this.mCurShape instanceof APolygon && ShapeEditMode.this.mSnapAngle == ShapeCommands.SnapAngle.Orthogonal) {
                worldPt = worldPt.closestOrthogonal(this.mPreviousPt);
            }
            if (!worldPt.equals((Object)ShapeEditMode.this.mCursorPt)) {
                AGeom newCursorGeom;
                ShapeEditMode.this.setCursorLoc(worldPt);
                if (this.mCurShape != null && (newCursorGeom = this.setMovingPt(this.mCurShape, ShapeEditMode.this.mCursorPt)) != null) {
                    this.mCurShape = newCursorGeom;
                    ShapeEditMode.this.repaintOverlay();
                }
            }
        }

        @Override
        public void mouseClick(DesignView2D.MouseAction e) {
            if (e.isPopupTrigger() || e.getButton() != 1) {
                return;
            }
            this.mouseMove(e);
            if (ShapeEditMode.this.mDevicePath == null && !ShapeEditMode.this.selectDevice(ShapeEditMode.this.mCursorPt)) {
                return;
            }
            if (this.mCurShape == null) {
                this.mCurShape = ShapeEditMode.this.createShapeStartingAtPt(this.getShapeType(), ShapeEditMode.this.mCursorPt);
                this.mPreviousPt = ShapeEditMode.this.mCursorPt;
                ShapeEditMode.this.repaintOverlay();
            } else {
                boolean completeShape;
                boolean bl = completeShape = this.mCurShape instanceof ARect || this.mCurShape instanceof ACircle || this.mCurShape instanceof AOctagon || e.getClickCount() == 2;
                if (completeShape) {
                    ShapeCommands.HierGeom o;
                    ShapeCommands.HierGeom hi;
                    if (this.mCurShape instanceof APolygon) {
                        APoint2D snapPoint = null;
                        APolygon poly = (APolygon)this.mCurShape;
                        if (ShapeEditMode.this.mSnapAngle == ShapeCommands.SnapAngle.Orthogonal && poly.getPointCount() > 3 && !ShapeEditMode.this.mCursorPt.equals((Object)poly.getFirstPoint())) {
                            poly.removePoint(poly.getPointCount() - 1);
                            Stream<ALine> segs = this.getBestOrthoLines(ShapeEditMode.this.mCursorPt, poly.getFirstPoint(), poly);
                            snapPoint = segs.findFirst().map(line -> line.getP1()).orElse(null);
                        }
                        if (snapPoint != null) {
                            poly.addPoint(snapPoint);
                            poly.addPoint(poly.getFirstPoint());
                        }
                    }
                    ShapeCommands.HierGeom hierGeom = hi = (o = ShapeEditMode.this.createOwnedGeom(this.mCurShape)) instanceof ShapeCommands.OwnedGeom ? o : null;
                    if (hi != null) {
                        ShapeEditMode.this.notifyEditShapeSet(hi);
                        ShapeEditMode.this.setState(ShapeEditMode.this.getDefaultState());
                        ShapeEditMode.this.repaintView();
                    } else {
                        String err = String.format("Unexpected result from createOwnedGeom: '%s'", o);
                        ALog.logError((Throwable)new IllegalStateException(err), (String)err, (Object[])new Object[0]);
                        assert (false);
                    }
                } else if (this.mCurShape instanceof APolygon) {
                    APolygon poly = (APolygon)this.mCurShape;
                    poly.addPoint(ShapeEditMode.this.mCursorPt);
                    ShapeEditMode.this.repaintOverlay();
                    this.mPreviousPt = ShapeEditMode.this.mCursorPt;
                } else assert (false);
            }
        }

        @Override
        public void paintOverlay(Graphics2D g) {
            if (this.mCurShape == null) {
                return;
            }
            Color oldColor = g.getColor();
            g.setColor(Color.RED);
            g.setXORMode(Color.WHITE);
            AGeom drawShape = this.mCurShape;
            boolean shapeDrawn = false;
            if (drawShape instanceof APolygon && ShapeEditMode.this.mSnapAngle == ShapeCommands.SnapAngle.Orthogonal && ((APolygon)drawShape).getPointCount() > 2) {
                shapeDrawn = this.drawPartialPolyOrtho(g, (APolygon)drawShape, Color.ORANGE);
            }
            if (!shapeDrawn) {
                ShapeEditMode.this.drawScreenShape(g, drawShape);
            }
            g.setPaintMode();
            g.setColor(oldColor);
        }

        protected boolean drawPartialPolyOrtho(Graphics2D g, APolygon poly, Color partialColor) {
            if (poly.getPointCount() <= 2 || AUtil.equals((Object)poly.getFirstPoint(), (Object)poly.getLastPoint())) {
                return false;
            }
            APoint2D lastPt = poly.getLastPoint();
            APoint2D firstPt = poly.getFirstPoint();
            if (firstPt.equals((Object)lastPt)) {
                return false;
            }
            Stream<ALine> segs = this.getBestOrthoLines(lastPt, firstPt, poly);
            Stroke oldStroke = g.getStroke();
            g.setStroke(ShapeEditMode.this.StrokeDash);
            Color oldColor = g.getColor();
            g.setColor(partialColor);
            segs.forEach(seg -> g.draw(ShapeEditMode.this.getScreenLine((ALine)seg)));
            g.setColor(oldColor);
            g.setStroke(oldStroke);
            poly.getSegments().forEach(seg -> g.draw(ShapeEditMode.this.getScreenLine((ALine)seg)));
            return true;
        }

        Stream<ALine> getBestOrthoLines(APoint2D from, APoint2D to, APolygon poly) {
            ALine l = new ALine(from, to);
            if (l.isOrthogonal()) {
                return Stream.of(l);
            }
            return ShapeEditMode.getOrthoPts(from, to).map(p -> AUtil.linkedList((Object[])new ALine[]{new ALine(from, p), new ALine(p, to)})).min((a, b) -> {
                long bs = b.stream().mapToLong(line -> ShapeEditMode.intersections(line, poly)).sum() + (long)(poly.pointInside(((ALine)b.get(0)).getP1()) ? 1 : 0);
                long as = a.stream().mapToLong(line -> ShapeEditMode.intersections(line, poly)).sum() + (long)(poly.pointInside(((ALine)a.get(0)).getP1()) ? 1 : 0);
                return Long.signum(as - bs);
            }).map(list -> list.stream()).orElseGet(Stream::empty);
        }

        @Override
        public IterableIterator<Action> getActions(Point loc) {
            LinkedList<Action> actions = new LinkedList<Action>();
            actions.add(this.getActionEndEdit());
            return AIterableItr.itr(actions);
        }

        protected Action getActionEndEdit() {
            return new AbstractAction("End Edit"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StateCreate.this.mUninstallClearsEditState = false;
                    if (!ShapeEditMode.this.autoExitEditing()) {
                        ShapeEditMode.this.setState(ShapeEditMode.this.getDefaultState());
                    }
                }
            };
        }

        protected AGeom setMovingPt(AGeom geom, APoint2D worldPt) {
            if (geom instanceof ARect) {
                return ARect.create((APoint2D)this.mPreviousPt, (APoint2D)worldPt);
            }
            if (geom instanceof AOctagon) {
                return new AOctagon(worldPt.distance(this.mPreviousPt), this.mPreviousPt);
            }
            if (geom instanceof APolygon) {
                APolygon poly = (APolygon)geom;
                poly.setPoint(poly.getPointCount() - 1, worldPt);
                return poly;
            }
            if (geom instanceof ACircle) {
                return new ACircle(this.mPreviousPt, worldPt.distance(this.mPreviousPt));
            }
            return null;
        }
    }

    protected class StateFind
    extends State {
        protected Consumer<ShapeCommands.HierGeom<T>> mOnComplete;
        protected ShapeCommands.HierGeom<T> mHighlightShape;

        protected StateFind() {
            this.mHighlightShape = null;
        }

        public void setOnComplete(Consumer<ShapeCommands.HierGeom<T>> onComplete) {
            this.mOnComplete = onComplete;
        }

        @Override
        public boolean enter() {
            ShapeEditMode.this.informUser("Click a shape to edit or press a shape button to create a new %s", new Object[]{ShapeEditMode.this.getCreatedObjectName()});
            return true;
        }

        @Override
        public boolean exit() {
            ShapeEditMode.this.informUser(null, new Object[0]);
            this.mHighlightShape = null;
            return super.exit();
        }

        @Override
        public void paintOverlay(Graphics2D g) {
            AGeom hlGeom;
            super.paintOverlay(g);
            RenderingHints oldRenderingHints = g.getRenderingHints();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color colorOld = g.getColor();
            AGeom aGeom = hlGeom = this.mHighlightShape == null ? null : this.mHighlightShape.getGeom();
            if (hlGeom != null) {
                g.setColor(Color.RED);
                g.setXORMode(Color.WHITE);
                DesignCanvas2D.drawGeom(g, ShapeEditMode.this.mView.getCanvas().getXForm(), hlGeom, this.mHighlightShape.getPath().getTransform(), null);
            }
            g.setPaintMode();
            g.setColor(colorOld);
            g.setRenderingHints(oldRenderingHints);
        }

        @Override
        public void mouseMove(DesignView2D.MouseAction e) {
            this.updateMouseLoc(e, false);
            super.mouseMove(e);
        }

        @Override
        public void mouseClick(DesignView2D.MouseAction e) {
            this.updateMouseLoc(e, true);
            if (this.mHighlightShape != null) {
                this.mOnComplete.accept(this.mHighlightShape);
                this.mHighlightShape = null;
            }
        }

        protected void updateMouseLoc(DesignView2D.MouseAction e, boolean useCp) {
            APoint2D worldPt = ShapeEditMode.this.getWorldPoint(e.getPoint());
            ShapeCommands.HierGeom hls = ShapeEditMode.this.findShape(worldPt, useCp);
            if (!AUtil.equals(this.mHighlightShape, hls)) {
                this.mHighlightShape = hls;
                ShapeEditMode.this.repaintOverlay();
            }
        }
    }

    protected abstract class State {
        protected State() {
        }

        public boolean enter() {
            return true;
        }

        public boolean exit() {
            return true;
        }

        public void mouseClick(DesignView2D.MouseAction e) {
        }

        public void mouseDrag(DesignView2D.MouseAction e) {
        }

        public void mouseEnter(DesignView2D.MouseAction e) {
        }

        public void mouseExit(DesignView2D.MouseAction e) {
        }

        public void mouseMove(DesignView2D.MouseAction e) {
            ShapeEditMode.this.setCursorLoc(ShapeEditMode.this.getWorldPoint(e));
        }

        public void mousePress(DesignView2D.MouseAction e) {
        }

        public void mouseRelease(DesignView2D.MouseAction e) {
        }

        public void paintOverlay(Graphics2D g) {
        }

        public IterableIterator<Action> getActions(Point loc) {
            return AEmptyItr.create();
        }

        public void prepareContexMenu(JPopupMenu menu, Point loc) {
        }
    }

    public static interface OverlayPainter {
        public void paintOverlay(Graphics2D var1);
    }
}

