/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.side_panels;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import com.sigrity.tools.dbexplorer.tree.DbTreeModel;
import javax.swing.Icon;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreeModel;

public class CurDbDeviceHierarchyPanel
extends DbExplorerPanel
implements OrbitApp.CurrentDbListener {
    public static final String NAME = "Device Hierarchy";
    private static boolean isRegistered = false;
    private static SingleCDockableFactory dockableFactory = id -> {
        DefaultSingleCDockable dockable = new DefaultSingleCDockable(id, new CAction[0]);
        dockable.setLocation((CLocation)CLocation.base().normalRectangle(0.0, 0.75, 0.2, 0.25));
        dockable.setCloseable(false);
        dockable.setMinimizable(false);
        dockable.setTitleIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.LIBRARY_HIERARCHY, (int)16, (int)16));
        return dockable;
    };
    protected OrbitIO mApp = null;

    public static void registerDockingUI() {
        if (isRegistered) {
            return;
        }
        OrbitGuiWS ws = OrbitIO.getApp().getWorkspace();
        if (ws == null) {
            return;
        }
        CControl dockControl = ws.getDockingController();
        dockControl.addSingleDockableFactory(CurDbDeviceHierarchyPanel.class.getName(), dockableFactory);
        isRegistered = true;
    }

    public CurDbDeviceHierarchyPanel(OrbitIO app, DbExplorerPanel.ExploreNetListener enl) {
        super(NAME, false);
        this.mApp = app;
        this.setRelationDisplay(DbExplorerPanel.RELATION_DISPLAY.HIDE);
        this.setExploreNetListener(enl);
    }

    public void currentDbChanged(Db newDb) {
        this.setDb(newDb);
    }

    @Override
    public void updateCurDbTo(Db db) {
        this.mDb = db;
        TreeModel tm = this.mTree.getModel();
        if (tm instanceof DbTreeModel) {
            DbTreeModel dbtm = (DbTreeModel)((Object)tm);
            dbtm.dispose();
        }
        if (db != null) {
            this.mTree.setRootVisible(false);
        } else {
            this.mTree.setModel(null);
        }
        if (db != null) {
            TreeUI backupUI = this.mTree.getUI();
            this.mTree.setUI(null);
            this.mTree.setRootVisible(true);
            if (Design.getDesign((Db)db) != null) {
                DbTreeModel dbtm = new DbTreeModel();
                DbExplorerPanel.DeviceHierarchyRootNode hrn = new DbExplorerPanel.DeviceHierarchyRootNode(this, null);
                hrn.setModel(dbtm);
                int defaultOpenLevels = (Integer)Settings.getSettings((String)"UserPreferences").getSetting("DfltHiearchyExplorerLevels", (Object)-1);
                hrn.setDefaultOpenLevels(defaultOpenLevels);
                dbtm.setRoot(hrn);
                this.mTree.setModel((TreeModel)((Object)dbtm));
            }
            this.mTree.setUI(backupUI);
        }
        if (db != null) {
            this.mPnlSearch.setTree(this.mTree);
            this.mPnlSelJump.setTree(this.mTree);
        } else {
            this.mPnlSearch.getTreeSearchUI().setModel(null);
            this.mPnlSelJump.getTreeSearchUI().setModel(null);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setDb(this.mApp.getCurrentDb());
        this.mApp.addCurrentDbListener(this);
    }

    @Override
    public void removeNotify() {
        this.mApp.removeCurrentDbListener(this);
        this.setDb(null);
        super.removeNotify();
    }
}

