/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.side_panels;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import com.sigrity.tools.dbexplorer.tree.DbTreeNode;
import javax.swing.Icon;
import javax.swing.tree.TreeModel;

public class CurDbExplorerPanel
extends DbExplorerPanel
implements OrbitApp.CurrentDbListener {
    public static final String NAME = "Design Explorer";
    private static boolean isRegistered = false;
    private static SingleCDockableFactory dockableFactory = id -> {
        DefaultSingleCDockable dockable = new DefaultSingleCDockable(id, new CAction[0]);
        dockable.setLocation((CLocation)CLocation.base().normalWest(0.25));
        dockable.setCloseable(true);
        dockable.setMinimizable(false);
        dockable.setTitleIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.FOLDER_DESIGN_COG, (int)16, (int)16));
        return dockable;
    };
    protected OrbitIO mApp = null;

    public static void registerDockingUI() {
        if (isRegistered) {
            return;
        }
        OrbitGuiWS ws = OrbitIO.getGuiWorkspace();
        if (ws == null) {
            return;
        }
        CControl dockControl = ws.getDockingController();
        dockControl.addSingleDockableFactory(CurDbExplorerPanel.class.getName(), dockableFactory);
        isRegistered = true;
    }

    public CurDbExplorerPanel(OrbitIO app, DbExplorerPanel.ExploreNetListener enl) {
        super(NAME, false);
        this.mApp = app;
        this.setExploreNetListener(enl);
    }

    public void currentDbChanged(Db newDb) {
        this.setDb(newDb);
    }

    @Override
    public void updateCurDbTo(Db db) {
        Object rootNode;
        super.updateCurDbTo(db);
        TreeModel model = this.mTree.getModel();
        if (model != null && (rootNode = model.getRoot()) instanceof DbExplorerPanel.DatabaseNode) {
            DbExplorerPanel.DatabaseNode dn = (DbExplorerPanel.DatabaseNode)rootNode;
            for (DbTreeNode n : AUtil.getIterable(dn.children())) {
                if (!(n instanceof DbExplorerPanel.DeviceHierarchyRootNode)) continue;
                DbExplorerPanel.DeviceHierarchyRootNode hrn = (DbExplorerPanel.DeviceHierarchyRootNode)n;
                hrn.setDefaultOpenLevels(0);
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setDb(this.mApp.getCurrentDb());
        this.mApp.addCurrentDbListener(this);
    }

    @Override
    public void removeNotify() {
        this.mApp.removeCurrentDbListener(this);
        this.setDb(null);
        super.removeNotify();
    }

    static {
        CurDbExplorerPanel.registerDockingUI();
    }
}

