/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.side_panels;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.tools.dbexplorer.DbHistoryExplorerPanel;
import javax.swing.Icon;

public class CurDbHistoryPanel
extends DbHistoryExplorerPanel
implements OrbitApp.CurrentDbListener {
    public static final String NAME = "Undo History";
    private static boolean isRegistered = false;
    private static SingleCDockableFactory dockableFactory = id -> {
        DefaultSingleCDockable dockable = new DefaultSingleCDockable(id, new CAction[0]);
        dockable.setLocation((CLocation)CLocation.base().normalWest(0.25));
        dockable.setCloseable(true);
        dockable.setMinimizable(false);
        dockable.setCloseable(true);
        dockable.setMinimizable(false);
        dockable.setTitleIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.HISTORY, (int)16, (int)16));
        return dockable;
    };
    protected OrbitIO mApp = null;

    public static void registerDockingUI() {
        if (isRegistered) {
            return;
        }
        OrbitGuiWS ws = OrbitIO.getApp().getWorkspace();
        if (ws == null) {
            return;
        }
        CControl dockControl = ws.getDockingController();
        dockControl.addSingleDockableFactory(CurDbHistoryPanel.class.getName(), dockableFactory);
        isRegistered = true;
    }

    public CurDbHistoryPanel(OrbitIO app) {
        this.mApp = app;
        this.setName(NAME);
    }

    public void currentDbChanged(Db newDb) {
        this.setDb(newDb);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setDb(this.mApp.getCurrentDb());
        this.mApp.addCurrentDbListener(this);
    }

    @Override
    public void removeNotify() {
        this.mApp.removeCurrentDbListener(this);
        this.setDb(null);
        super.removeNotify();
    }

    static {
        CurDbHistoryPanel.registerDockingUI();
    }
}

