/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.side_panels;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import com.sigrity.tools.dbexplorer.tree.DbTreeModel;
import com.sigrity.tools.dbexplorer.tree.DbTreeNode;
import com.sigrity.tools.dbexplorer.tree.JitDbTreeNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;

public class CurDbNetExplorerPanel
extends DbExplorerPanel
implements OrbitApp.CurrentDbListener {
    public static final String NAME = "Net Explorer";
    public static final String CLIENTPROP_SHOWNETPORTS = "ShowNetPorts";
    private static boolean isRegistered = false;
    private static SingleCDockableFactory dockableFactory = id -> {
        DefaultSingleCDockable dockable = new DefaultSingleCDockable(id, new CAction[0]);
        dockable.setLocation((CLocation)CLocation.base().normalWest(0.25));
        dockable.setCloseable(true);
        dockable.setMinimizable(false);
        dockable.setCloseable(true);
        dockable.setMinimizable(false);
        dockable.setTitleIcon(UIUtil.getScaledIcon((Icon)DBEResources.ICON_DESIGNNETS, (int)16, (int)16));
        return dockable;
    };
    protected OrbitIO mApp = null;
    protected DbExplorerPanel.DeviceTemplatesNetsNode mDeviceTemplatesNetsNode;
    protected DbExplorerPanel.NetHierarchyDesignNetsNode mNetHierarchyDesignNetsNode;
    protected JMenuItem mMenuItemShowPorts = new JCheckBoxMenuItem(){
        {
            this.setText("Show pins");
            this.setSelected(CurDbNetExplorerPanel.this.getShowNetPorts());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CurDbNetExplorerPanel.this.setShowNetPorts(!CurDbNetExplorerPanel.this.getShowNetPorts());
                }
            });
        }
    };

    public static void registerDockingUI() {
        if (isRegistered) {
            return;
        }
        OrbitGuiWS ws = OrbitIO.getGuiWorkspace();
        if (ws == null) {
            return;
        }
        CControl dockControl = ws.getDockingController();
        dockControl.addSingleDockableFactory(CurDbNetExplorerPanel.class.getName(), dockableFactory);
        isRegistered = true;
    }

    public CurDbNetExplorerPanel(OrbitIO app, DbExplorerPanel.ExploreNetListener enl) {
        super(NAME, false);
        this.mApp = app;
        this.setExploreNetListener(enl);
    }

    public void currentDbChanged(Db newDb) {
        this.setDb(newDb);
    }

    @Override
    public void updateCurDbTo(Db db) {
        super.updateCurDbTo(db);
        if (db != null) {
            DbTreeModel m = (DbTreeModel)((Object)this.mTree.getModel());
            NetExplorerRootNode root = new NetExplorerRootNode(m);
            m.setRoot(root);
            this.mTree.setRootVisible(false);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setDb(this.mApp.getCurrentDb());
        this.mApp.addCurrentDbListener(this);
    }

    @Override
    public void removeNotify() {
        this.mApp.removeCurrentDbListener(this);
        this.setDb(null);
        super.removeNotify();
    }

    public void gotoNet(DevicePath devicePath, Net net) {
        this.mTree.setExpandsSelectedPaths(true);
        TreePath targetPath = null;
        if (devicePath != null) {
            int start;
            List path = NetMap.getPathFromTopNet((Net)net, (DevicePath)devicePath);
            Net top = ((NetMap)path.get(0)).getParentNet();
            if (top == null) {
                top = net;
            }
            LinkedList<DbTreeNode> treePath = new LinkedList<DbTreeNode>();
            treePath.add((DbTreeNode)this.mTree.getModel().getRoot());
            if (top.getDeviceTemplate() == null) {
                treePath.add(this.mNetHierarchyDesignNetsNode);
                treePath.add(this.mNetHierarchyDesignNetsNode.getChildFor(top));
            } else {
                treePath.add(this.mDeviceTemplatesNetsNode);
                DeviceTemplate dt = top.getDeviceTemplate();
                DbExplorerPanel.DeviceTemplateNetsNode dtnn = this.mDeviceTemplatesNetsNode.getChildFor(dt);
                treePath.add(dtnn);
                treePath.add(dtnn.getChildFor(top, null));
            }
            assert (treePath.getLast() != null);
            for (int i = start = ((NetMap)path.get(0)).getParentNet() == null ? 1 : 0; i < path.size(); ++i) {
                NetMap nm = (NetMap)path.get(i);
                DbExplorerPanel.NetHierarchyNode curLastNode = (DbExplorerPanel.NetHierarchyNode)treePath.getLast();
                DbExplorerPanel.NetHierarchyNode nhn = curLastNode.getChildFor(nm.getChildNet(), nm.getDevice());
                if (nhn == null) {
                    assert (false);
                    break;
                }
                treePath.add(nhn);
            }
            targetPath = new TreePath(treePath.toArray());
        } else {
            DeviceTemplate dt = net.getDeviceTemplate();
            DbExplorerPanel.DeviceTemplateNetsNode dtnn = this.mDeviceTemplatesNetsNode.getChildFor(dt);
            DbExplorerPanel.NetHierarchyNode netNode = dtnn.getChildFor(net, null);
            if (dtnn != null) {
                Object[] p = new Object[]{this.mTree.getModel().getRoot(), this.mDeviceTemplatesNetsNode, dtnn, netNode};
                targetPath = new TreePath(p);
            }
        }
        this.mTree.setSelectionPath(targetPath);
        this.mTree.scrollPathToVisible(targetPath);
    }

    @Override
    protected LinkedList<JMenuItem> createContextMenu() {
        LinkedList<JMenuItem> items = super.createContextMenu();
        items.add(1, this.mMenuItemShowPorts);
        return items;
    }

    public boolean getShowNetPorts() {
        return this.getClientProperty(CLIENTPROP_SHOWNETPORTS) != null;
    }

    public void setShowNetPorts(boolean b) {
        if (this.getShowNetPorts() == b) {
            return;
        }
        this.putClientProperty(CLIENTPROP_SHOWNETPORTS, b ? Boolean.valueOf(true) : null);
        CurDbNetExplorerPanel.refreshAll();
    }

    static {
        CurDbNetExplorerPanel.registerDockingUI();
    }

    public class NetExplorerRootNode
    extends JitDbTreeNode {
        public NetExplorerRootNode(DbTreeModel m) {
            super(m);
        }

        @Override
        public void populateChildren() {
            ArrayList<JitDbTreeNode> children = new ArrayList<JitDbTreeNode>();
            CurDbNetExplorerPanel.this.mDeviceTemplatesNetsNode = new DbExplorerPanel.DeviceTemplatesNetsNode(CurDbNetExplorerPanel.this, this);
            children.add(CurDbNetExplorerPanel.this.mDeviceTemplatesNetsNode);
            CurDbNetExplorerPanel.this.mNetHierarchyDesignNetsNode = new DbExplorerPanel.NetHierarchyDesignNetsNode(CurDbNetExplorerPanel.this, this);
            children.add(CurDbNetExplorerPanel.this.mNetHierarchyDesignNetsNode);
            this.mChildren = children;
        }

        @Override
        public String getText() {
            return "Net Explorer Root Node";
        }

        @Override
        public void render(DbExplorerPanel.DbTreeCellRenderer r) {
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            return other instanceof NetExplorerRootNode;
        }
    }
}

