/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.side_panels;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ADecoratedIcon;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.tools.dbexplorer.DbSelectionPanel;
import java.awt.Color;
import javax.swing.Icon;

public class CurDbSelectionPanel
extends DbSelectionPanel
implements OrbitApp.CurrentDbListener {
    public static final String NAME = "Selection Status";
    private static boolean isRegistered = false;
    private static SingleCDockableFactory dockableFactory = id -> {
        DefaultSingleCDockable dockable = new DefaultSingleCDockable(id, new CAction[0]);
        dockable.setLocation((CLocation)CLocation.base().normalRectangle(0.7, 0.75, 0.1, 0.25));
        dockable.setCloseable(true);
        dockable.setMinimizable(false);
        dockable.setCloseable(true);
        dockable.setMinimizable(false);
        dockable.setTitleIcon(CurDbSelectionPanel.getIcon());
        return dockable;
    };
    protected OrbitIO mApp = null;

    private static Icon getIcon() {
        AColorIcon bg = new AColorIcon(16, 16, new Color(0.0f, 0.0f, 0.0f, 0.0f));
        Icon select = UIUtil.getScaledIcon((Icon)OrbitIcons.SELECT, (int)14, (int)14);
        ADecoratedIcon main = new ADecoratedIcon((Icon)bg, select, ADecoratedIcon.POSX.LEFT, ADecoratedIcon.POSY.TOP);
        return new ADecoratedIcon((Icon)main, (Icon)notifyIcon, ADecoratedIcon.POSX.RIGHT, ADecoratedIcon.POSY.BOTTOM);
    }

    public static void registerDockingUI() {
        if (isRegistered) {
            return;
        }
        OrbitGuiWS ws = OrbitIO.getApp().getWorkspace();
        if (ws == null) {
            return;
        }
        CControl dockControl = ws.getDockingController();
        dockControl.addSingleDockableFactory(CurDbSelectionPanel.class.getName(), dockableFactory);
        isRegistered = true;
    }

    public CurDbSelectionPanel(OrbitIO app) {
        this.mApp = app;
        this.setName(NAME);
    }

    public void currentDbChanged(Db newDb) {
        this.setDb(newDb);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setDb(this.mApp.getCurrentDb());
        this.mApp.addCurrentDbListener(this);
    }

    @Override
    public void removeNotify() {
        this.mApp.removeCurrentDbListener(this);
        this.setDb(null);
        super.removeNotify();
    }

    @Override
    protected void updateNotifyMessage(Selection s) {
        super.updateNotifyMessage(s);
        OrbitGuiWS ws = OrbitIO.getApp().getWorkspace();
        if (ws != null) {
            DefaultSingleCDockable d = ws.getSingleDockable(this.getClass().getName());
            Icon newIcon = CurDbSelectionPanel.getIcon();
            d.setTitleIcon(newIcon);
            ws.getDockToolBar().updateTitleIcon(d, newIcon);
        }
    }
}

