/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.side_panels;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import com.sigrity.acl.ALog;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;

public class CurModeOptionPanel
extends JPanel {
    public static final String NAME = "Options";
    private static boolean isRegistered = false;
    private static SingleCDockableFactory dockableFactory = id -> {
        DefaultSingleCDockable dockable = new DefaultSingleCDockable(id, new CAction[0]);
        dockable.setLocation((CLocation)CLocation.base().normalRectangle(0.8, 0.0, 0.2, 0.2));
        dockable.setCloseable(true);
        dockable.setMinimizable(false);
        dockable.setTitleIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.COG, (int)16, (int)16));
        return dockable;
    };
    protected OrbitIO mApp;

    public static void registerDockingUI() {
        if (isRegistered) {
            return;
        }
        OrbitGuiWS ws = OrbitIO.getApp().getWorkspace();
        if (ws == null) {
            ALog.logError((String)"Fail");
            return;
        }
        CControl dockControl = ws.getDockingController();
        dockControl.addSingleDockableFactory(CurModeOptionPanel.class.getName(), dockableFactory);
        isRegistered = true;
    }

    public CurModeOptionPanel(OrbitIO app) {
        this.setName(NAME);
        this.mApp = app;
    }

    public void load(JPanel panel) {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (panel != null) {
            this.add((Component)panel, "Center");
        }
    }

    public void clear() {
        this.removeAll();
    }
}

