/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.side_panels;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.jfxui.AJFXButton;
import com.sigrity.acl.jfxui.AJFXDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitUIMisc;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import com.sigrity.tools.dbexplorer.NodeIcons;
import com.sigrity.tools.dbexplorer.NodeOptions;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashSet;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Accordion;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Separator;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class DbExplorerConfigDialog
extends AJFXDialog {
    protected final DbExplorerPanel mExplorer;
    EventHandler<ActionEvent> mOkHandler = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent e) {
            UIUtil.closeWindow((Window)((Object)DbExplorerConfigDialog.this));
            DbExplorerConfigDialog.this.mExplorer.refresh();
        }
    };

    public static void show(DbExplorerPanel explorer) {
        String title = String.format("%s - Properties", explorer.getName());
        DbExplorerConfigDialog dialog = new DbExplorerConfigDialog(OrbitIO.getMainWindow(), title, explorer);
        dialog.setVisible(true);
        dialog.setResizable(false);
    }

    public DbExplorerConfigDialog(Window owner, String title, DbExplorerPanel explorer) {
        super(owner, title);
        this.mExplorer = explorer;
        this.init();
        this.setModal(true);
    }

    protected AJFXPanel createJfxPanel() {
        return new ConfigPanel();
    }

    private class ConfigPanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 600;
        private static final int PANEL_HEIGHT = 460;

        public ConfigPanel() {
            this.setPreferredSize(new Dimension(600, 460));
        }

        protected Parent initSceneGraph() {
            BorderPane pane = new BorderPane();
            pane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            TitledPane extraBox = new TitledPane("Extra Information", (Node)this.getExtraPane());
            extraBox.setCollapsible(false);
            TitledPane iconBox = new TitledPane("Icon Descoration", (Node)this.getIconPane());
            iconBox.setCollapsible(false);
            TitledPane deviceBox = new TitledPane("Device", (Node)this.getDevicePane());
            TitledPane netBox = new TitledPane("Net", (Node)this.getNetPane());
            TitledPane pinBox = new TitledPane("Pin", (Node)this.getPinPane());
            VBox main = new VBox(10.0);
            HBox misc = new HBox(5.0);
            Accordion accordion = new Accordion();
            accordion.getPanes().addAll((Object[])new TitledPane[]{deviceBox, netBox, pinBox});
            accordion.setExpandedPane(deviceBox);
            misc.getChildren().addAll((Object[])new Node[]{extraBox, iconBox});
            VBox.setVgrow((Node)extraBox, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)extraBox, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)iconBox, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)iconBox, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)misc, (Priority)Priority.ALWAYS);
            misc.setPrefHeight(100.0);
            accordion.setPrefHeight(300.0);
            main.getChildren().addAll((Object[])new Node[]{misc, accordion});
            AJFXButton okBtn = AJFXButton.createOkBtn(DbExplorerConfigDialog.this.mOkHandler);
            HBox bottom = new HBox(5.0);
            bottom.getChildren().add((Object)okBtn);
            bottom.setAlignment(Pos.CENTER_RIGHT);
            pane.setTop((Node)main);
            pane.setBottom((Node)bottom);
            return pane;
        }

        public Pane getExtraPane() {
            VBox extraBox = new VBox(5.0);
            CheckBox showRelations = new CheckBox("Show Relations");
            showRelations.setSelected(DbExplorerConfigDialog.this.mExplorer.isShowRelations());
            showRelations.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean oldVal, Boolean newVal) {
                    if (newVal.booleanValue()) {
                        DbExplorerConfigDialog.this.mExplorer.setRelationDisplay(DbExplorerPanel.RELATION_DISPLAY.DISPLAY);
                    } else {
                        DbExplorerConfigDialog.this.mExplorer.setRelationDisplay(DbExplorerPanel.RELATION_DISPLAY.HIDE);
                    }
                }
            });
            extraBox.getChildren().add((Object)showRelations);
            return extraBox;
        }

        public Pane getIconPane() {
            VBox iconBox = new VBox(5.0);
            CheckBox showDeviceDir = new CheckBox("Show Device Direction");
            CheckBox showBumpDir = new CheckBox("Show Bump Direction");
            CheckBox showContactAttr = new CheckBox("Show Contact Attribute");
            Design design = Design.getDesign((Db)OrbitIO.getCurDb());
            showDeviceDir.setSelected(NodeIcons.isShowDeviceDirection(design));
            showDeviceDir.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean oldVal, Boolean newVal) {
                    NodeIcons.setShowDeviceDirection(newVal);
                }
            });
            showBumpDir.setSelected(NodeIcons.isShowBumpDirection(design));
            showBumpDir.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean oldVal, Boolean newVal) {
                    NodeIcons.setShowBumpDirection(newVal);
                }
            });
            showContactAttr.setSelected(NodeIcons.isShowContactAttribute(design));
            showContactAttr.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean oldVal, Boolean newVal) {
                    NodeIcons.setShowContactAttribute(newVal);
                }
            });
            iconBox.getChildren().addAll((Object[])new Node[]{showDeviceDir, showBumpDir, showContactAttr});
            return iconBox;
        }

        public Pane getPinPane() {
            HBox pinBox = new HBox(10.0);
            CheckBox typeCb = new CheckBox("Group By Type");
            typeCb.setSelected(NodeOptions.getGroupPinByType());
            typeCb.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean oldVal, Boolean newVal) {
                    NodeOptions.setGroupPinByType(newVal);
                }
            });
            pinBox.getChildren().add((Object)typeCb);
            return pinBox;
        }

        public Pane getNetPane() {
            HBox netBox = new HBox(10.0);
            VBox filterNetBox = new VBox(5.0);
            VBox groupNetBox = new VBox(5.0);
            VBox sortNetBox = new VBox(5.0);
            filterNetBox.getChildren().addAll((Object[])new Node[]{new Label("Filter"), new Separator()});
            final ToggleGroup netFilterGroup = new ToggleGroup();
            for (DeviceTemplate.NetFilter nf : OrbitIO.getOrbitIO().getNetFilters()) {
                RadioButton option = new RadioButton(nf.getName());
                Tooltip tooltip = new Tooltip();
                tooltip.setText(nf.getDescription());
                option.setTooltip(tooltip);
                option.setToggleGroup(netFilterGroup);
                option.setSelected(nf == NodeOptions.getDefaultNetFilter());
                option.setUserData((Object)nf);
                filterNetBox.getChildren().add((Object)option);
            }
            netFilterGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                public void changed(ObservableValue<? extends Toggle> ov, Toggle oldVal, Toggle newVal) {
                    if (netFilterGroup.getSelectedToggle() != null) {
                        DeviceTemplate.NetFilter nf = (DeviceTemplate.NetFilter)netFilterGroup.getSelectedToggle().getUserData();
                        NodeOptions.setDefaultNetFilter(nf);
                    }
                }
            });
            CheckBox intfCb = new CheckBox("Interface");
            CheckBox pgCb = new CheckBox("Power/Ground Signal");
            intfCb.setSelected(NodeOptions.getGroupNetByInterface());
            pgCb.setSelected(NodeOptions.getGroupNetByPowerSignal());
            intfCb.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean oldVal, Boolean newVal) {
                    NodeOptions.setGroupNetByInterface(newVal);
                }
            });
            pgCb.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean oldVal, Boolean newVal) {
                    NodeOptions.setGroupNetByPowerSignal(newVal);
                }
            });
            groupNetBox.getChildren().addAll((Object[])new Node[]{new Label("Group"), new Separator()});
            groupNetBox.getChildren().addAll((Object[])new Node[]{intfCb, pgCb});
            sortNetBox.getChildren().addAll((Object[])new Node[]{new Label("Sort"), new Separator()});
            final ToggleGroup sortGroup = new ToggleGroup();
            for (NodeOptions.SortType t : NodeOptions.SortType.values()) {
                RadioButton option = new RadioButton(t.getName());
                Tooltip tooltip = new Tooltip();
                tooltip.setText(t.getDescription());
                option.setTooltip(tooltip);
                option.setToggleGroup(sortGroup);
                option.setSelected(t == NodeOptions.getSortType());
                option.setUserData((Object)t);
                sortNetBox.getChildren().add((Object)option);
            }
            sortGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                public void changed(ObservableValue<? extends Toggle> ov, Toggle oldVal, Toggle newVal) {
                    if (sortGroup.getSelectedToggle() != null) {
                        NodeOptions.SortType sortType = (NodeOptions.SortType)((Object)sortGroup.getSelectedToggle().getUserData());
                        NodeOptions.setSortType(sortType);
                    }
                }
            });
            netBox.getChildren().addAll((Object[])new Node[]{filterNetBox, groupNetBox, sortNetBox});
            return netBox;
        }

        public Pane getDevicePane() {
            HBox deviceBox = new HBox(5.0);
            VBox groupDeviceBox = new VBox(5.0);
            GridPane typeList = new GridPane();
            typeList.setHgap(16.0);
            groupDeviceBox.getChildren().addAll((Object[])new Node[]{new Label("Group"), new Separator(), typeList});
            final ArrayList<CheckBox> group = new ArrayList<CheckBox>();
            int counter = 0;
            for (DeviceTemplate.Type t : OrbitUIMisc.GroupDeviceTemplateTypes) {
                CheckBox cb = new CheckBox(t.toString());
                cb.setUserData((Object)t);
                cb.setSelected(NodeOptions.getDeviceGroupTypes().contains(t));
                cb.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> ov, Boolean oldVal, Boolean newVal) {
                        HashSet<DeviceTemplate.Type> selTypes = new HashSet<DeviceTemplate.Type>();
                        for (CheckBox c : group) {
                            if (!c.isSelected()) continue;
                            selTypes.add((DeviceTemplate.Type)c.getUserData());
                        }
                        NodeOptions.setDeviceGroupTypes(selTypes);
                    }
                });
                group.add(cb);
                typeList.add((Node)cb, counter % 2, counter / 2);
                ++counter;
            }
            VBox extraGroupBox = new VBox(5.0);
            CheckBox unplacedCb = new CheckBox("Show Unplaced Group");
            unplacedCb.setSelected(NodeOptions.getGroupUnplacedDevice());
            unplacedCb.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean oldVal, Boolean newVal) {
                    NodeOptions.setGroupUnplacedDevice(newVal);
                }
            });
            extraGroupBox.getChildren().addAll((Object[])new Node[]{new Label("Extra"), new Separator(), unplacedCb});
            deviceBox.getChildren().addAll((Object[])new Node[]{groupDeviceBox, extraGroupBox});
            return deviceBox;
        }
    }
}

