/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.side_panels;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import com.sigrity.acl.ALog;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.ViewAdapter;
import com.sigrity.acl.app.ViewListener;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.JFXUtil;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DbObjectHighlighter;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPortShape;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.side_panels.sel_option.DesignPanel;
import com.sigrity.orbit.ui.side_panels.sel_option.DevPanel;
import com.sigrity.orbit.ui.side_panels.sel_option.DevTemplatePanel;
import com.sigrity.orbit.ui.side_panels.sel_option.LayerPanel;
import com.sigrity.orbit.ui.side_panels.sel_option.NetPanel;
import com.sigrity.orbit.ui.side_panels.sel_option.ObstaclePanel;
import com.sigrity.orbit.ui.side_panels.sel_option.PinTemplatePanel;
import com.sigrity.orbit.ui.side_panels.sel_option.PortTemplatePanel;
import com.sigrity.orbit.ui.side_panels.sel_option.StackLayout;
import com.sigrity.orbit.ui.side_panels.sel_option.SubstratePanel;
import com.sigrity.orbit.ui.side_panels.sel_option.TermPanel;
import java.awt.Dimension;
import java.util.Optional;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Border;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class EditAttributePanel
extends AJFXPanel {
    private static final String NAME = "Attribute Editor";
    private static boolean isRegistered = false;
    private static SingleCDockableFactory attrEditorDockableFactory = id -> {
        DefaultSingleCDockable dockable = new DefaultSingleCDockable(id, new CAction[0]);
        dockable.setLocation((CLocation)CLocation.base().normalWest(0.25));
        dockable.setTitleIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.INFORMATION, (int)16, (int)16));
        dockable.setTitleText(NAME);
        dockable.setCloseable(false);
        return dockable;
    };
    protected static final Selection.SelectionListener sSelListener = e -> EditAttributePanel.tryRefresh();
    protected static final OrbitApp.CurrentDbListener sCurDbListener = e -> EditAttributePanel.tryRefresh();
    protected static final DbHistory.Listener sDbTransListener = new DbHistory.ListenerAdapter(){

        public void coalesceChange(boolean newCoalesceState) {
            if (!newCoalesceState) {
                EditAttributePanel.tryRefresh();
            }
        }
    };
    protected static final DbObjectHighlighter.HighlightListener sHighlightListener = new DbObjectHighlighter.HighlightListener(){

        @Override
        public void highlight(DbObjectHighlighter highlighter) {
            Optional<HierInst<DbObject>> hierObj = highlighter.getHighlights().findFirst();
            if (hierObj.isPresent()) {
                EditAttributePanel.tryRefresh(hierObj.get());
            }
        }

        @Override
        public void clear(DbObjectHighlighter highlighter) {
        }
    };
    private HierInst<DbObject> mHierInst;
    private StackLayout.LAYOUT mLayoutType = StackLayout.LAYOUT.HORIZONTAL;
    private boolean isUpdating = false;
    private Pane mContentPane;
    private Pane mDetail;
    private ToolBar mToolBar;

    public static void registerDockingUI() {
        if (isRegistered) {
            return;
        }
        OrbitIO app = OrbitIO.getApp();
        OrbitGuiWS ws = app.getWorkspace();
        if (ws == null) {
            return;
        }
        CControl dockControl = ws.getDockingController();
        dockControl.addSingleDockableFactory(EditAttributePanel.class.getName(), attrEditorDockableFactory);
        ViewAdapter viewListener = new ViewAdapter(){

            public void activeViewChanged(AAppView oldView, AAppView newView) {
                EditAttributePanel.installListeners(newView == null ? null : newView.getDb());
                EditAttributePanel.tryRefresh(null);
            }

            public void viewOpened(AAppView view) {
                EditAttributePanel.installListeners(view.getDb());
            }
        };
        ws.addViewListener((ViewListener)viewListener);
        isRegistered = true;
        app.addCurrentDbListener(sCurDbListener);
        DbObjectHighlighter.addHighlightListener(sHighlightListener);
    }

    private static void installListeners(Db db) {
        if (db == null || db.closed()) {
            return;
        }
        if (Design.getSelection((Db)db) != null) {
            Design.getSelection((Db)db).addSelectionListener(sSelListener);
        }
        db.getHistory().addListener(sDbTransListener);
    }

    private static void tryRefresh() {
        HierInst hierInst;
        Db db = OrbitIO.getCurDb();
        if (db == null || db.getHistory().inTransactionCoalesce()) {
            return;
        }
        Design design = Design.getDesign((Db)db);
        if (design == null) {
            return;
        }
        Selection sel = design.getCurSelection();
        IterableIterator allHierInsts = sel.getAllHierInsts();
        HierInst hierInst2 = hierInst = !allHierInsts.hasNext() ? null : (HierInst)allHierInsts.next();
        if (hierInst != null) {
            EditAttributePanel.tryRefresh((HierInst<DbObject>)hierInst);
        }
    }

    private static void tryRefresh(HierInst<DbObject> hierInst) {
        OrbitIO app = OrbitIO.getApp();
        OrbitGuiWS ws = app.getWorkspace();
        EditAttributePanel editor = ws.getEditAttributePanel();
        if (editor != null) {
            editor.refresh(hierInst);
        }
    }

    public EditAttributePanel() {
        this.setName(NAME);
        this.setPreferredSize(new Dimension(800, 400));
        this.init();
    }

    private void refresh(HierInst<DbObject> hierInst) {
        this.mHierInst = hierInst;
        if (!this.isUpdating) {
            this.isUpdating = true;
            Platform.runLater(() -> {
                this.isUpdating = false;
                this.update(hierInst);
                SwingUtilities.invokeLater(() -> {
                    this.validate();
                    this.revalidate();
                    this.repaint();
                });
            });
        }
    }

    protected Parent initSceneGraph() {
        this.mDetail = EditAttributePanel.createLayoutPane(this.mLayoutType);
        this.mToolBar = new ToolBar();
        this.mContentPane = new VBox(5.0);
        this.refresh();
        this.relayout();
        return this.mContentPane;
    }

    private void relayout() {
        this.mContentPane.getChildren().clear();
        ScrollPane scrollPane = new ScrollPane((Node)this.mDetail);
        VBox.setVgrow((Node)scrollPane, (Priority)Priority.ALWAYS);
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        this.mContentPane.getChildren().addAll((Object[])new Node[]{this.mToolBar, scrollPane});
    }

    private void createDesignStack(Design design) {
        if (design == null) {
            return;
        }
        this.mDetail.getChildren().add((Object)new DesignPanel(design, this.mLayoutType));
    }

    private void createDevStack(DevicePath path, Device dev) {
        if (dev == null) {
            return;
        }
        this.mDetail.getChildren().add((Object)new DevPanel(dev, this.mLayoutType));
        this.createDevTemplateStack(path, dev.getTemplate());
    }

    private void createDevTemplateStack(DevicePath path, DeviceTemplate devT) {
        if (devT == null) {
            return;
        }
        this.mDetail.getChildren().add((Object)new DevTemplatePanel(devT, this.mLayoutType));
        if (devT.getType() != DeviceTemplate.Type.GROUP) {
            this.createSubstrateStack(path, devT.getSubstrate());
        }
    }

    private void createNetStack(DevicePath path, Net net) {
        if (net == null) {
            return;
        }
        this.mDetail.getChildren().add((Object)new NetPanel(net, this.mLayoutType));
        this.createDevTemplateStack(path, net.getDeviceTemplate());
    }

    private void createTermStack(DevicePath path, Term term) {
        if (term == null) {
            return;
        }
        this.mDetail.getChildren().add((Object)new TermPanel(term, this.mLayoutType));
        this.createNetStack(path, term.getNet());
    }

    private void createLayerStack(Layer l, boolean expand) {
        if (l == null) {
            return;
        }
        this.mDetail.getChildren().add((Object)new LayerPanel(l, this.mLayoutType));
        if (expand) {
            this.createSubstrateStack(null, l.getSubstrate());
        }
    }

    private void createSubstrateStack(DevicePath path, Substrate s) {
        if (s == null) {
            return;
        }
        this.mDetail.getChildren().add((Object)new SubstratePanel(s, this.mLayoutType));
    }

    private void createAlertStack(DbObject obj) {
        if (obj == null) {
            return;
        }
        this.mDetail.getChildren().add((Object)new Label(String.format("Unsupport %s type.", obj.getTypeName())));
    }

    private void createPinTemplateStack(DevicePath path, PinTemplate pt) {
        this.mDetail.getChildren().add((Object)new PinTemplatePanel(pt, this.mLayoutType));
        this.createNetStack(path, pt.getNet());
    }

    private void createPortTemplateStack(DevicePath path, PortTemplate port) {
        this.mDetail.getChildren().add((Object)new PortTemplatePanel(port, this.mLayoutType));
        this.createPinTemplateStack(path, port.getPinTemplate());
    }

    private void createObstacleStack(DevicePath path, Obstacle obs) {
        this.mDetail.getChildren().add((Object)new ObstaclePanel(obs, this.mLayoutType));
        this.createDevTemplateStack(path, obs.getDeviceTemplate());
    }

    private static Pane createLayoutPane(StackLayout.LAYOUT layoutType) {
        if (layoutType == StackLayout.LAYOUT.VERTICAL) {
            return new VBox(5.0);
        }
        return new VBox(0.0);
    }

    public void update(HierInst<DbObject> hier) {
        this.mHierInst = hier;
        this.refresh();
    }

    private void addDbObjectNode(HierInst<DbObject> hier) {
        DbObject dbo;
        DevicePath path = hier == null ? null : hier.getPath();
        DbObject dbObject = dbo = hier == null ? null : hier.getDbObject();
        if (dbo == null && OrbitIO.getCurDb() != null) {
            Design design = OrbitIO.getCurDesign();
            path = new DevicePath((DeviceTemplate)design);
            dbo = design;
        }
        if (dbo == null || dbo.getDb() == null || dbo.getDb().closed() || dbo.getDb() != OrbitIO.getCurDb()) {
            return;
        }
        if (dbo instanceof Design) {
            this.createDesignStack((Design)dbo);
        } else if (dbo instanceof Device) {
            this.createDevStack(path, (Device)dbo);
        } else if (dbo instanceof DeviceTemplate) {
            this.createDevTemplateStack(path, (DeviceTemplate)dbo);
        } else if (dbo instanceof Net) {
            this.createNetStack(path, (Net)dbo);
        } else if (dbo instanceof Term) {
            this.createTermStack(path, (Term)dbo);
        } else if (dbo instanceof Substrate) {
            this.createSubstrateStack(path, (Substrate)dbo);
        } else if (dbo instanceof PinInstance) {
            this.createPinTemplateStack(path, ((PinInstance)dbo).getPinTemplate());
        } else if (dbo instanceof PinTemplate) {
            this.createPinTemplateStack(path, (PinTemplate)dbo);
        } else if (dbo instanceof PortTemplate) {
            this.createPortTemplateStack(path, (PortTemplate)dbo);
        } else if (dbo instanceof Wire) {
            this.createDevTemplateStack(path, ((Wire)dbo).getDeviceTemplate());
        } else if (dbo instanceof Metal) {
            this.createDevTemplateStack(path, ((Metal)dbo).getDeviceTemplate());
        } else if (dbo instanceof Bundle) {
            this.createDevTemplateStack(path, ((Bundle)dbo).getTemplate());
        } else if (dbo instanceof PadTemplate) {
            this.createSubstrateStack(path, ((PadTemplate)dbo).getSubstrate());
        } else if (dbo instanceof Obstacle) {
            this.createObstacleStack(path, (Obstacle)dbo);
        } else if (dbo instanceof LayerShape && HierPortShape.class.isInstance(hier)) {
            HierPortShape hpshape = (HierPortShape)HierPortShape.class.cast(hier);
            this.createLayerStack(hpshape.getLayer(), false);
            this.createPortTemplateStack(path, (PortTemplate)hpshape.getOwner());
        } else if (dbo instanceof Layer) {
            this.createLayerStack((Layer)dbo, true);
        } else {
            this.createAlertStack(dbo);
        }
    }

    private void refresh() {
        Platform.runLater(() -> {
            this.mDetail.getChildren().clear();
            try {
                this.addDbObjectNode(this.mHierInst);
            }
            catch (Exception e) {
                ALog.logDebug((String)"Refresh 'Attribute Editor' failed");
            }
        });
    }

    private class ToolBar
    extends HBox {
        public ToolBar() {
            super(0.0);
            ToggleGroup group = new ToggleGroup();
            ToggleButton h = new ToggleButton();
            ToggleButton v = new ToggleButton();
            h.setBorder(Border.EMPTY);
            v.setBorder(Border.EMPTY);
            h.setToggleGroup(group);
            h.setGraphic((Node)new ImageView(JFXUtil.getFxImage((Icon)OrbitIcons.VIEW_VERTICAL)));
            h.setUserData((Object)StackLayout.LAYOUT.HORIZONTAL);
            h.setSelected(true);
            v.setToggleGroup(group);
            v.setGraphic((Node)new ImageView(JFXUtil.getFxImage((Icon)OrbitIcons.VIEW_HORIZONTAL)));
            v.setUserData((Object)StackLayout.LAYOUT.VERTICAL);
            this.getChildren().addAll((Object[])new Node[]{h, v});
            this.setAlignment(Pos.CENTER_LEFT);
            group.selectedToggleProperty().addListener((ov, oldVal, newVal) -> {
                EditAttributePanel.this.mLayoutType = (StackLayout.LAYOUT)((Object)((Object)newVal.getUserData()));
                EditAttributePanel.this.mDetail = EditAttributePanel.createLayoutPane(EditAttributePanel.this.mLayoutType);
                EditAttributePanel.this.relayout();
                EditAttributePanel.this.refresh();
            });
        }
    }
}

