/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.side_panels;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.flowman.Flow;
import com.sigrity.flowman.FlowIcons;
import com.sigrity.flowman.ui.FlowWorkspacePanel;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import javax.swing.Icon;
import javax.swing.JPanel;

public class FlowManPanel
extends JPanel {
    public static final String NAME = "Flow Manager";
    private static boolean isRegistered = false;
    private static SingleCDockableFactory dockableFactory = id -> {
        DefaultSingleCDockable dockable = new DefaultSingleCDockable(id, new CAction[0]);
        dockable.setLocation((CLocation)CLocation.base().normalRectangle(0.0, 0.0, 0.2, 0.75));
        dockable.setCloseable(true);
        dockable.setMinimizable(false);
        dockable.setCloseable(true);
        dockable.setMinimizable(false);
        dockable.setTitleIcon(UIUtil.getScaledIcon((Icon)FlowIcons.FLOW, (int)16, (int)16));
        return dockable;
    };
    protected OrbitIO mApp = null;
    protected FlowWorkspacePanel mFlowWorkspace = null;

    public static void registerDockingUI() {
        if (isRegistered) {
            return;
        }
        OrbitGuiWS ws = OrbitIO.getApp().getWorkspace();
        if (ws == null) {
            return;
        }
        CControl dockControl = ws.getDockingController();
        dockControl.addSingleDockableFactory(FlowManPanel.class.getName(), dockableFactory);
        isRegistered = true;
    }

    public FlowManPanel(OrbitIO app) {
        this.mApp = app;
        this.setName(NAME);
        GridBagManager l = new GridBagManager((Container)this);
        this.mFlowWorkspace = new FlowWorkspacePanel();
        l.add((Component)this.mFlowWorkspace, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
    }

    public boolean showFlow(Flow flow) {
        return this.mFlowWorkspace.openFlow(flow);
    }

    static {
        FlowManPanel.registerDockingUI();
    }
}

