/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.side_panels;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import com.google.common.collect.Lists;
import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.AFileExplorer;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.ViewAdapter;
import com.sigrity.acl.app.ViewListener;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.ui.AFileBreadcrumb;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.AMenuUtil;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FilenameUtils;

public class ResourceManPanel
extends JPanel {
    public static final String NAME = "Resource Manager";
    private static final String OPEN_FILE_ACTION_NAME = "Open File";
    private static final String BROWSE_FILE_DIRECTORY_ACTION_NAME = "Open File Location";
    private static boolean isRegistered = false;
    private static SingleCDockableFactory dockableFactory = id -> {
        DefaultSingleCDockable dockable = new DefaultSingleCDockable(id, new CAction[0]);
        dockable.setLocation((CLocation)CLocation.base().normalRectangle(0.0, 0.0, 0.2, 0.75));
        dockable.setCloseable(true);
        dockable.setMinimizable(false);
        dockable.setTitleIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.STACK, (int)16, (int)16));
        return dockable;
    };
    protected OrbitIO mApp = null;
    protected Db mDb = null;
    protected static File mWorkspace = new File(System.getProperty("user.dir"));
    protected JTree mTree = null;
    protected JScrollPane mScrollTree;
    protected AFileBreadcrumb mFileBread;
    protected boolean mRefreshPending = false;
    protected ViewAdapter mViewListener = new ViewAdapter(){

        public void activeViewChanged(AAppView oldView, AAppView newView) {
            ResourceManPanel.this.refresh();
        }
    };
    protected static final Map<Class<?>, Integer> mNodeClassOrder = AUtil.indexMap((Object[])new Class[]{ResourceRootNode.class, RecentDesignsNode.class, RecentScriptsNode.class, WorkspaceNode.class, FolderNode.class, DesignFileNode.class, ScriptFileNode.class, FileNode.class});

    public static void registerDockingUI() {
        if (isRegistered) {
            return;
        }
        OrbitGuiWS ws = OrbitIO.getApp().getWorkspace();
        if (ws == null) {
            ALog.logError((String)"Fail");
            return;
        }
        CControl dockControl = ws.getDockingController();
        dockControl.addSingleDockableFactory(ResourceManPanel.class.getName(), dockableFactory);
        isRegistered = true;
    }

    public ResourceManPanel(OrbitIO app) {
        this.mApp = app;
        this.mDb = OrbitIO.getCurDb();
        this.setName(NAME);
        GridBagManager l = new GridBagManager((Container)this);
        this.mTree = this.createTree();
        this.mScrollTree = new JScrollPane(this.mTree);
        this.mFileBread = new AFileBreadcrumb(mWorkspace);
        this.mFileBread.addFileListener(file -> {
            ResourceManPanel.setWorkspaceFile(file);
            this.refreshWorkspace();
        });
        l.add((Component)this.mFileBread, (GridBagConstraints)GridBagManager.FILLX.noInsets());
        l.newline();
        l.add((Component)this.mScrollTree, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        this.installPopupMenu();
    }

    protected void installPopupMenu() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rectangle r;
                Point p = new Point();
                TreePath sel = ResourceManPanel.this.mTree.getSelectionPath();
                if (sel != null && (r = ResourceManPanel.this.mTree.getPathBounds(sel)) != null) {
                    p.x = r.x;
                    p.y = r.y + r.height;
                }
                ResourceManPanel.this.showTreeContextMenu(p.x, p.y);
            }
        };
        ActionMap am = this.mTree.getActionMap();
        am.put(action, action);
        this.mTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            protected void maybeShowPopup(MouseEvent e) {
                TreePath p = ResourceManPanel.this.mTree.getPathForLocation(e.getX(), e.getY());
                if (e.isPopupTrigger()) {
                    if (p != null && !ResourceManPanel.this.mTree.isPathSelected(p)) {
                        ResourceManPanel.this.mTree.setSelectionPath(p);
                    }
                    ResourceManPanel.this.showTreeContextMenu(e.getX(), e.getY());
                }
            }
        });
    }

    public void showTreeContextMenu(int x, int y) {
        JPopupMenu m = new JPopupMenu();
        LinkedList<JMenuItem> menuItems = this.createContextMenu();
        for (JMenuItem mi : menuItems) {
            if (mi == null) {
                m.addSeparator();
                continue;
            }
            m.add(mi);
            UIUtil.setUniqueMnemonic((JPopupMenu)m, (AbstractButton)mi);
        }
        AMenuUtil.setMnemonics((JPopupMenu)m, (boolean)true, (boolean)true);
        if (OrbitIO.getGuiWorkspace() != null) {
            OrbitIO.getGuiWorkspace().beautify(m);
        }
        m.show(this.mTree, x, y);
    }

    private JTree createTree() {
        JTree tree = new JTree(){

            @Override
            public String getToolTipText(MouseEvent event) {
                TreePath path = this.getPathForLocation(event.getX(), event.getY());
                if (path == null) {
                    return null;
                }
                Object node = path.getLastPathComponent();
                if (node instanceof FileTreeNode) {
                    return ((FileTreeNode)node).getTooltipText();
                }
                return path.getLastPathComponent().toString();
            }
        };
        ToolTipManager.sharedInstance().registerComponent(tree);
        tree.setScrollsOnExpand(false);
        tree.setModel(new ResourceTreeModel());
        tree.setEditable(false);
        tree.setCellRenderer(new FileTreeCellRenderer());
        tree.setShowsRootHandles(false);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setDragEnabled(true);
        tree.setTransferHandler(new TransferHandler(){
            private File f;

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                TreePath p = ((JTree)c).getSelectionPath();
                if (p == null) {
                    return null;
                }
                Object n = p.getLastPathComponent();
                if (!(n instanceof FileNode)) {
                    return null;
                }
                this.f = ((FileNode)n).mFile;
                if (Objects.nonNull(this.f)) {
                    return new Transferable(){

                        @Override
                        public Object getTransferData(DataFlavor flavor) {
                            return Arrays.asList(f);
                        }

                        @Override
                        public DataFlavor[] getTransferDataFlavors() {
                            return new DataFlavor[]{DataFlavor.javaFileListFlavor};
                        }

                        @Override
                        public boolean isDataFlavorSupported(DataFlavor flavor) {
                            return flavor.equals(DataFlavor.javaFileListFlavor);
                        }
                    };
                }
                return null;
            }
        });
        return tree;
    }

    protected LinkedList<JMenuItem> createContextMenu() {
        Object activeObject;
        LinkedList<JMenuItem> menuItems = new LinkedList<JMenuItem>();
        TreePath[] selPaths = this.mTree.getSelectionPaths();
        if (selPaths != null && selPaths.length == 1 && (activeObject = selPaths[0].getLastPathComponent()) instanceof ContextMenuSupport) {
            ContextMenuSupport cms = (ContextMenuSupport)activeObject;
            cms.populateMenuItems(menuItems);
        }
        return menuItems;
    }

    public void refresh() {
        if (this.mRefreshPending) {
            return;
        }
        this.mRefreshPending = true;
        EventQueue.invokeLater(() -> {
            try {
                this.setDb(OrbitIO.getCurDb());
            }
            finally {
                this.mRefreshPending = false;
            }
        });
    }

    public void refreshWorkspace() {
        State savedState = this.getState();
        this.mTree.setModel(new ResourceTreeModel());
        this.putState(savedState);
    }

    public void setDb(Db db) {
        State savedState = this.getState();
        this.updateCurDbTo(db);
        this.putState(savedState);
    }

    public Db getDb() {
        return this.mDb;
    }

    protected void updateCurDbTo(Db db) {
        this.mDb = db;
        TreeModel tm = this.mTree.getModel();
        if (tm instanceof ResourceTreeModel) {
            ResourceTreeModel dbtm = (ResourceTreeModel)tm;
            dbtm.dispose();
        }
        this.mTree.setModel(new ResourceTreeModel());
        this.mTree.setRootVisible(true);
        this.mFileBread.setup(ResourceManPanel.getWorkspaceFile());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        OrbitIO.getApp().getWorkspace().addViewListener((ViewListener)this.mViewListener);
        this.setDb(OrbitIO.getCurDb());
    }

    @Override
    public void removeNotify() {
        OrbitIO.getApp().getWorkspace().removeViewListener((ViewListener)this.mViewListener);
        super.removeNotify();
        this.setDb(null);
    }

    public static void setWorkspaceFile(File f) {
        mWorkspace = f;
    }

    public static File getWorkspaceFile() {
        return mWorkspace;
    }

    public State getState() {
        return new State();
    }

    public void putState(State state) {
        for (TreePath p : state.mExpanded) {
            TreePath newP = this.findPath(this.mTree.getModel(), p);
            if (newP == null) continue;
            this.mTree.expandPath(newP);
        }
    }

    public TreePath findPath(TreeModel m, TreePath p) {
        TreePath res = null;
        JitFileTreeNode curActualNode = (JitFileTreeNode)m.getRoot();
        for (Object obj : p.getPath()) {
            JitFileTreeNode curRefNode = (JitFileTreeNode)obj;
            if (res == null) {
                if (curRefNode.equiv(curActualNode)) {
                    res = new TreePath(curActualNode);
                    continue;
                }
                return null;
            }
            boolean found = false;
            for (int i = 0; i < m.getChildCount(curActualNode); ++i) {
                JitFileTreeNode dbtn;
                Object o = m.getChild(curActualNode, i);
                if (!(o instanceof JitFileTreeNode) || !curRefNode.equiv(dbtn = (JitFileTreeNode)o)) continue;
                found = true;
                res = res.pathByAddingChild(dbtn);
                curActualNode = dbtn;
                break;
            }
            if (found) continue;
            return null;
        }
        return res;
    }

    private static Action newOpenFileAction(File file) {
        return new AFileExplorer.OpenAction(OPEN_FILE_ACTION_NAME, file);
    }

    private static Action newOpenFileLocationAction(File file) {
        return new AFileExplorer.BrowseFileDirectoryAction(BROWSE_FILE_DIRECTORY_ACTION_NAME, file);
    }

    public class State {
        protected List<TreePath> mExpanded = Lists.newLinkedList();

        public State() {
            TreePath rootPath = new TreePath(ResourceManPanel.this.mTree.getModel().getRoot());
            Enumeration<TreePath> expanded = ResourceManPanel.this.mTree.getExpandedDescendants(rootPath);
            if (expanded != null) {
                for (TreePath p : AUtil.getIterable(expanded)) {
                    this.mExpanded.add(p);
                }
            }
        }
    }

    public static class ActionSetAsWorkingDirectory
    extends AbstractAction {
        protected File mFile;

        public ActionSetAsWorkingDirectory(File f) {
            super("Set As Working Directory");
            this.mFile = f;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.setProperty("user.dir", this.mFile.getAbsolutePath());
        }
    }

    public class ActionChangeWorkspaceToDesign
    extends AbstractAction {
        protected File mFile;

        public ActionChangeWorkspaceToDesign() {
            super("Change Workspace to Current Design");
            if (ResourceManPanel.this.mDb == null || ResourceManPanel.this.mDb.getFile() == null) {
                this.setEnabled(false);
            } else {
                this.mFile = ResourceManPanel.this.mDb.getFile().getParentFile();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResourceManPanel.setWorkspaceFile(this.mFile);
            ResourceManPanel.this.refreshWorkspace();
        }
    }

    public class ActionChangeWorkspace
    extends AbstractAction {
        protected File mFile;

        public ActionChangeWorkspace(File f) {
            super("Change Workspace");
            this.mFile = f;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            fc.setCurrentDirectory(this.mFile);
            fc.setDialogTitle("Choose New Directory");
            fc.setFileSelectionMode(1);
            fc.setAcceptAllFileFilterUsed(false);
            if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) == 0) {
                ResourceManPanel.setWorkspaceFile(fc.getCurrentDirectory());
                ResourceManPanel.this.refreshWorkspace();
            }
        }
    }

    public static class ActionRevealFile
    extends AbstractAction {
        protected File mFile;

        public ActionRevealFile(File f) {
            super(ResourceManPanel.OPEN_FILE_ACTION_NAME);
            this.mFile = f;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Desktop.getDesktop().open(this.mFile);
            }
            catch (IOException err) {
                ALog.logWarn((Throwable)err);
            }
        }
    }

    public static class ActionRunScript
    extends AbstractAction {
        protected File mFile;

        public ActionRunScript(File file) {
            super("Run Script...");
            this.mFile = file;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OrbitIO.getApp().getWorkspace().sourceScript(this.mFile.getAbsolutePath());
        }
    }

    public static class ActionOpenDesign
    extends AbstractAction {
        protected File mFile;

        public ActionOpenDesign(File file) {
            super("Open Design...");
            this.mFile = file;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"OrbitIO.openDesign(%s);", (Object[])new Object[]{Cp.getFileAsArgument((File)this.mFile)});
        }
    }

    public class ActionSetAsWorkspaceRoot
    extends AbstractAction {
        protected File mFile;

        public ActionSetAsWorkspaceRoot(File file) {
            super("Set As Workspace Root");
            this.mFile = file;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResourceManPanel.setWorkspaceFile(this.mFile);
            ResourceManPanel.this.refreshWorkspace();
        }
    }

    public class ScriptFileNode
    extends FileNode {
        protected final boolean showAbsPath;

        public ScriptFileNode(FileTreeNode parent, File f) {
            this(parent, f, false);
        }

        public ScriptFileNode(FileTreeNode parent, File f, boolean showAbsPath) {
            super(parent, f);
            this.showAbsPath = showAbsPath;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public void populateChildren() {
        }

        @Override
        public void render(FileTreeCellRenderer r) {
            r.setText(this.getText());
            if (this.showAbsPath) {
                r.setCommentText(this.mFile.getAbsolutePath());
            }
            r.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.SCRIPT_FILE, (int)16, (int)16));
        }

        @Override
        public String getText() {
            return this.mFile.getName();
        }

        @Override
        public String getTooltipText() {
            return this.mFile.getAbsolutePath();
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            items.add(new JMenuItem(new ActionRunScript(this.mFile)));
            items.add(null);
            items.add(new JMenuItem(ResourceManPanel.newOpenFileAction(this.mFile)));
            items.add(new JMenuItem(ResourceManPanel.newOpenFileLocationAction(this.mFile)));
        }
    }

    public class DesignFileNode
    extends FileNode {
        protected final boolean showAbsPath;

        public DesignFileNode(FileTreeNode parent, File f) {
            this(parent, f, false);
        }

        public DesignFileNode(FileTreeNode parent, File f, boolean showAbsPath) {
            super(parent, f);
            this.showAbsPath = showAbsPath;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public void populateChildren() {
        }

        @Override
        public void render(FileTreeCellRenderer r) {
            r.setText(this.getText());
            if (this.showAbsPath) {
                r.setCommentText(this.mFile.getAbsolutePath());
            }
            r.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.ORBIT, (int)16, (int)16));
        }

        @Override
        public String getText() {
            return this.mFile.getName();
        }

        @Override
        public String getTooltipText() {
            return this.mFile.getAbsolutePath();
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            items.add(new JMenuItem(new ActionOpenDesign(this.mFile)));
            items.add(null);
            items.add(new JMenuItem(ResourceManPanel.newOpenFileLocationAction(this.mFile)));
        }
    }

    public class FileNode
    extends JitFileTreeNode {
        protected File mFile;

        public FileNode(FileTreeNode parent, File f) {
            super(parent);
            this.mFile = f;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public void populateChildren() {
        }

        @Override
        public void render(FileTreeCellRenderer r) {
            r.setText(this.getText());
            r.setIcon(UIUtil.getScaledIcon((Icon)UIUtil.getSystemIcon((File)this.mFile), (int)16, (int)16));
        }

        @Override
        public boolean equiv(FileTreeNode other) {
            if (!(other instanceof FileNode)) {
                return false;
            }
            return this.mFile.equals(((FileNode)other).mFile);
        }

        @Override
        public String getText() {
            return this.mFile.getName();
        }

        @Override
        public String getTooltipText() {
            return this.mFile.getAbsolutePath();
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            items.add(new JMenuItem(ResourceManPanel.newOpenFileAction(this.mFile)));
            items.add(new JMenuItem(ResourceManPanel.newOpenFileLocationAction(this.mFile)));
        }
    }

    public class FolderNode
    extends JitFileTreeNode {
        protected File mFolder;

        public FolderNode(FileTreeNode parent, File f) {
            super(parent);
            this.mFolder = f;
            this.mSortChildren = true;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public void populateChildren() {
            ArrayList<JitFileTreeNode> children = new ArrayList<JitFileTreeNode>();
            for (File f : this.mFolder.listFiles()) {
                if (f.isFile()) {
                    String ext = FilenameUtils.getExtension((String)f.getName());
                    if (ext.equals("oio")) {
                        children.add(new DesignFileNode(this, f));
                        continue;
                    }
                    if (ext.equals("ojs") || ext.equals("tjs")) {
                        children.add(new ScriptFileNode(this, f));
                        continue;
                    }
                    children.add(new FileNode(this, f));
                    continue;
                }
                children.add(new FolderNode(this, f));
            }
            this.mChildren = children;
        }

        @Override
        public void render(FileTreeCellRenderer r) {
            r.setText(this.getText());
            r.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.FOLDER, (int)16, (int)16));
        }

        @Override
        public boolean equiv(FileTreeNode other) {
            if (!(other instanceof FolderNode)) {
                return false;
            }
            return this.mFolder.equals(((FolderNode)other).mFolder);
        }

        @Override
        public String getText() {
            return this.mFolder.getName();
        }

        @Override
        public String getTooltipText() {
            return this.mFolder.getAbsolutePath();
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            items.add(new JMenuItem(ResourceManPanel.newOpenFileLocationAction(this.mFolder)));
            items.add(new JMenuItem(new ActionSetAsWorkspaceRoot(this.mFolder)));
        }
    }

    public class WorkspaceNode
    extends FolderNode {
        public WorkspaceNode(FileTreeNode parent) {
            super(parent, null);
            this.mFolder = ResourceManPanel.getWorkspaceFile();
            this.populateChildren();
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public void render(FileTreeCellRenderer r) {
            r.setText(this.getText());
            r.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.FOLDER, (int)16, (int)16));
            if (this.mFolder != null) {
                r.setCommentText(this.mFolder.getAbsolutePath());
            }
        }

        @Override
        public boolean equiv(FileTreeNode other) {
            if (!(other instanceof WorkspaceNode)) {
                return false;
            }
            return this.mFolder.equals(((WorkspaceNode)other).mFolder);
        }

        @Override
        public String getText() {
            return "Workspace";
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            super.populateMenuItems(items);
            items.add(null);
            items.add(new JMenuItem(new ActionChangeWorkspace(this.mFolder)));
            items.add(new JMenuItem(new ActionChangeWorkspaceToDesign()));
            items.add(new JMenuItem(new ActionSetAsWorkingDirectory(this.mFolder)));
        }
    }

    public class RecentScriptsNode
    extends JitFileTreeNode {
        public RecentScriptsNode(FileTreeNode parent) {
            super(parent);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public void populateChildren() {
            ArrayList<ScriptFileNode> children = new ArrayList<ScriptFileNode>();
            List<String> files = OrbitIO.getApp().getWorkspace().getRecentScripts();
            for (String s : files) {
                children.add(new ScriptFileNode(this, new File(s), true));
            }
            this.mChildren = children;
            this.mSortChildren = false;
        }

        @Override
        public void render(FileTreeCellRenderer r) {
            r.setText(this.getText());
            r.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.FOLDER, (int)16, (int)16));
            r.setCommentText("" + this.getChildCount());
        }

        @Override
        public boolean equiv(FileTreeNode other) {
            return other instanceof RecentScriptsNode;
        }

        @Override
        public String getText() {
            return "Recent Scripts";
        }
    }

    public class RecentDesignsNode
    extends JitFileTreeNode {
        public RecentDesignsNode(FileTreeNode parent) {
            super(parent);
        }

        @Override
        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        @Override
        public void populateChildren() {
            ArrayList<DesignFileNode> children = new ArrayList<DesignFileNode>();
            List<File> files = OrbitIO.getApp().getWorkspace().getMostRecentUsedDesign();
            for (File f : files) {
                children.add(new DesignFileNode(this, f, true));
            }
            this.mChildren = children;
            this.mSortChildren = false;
        }

        @Override
        public void render(FileTreeCellRenderer r) {
            r.setText(this.getText());
            r.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.FOLDER, (int)16, (int)16));
            r.setCommentText("" + this.getChildCount());
        }

        @Override
        public boolean equiv(FileTreeNode other) {
            return other instanceof RecentDesignsNode;
        }

        @Override
        public String getText() {
            return "Recent Designs";
        }
    }

    private class ResourceRootNode
    extends JitFileTreeNode {
        public ResourceRootNode() {
            super(null);
        }

        @Override
        public void populateChildren() {
            ArrayList<JitFileTreeNode> children = new ArrayList<JitFileTreeNode>();
            children.add(new RecentDesignsNode(this));
            children.add(new RecentScriptsNode(this));
            children.add(new WorkspaceNode(this));
            this.mChildren = children;
        }

        @Override
        public void render(FileTreeCellRenderer r) {
            r.setText(this.getText());
            r.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.STACK, (int)16, (int)16));
        }

        @Override
        public boolean equiv(FileTreeNode other) {
            return other instanceof ResourceRootNode;
        }

        @Override
        public String getText() {
            return "Resource";
        }
    }

    public abstract class JitFileTreeNode
    extends FileTreeNode {
        protected List<? extends FileTreeNode> mChildren;
        protected boolean mChildrenValid;
        protected boolean mSortChildren;

        public JitFileTreeNode(FileTreeNode parent) {
            super(parent);
            this.mChildren = null;
            this.mChildrenValid = false;
            this.mSortChildren = true;
        }

        public abstract void populateChildren();

        @Override
        public TreeNode getChildAt(int childIndex) {
            this.populateChildrenAsNeeded();
            if (this.mChildren == null) {
                return null;
            }
            return this.mChildren.get(childIndex);
        }

        @Override
        public int getChildCount() {
            this.populateChildrenAsNeeded();
            if (this.mChildren == null) {
                return 0;
            }
            return this.mChildren.size();
        }

        @Override
        public int getIndex(TreeNode node) {
            this.populateChildrenAsNeeded();
            if (this.mChildren == null) {
                return 0;
            }
            return this.mChildren.indexOf(node);
        }

        public Enumeration<? extends FileTreeNode> children() {
            this.populateChildrenAsNeeded();
            if (this.mChildren == null) {
                return null;
            }
            return AUtil.getEnumeration(this.mChildren.iterator());
        }

        protected void populateChildrenAsNeeded() {
            if (!this.mChildrenValid) {
                try {
                    this.populateChildren();
                }
                catch (Exception e) {
                    ALog.logWarn((Throwable)e, (String)"Populate FileTreeNode children failed, nodes under '%s' are reused.", (Object[])new Object[]{this});
                }
                if (this.mChildren != null && this.mSortChildren) {
                    try {
                        this.mChildren = new ArrayList<FileTreeNode>(this.mChildren.stream().sorted().collect(Collectors.toList()));
                    }
                    catch (Exception e) {
                        ALog.logWarn((Throwable)e, (String)"Sorting FileTreeNode children failed, nodes under '%s' are unsorted.", (Object[])new Object[]{this});
                    }
                }
                this.mChildrenValid = true;
            }
        }

        public void invalidateChildren() {
            this.clearChildren();
            ResourceTreeModel tm = (ResourceTreeModel)ResourceManPanel.this.mTree.getModel();
            tm.fireTreeStructureChanged(this, this.getTreePath().getPath(), new int[0], new Object[0]);
        }

        @Override
        public void dispose() {
            this.clearChildren();
        }

        protected void clearChildren() {
            if (this.mChildrenValid && this.mChildren != null) {
                for (FileTreeNode fileTreeNode : this.mChildren) {
                    fileTreeNode.dispose();
                }
            }
            this.mChildren = null;
            this.mChildrenValid = false;
        }
    }

    public abstract class FileTreeNode
    implements TreeNode,
    ContextMenuSupport,
    Comparable<Object> {
        protected FileTreeNode mParent = null;

        public FileTreeNode(FileTreeNode parent) {
            this.mParent = parent;
        }

        public TreePath getTreePath() {
            LinkedList<FileTreeNode> path = new LinkedList<FileTreeNode>();
            for (FileTreeNode cur = this; cur != null; cur = cur.getParent()) {
                path.add(0, cur);
            }
            Object[] nodes = path.toArray(new FileTreeNode[0]);
            return new TreePath(nodes);
        }

        @Override
        public FileTreeNode getParent() {
            return this.mParent;
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public abstract void render(FileTreeCellRenderer var1);

        public abstract boolean equiv(FileTreeNode var1);

        public JComponent getDetailsView() {
            return null;
        }

        public void dispose() {
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
        }

        @Override
        public int compareTo(Object o) {
            int c;
            Integer myOrder = mNodeClassOrder.get(this.getClass());
            Integer otherOrder = mNodeClassOrder.get(o.getClass());
            if (myOrder != null && otherOrder != null && (c = Integer.compare(myOrder, otherOrder)) != 0) {
                return c;
            }
            if (o.getClass().isInstance(this) || this.getClass().isInstance(o)) {
                String otherText = o instanceof FileTreeNode ? ((FileTreeNode)o).getText() : o.toString();
                AAlphaNumComp ac = AAlphaNumComp.get();
                return ac.compare((Object)this.getText(), (Object)otherText);
            }
            String str = this.toString();
            if (str == null) {
                return -1;
            }
            return str.compareTo(o.toString());
        }

        public String toString() {
            return this.getText();
        }

        public abstract String getText();

        public String getTooltipText() {
            return null;
        }
    }

    static interface ContextMenuSupport {
        public void populateMenuItems(List<JMenuItem> var1);
    }

    public class ResourceTreeModel
    extends DefaultTreeModel {
        public ResourceTreeModel() {
            super(new ResourceRootNode());
        }

        @Override
        public void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            super.fireTreeStructureChanged(source, path, childIndices, children);
        }

        public void dispose() {
            if (this.getRoot() instanceof FileTreeNode) {
                ((FileTreeNode)this.getRoot()).dispose();
            }
        }
    }

    public class FileTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected DefaultTreeCellRenderer mDfltRenderer = new DefaultTreeCellRenderer();
        protected JLabel mIconLabel = new JLabel();
        protected JLabel mColorLabel = new JLabel();
        protected JLabel mCommentLabel = new JLabel();
        protected Object value;
        protected JTree tree;
        protected boolean selected;
        protected boolean expanded;
        protected boolean leaf;
        protected int row;
        protected boolean hasFocus;
        protected int mMaxRenderWidth = 16;
        protected boolean mRenderUpdating = false;
        protected static final int MaxRenderHeight = 18;
        protected Dimension mCellDim = new Dimension(this.mMaxRenderWidth, 18);

        public FileTreeCellRenderer() {
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.mIconLabel);
            this.add(this.mColorLabel);
            this.add(Box.createHorizontalStrut(2));
            this.add(this.mDfltRenderer);
            this.add(Box.createHorizontalStrut(2));
            this.add(this.mCommentLabel);
            this.mCommentLabel.setForeground(Color.GRAY);
            this.mDfltRenderer.setLeafIcon(null);
            this.mDfltRenderer.setOpenIcon(null);
            this.mDfltRenderer.setClosedIcon(null);
            this.mDfltRenderer.setIcon(null);
            if (ResourceManPanel.this.mScrollTree != null) {
                this.mMaxRenderWidth = Math.max(ResourceManPanel.this.mScrollTree.getWidth(), 16);
            }
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.tree = tree;
            this.value = value;
            this.selected = selected;
            this.expanded = expanded;
            this.leaf = leaf;
            this.row = row;
            this.hasFocus = hasFocus;
            this.setPreferredSize(this.mCellDim);
            this.mRenderUpdating = false;
            return this;
        }

        @Override
        public void paintComponent(Graphics g) {
            this.setIcon(null);
            this.setFont(this.getFont().deriveFont(0));
            this.setPreferredSize(null);
            this.mColorLabel.setVisible(false);
            this.mDfltRenderer.getTreeCellRendererComponent(this.tree, this.value, this.selected, this.expanded, this.leaf, this.row, this.hasFocus);
            this.mCommentLabel.setVisible(false);
            if (this.value instanceof FileTreeNode) {
                ((FileTreeNode)this.value).render(this);
            }
            this.validate();
            Dimension drawDim = this.getPreferredSize();
            if (drawDim.getWidth() > (double)this.mMaxRenderWidth) {
                this.mMaxRenderWidth = (int)drawDim.getWidth();
                this.mCellDim = new Dimension(this.mMaxRenderWidth, 18);
                if (!this.mRenderUpdating) {
                    this.mRenderUpdating = true;
                    EventQueue.invokeLater(ResourceManPanel.this::refresh);
                }
            }
            super.paintComponent(g);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.mDfltRenderer != null) {
                this.mDfltRenderer.setFont(font);
            }
        }

        public void setText(String text) {
            this.mDfltRenderer.setText(text);
        }

        public void setIcon(Icon icon) {
            this.mIconLabel.setIcon(icon);
        }

        public void setColorIcon(Icon icon) {
            this.mColorLabel.setVisible(true);
            this.mColorLabel.setIcon(icon);
        }

        public void setCommentText(String text) {
            this.mCommentLabel.setVisible(true);
            this.mCommentLabel.setText("(" + text + ")");
        }

        @Override
        public void setToolTipText(String text) {
            ALog.logError((Throwable)new Exception("Not supported"), (String)"Do not use this function. Please replace with Node.getTooltipText()", (Object[])new Object[0]);
        }
    }
}

