/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.side_panels;

import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.orbit.DbObjectHighlighter;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.side_panels.sel_option.InteractiveSelModePnl;
import java.util.Optional;
import javax.swing.JPanel;

public class SelOptionWorkspace {
    protected final Selection.SelectionListener mOptionSelListener;
    protected final OrbitApp.CurrentDbListener mCurDbListener;
    protected final DbHistory.Listener mDbTransListener = new DbHistory.ListenerAdapter(){

        public void coalesceChange(boolean newCoalesceState) {
            if (!newCoalesceState) {
                SelOptionWorkspace.this.updatePanel();
            }
        }
    };
    protected final DbObjectHighlighter.HighlightListener mHighlightListener = new DbObjectHighlighter.HighlightListener(){

        @Override
        public void highlight(DbObjectHighlighter highlighter) {
            Optional<HierInst<DbObject>> hierObj = highlighter.getHighlights().findFirst();
            if (hierObj.isPresent()) {
                SelOptionWorkspace.this.mSelPnl.updateSel(hierObj.get());
            }
        }

        @Override
        public void clear(DbObjectHighlighter highlighter) {
        }
    };
    private InteractiveSelModePnl mSelPnl = new InteractiveSelModePnl();

    public SelOptionWorkspace() {
        this.mOptionSelListener = set -> this.updatePanel();
        this.mCurDbListener = newDb -> this.resetPanel();
    }

    protected void updatePanel() {
        HierInst hierInst;
        Db db = OrbitIO.getCurDb();
        if (db == null || db.getHistory().inTransactionCoalesce()) {
            return;
        }
        Design design = Design.getDesign((Db)db);
        if (design == null) {
            return;
        }
        Selection sel = design.getCurSelection();
        IterableIterator allHierInsts = sel.getAllHierInsts();
        HierInst hierInst2 = hierInst = !allHierInsts.hasNext() ? null : (HierInst)allHierInsts.next();
        if (hierInst != null) {
            this.mSelPnl.updateSel((HierInst<DbObject>)hierInst);
        }
    }

    protected void resetPanel() {
        this.mSelPnl = new InteractiveSelModePnl();
        this.updatePanel();
    }

    public Selection.SelectionListener getSelListener() {
        return this.mOptionSelListener;
    }

    public OrbitApp.CurrentDbListener getCurDbListener() {
        return this.mCurDbListener;
    }

    public DbHistory.Listener getDbHistoryListener() {
        return this.mDbTransListener;
    }

    public DbObjectHighlighter.HighlightListener getHighlightListener() {
        return this.mHighlightListener;
    }

    public JPanel getContentPane() {
        return this.mSelPnl;
    }
}

