/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.side_panels;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import com.sigrity.acl.ALog;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.app.ViewAdapter;
import com.sigrity.acl.app.ViewListener;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.DesignView3D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.core.OrbitHotkey;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.ui.docking.ViewOptionDockUI;
import com.sigrity.orbit.ui.side_panels.ViewOptionsToolBar;
import com.sigrity.orbit.ui.side_panels.ViewPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ViewOptionsPanel
extends JPanel {
    protected static boolean IsRegistered = false;
    protected static ViewOptionsPanel ThePanel = null;
    protected static ViewListener TheViewListener = null;
    protected static Db.DbListener TheDbListener = null;
    public static final String SettingNameVisible = ViewOptionsPanel.class.getName() + ".visible";
    public static final AbstractAction ActionToggleDisplay = new AbstractAction("Toggle View Options Panel Display"){

        @Override
        public boolean isEnabled() {
            this.putValue("SwingSelectedKey", ViewOptionsPanel.getPanelVisible());
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewOptionsPanel.setPanelVisible(!ViewOptionsPanel.getPanelVisible());
        }
    };
    protected static SingleCDockableFactory dockableFactory = id -> {
        DefaultSingleCDockable dockable = new DefaultSingleCDockable(id, new CAction[0]);
        dockable.setLocation((CLocation)CLocation.base().normalRectangle(0.7, 0.0, 0.1, 0.75));
        dockable.setCloseable(false);
        dockable.setMinimizable(false);
        dockable.setTitleIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.VIEW_SETTING, (int)16, (int)16));
        return dockable;
    };
    protected AAppView mView = null;
    protected ViewPanel mLayerOpts;
    protected ViewPanel mObjectOpts;
    protected ViewOptionsToolBar mOptionBar;
    Map<Db, List<DbClass>> mDb2RegisteredClassListeners = new WeakHashMap<Db, List<DbClass>>();
    protected DbClass.DbObjectListener mDboListener = new DbClass.DbObjectAdapter(){
        protected boolean mRefreshPending = false;

        public void addedObject(DbClass.ObjectAdd add) {
            this.refresh();
        }

        public void removedObject(DbClass.ObjectRemove remove) {
            this.refresh();
        }

        public void changedObject(DbClass.ObjectChange change) {
            this.refresh();
        }

        protected void refresh() {
            if (this.mRefreshPending) {
                return;
            }
            this.mRefreshPending = true;
            EventQueue.invokeLater(() -> {
                try {
                    ViewOptionsPanel.this.mLayerOpts.setView(ViewOptionsPanel.this.mView);
                    ViewOptionsPanel.this.mObjectOpts.setView(ViewOptionsPanel.this.mView);
                }
                finally {
                    this.mRefreshPending = false;
                }
            });
        }
    };
    protected PropertyChangeListener mColorizerListener = e -> {
        String prop = e.getPropertyName();
        if (prop != null && (prop.startsWith("Color:LayerKey") || prop.startsWith("Visible:LayerKey"))) {
            this.mLayerOpts.repaint();
        } else {
            this.mObjectOpts.repaint();
        }
    };
    protected PropertyChangeListener mNewColorizerListener = e -> {
        String prop = e.getPropertyName();
        if (prop.equals("Colorizer")) {
            ViewColorizer c = (ViewColorizer)e.getNewValue();
            this.mLayerOpts.setColorizer(c);
            this.mObjectOpts.setColorizer(c);
            this.mOptionBar.setColorizer(c);
        }
    };

    protected static OrbitGuiWS getWorkspace() {
        OrbitIO app = OrbitIO.getApp();
        return app == null ? null : app.getWorkspace();
    }

    public static void registerDockingUI() {
        if (IsRegistered) {
            return;
        }
        OrbitGuiWS ws = ViewOptionsPanel.getWorkspace();
        if (ws == null) {
            return;
        }
        CControl dockControl = ws.getDockingController();
        dockControl.addSingleDockableFactory(ViewOptionsPanel.class.getName(), dockableFactory);
        IsRegistered = true;
        TheViewListener = new ViewAdapter(){

            public void activeViewChanged(AAppView oldView, AAppView newView) {
                ViewOptionsPanel.notifyViewChange();
            }
        };
        TheDbListener = new Db.DbListenerAdapter(){

            public void dbObjectListenerStateChange(Db db, boolean listenersEnabled) {
                if (listenersEnabled) {
                    ViewOptionsPanel.notifyViewChange();
                }
            }

            public void dbLoaded(Db db) {
                ViewOptionsPanel.notifyViewChange();
            }
        };
        Settings s = Settings.getSettings((String)"GUI");
        ViewOptionsPanel.setPanelVisible(Boolean.parseBoolean((String)s.getSetting(SettingNameVisible, (Object)"true")));
        ws.getMainFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Settings s = Settings.getSettings((String)"GUI");
                s.putSetting(SettingNameVisible, (Object)ViewOptionsPanel.getPanelVisible());
                s.save();
            }
        });
    }

    public static boolean getPanelVisible() {
        return ThePanel != null;
    }

    public static void setPanelVisible(boolean show) {
        ViewOptionsPanel.setPanelVisible(show, false);
    }

    public static void setPanelVisible(boolean show, boolean fromXML) {
        DefaultSingleCDockable dock;
        OrbitGuiWS ws;
        OrbitIO app = OrbitIO.getApp();
        OrbitGuiWS orbitGuiWS = ws = app == null ? null : app.getWorkspace();
        if (ws == null) {
            ALog.logError((String)"Unable to show the View Options Panel, unable to find an OrbitIO GUI workspace.");
            assert (false);
            return;
        }
        if (show && ThePanel == null) {
            ThePanel = new ViewOptionsPanel();
            Db.addDbListener((Db.DbListener)TheDbListener);
            ws.addViewListener(TheViewListener);
        }
        if (!fromXML) {
            DefaultSingleCDockable dock2 = ws.setSingleDockableVisible(ThePanel, show, null);
            if (dock2 != null) {
                ViewOptionDockUI.installToolBar(dock2);
            }
        } else if (ThePanel != null && (dock = ws.getSingleDockable(ThePanel.getClass().getName())) != null) {
            dock.getContentPane().removeAll();
            dock.getContentPane().add(ThePanel);
            dock.setTitleText(ThePanel.getName());
            ViewOptionDockUI.installToolBar(dock);
        }
        if (!show && ThePanel != null) {
            ThePanel = null;
        }
    }

    protected static void refreshView(AAppView v) {
        if (v instanceof DesignView2D) {
            ((DesignView2D)v).getCanvas().refresh();
        } else if (v instanceof DesignView3D) {
            ((DesignView3D)v).repaint();
        }
    }

    protected void refreshView() {
        ViewOptionsPanel.refreshView(this.mView);
    }

    public ViewOptionsPanel() {
        this.setName("View Options");
        GridBagManager l = GridBagManager.layout((Container)this);
        JTabbedPane pane = new JTabbedPane();
        this.mLayerOpts = new ViewPanel(ViewPanel.Mode.LAYER);
        this.mObjectOpts = new ViewPanel(ViewPanel.Mode.OBJECT);
        this.mOptionBar = new ViewOptionsToolBar();
        pane.addTab("Layers", this.mLayerOpts);
        pane.addTab("Objects", this.mObjectOpts);
        l.add((Component)pane, (GridBagConstraints)GridBagManager.FILLALL_REMAINX.noInsets());
        l.newline();
        l.add((Component)this.mOptionBar, (GridBagConstraints)GridBagManager.FILLX.noInsets());
        this.setView(OrbitIO.getCurView());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setView(OrbitIO.getCurView());
    }

    @Override
    public void removeNotify() {
        this.setView(null);
        super.removeNotify();
    }

    public static void notifyViewChange() {
        OrbitGuiWS ws = ViewOptionsPanel.getWorkspace();
        AAppView view = ws == null ? null : ws.getCurrentView();
        ThePanel.setView(view);
    }

    public void setView(AAppView view) {
        this.enableListeners(false);
        this.mView = view;
        this.mLayerOpts.setView(view);
        this.mObjectOpts.setView(view);
        this.mOptionBar.setView(view);
        this.enableListeners(true);
    }

    protected void enableListeners(boolean enable) {
        DesignCanvas2D canvas;
        ViewColorizer vc;
        if (this.mView == null) {
            return;
        }
        Db db = this.mView.getDb();
        if (db != null) {
            if (enable) {
                this.registerClassListener(db.getDbClass(Substrate.class));
                this.registerClassListener(db.getDbClass(Layer.class));
            } else {
                this.deregisterClassListeners(db);
            }
        }
        if ((vc = this.getColorizer()) != null) {
            if (enable) {
                vc.addChangeListener(this.mColorizerListener);
            } else {
                vc.removeChangeListener(this.mColorizerListener);
            }
        }
        if (this.mView instanceof DesignView2D && (canvas = ((DesignView2D)this.mView).getCanvas()) != null) {
            if (enable) {
                canvas.addPropertyChangeListener(this.mNewColorizerListener);
            } else {
                canvas.removePropertyChangeListener(this.mNewColorizerListener);
            }
        }
    }

    protected void registerClassListener(DbClass dbc) {
        if (dbc == null) {
            return;
        }
        dbc.addObjectListener(this.mDboListener, DbClass.DbObjectEventType.getUpdated());
        this.mDb2RegisteredClassListeners.computeIfAbsent(dbc.getDb(), db -> new LinkedList()).add(dbc);
    }

    protected void deregisterClassListeners(Db db) {
        for (DbClass dbc : this.mDb2RegisteredClassListeners.get(db)) {
            dbc.removeObjectListener(this.mDboListener, DbClass.DbObjectEventType.getUpdated());
        }
        this.mDb2RegisteredClassListeners.remove(db);
    }

    public Db getDb() {
        return this.mLayerOpts.getDb();
    }

    protected ViewColorizer getColorizer() {
        return this.mLayerOpts.getColorizer();
    }

    public static class ActionRefreshNodes
    extends AbstractAction {
        public ActionRefreshNodes() {
            super("Refresh All Nodes", OrbitIcons.REFRESH);
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("UI Refresh"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ThePanel != null) {
                ThePanel.setView(OrbitIO.getCurView());
            }
        }
    }
}

