/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.side_panels;

import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.VisibilityControlUI;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.DesignView3D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ViewOptionsToolBar
extends JPanel {
    public static final String ICON_DEVICE_NAME = "iconDeviceName16.png";
    public static final String ICON_PIN_NAME = "iconPinName16.png";
    public static final String ICON_PIN_NET = "iconPinNet16.png";
    public static final String ICON_PIN_TOPNET = "iconPinTopNet16.png";
    public static final String ICON_PIN_TEXT = "iconPinText16.png";
    protected VisibilityControlUI.ObjectFilterSlider mSlideObjectFilter;
    protected JToggleButton mBtnDevName;
    protected JToggleButton mBtnPinName;
    protected JToggleButton mBtnPinNet;
    protected JToggleButton mBtnPinTopmostNet;
    protected JToggleButton mBtnPinText;
    protected JButton mBtnViewSettings;
    protected AAppView mView = null;
    protected ViewColorizer mColorizer = null;
    protected ActionListener mToggleDevName = e -> {
        ViewColorizer c = this.getColorizer();
        if (c == null) {
            return;
        }
        c.setShowDeviceNames(!c.getShowDeviceNames());
        this.refreshView();
    };
    protected ActionListener mTogglePinName = e -> {
        ViewColorizer c = this.getColorizer();
        if (c == null) {
            return;
        }
        c.setShowPinNames(!c.getShowPinNames());
        this.refreshView();
    };
    protected ActionListener mTogglePinNet = e -> {
        ViewColorizer c = this.getColorizer();
        if (c == null) {
            return;
        }
        c.setShowPinNetNames(!c.getShowPinNetNames());
        this.refreshView();
    };
    protected ActionListener mTogglePinTopmostNet = e -> {
        ViewColorizer c = this.getColorizer();
        if (c == null) {
            return;
        }
        c.setShowPinTopmostNetNames(!c.getShowPinTopmostNetNames());
        this.refreshView();
    };
    protected ActionListener mTogglePinText = e -> {
        ViewColorizer c = this.getColorizer();
        if (c == null) {
            return;
        }
        c.setShowCustomPinText(!c.getShowCustomPinText());
        this.refreshView();
        String text = c.getCustomPinText();
        if (c.getShowCustomPinText() && this.mView instanceof DesignView2D && (text == null || text.isEmpty())) {
            DesignView2D v2d = (DesignView2D)this.mView;
            String msg = "No custom pin text is defined, would you like to open the View Settings Dialog to enter some now?";
            String title = "No Custom Text";
            if (0 == JOptionPane.showConfirmDialog(null, msg, title, 0)) {
                VisibilityControlUI.showFor(v2d);
            }
        }
    };
    protected ActionListener mShowViewSettings = e -> {
        if (this.mView instanceof DesignView2D) {
            VisibilityControlUI.showFor((DesignView2D)this.mView);
        }
    };
    protected PropertyChangeListener mColorizerListener = e -> {
        String prop = e.getPropertyName();
        if (prop.equals("ShowDeviceNames") || prop.equals("ShowPinNames") || prop.equals("ShowPinNetNames") || prop.equals("ShowPinTopmostNetNames") || prop.equals("ShowCustomPinText")) {
            this.updateViewButtons();
        }
    };

    public ViewOptionsToolBar() {
        GridBagManager l = GridBagManager.layout((Container)this);
        this.mSlideObjectFilter = new VisibilityControlUI.ObjectFilterSlider(0, 20, null);
        this.mSlideObjectFilter.setSmall();
        JLabel iconMoreLabel = new JLabel("Detail");
        JLabel iconLessLabel = new JLabel("Speed");
        l.add((Component)iconMoreLabel);
        l.add((Component)this.mSlideObjectFilter, (GridBagConstraints)GridBagManager.FILLX.width(5));
        l.add((Component)iconLessLabel);
        l.newline();
        this.mBtnDevName = this.addFooterBtn(l, new JToggleButton(OrbitIcons.getIcon(ICON_DEVICE_NAME)), "Toggle display of device names");
        this.mBtnPinName = this.addFooterBtn(l, new JToggleButton(OrbitIcons.getIcon(ICON_PIN_NAME)), "Toggle display of pin names");
        this.mBtnPinNet = this.addFooterBtn(l, new JToggleButton(OrbitIcons.getIcon(ICON_PIN_NET)), "Toggle display of pin net names");
        this.mBtnPinTopmostNet = this.addFooterBtn(l, new JToggleButton(OrbitIcons.getIcon(ICON_PIN_TOPNET)), "Toggle display of pin topmost net names");
        this.mBtnPinText = this.addFooterBtn(l, new JToggleButton(OrbitIcons.getIcon(ICON_PIN_TEXT)), "Toggle display of custom pin text");
        l.addFillX();
        this.mBtnViewSettings = new JButton(UIUtil.getScaledIcon((Icon)OrbitIcons.VIEW_SETTING, (int)16, (int)16));
        UIUtil.makeToolBarButton((AbstractButton)this.mBtnViewSettings);
        this.mBtnViewSettings.setToolTipText("Show the View Settings Dialog");
        l.add((Component)this.mBtnViewSettings, (GridBagConstraints)GridBagManager.RIGHT.insets(0));
        this.mBtnDevName.addActionListener(this.mToggleDevName);
        this.mBtnPinName.addActionListener(this.mTogglePinName);
        this.mBtnPinNet.addActionListener(this.mTogglePinNet);
        this.mBtnPinTopmostNet.addActionListener(this.mTogglePinTopmostNet);
        this.mBtnPinText.addActionListener(this.mTogglePinText);
        this.mBtnViewSettings.addActionListener(this.mShowViewSettings);
    }

    protected <T extends AbstractButton> T addFooterBtn(GridBagManager l, T b, String tip) {
        l.add(b, (GridBagConstraints)GridBagManager.LEFT.noInsets());
        UIUtil.makeToolBarButton(b);
        b.setRolloverEnabled(true);
        b.setToolTipText(tip);
        return b;
    }

    protected void enableListeners(boolean enable) {
        if (this.mView == null) {
            return;
        }
        ViewColorizer vc = this.getColorizer();
        if (vc != null) {
            if (enable) {
                vc.addChangeListener(this.mColorizerListener);
            } else {
                vc.removeChangeListener(this.mColorizerListener);
            }
        }
    }

    protected void updateViewButtons() {
        ViewColorizer vc = this.getColorizer();
        this.mBtnDevName.setEnabled(vc != null);
        this.mBtnDevName.setSelected(vc != null && vc.getShowDeviceNames());
        this.mBtnPinName.setEnabled(vc != null);
        this.mBtnPinName.setSelected(vc != null && vc.getShowPinNames());
        this.mBtnPinNet.setEnabled(vc != null);
        this.mBtnPinNet.setSelected(vc != null && vc.getShowPinNetNames());
        this.mBtnPinTopmostNet.setEnabled(vc != null);
        this.mBtnPinTopmostNet.setSelected(vc != null && vc.getShowPinTopmostNetNames());
        this.mBtnPinText.setEnabled(vc != null);
        this.mBtnPinText.setSelected(vc != null && vc.getShowCustomPinText());
        this.mBtnViewSettings.setEnabled(this.mView instanceof DesignView2D);
    }

    public void setView(AAppView view) {
        this.enableListeners(false);
        this.mView = view;
        if (this.mView instanceof DesignView2D) {
            this.mColorizer = ((DesignView2D)this.mView).getColorizer();
            this.mSlideObjectFilter.setView((DesignView2D)this.mView);
        } else {
            this.mColorizer = this.mView instanceof DesignView3D ? ((DesignView3D)this.mView).getColorizer() : null;
        }
        this.updateViewButtons();
        this.enableListeners(true);
    }

    protected ViewColorizer getColorizer() {
        return this.mColorizer;
    }

    protected void refreshView() {
        if (this.mView instanceof DesignView2D) {
            ((DesignView2D)this.mView).getCanvas().refresh();
        } else if (this.mView instanceof DesignView3D) {
            ((DesignView3D)this.mView).repaint();
        }
    }

    public void setColorizer(ViewColorizer c) {
        this.mColorizer = c;
        this.updateViewButtons();
    }
}

