/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.side_panels;

import com.google.common.collect.Lists;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.ASingletonItr;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AActionProvider;
import com.sigrity.acl.ui.ACheckBoxIcon;
import com.sigrity.acl.ui.AMenuUtil;
import com.sigrity.acl.ui.ATreeUtil;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.AAbstractTreeTableModel;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATree;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.acl.ui.atree.ATreeTable;
import com.sigrity.acl.ui.atree.ATreeTableModel;
import com.sigrity.orbit.DbObjectHighlighter;
import com.sigrity.orbit.DesignSettings;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.LayerUI;
import com.sigrity.orbit.ui.VisibilityControlUI;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.DesignView3D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.orbit.ui.side_panels.ViewOptionsPanel;
import com.sigrity.orbit.ui.table_editor.EditLayerUI;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import com.sigrity.tools.dbexplorer.NodeOptions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

class ViewPanel
extends JPanel {
    protected final Mode mMode;
    protected AAppView mView = null;
    protected ViewColorizer mColorizer = null;
    protected ATreeTable mTreeTable;

    public ViewPanel(Mode mode) {
        this.mMode = mode;
        GridBagManager l = GridBagManager.layout((Container)this);
        this.mTreeTable = new ATreeTable((AAbstractTreeTableModel)new ViewSetModel(null));
        JScrollPane pane = (JScrollPane)l.add((Component)new JScrollPane((Component)this.mTreeTable), (GridBagConstraints)GridBagManager.FILLALL_REMAINX.noInsets());
        this.mTreeTable.setRootVisible(false);
        this.mTreeTable.setShowsRootHandles(true);
        this.mTreeTable.setRowSelectionAllowed(true);
        this.mTreeTable.getTableHeader().setReorderingAllowed(false);
        pane.getViewport().setBackground(Color.WHITE);
        this.mTreeTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.handleContextMenu(e)) {
                    return;
                }
                this.handleEditItem(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.handleContextMenu(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.handleContextMenu(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.handleContextMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handleContextMenu(e);
            }

            public boolean handleEditItem(MouseEvent e) {
                int row = ViewPanel.this.mTreeTable.rowAtPoint(e.getPoint());
                int col = ViewPanel.this.mTreeTable.columnAtPoint(e.getPoint());
                if (row < 0 || col < 0) {
                    return false;
                }
                Object node = ViewPanel.this.mTreeTable.getTreeNode(row);
                if (col == 0) {
                    if (e.getClickCount() == 2 && node instanceof LayerNode) {
                        LayerNode ln = (LayerNode)node;
                        Layer layer = ln.getLayer();
                        LayerUI.editLayer(layer);
                    } else if (e.getClickCount() == 2 && node instanceof SubstrateNode) {
                        TreePath path = ViewPanel.this.mTreeTable.getTree().getPathForLocation(e.getX(), e.getY());
                        if (path != null) {
                            EditLayerUI.getAction(((SubstrateNode)node).getSubstrate()).actionPerformed(null);
                        }
                    } else if (e.getClickCount() == 2 && node instanceof LayerHidenNode) {
                        new ActionManageLayerDisplay().actionPerformed(null);
                    }
                } else if (col == 1) {
                    if (node instanceof LayerNode) {
                        LayerNode ln = (LayerNode)node;
                        Layer layer = ln.getLayer();
                        if (LayerUI.changeLayerColor(layer)) {
                            ViewPanel.this.mTreeTable.repaint();
                        }
                    } else if (node instanceof KeyNode) {
                        KeyNode keyNode = (KeyNode)((Object)node);
                        VisibilityControlUI.ActionChangeColor a = new VisibilityControlUI.ActionChangeColor(OrbitIO.getMainWindow(), ViewPanel.this.mColorizer, keyNode.mKey, Design.getDesignPath((Db)OrbitIO.getCurDb()));
                        a.actionPerformed(null);
                        ViewPanel.this.mTreeTable.repaint();
                        ViewPanel.refreshView(ViewPanel.this.mView);
                    }
                } else if (col == 2) {
                    if (node instanceof LayerNode) {
                        LayerNode ln = (LayerNode)node;
                        Layer layer = ln.getLayer();
                        LayerUI.toggleLayerVisible(layer);
                        ViewPanel.this.mTreeTable.repaint();
                        ViewPanel.refreshView(ViewPanel.this.mView);
                    } else if (node instanceof KeyNode) {
                        KeyNode keyNode = (KeyNode)((Object)node);
                        boolean isDisplay = ViewPanel.this.mColorizer.getDisplay(null, keyNode.mKey);
                        this.cpKeyVisible((IterableIterator<ViewColorizer.Key>)ASingletonItr.create((Object)keyNode.mKey), isDisplay);
                        ViewPanel.this.mTreeTable.repaint();
                        ViewPanel.refreshView(ViewPanel.this.mView);
                    } else if (node instanceof SubstrateNode) {
                        SubstrateNode sn = (SubstrateNode)node;
                        Boolean vis = sn.isVisible();
                        this.cpSubstrateVisible(sn.getSubstrate(), vis);
                        ViewPanel.this.mTreeTable.repaint();
                        ViewPanel.refreshView(ViewPanel.this.mView);
                    } else if (node instanceof KeyGroupNode) {
                        KeyGroupNode groupNode = (KeyGroupNode)((Object)node);
                        Boolean vis = groupNode.isVisible();
                        this.cpKeyVisible(groupNode.getObjectKeys(), vis);
                        ViewPanel.this.mTreeTable.repaint();
                        ViewPanel.refreshView(ViewPanel.this.mView);
                    }
                }
                return true;
            }

            private void cpSubstrateVisible(Substrate s, Boolean vis) {
                try (DbHistory.DbTransaction txn = DbHistory.newDbTransaction((Db)s.getDb(), (String)"Substrate Visible");){
                    Cp.exec((String)"com.sigrity.orbit.cmd.SubstrateCommands.setSubstrateVisible(%s, %b)", (Object[])new Object[]{CpHelper.getObjCmdStr(s), !Boolean.TRUE.equals(vis)});
                }
            }

            private void cpKeyVisible(IterableIterator<ViewColorizer.Key> keys, Boolean vis) {
                for (ViewColorizer.Key key : keys) {
                    Cp.exec((String)"com.sigrity.orbit.ui.core.ViewColorizer.setDisplay(\"%s\", \"%s\", %b)", (Object[])new Object[]{"/", key.asString(), !Boolean.TRUE.equals(vis)});
                }
            }

            public boolean handleContextMenu(MouseEvent e) {
                List<Layer> layers;
                if (!e.isPopupTrigger()) {
                    return false;
                }
                int row = ViewPanel.this.mTreeTable.rowAtPoint(e.getPoint());
                Object node = row < 0 ? null : ViewPanel.this.mTreeTable.getTreeNode(row);
                JPopupMenu menu = new JPopupMenu();
                menu.add(new ViewOptionsPanel.ActionRefreshNodes());
                menu.addSeparator();
                if (node instanceof AActionProvider) {
                    for (Action a : AIterableItr.itr(((AActionProvider)node).getActions())) {
                        menu.add(a);
                    }
                }
                if (menu.getComponentCount() > 0) {
                    menu.add(new JSeparator());
                }
                if ((layers = ViewPanel.this.getAllOrSelectedLayers(true)).size() > 1) {
                    menu.add(new LayerUI.ActionSetAllLayersVisible("Selected Layers on", layers, true, () -> ViewPanel.this.mTreeTable.repaint()));
                    menu.add(new LayerUI.ActionSetAllLayersVisible("Selected Layers off", layers, false, () -> ViewPanel.this.mTreeTable.repaint()));
                }
                if ((layers = ViewPanel.this.getAllOrSelectedLayers(false)).size() > 1) {
                    menu.add(new LayerUI.ActionSetAllLayersVisible("All Layers on", layers, true, () -> ViewPanel.this.mTreeTable.repaint()));
                    menu.add(new LayerUI.ActionSetAllLayersVisible("All Layers off", layers, false, () -> ViewPanel.this.mTreeTable.repaint()));
                }
                menu.add(new JSeparator());
                OrbitGuiWS gws = OrbitIO.getOrbitIO().getWorkspace();
                ObjectActionRegistry oar = gws.getObjectActionRegistry();
                IterableIterator<JMenuItem> regMenuItems = AEmptyItr.create();
                if (node instanceof SubstrateNode) {
                    SubstrateNode substrateNode = (SubstrateNode)node;
                    regMenuItems = oar.getJMenuItems(substrateNode.getSubstrate());
                } else if (node instanceof LayerNode) {
                    LayerNode layerNode = (LayerNode)node;
                    regMenuItems = oar.getJMenuItems(layerNode.getLayer());
                } else if (ViewPanel.this.mMode == Mode.LAYER) {
                    menu.add(EditLayerUI.getAction());
                }
                LinkedList sortedItems = AMenuUtil.groupByFirstWord(regMenuItems);
                AMenuUtil.sort((List)sortedItems, (boolean)true);
                for (JMenuItem item : sortedItems) {
                    menu.add(item);
                }
                OrbitIO.getGuiWorkspace().beautify(menu);
                if (menu.getComponentCount() > 0) {
                    menu.show((Component)ViewPanel.this.mTreeTable, e.getX(), e.getY());
                }
                return true;
            }
        });
    }

    private List<Layer> getAllOrSelectedLayers(boolean onlySelected) {
        LinkedList res = Lists.newLinkedList();
        TreeSelectionModel selModel = this.mTreeTable.getTree().getSelectionModel();
        for (TreePath p : ATreeUtil.getDepthFirstItr((TreeModel)this.mTreeTable.getTreeModel())) {
            Object o;
            if (onlySelected && !selModel.isPathSelected(p) || !((o = p.getLastPathComponent()) instanceof LayerNode)) continue;
            res.add(((LayerNode)o).getLayer());
        }
        return res;
    }

    public void setView(AAppView view) {
        this.mView = view;
        this.mColorizer = DesignSettings.getViewColorizer(this.mView == null ? null : this.mView.getDb());
        if (this.mMode == Mode.LAYER) {
            this.mTreeTable.setTreeTableModel((AAbstractTreeTableModel)new ViewSetModel(new RootNode(this.getDb())));
        } else if (this.mMode == Mode.OBJECT) {
            this.mTreeTable.setTreeTableModel((AAbstractTreeTableModel)new ViewSetModel(new ObjectRootNode(this.getDb())));
        }
        this.mTreeTable.getColumnModel().getColumn(1).setPreferredWidth(20);
        this.mTreeTable.getColumnModel().getColumn(1).setMaxWidth(20);
        this.mTreeTable.getColumnModel().getColumn(2).setPreferredWidth(20);
        this.mTreeTable.getColumnModel().getColumn(2).setMaxWidth(20);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.mTreeTable.getTree());
        this.mTreeTable.getSelectionModel().addListSelectionListener(event -> {
            Object node = this.mTreeTable.getTreeNode(this.mTreeTable.getSelectedRow());
            if (node instanceof LayerNode) {
                LayerNode ln = (LayerNode)node;
                if (this.mView instanceof DesignView2D) {
                    DbObjectHighlighter.clear((DesignView2D)this.mView);
                    DbObjectHighlighter.highlight((DesignView2D)this.mView, null, (DbObject)ln.getLayer());
                }
            }
        });
        UIUtil.expandTreeLevels((JTree)this.mTreeTable.getTree(), (int)2);
    }

    public ViewColorizer getColorizer() {
        return this.mColorizer;
    }

    public void setColorizer(ViewColorizer v) {
        this.mColorizer = v;
        this.repaint();
    }

    public Db getDb() {
        return this.mView == null ? null : this.mView.getDb();
    }

    protected static void refreshView(AAppView v) {
        if (v instanceof DesignView2D) {
            ((DesignView2D)v).getCanvas().refresh();
        } else if (v instanceof DesignView3D) {
            ((DesignView3D)v).repaint();
        }
    }

    public ATree getTree() {
        return this.mTreeTable.getTree();
    }

    protected class ActionManageLayerDisplay
    extends AbstractAction {
        ActionManageLayerDisplay() {
            super("Manage Layer Display");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ViewPanel.this.mView instanceof DesignView2D) {
                VisibilityControlUI.showFor((DesignView2D)ViewPanel.this.mView, 3);
            }
        }
    }

    protected class KeyNode
    extends ViewNode {
        private ViewColorizer.Key mKey;

        public KeyNode(KeyGroupNode parent, ViewColorizer.Key key) {
            super((ATreeNode)parent);
            this.mKey = key;
        }

        public boolean isLeaf() {
            return true;
        }

        public List<? extends ATreeNode> populateChildren() {
            return null;
        }

        public String getText() {
            if (this.mKey instanceof ViewColorizer.ObjectKey) {
                return ((ViewColorizer.ObjectKey)this.mKey).getUserText();
            }
            return this.mKey.asString();
        }

        public Icon getIcon() {
            return null;
        }

        @Override
        public Icon getColorIcon() {
            if (ViewPanel.this.mColorizer == null) {
                return null;
            }
            APatternColor color = ViewPanel.this.mColorizer.getColor(null, this.mKey, true);
            return color.getIcon(14);
        }

        @Override
        public Icon getVisibleIcon() {
            if (ViewPanel.this.mColorizer == null) {
                return null;
            }
            if (ViewPanel.this.mColorizer.getDisplay(null, this.mKey)) {
                return ACheckBoxIcon.Y;
            }
            return ACheckBoxIcon.N;
        }
    }

    protected class KeyGroupNode
    extends ViewNode {
        protected ViewColorizer.KeyType mType;
        protected Collection<ViewColorizer.Key> mKeys;

        public KeyGroupNode(ViewNode parent, ViewColorizer.KeyType type) {
            super((ATreeNode)parent);
            this.mType = type;
            this.mKeys = (Collection)ViewColorizer.getKeyTypeMap().get(type);
        }

        public List<? extends ATreeNode> populateChildren() {
            ArrayList<ViewNode> children = new ArrayList<ViewNode>();
            this.mSortChildren = false;
            if (this.mKeys != null) {
                for (ViewColorizer.Key key : this.mKeys) {
                    children.add(new KeyNode(this, key));
                }
            }
            for (ViewColorizer.KeyType childType : this.mType.getChildren()) {
                children.add(new KeyGroupNode(this, childType));
            }
            return children;
        }

        public String getText() {
            return this.mType.getUserName();
        }

        public Icon getIcon() {
            return DBEResources.ICON_FOLDER;
        }

        private Boolean isVisible() {
            int visible = 0;
            int invisible = 0;
            for (ViewColorizer.Key k : this.getObjectKeys()) {
                if (ViewPanel.this.mColorizer.getDisplay(null, k)) {
                    ++visible;
                    continue;
                }
                ++invisible;
            }
            if (visible == 0) {
                return Boolean.FALSE;
            }
            if (invisible == 0) {
                return Boolean.TRUE;
            }
            return null;
        }

        @Override
        public Icon getVisibleIcon() {
            if (ViewPanel.this.mColorizer == null) {
                return null;
            }
            Boolean state = this.isVisible();
            if (Boolean.FALSE.equals(state)) {
                return ACheckBoxIcon.N;
            }
            if (Boolean.TRUE.equals(state)) {
                return ACheckBoxIcon.Y;
            }
            return ACheckBoxIcon.YN;
        }

        public IterableIterator<ViewColorizer.Key> getObjectKeys() {
            LinkedHashSet<ViewColorizer.Key> ret = new LinkedHashSet<ViewColorizer.Key>();
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                ATreeNode node = this.getChildAt(i);
                if (node instanceof KeyNode) {
                    ret.add(((KeyNode)node).mKey);
                    continue;
                }
                if (!(node instanceof KeyGroupNode)) continue;
                for (ViewColorizer.Key k : ((KeyGroupNode)node).getObjectKeys()) {
                    ret.add(k);
                }
            }
            return AIterableItr.itr(ret);
        }
    }

    protected class ObjectRootNode
    extends ViewNode {
        protected final Db mDb;

        public ObjectRootNode(Db db) {
            super((ATreeModel)ViewPanel.this.mTreeTable.getTreeModel());
            this.mDb = db;
        }

        public Db getDb() {
            return this.mDb;
        }

        public String getText() {
            return this.mDb == null ? "No database" : "Object Options for " + this.mDb.getDescription(false);
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            ArrayList<KeyGroupNode> children = new ArrayList<KeyGroupNode>();
            if (ViewPanel.this.mColorizer != null) {
                for (ViewColorizer.KeyType e : ViewColorizer.KeyType.values()) {
                    if (e == ViewColorizer.KeyType.OBJ_LAYER || e.getParentType() != null) continue;
                    children.add(new KeyGroupNode(this, e));
                }
            }
            return children;
        }
    }

    protected class LayerHidenNode
    extends ViewNode
    implements AActionProvider {
        public LayerHidenNode(ATreeNode parent) {
            super(parent);
        }

        public String getText() {
            return "...";
        }

        public Icon getIcon() {
            return null;
        }

        @Override
        public Icon getColorIcon() {
            return null;
        }

        @Override
        public Icon getVisibleIcon() {
            if (ViewPanel.this.mColorizer == null) {
                return null;
            }
            return ACheckBoxIcon.YN;
        }

        public boolean isLeaf() {
            return true;
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            return Lists.newArrayList();
        }

        @Override
        public String getTooltip() {
            return "Click to edit default visibility of layer type on UI";
        }

        @Override
        public Iterator<Action> getActions() {
            ActionManageLayerDisplay manageAction = new ActionManageLayerDisplay();
            return ASingletonItr.create((Object)manageAction);
        }
    }

    protected class LayerNode
    extends ViewNode
    implements AActionProvider {
        protected Layer mLayer;

        public LayerNode(ATreeNode parent, Layer l) {
            super(parent);
            this.mLayer = l;
        }

        public String getText() {
            return this.mLayer.getName();
        }

        public Icon getIcon() {
            return null;
        }

        @Override
        public Icon getColorIcon() {
            if (ViewPanel.this.mColorizer == null) {
                return null;
            }
            APatternColor color = ViewPanel.this.mColorizer.getColor(null, this.mLayer, true);
            return UIUtil.getScaledIcon((Icon)color.getIcon(), (int)14, (int)14);
        }

        @Override
        public Icon getVisibleIcon() {
            if (ViewPanel.this.mColorizer == null) {
                return null;
            }
            ViewColorizer.LayerKey key = ViewPanel.this.mColorizer.getLayerKey(this.getLayer(), true);
            if (ViewPanel.this.mColorizer.getDisplay(null, (ViewColorizer.Key)key)) {
                return ACheckBoxIcon.Y;
            }
            return ACheckBoxIcon.N;
        }

        public boolean isLeaf() {
            return true;
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            return Lists.newArrayList();
        }

        @Override
        public String getTooltip() {
            return String.format("Layer '%s' (%s) on Substrate '%s'.", this.mLayer.getName(), this.mLayer.getType(), this.mLayer.getSubstrate().getName());
        }

        public Layer getLayer() {
            return this.mLayer;
        }

        @Override
        public Iterator<Action> getActions() {
            LayerUI.ActionToggleLayerVisibility toggleVisible = new LayerUI.ActionToggleLayerVisibility(this.mLayer, () -> ViewPanel.this.mTreeTable.repaint());
            return new AIterableItr((Object[])new Action[]{toggleVisible});
        }
    }

    protected class SubstrateNode
    extends ViewNode
    implements AActionProvider {
        protected Substrate mSubstrate;

        public SubstrateNode(ViewNode parent, Substrate s) {
            super((ATreeNode)parent);
            this.mSubstrate = s;
            this.mSortChildren = false;
        }

        public Substrate getSubstrate() {
            return this.mSubstrate;
        }

        public String getText() {
            return this.mSubstrate.getName();
        }

        public Icon getIcon() {
            return DbExplorerPanel.getIconForSubstrate(this.mSubstrate);
        }

        public Boolean isVisible() {
            int visible = 0;
            int invisible = 0;
            for (Layer l : this.mSubstrate.getLayers()) {
                ViewColorizer.LayerKey key = ViewPanel.this.mColorizer.getLayerKey(l, true);
                if (ViewPanel.this.mColorizer.getDisplay(null, (ViewColorizer.Key)key)) {
                    ++visible;
                    continue;
                }
                ++invisible;
            }
            if (visible == 0) {
                return Boolean.FALSE;
            }
            if (invisible == 0) {
                return Boolean.TRUE;
            }
            return null;
        }

        @Override
        public Icon getVisibleIcon() {
            if (ViewPanel.this.mColorizer == null) {
                return null;
            }
            Boolean state = this.isVisible();
            if (Boolean.FALSE.equals(state)) {
                return ACheckBoxIcon.N;
            }
            if (Boolean.TRUE.equals(state)) {
                return ACheckBoxIcon.Y;
            }
            return ACheckBoxIcon.YN;
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            ArrayList children = Lists.newArrayList();
            boolean hasHide = false;
            for (Layer l : this.mSubstrate.getLayers(Layer.TopFirstSort)) {
                if (NodeOptions.getDisplayLayerTypes().contains(l.getType())) {
                    children.add(new LayerNode((ATreeNode)this, l));
                    continue;
                }
                hasHide = true;
            }
            if (hasHide) {
                children.add(new LayerHidenNode((ATreeNode)this));
            }
            return children;
        }

        @Override
        public Iterator<Action> getActions() {
            LayerUI.ActionSetAllLayersVisible turnOn = new LayerUI.ActionSetAllLayersVisible(String.format("All '%s' Layers on", this.mSubstrate.getName()), (Iterable<Layer>)this.mSubstrate.getLayers(), true, () -> ViewPanel.this.mTreeTable.repaint());
            LayerUI.ActionSetAllLayersVisible turnOff = new LayerUI.ActionSetAllLayersVisible(String.format("All '%s' Layers off", this.mSubstrate.getName()), (Iterable<Layer>)this.mSubstrate.getLayers(), false, () -> ViewPanel.this.mTreeTable.repaint());
            return new AIterableItr((Object[])new Action[]{turnOn, turnOff}).iterator();
        }
    }

    protected class RootNode
    extends ViewNode {
        protected final Db mDb;

        public RootNode(Db db) {
            super((ATreeModel)ViewPanel.this.mTreeTable.getTreeModel());
            this.mDb = db;
        }

        public Db getDb() {
            return this.mDb;
        }

        public String getText() {
            return this.mDb == null ? "No database" : "Layer Options for " + this.mDb.getDescription(false);
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            ArrayList children = new ArrayList();
            if (this.mDb != null) {
                this.mDb.getObjects(Substrate.class).stream().sorted().forEach(substrate -> children.add(new SubstrateNode(this, (Substrate)substrate)));
            }
            return children;
        }
    }

    public static class ViewSetModel
    extends AAbstractTreeTableModel {
        protected static String[] columnNames = new String[]{"", "", "V"};
        protected static Class<?>[] columnTypes = new Class[]{ATreeTableModel.class, Icon.class, Icon.class};

        public ViewSetModel(ViewNode rootNode) {
            super((Object)rootNode);
            this.mRoot = rootNode;
        }

        public Object getChild(Object parent, int index) {
            return ((ViewNode)((Object)parent)).getChildAt(index);
        }

        public int getChildCount(Object parent) {
            return ((ViewNode)((Object)parent)).getChildCount();
        }

        public int getColumnCount() {
            return columnNames.length;
        }

        public String getColumnName(int column) {
            return columnNames[column];
        }

        public Class<?> getColumnClass(int column) {
            return columnTypes[column];
        }

        public Object getValueAt(Object node, int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return ((ViewNode)((Object)node)).getColorIcon();
                }
                case 2: {
                    return ((ViewNode)((Object)node)).getVisibleIcon();
                }
            }
            return null;
        }

        public void setValueAt(Object aValue, Object node, int column) {
        }
    }

    public static abstract class ViewNode
    extends ALazyTreeNode {
        public ViewNode(ATreeModel owner) {
            super(owner);
        }

        public ViewNode(ATreeNode parent) {
            super(parent);
        }

        Icon getColorIcon() {
            return null;
        }

        Icon getVisibleIcon() {
            return null;
        }

        public String getTooltip() {
            return this.getText();
        }
    }

    static enum Mode {
        LAYER,
        OBJECT,
        MIXED;

    }
}

