/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.side_panels.sel_option;

import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGridArea;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.table_editor.EditDeviceUI;
import com.sigrity.orbit.ui.table_editor.EditNetUI;
import com.sigrity.orbit.ui.table_editor.EditPinUI;
import com.sigrity.orbit.ui.table_editor.EditTermUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class InteractiveSelModePnl
extends JPanel {
    private final EditTermUI.TermTableBodyPanel mTermsTable;
    private final EditNetUI.NetTableBodyPanel mNetsTable;
    private final EditPinUI.PinTableBodyPanel mPinsTable;
    private final EditDeviceUI.DeviceTableBodyPanel mDevicesTable;
    private static final String DEVICESTABLE_NAME = "Devices Table";
    private static final String NETSTABLE_NAME = "Nets Table";
    private static final String TERMSTABLE_NAME = "Terms Table";
    private static final String PINSTABLE_NAME = "Pins Table";
    private HierInst<DbObject> hierInst;
    private boolean isUpdating = false;
    private boolean initDocking = false;
    private static boolean isRegistered = false;
    private static CContentArea mDockingArea = InteractiveSelModePnl.registerDockingArea();
    private static Map<String, DefaultSingleCDockable> mDockingMap = new HashMap<String, DefaultSingleCDockable>();
    private static SingleCDockableFactory devicesDockableFactory = id -> {
        UtilDockable dockable = new UtilDockable(id, DEVICESTABLE_NAME, OrbitIcons.TABLE, null);
        InteractiveSelModePnl.initUtilDock(dockable);
        return dockable;
    };
    private static SingleCDockableFactory netsDockableFactory = id -> {
        UtilDockable dockable = new UtilDockable(id, NETSTABLE_NAME, OrbitIcons.TABLE, null);
        InteractiveSelModePnl.initUtilDock(dockable);
        return dockable;
    };
    private static SingleCDockableFactory termsDockableFactory = id -> {
        UtilDockable dockable = new UtilDockable(id, TERMSTABLE_NAME, OrbitIcons.TABLE, null);
        InteractiveSelModePnl.initUtilDock(dockable);
        return dockable;
    };
    private static SingleCDockableFactory pinsDockableFactory = id -> {
        UtilDockable dockable = new UtilDockable(id, PINSTABLE_NAME, OrbitIcons.TABLE, null);
        InteractiveSelModePnl.initUtilDock(dockable);
        return dockable;
    };

    private static void initUtilDock(UtilDockable dock) {
        mDockingMap.put(dock.getUniqueId(), dock);
        mDockingArea.getControl().addDockable((SingleCDockable)dock);
        dock.setDefaultLocation(ExtendedMode.NORMALIZED, (CLocation)CLocation.normalized((CGridArea)mDockingArea.getCenterArea()));
        dock.setLocation((CLocation)CLocation.normalized((CGridArea)mDockingArea.getCenterArea()));
        dock.setVisible(true);
    }

    static String getDockingId(String title) {
        return InteractiveSelModePnl.class.getName() + ":" + title;
    }

    public static void registerDockingUI() {
        if (isRegistered) {
            return;
        }
        OrbitGuiWS ws = OrbitIO.getApp().getWorkspace();
        if (ws == null) {
            return;
        }
        CControl dockControl = ws.getDockingController();
        dockControl.addSingleDockableFactory(InteractiveSelModePnl.getDockingId(DEVICESTABLE_NAME), devicesDockableFactory);
        dockControl.addSingleDockableFactory(InteractiveSelModePnl.getDockingId(NETSTABLE_NAME), netsDockableFactory);
        dockControl.addSingleDockableFactory(InteractiveSelModePnl.getDockingId(TERMSTABLE_NAME), termsDockableFactory);
        dockControl.addSingleDockableFactory(InteractiveSelModePnl.getDockingId(PINSTABLE_NAME), pinsDockableFactory);
        isRegistered = true;
    }

    private static CContentArea registerDockingArea() {
        CControl dockControl = OrbitIO.getApp().getWorkspace().getDockingController();
        return dockControl.createContentArea(String.format("%s", InteractiveSelModePnl.class.getName()));
    }

    public InteractiveSelModePnl() {
        super(new BorderLayout());
        DevicePath rootPath = Design.getDesignPath((Db)OrbitApp.getCurDb());
        Window mainWindow = OrbitIO.getMainWindow();
        this.mTermsTable = EditTermUI.getEditTermPanel(mainWindow, rootPath);
        this.mNetsTable = EditNetUI.getEditNetPanel(mainWindow, rootPath);
        this.mPinsTable = EditPinUI.getEditPinPanel(mainWindow, rootPath);
        this.mDevicesTable = EditDeviceUI.getEditDevicePanel(mainWindow, rootPath);
        InteractiveSelModePnl.registerDockingUI();
        this.add((Component)mDockingArea, "Center");
        this.initDocks();
    }

    private void initDocks() {
        if (this.initDocking) {
            return;
        }
        this.initDocking = true;
        InteractiveSelModePnl.getOrCreateDock(TERMSTABLE_NAME, this.createTablePanel((JFXPanel)this.mTermsTable));
        InteractiveSelModePnl.getOrCreateDock(NETSTABLE_NAME, this.createTablePanel((JFXPanel)this.mNetsTable));
        InteractiveSelModePnl.getOrCreateDock(PINSTABLE_NAME, this.createTablePanel((JFXPanel)this.mPinsTable));
        InteractiveSelModePnl.getOrCreateDock(DEVICESTABLE_NAME, this.createTablePanel((JFXPanel)this.mDevicesTable));
    }

    private static DefaultSingleCDockable getOrCreateDock(String title, JComponent panel) {
        String dockId = InteractiveSelModePnl.getDockingId(title);
        OrbitGuiWS ws = OrbitIO.getApp().getWorkspace();
        CControl controller = ws.getDockingController();
        DefaultSingleCDockable dock = (DefaultSingleCDockable)controller.getSingleDockable(dockId);
        if (dock == null) {
            dock = mDockingMap.get(dockId);
        }
        if (dock == null) {
            dock = (DefaultSingleCDockable)controller.getSingleDockableFactory(dockId).createBackup(dockId);
        }
        dock.getContentPane().removeAll();
        dock.getContentPane().add(panel);
        return dock;
    }

    public void updateSel(HierInst<DbObject> hier) {
        this.hierInst = hier;
        if (!this.isUpdating) {
            this.isUpdating = true;
            Platform.runLater(() -> {
                this.isUpdating = false;
                this.updateTable();
                SwingUtilities.invokeLater(() -> {
                    this.validate();
                    this.revalidate();
                    this.repaint();
                });
            });
        }
    }

    private JPanel createTablePanel(JFXPanel fxTable) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)fxTable, "Center");
        return panel;
    }

    private void updateTable() {
        DevicePath path = Design.getDesignPath((Db)OrbitApp.getCurDb());
        if (this.hierInst != null && this.hierInst.getDbObject() instanceof Device && this.hierInst.getPath() != null && this.hierInst.getPath().isValid()) {
            path = this.hierInst.getPath();
            Device dev = (Device)this.hierInst.getDbObject();
            if (path.getDeviceTemplate() == dev.getParent()) {
                path.add(dev);
            }
        }
        this.updateTermsTable(path);
        this.updateNetsTable(path);
        this.updatePinsTable(path);
        this.updateDevicesTable(path);
    }

    private void updateDevicesTable(DevicePath path) {
        this.mDevicesTable.updateDevPath(path);
    }

    private void updateNetsTable(DevicePath path) {
        this.mNetsTable.updateDevPath(path);
    }

    private void updateTermsTable(DevicePath path) {
        this.mTermsTable.updateDevPath(path);
    }

    private void updatePinsTable(DevicePath path) {
        this.mPinsTable.updateDevPath(path);
    }

    static class UtilDockable
    extends DefaultSingleCDockable {
        public UtilDockable(String id, String title, Icon icon, JComponent panel) {
            super(id, new CAction[0]);
            this.setTitleText(title);
            this.setTitleIcon(icon);
            this.getContentPane().setLayout(new BorderLayout());
            if (panel != null) {
                this.getContentPane().add((Component)panel, "Center");
            }
            this.setCloseable(false);
        }
    }
}

