/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.side_panels.sel_option;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.DbObject;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.orbit.ui.side_panels.sel_option.StackLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.DataFormat;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.GridPane;
import org.javatuples.Pair;

public class StackPanel
extends TitledPane {
    private static final float WIDTH = 240.0f;
    protected DbObject mObject;
    protected static Map<Class<?>, Boolean> prefSetting = new HashMap();
    protected ArrayList<Pair<String, Control>> mField = new ArrayList();
    private StackLayout mLayout;
    private GridPane mGridPane = new GridPane();

    public StackPanel(String title, StackLayout.LAYOUT l) {
        this.setPrefWidth(240.0);
        this.mLayout = new StackLayout(l, this.mGridPane);
        this.setTitle(title);
        this.setContent((Node)this.mGridPane);
        this.initExpandListener();
        this.setExpanded(this.getPerfExpand());
    }

    protected void setTitle(String title) {
        this.setText(title);
    }

    protected void setPerfExpand(boolean b) {
        prefSetting.put(((Object)((Object)this)).getClass(), b);
    }

    protected boolean getPerfExpand() {
        return prefSetting.computeIfAbsent(((Object)((Object)this)).getClass(), k -> true);
    }

    protected void initExpandListener() {
        this.expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> obs, Boolean oldVal, Boolean newVal) {
                StackPanel.this.setPerfExpand(newVal);
            }
        });
    }

    protected void initTextField(String target, Supplier<String> supplier) {
        this.initTextField(target, target, supplier);
    }

    private static String getSystemSelection() {
        Clipboard x11Sel = Toolkit.getDefaultToolkit().getSystemSelection();
        if (x11Sel != null) {
            try {
                return (String)x11Sel.getData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static String getClipboardString() {
        javafx.scene.input.Clipboard clipboard = javafx.scene.input.Clipboard.getSystemClipboard();
        if (clipboard.hasString()) {
            return (String)clipboard.getContent(DataFormat.PLAIN_TEXT);
        }
        return null;
    }

    protected void initTextField(String userText, final String target, final Supplier<String> supplier) {
        final TextField tf = new TextField(supplier.get());
        this.setTooltipOnField((Control)tf, this.mObject.getKeyStr());
        tf.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                StackPanel.this.cpSetTextField(target, tf, supplier);
            }
        });
        tf.setOnMousePressed(me -> {
            if (me.getButton() == MouseButton.MIDDLE) {
                String text = StackPanel.getSystemSelection();
                if (text == null) {
                    text = StackPanel.getClipboardString();
                }
                if (text != null) {
                    tf.setText(text);
                }
            }
        });
        tf.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> obs, Boolean oldfocus, Boolean newfocus) {
                if (Boolean.FALSE.equals(newfocus)) {
                    StackPanel.this.cpSetTextField(target, tf, supplier);
                }
            }
        });
        this.mField.add((Pair<String, Control>)new Pair((Object)(userText + ": "), (Object)tf));
    }

    protected void cpSetTextField(String target, TextField tf, Supplier<String> getter) {
        Cp.exec((String)"%s.set%s(\"%s\")", (Object[])new Object[]{CpHelper.getObjCmdStr(this.mObject), target, tf.getText()});
        tf.setText(getter.get());
        this.refreshCanvas();
    }

    protected void initNumericField(String userText, final String target, final Unit unit, final Supplier<?> supplier) {
        Object valStr = unit != null ? unit.toUserStr(((Long)supplier.get()).longValue()) : "" + ((Float)supplier.get()).floatValue();
        final TextField vf = new TextField();
        vf.setText((String)valStr);
        vf.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                StackPanel.this.cpSetValueField(target, vf, supplier, unit);
            }
        });
        vf.setOnMousePressed(me -> {
            if (me.getButton() == MouseButton.MIDDLE) {
                String text = StackPanel.getSystemSelection();
                if (text == null) {
                    text = StackPanel.getClipboardString();
                }
                if (text != null) {
                    vf.setText(text);
                }
            }
        });
        vf.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> obs, Boolean oldfocus, Boolean newfocus) {
                if (Boolean.FALSE.equals(newfocus)) {
                    StackPanel.this.cpSetValueField(target, vf, supplier, unit);
                }
            }
        });
        this.mField.add((Pair<String, Control>)new Pair((Object)(userText + ": "), (Object)vf));
    }

    protected void cpSetValueField(String target, TextField vf, Supplier<?> getter, Unit unit) {
        try {
            String newVal = vf.getText();
            if (unit != null) {
                Cp.exec((String)"%s.set%s(%dL)", (Object[])new Object[]{CpHelper.getObjCmdStr(this.mObject), target, unit.fromUserString(newVal)});
                vf.setText(unit.toUserStr(((Long)getter.get()).longValue()));
            } else {
                Cp.exec((String)"%s.set%s(%fF)", (Object[])new Object[]{CpHelper.getObjCmdStr(this.mObject), target, Float.valueOf(newVal)});
                vf.setText(String.valueOf(((Float)getter.get()).floatValue()));
            }
        }
        catch (NumberFormatException ee) {
            ALog.logError((String)(ee.getMessage() + " is not a number."));
            if (unit != null) {
                vf.setText(String.valueOf(unit.toUser(((Long)getter.get()).longValue())));
            }
            vf.setText(String.valueOf(((Float)getter.get()).floatValue()));
        }
        this.refreshCanvas();
    }

    protected void initBooleanField(String userText, String tooltip, final String target, BooleanSupplier supplier) {
        boolean val = supplier.getAsBoolean();
        final CheckBox cb = new CheckBox();
        cb.setSelected(val);
        cb.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                boolean newVal = cb.isSelected();
                Cp.exec((String)"%s.set%s(%b)", (Object[])new Object[]{CpHelper.getObjCmdStr(StackPanel.this.mObject), target, newVal});
                StackPanel.this.refreshCanvas();
            }
        });
        cb.setTooltip(new Tooltip(tooltip));
        this.mField.add((Pair<String, Control>)new Pair((Object)(userText + ": "), (Object)cb));
    }

    protected <E extends Enum<E>> void initComboField(final String target, final Class<E> enumClass, final Supplier<E> supplier) {
        final ComboBox cb = new ComboBox();
        for (Enum use : (Enum[])enumClass.getEnumConstants()) {
            cb.getItems().add((Object)use);
        }
        cb.setValue((Object)((Enum)supplier.get()));
        cb.setVisibleRowCount(4);
        cb.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                Enum e = (Enum)cb.getSelectionModel().getSelectedItem();
                Cp.exec((String)"%s.set%s(%s.%s)", (Object[])new Object[]{CpHelper.getObjCmdStr(StackPanel.this.mObject), target, enumClass.getName(), e});
                cb.setValue((Object)((Enum)supplier.get()));
                StackPanel.this.refreshCanvas();
            }
        });
        this.mField.add((Pair<String, Control>)new Pair((Object)(target + ": "), (Object)cb));
    }

    protected void addField(String title, Control ct) {
        Label titleLabel = new Label(title);
        this.mLayout.addField((Control)titleLabel, ct);
    }

    protected void addAllField() {
        for (Pair<String, Control> p : this.mField) {
            this.addField((String)p.getValue0(), (Control)p.getValue1());
        }
    }

    protected void setTooltipOnField(Control lb, String text) {
        lb.setTooltip(new Tooltip(text));
    }

    protected void refreshCanvas() {
        OrbitIO.refreshViewsOf(this.mObject.getDb());
    }
}

