/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.table_editor;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.jfxui.AJFXAlerts;
import com.sigrity.acl.jfxui.AJFXButton;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.CloseHBox;
import com.sigrity.acl.jfxui.Separators;
import com.sigrity.acl.jfxui.SlowOperationAlert;
import com.sigrity.acl.jfxui.StringConverters;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import com.sigrity.orbit.inter_substrate_checks.ui.PinMapCheckEngineUI;
import com.sigrity.orbit.jfxui.AJFXGetters;
import com.sigrity.orbit.jfxui.EditorTableView;
import com.sigrity.orbit.jfxui.OrbitJFXImages;
import com.sigrity.orbit.ui.ContactDeviceFactoryUI;
import com.sigrity.orbit.ui.DbObjectDetailsUI;
import com.sigrity.orbit.ui.DeleteContactUI;
import com.sigrity.orbit.ui.EditContactLayerUI;
import com.sigrity.orbit.ui.ExportContactLayerDlg;
import com.sigrity.orbit.ui.ImportContactLayerDlg;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.PinMapExportUI;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class EditContactLayerUI
extends AJFXDesignDialog {
    private static final String ACTION_TITLE = "ContactLayers Table";
    private static final String DIALOG_TITLE = "ContactLayer Table Editor";
    private static final int PANEL_WIDTH = 600;
    private static final int PANEL_HEIGHT = 300;

    public static Action getAction() {
        return new AbstractAction(ACTION_TITLE, OrbitIcons.TABLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditContactLayerUI.createDialog(OrbitIO.getMainWindow(), OrbitIO.getCurDb());
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static EditContactLayerUI createDialog(Window owner, Db db) {
        if (db == null) {
            ALog.logError((String)"No design is open.");
            return null;
        }
        EditContactLayerUI dlg = new EditContactLayerUI(owner, db);
        dlg.setVisible(true);
        return dlg;
    }

    private EditContactLayerUI(Window owner, Db db) {
        super(db, owner, DIALOG_TITLE);
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new EditContactLayerPanel((Window)((Object)this), this.getDb());
    }

    public static TableBodyPanel getBodyPanel(Window owner, Db db) {
        Platform.setImplicitExit((boolean)false);
        TableBodyPanel tableBodyPanel = new TableBodyPanel(owner, db);
        tableBodyPanel.init();
        return tableBodyPanel;
    }

    private static String getDevPathShowedStr(DevicePath devPath) {
        DevicePath fullPathA = devPath.getAFullPath();
        return fullPathA == null ? devPath.escapedString() : fullPathA.toString();
    }

    private static enum CheckState {
        IDLE("Idle"),
        RUNNING("Running..."),
        FAILED("Failed"),
        SUCCESS("Success");

        private String str;

        private CheckState(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    private static class TableBodyPanel
    extends AJFXPanel {
        private final Window mOwner;
        private final Db mDb;
        private final Unit mUnit;
        private final EditContactLayerUI.Options mDefaultOptions;
        private ContactLayerTableView mTableView;

        public TableBodyPanel(Window owner, Db db) {
            this.mOwner = owner;
            this.mDb = db;
            this.mUnit = Design.getUnit((Db)db);
            this.mDefaultOptions = new EditContactLayerUI.Options(db);
            this.setPreferredSize(new Dimension(600, 300));
        }

        protected Parent initSceneGraph() {
            VBox pane = new VBox(5.0);
            Toolbar mToolbar = new Toolbar();
            VBox.setVgrow((Node)mToolbar, (Priority)Priority.NEVER);
            pane.getChildren().add((Object)mToolbar);
            this.mTableView = new ContactLayerTableView();
            VBox.setVgrow((Node)this.mTableView, (Priority)Priority.ALWAYS);
            pane.getChildren().add((Object)this.mTableView);
            this.mOwner.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    Platform.runLater(() -> mTableView.cancelCheckingTasks());
                }
            });
            return pane;
        }

        private class CheckColumnItem {
            private PinMapCheck mCheckEngine;
            private CheckState mCheckState;
            private ExecutorService mExeService;

            private CheckColumnItem(ContactLayer contactLayer) {
                this.mCheckEngine = TableBodyPanel.this.mDefaultOptions.getCheckEngine(contactLayer);
                this.mCheckState = CheckState.IDLE;
                this.startNewCheckingTask();
            }

            public CheckState getCheckState() {
                return this.mCheckState;
            }

            public void showResultUI() {
                PinMapCheckEngineUI.createDialog(TableBodyPanel.this.mOwner, TableBodyPanel.this.mDb, this.mCheckEngine);
            }

            private void startNewCheckingTask() {
                this.cancelCheckingTask();
                this.mExeService = Executors.newSingleThreadExecutor();
                this.mExeService.execute(() -> {
                    this.mCheckState = CheckState.RUNNING;
                    if (TableBodyPanel.this.mTableView != null) {
                        TableBodyPanel.this.mTableView.refreshFocusLater();
                    }
                    this.mCheckEngine.execute();
                    int violationCount = this.mCheckEngine.getViolationCount();
                    this.mCheckState = violationCount == 0 ? CheckState.SUCCESS : CheckState.FAILED;
                    if (TableBodyPanel.this.mTableView != null) {
                        TableBodyPanel.this.mTableView.refreshFocusLater();
                    }
                });
                this.mExeService.shutdown();
            }

            private void cancelCheckingTask() {
                if (this.mExeService == null || !this.mExeService.isShutdown()) {
                    return;
                }
                this.mExeService.shutdownNow();
            }
        }

        private class ContactLayerTableView
        extends EditorTableView<ContactLayer> {
            private Map<ContactLayer, CheckColumnItem> contactLayer2CheckColumnItem;

            public ContactLayerTableView() {
                this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
                this.getSelectionModel().setCellSelectionEnabled(true);
                this.setEditable(true);
                this.setSortedComparator(ContactLayer.StableComparator);
            }

            @Override
            protected List<ContactLayer> getItemList() {
                return AUtil.arrayList((Iterator)ContactLayer.getValid((Db)TableBodyPanel.this.mDb));
            }

            @Override
            protected void initHeader() {
                this.initRowNumCol();
                this.initCheckCol();
                this.iniContactDeviceACol();
                this.iniContactDeviceBCol();
                this.initHeightCol();
            }

            public void clearCheckItems() {
                this.contactLayer2CheckColumnItem = null;
            }

            public void clearCheckItems(List<ContactLayer> contactLayers) {
                contactLayers.forEach(this.contactLayer2CheckColumnItem::remove);
            }

            public void startNewCheckingTasks(List<ContactLayer> cls) {
                cls.forEach(this::startNewCheckingTask);
            }

            public void startNewCheckingTask(ContactLayer cl) {
                if (this.contactLayer2CheckColumnItem == null) {
                    return;
                }
                CheckColumnItem checkColumnItem = this.contactLayer2CheckColumnItem.get(cl);
                if (checkColumnItem != null) {
                    checkColumnItem.startNewCheckingTask();
                }
            }

            public void cancelCheckingTasks() {
                if (this.contactLayer2CheckColumnItem == null) {
                    return;
                }
                this.contactLayer2CheckColumnItem.forEach((k, v) -> v.cancelCheckingTask());
            }

            public void cancelCheckingTask(ContactLayer cl) {
                if (this.contactLayer2CheckColumnItem == null) {
                    return;
                }
                CheckColumnItem checkColumnItem = this.contactLayer2CheckColumnItem.get(cl);
                if (checkColumnItem != null) {
                    checkColumnItem.cancelCheckingTask();
                }
            }

            private void initRowNumCol() {
                this.addNewRowNumCol();
            }

            private void initCheckCol() {
                EditorTableView.EditorTableColumn<CheckState> col = this.addNewEditorTableColumn("Check", CheckState::toString, cl -> this.getOrCreateCheckColumnItem((ContactLayer)cl).getCheckState());
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                col.setCellFactory(col.newGraphicCellFactory(new CheckGraphicGetter(), new CheckContextMenuGetter(), new CheckMouseClickHandler()));
            }

            private CheckColumnItem getOrCreateCheckColumnItem(ContactLayer cl) {
                if (this.contactLayer2CheckColumnItem == null) {
                    this.contactLayer2CheckColumnItem = new HashMap<ContactLayer, CheckColumnItem>();
                }
                return this.contactLayer2CheckColumnItem.computeIfAbsent(cl, x -> new CheckColumnItem(cl));
            }

            private void iniContactDeviceACol() {
                String colName = "Contact Device A";
                this.iniContactDeviceCol(colName, ContactLayer::getDevicePathA, ContactLayer::getContactLayerA);
            }

            private void iniContactDeviceBCol() {
                String colName = "Contact Device B";
                this.iniContactDeviceCol(colName, ContactLayer::getDevicePathB, ContactLayer::getContactLayerB);
            }

            private void iniContactDeviceCol(String colName, AJFXGetters.ValueGetter<ContactLayer, DevicePath> devPathGetter, AJFXGetters.ValueGetter<ContactLayer, Layer> layerGetter) {
                TableColumn col = new TableColumn(colName);
                this.initDevicePathCol((TableColumn<ContactLayer, String>)col, devPathGetter);
                this.initLayerCol((TableColumn<ContactLayer, String>)col, layerGetter);
                this.getColumns().add((Object)col);
            }

            private void initDevicePathCol(TableColumn<ContactLayer, String> parentCol, AJFXGetters.ValueGetter<ContactLayer, DevicePath> valueGetter) {
                AJFXGetters.TextGetter<DevicePath> textGetter = x$0 -> EditContactLayerUI.getDevPathShowedStr(x$0);
                EditorTableView.EditorTableColumn<DevicePath> col = this.addNewEditorTableColumn("DevicePath", textGetter, valueGetter, parentCol);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                col.setCellFactory(col.newValueTextCellFactory(devPath -> new ImageView(OrbitJFXImages.getImageForTemplate(devPath.getDeviceTemplate())), new DevicePathContextMenuGetter()));
                col.setMinWidth(110.0);
            }

            private void initLayerCol(TableColumn<ContactLayer, String> parentCol, AJFXGetters.ValueGetter<ContactLayer, Layer> valueGetter) {
                EditorTableView.EditorTableColumn<Layer> col = this.addNewEditorTableColumn("Layer", Layer::getName, valueGetter, parentCol);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                col.setCellFactory(col.newValueTextCellFactory());
            }

            private void initHeightCol() {
                EditorTableView.EditorTableColumn<Number> col = this.addNewEditorTableColumn("Height", Object::toString, cl -> TableBodyPanel.this.mUnit.toUser(cl.getHeight()));
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleDoubleFactory());
                col.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new StringConverters.DoubleNumberStringConverter()));
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<ContactLayer, Number>>(){

                    public void handle(TableColumn.CellEditEvent<ContactLayer, Number> t) {
                        Number newNumber = (Number)t.getNewValue();
                        if (newNumber == null) {
                            this.showSetHeightAlert();
                            ContactLayerTableView.this.refreshFocus();
                            return;
                        }
                        ObservableList selectedItems = ContactLayerTableView.this.getSelectedItems();
                        double newValue = newNumber.doubleValue();
                        long orbitValue = TableBodyPanel.this.mUnit.fromUser(newValue);
                        SwingUtilities.invokeLater(() -> {
                            selectedItems.forEach(i -> this.cpSetHeight((ContactLayer)i, orbitValue));
                            ContactLayerTableView.this.refreshFocusLater();
                        });
                    }

                    private void showSetHeightAlert() {
                        String headerTxt = "Invalid height of contactLayer";
                        String contactTxt = "Height of contactLayer should be a number.";
                        AJFXAlerts.showErrorAlert((Window)TableBodyPanel.this.mOwner, (String)EditContactLayerUI.DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
                    }

                    private void cpSetHeight(ContactLayer layer, long orbitValue) {
                        Cp.exec((String)"%s.setHeight(%dL)", (Object[])new Object[]{CpHelper.getObjCmdStr(layer), orbitValue});
                    }
                });
            }

            @Override
            protected void bindKeys() {
            }

            private class DevicePathContextMenuGetter
            implements AJFXGetters.ContextMenuGetter<DevicePath> {
                private DevicePathContextMenuGetter() {
                }

                @Override
                public ContextMenu get(DevicePath item) {
                    ContextMenu contextMenu = new ContextMenu();
                    MenuItem generateContactMenu = this.getGenerateContactMenu(item);
                    contextMenu.getItems().add((Object)generateContactMenu);
                    MenuItem deleteContactMenu = this.getDeleteContactMenu(item);
                    contextMenu.getItems().add((Object)deleteContactMenu);
                    return contextMenu;
                }

                private MenuItem getGenerateContactMenu(final DevicePath item) {
                    ImageView imageView = new ImageView(OrbitJFXImages.CONTACT_DEVICE);
                    MenuItem menuItem = new MenuItem("Generate contacts", (Node)imageView);
                    menuItem.setOnAction(e -> {
                        final ContactLayer cl = (ContactLayer)TableBodyPanel.this.mTableView.getSelectedItem();
                        if (cl == null) {
                            return;
                        }
                        TableBodyPanel.this.mTableView.cancelCheckingTask(cl);
                        SwingUtilities.invokeLater(() -> {
                            boolean isDevPathA = item.equals((Object)cl.getDevicePathA());
                            ContactDeviceFactoryUI dlg = ContactDeviceFactoryUI.createDialog(TableBodyPanel.this.mOwner, TableBodyPanel.this.mDb, cl, isDevPathA);
                            dlg.addWindowListener(new WindowAdapter(){

                                @Override
                                public void windowClosed(WindowEvent e) {
                                    Platform.runLater(() -> {
                                        if (item == null || !cl.isValid()) {
                                            TableBodyPanel.this.mTableView.reloadItems();
                                        } else {
                                            TableBodyPanel.this.mTableView.startNewCheckingTask(cl);
                                        }
                                    });
                                }
                            });
                        });
                    });
                    return menuItem;
                }

                private MenuItem getDeleteContactMenu(DevicePath item) {
                    ImageView imageView = new ImageView(OrbitJFXImages.CROSS);
                    MenuItem menuItem = new MenuItem("Delete contacts", (Node)imageView);
                    menuItem.setOnAction(e -> {
                        ContactLayer cl = (ContactLayer)TableBodyPanel.this.mTableView.getSelectedItem();
                        if (cl == null) {
                            return;
                        }
                        Optional<DeleteContactUI.DeleteActionType> deleteOption = this.getDeleteOption(item);
                        if (deleteOption.isEmpty()) {
                            return;
                        }
                        TableBodyPanel.this.mTableView.cancelCheckingTask(cl);
                        SwingUtilities.invokeLater(() -> {
                            String devPathShowedStr = EditContactLayerUI.getDevPathShowedStr(item);
                            ALog.logInfo((String)"Deleting contacts on '%s'...", (Object[])new Object[]{devPathShowedStr});
                            boolean isDevPathA = item.equals((Object)cl.getDevicePathA());
                            if (deleteOption.get() == DeleteContactUI.DeleteActionType.PIN) {
                                DeleteContactUI.cpDeletePins(cl.getKeyStr(), isDevPathA);
                            } else if (deleteOption.get() == DeleteContactUI.DeleteActionType.DEVICE) {
                                DeleteContactUI.cpDeleteDevs(cl.getKeyStr(), isDevPathA);
                            }
                            ALog.logInfo((String)"Delete contacts on '%s' complete", (Object[])new Object[]{devPathShowedStr});
                            Platform.runLater(() -> {
                                if (cl == null || !cl.isValid()) {
                                    TableBodyPanel.this.mTableView.reloadItems();
                                } else {
                                    TableBodyPanel.this.mTableView.startNewCheckingTask(cl);
                                }
                            });
                        });
                    });
                    return menuItem;
                }

                private Optional<DeleteContactUI.DeleteActionType> getDeleteOption(DevicePath devPath) {
                    if (devPath.getIsAbstractContactDevice()) {
                        return this.showWarningDialog(devPath);
                    }
                    return Optional.of(DeleteContactUI.DeleteActionType.PIN);
                }

                private Optional<DeleteContactUI.DeleteActionType> showWarningDialog(DevicePath devPath) {
                    String title = "Delete Contacts";
                    String message = String.format("'%s' is a contact device", devPath);
                    ChoiceDialog dialog = new ChoiceDialog((Object)DeleteContactUI.DeleteActionType.DEVICE, (Object[])DeleteContactUI.DeleteActionType.values());
                    dialog.setTitle(title);
                    dialog.setHeaderText(message);
                    return dialog.showAndWait();
                }
            }

            private class CheckMouseClickHandler
            implements EditorTableView.MouseClickHandler<ContactLayer, CheckState> {
                private CheckMouseClickHandler() {
                }

                @Override
                public void handle(TableCell<ContactLayer, CheckState> tableCell) {
                    ContactLayer cl = (ContactLayer)tableCell.getTableRow().getItem();
                    CheckColumnItem i = ContactLayerTableView.this.getOrCreateCheckColumnItem(cl);
                    SwingUtilities.invokeLater(i::showResultUI);
                }
            }

            private class CheckGraphicGetter
            implements AJFXGetters.GraphicGetter<CheckState> {
                private CheckGraphicGetter() {
                }

                @Override
                public Node get(CheckState item) {
                    switch (item) {
                        case IDLE: {
                            return new ImageView(OrbitJFXImages.WAIT);
                        }
                        case RUNNING: {
                            ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);
                            progressIndicator.setMaxSize(16.0, 16.0);
                            progressIndicator.setPrefSize(16.0, 16.0);
                            return progressIndicator;
                        }
                        case FAILED: {
                            return new ImageView(OrbitJFXImages.EXCLAMATION);
                        }
                        case SUCCESS: {
                            return new ImageView(OrbitJFXImages.CHECK);
                        }
                    }
                    assert (false);
                    return null;
                }
            }

            private class CheckContextMenuGetter
            implements AJFXGetters.ContextMenuGetter<CheckState> {
                private CheckContextMenuGetter() {
                }

                @Override
                public ContextMenu get(CheckState item) {
                    ContextMenu contextMenu = new ContextMenu();
                    MenuItem checkOptionsMenu = this.getCheckOptionsMenu();
                    contextMenu.getItems().add((Object)checkOptionsMenu);
                    return contextMenu;
                }

                private MenuItem getCheckOptionsMenu() {
                    ImageView imageView = new ImageView(OrbitJFXImages.COG_EDIT);
                    MenuItem menuItem = new MenuItem("Check options", (Node)imageView);
                    menuItem.setOnAction(e -> {
                        ObservableList items = TableBodyPanel.this.mTableView.getSelectedItems();
                        if (items.isEmpty()) {
                            return;
                        }
                        SwingUtilities.invokeLater(() -> {
                            EditContactLayerUI.OptionsDlg dlg = new EditContactLayerUI.OptionsDlg(TableBodyPanel.this.mDb, TableBodyPanel.this.mOwner, TableBodyPanel.this.mDefaultOptions, (List<ContactLayer>)items);
                            dlg.setVisible(true);
                            dlg.addWindowListener(new WindowAdapter((List)items){
                                final /* synthetic */ List val$items;
                                {
                                    this.val$items = list;
                                }

                                @Override
                                public void windowClosed(WindowEvent e) {
                                    Platform.runLater(() -> {
                                        TableBodyPanel.this.mTableView.clearCheckItems(this.val$items);
                                        TableBodyPanel.this.mTableView.reloadItems();
                                    });
                                }
                            });
                        });
                    });
                    return menuItem;
                }
            }
        }

        private class Toolbar
        extends HBox {
            public Toolbar() {
                this.initUI();
            }

            private void initUI() {
                this.initRefreshBtn();
                this.addSeparator();
                this.initImportBtn();
                this.initExportBtn();
                this.addSeparator();
                this.initAddBtn();
                this.initDeleteLayerBtn();
                this.addSeparator();
                this.initExportPinMapBtn();
                this.initAutoNetMapBtn();
                this.addSeparator();
                this.initInformationBtn();
                this.setAlignment(Pos.CENTER_LEFT);
            }

            private void initRefreshBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.REFRESH, "Refresh");
                btn.transparentBorder();
                btn.setOnAction(this.newRefreshAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newRefreshAction() {
                return e -> SwingUtilities.invokeLater(() -> {
                    try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)TableBodyPanel.this.mDb, (String)"Refresh");){
                        this.cpRecreatePinMaps();
                    }
                    Platform.runLater(() -> {
                        TableBodyPanel.this.mTableView.clearCheckItems();
                        TableBodyPanel.this.mTableView.reloadItems();
                        TableBodyPanel.this.mTableView.requestFocus();
                    });
                });
            }

            private void cpRecreatePinMaps() {
                Cp.exec((String)"com.sigrity.acl.db.std.PinMap.deleteAll()", (Object[])new Object[0]);
                Cp.exec((String)"com.sigrity.orbit.automation.pinMap.PinMapGenerator.createPinMapFromPhysicalContact()", (Object[])new Object[0]);
            }

            private void initDeleteLayerBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.DELETE_ROW, "Delete contactLayer");
                btn.transparentBorder();
                btn.setOnAction(this.newDeleteAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newDeleteAction() {
                return e -> {
                    ObservableList<ContactLayer> items = TableBodyPanel.this.mTableView.getSelectedItems();
                    if (items == null || items.isEmpty()) {
                        return;
                    }
                    items.forEach(TableBodyPanel.this.mTableView::cancelCheckingTask);
                    int preSelectedIndex = TableBodyPanel.this.mTableView.getSelectedIndex();
                    SwingUtilities.invokeLater(() -> {
                        try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)TableBodyPanel.this.mDb, (String)"Delete contactLayers");){
                            items.forEach(this::cpDeleteContactLayer);
                        }
                        Platform.runLater(() -> {
                            TableBodyPanel.this.mTableView.reloadItems();
                            TableBodyPanel.this.mTableView.requestFocus();
                            TableBodyPanel.this.mTableView.clearSelection();
                            TableBodyPanel.this.mTableView.select(preSelectedIndex);
                        });
                    });
                };
            }

            private void cpDeleteContactLayer(ContactLayer cl) {
                Cp.exec((String)"%s.deleteFromDb()", (Object[])new Object[]{CpHelper.getObjCmdStr(cl)});
            }

            private void initAddBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.INSERT_ROW_ABOVE, "Add contactLayer");
                btn.transparentBorder();
                btn.setOnAction(this.newAddAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newAddAction() {
                return e -> SwingUtilities.invokeLater(() -> {
                    EditContactLayerUI.AddContactLayerDlg addContactLayerDlg = new EditContactLayerUI.AddContactLayerDlg(TableBodyPanel.this.mDb, TableBodyPanel.this.mOwner);
                    addContactLayerDlg.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            Platform.runLater(() -> {
                                TableBodyPanel.this.mTableView.reloadItems();
                                TableBodyPanel.this.mTableView.requestFocus();
                                TableBodyPanel.this.mTableView.clearSelection();
                            });
                        }
                    });
                    addContactLayerDlg.setVisible(true);
                });
            }

            private void initImportBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.IMPORT, "Import contactLayer csv");
                btn.transparentBorder();
                btn.setOnAction(this.newImportAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newImportAction() {
                return e -> SwingUtilities.invokeLater(() -> {
                    ImportContactLayerDlg.showUI();
                    Platform.runLater(() -> {
                        TableBodyPanel.this.mTableView.reloadItems();
                        TableBodyPanel.this.mTableView.requestFocus();
                        TableBodyPanel.this.mTableView.clearSelection();
                    });
                });
            }

            private void initExportBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.EXPORT, "Export contactLayer csv");
                btn.transparentBorder();
                btn.setOnAction(this.newExportAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newExportAction() {
                return e -> SwingUtilities.invokeLater(ExportContactLayerDlg::showUI);
            }

            private void initExportPinMapBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.EXPORT_PIN, "Export pinMap csv");
                btn.transparentBorder();
                btn.setOnAction(this.newExportPinMapAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newExportPinMapAction() {
                return e -> {
                    ObservableList items = TableBodyPanel.this.mTableView.getSelectedItems();
                    if (items == null || items.isEmpty()) {
                        ALog.logWarn((String)"No contactLayer selected. Select contactLayers before export pinMap csv");
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        PinMapExportUI ui = new PinMapExportUI((List<ContactLayer>)items);
                        ui.showUI();
                    });
                };
            }

            private void initAutoNetMapBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.NETMAP_UP, "Auto-connect nets");
                btn.transparentBorder();
                btn.setOnAction(this.newAutoNetMapAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newAutoNetMapAction() {
                return e -> {
                    ObservableList items = TableBodyPanel.this.mTableView.getSelectedItems();
                    if (items == null || items.isEmpty()) {
                        ALog.logWarn((String)"No contactLayer selected. Select contactLayers before auto-connect nets");
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        ALog.logInfo((String)"Auto-Connecting nets for %d contactLayer", (Object[])new Object[]{items.size()});
                        try (DbHistory.DbTransaction dbTransaction = DbHistory.newDbTransaction((Db)TableBodyPanel.this.mDb, (String)"Auto-Connect Net");){
                            this.cpAutoNetMap((List<ContactLayer>)items);
                        }
                        ALog.logInfo((String)"Auto-Connecting nets complete");
                        Platform.runLater(() -> TableBodyPanel.this.mTableView.startNewCheckingTasks((List<ContactLayer>)items));
                    });
                };
            }

            private void cpAutoNetMap(List<ContactLayer> contactLayers) {
                Cp.exec((String)"unset(\"_netMapGenerator\");", (Object[])new Object[0]);
                Cp.exec((String)"_netMapGenerator = new com.sigrity.orbit.automation.pinMap.NetMapGenerator(curDb());", (Object[])new Object[0]);
                for (ContactLayer cl : contactLayers) {
                    Cp.exec((String)"_netMapGenerator.addContactLayer(%s)", (Object[])new Object[]{CpHelper.getObjCmdStr(cl)});
                }
                Cp.exec((String)"_netMapGenerator.createNetMapFromPinMap()", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_netMapGenerator\");", (Object[])new Object[0]);
            }

            private void initInformationBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.INFORMATION, "Details");
                btn.transparentBorder();
                btn.setOnAction(this.newShowDetailsAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newShowDetailsAction() {
                return e -> {
                    Optional result;
                    ObservableList items = TableBodyPanel.this.mTableView.getSelectedItems();
                    if (items == null || items.isEmpty()) {
                        return;
                    }
                    int itemCount = items.size();
                    if (itemCount > 10 && ((result = SlowOperationAlert.showLargeNumUIAlert((Window)TableBodyPanel.this.mOwner, (int)itemCount)).isEmpty() || result.get() != ButtonType.OK)) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        for (ContactLayer net : items) {
                            DbObjectDetailsUI.show(TableBodyPanel.this.mOwner, (DbObject)net, null, OrbitIO.getCurView());
                        }
                    });
                };
            }

            private void addSeparator() {
                this.getChildren().add((Object)Separators.newToolbarSeparator());
            }
        }
    }

    public static class EditContactLayerPanel
    extends AJFXPanel {
        private final TableBodyPanel mTableBodyPanel;

        public EditContactLayerPanel(Window owner, Db db) {
            this.mTableBodyPanel = new TableBodyPanel(owner, db);
            this.setPreferredSize(new Dimension(600, 300));
        }

        protected Parent initSceneGraph() {
            VBox root = (VBox)this.mTableBodyPanel.initSceneGraph();
            CloseHBox closeBox = new CloseHBox(this.mTableBodyPanel.mOwner);
            root.getChildren().add((Object)closeBox);
            return root;
        }
    }
}

