/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.table_editor;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.jfxui.AJFXAlerts;
import com.sigrity.acl.jfxui.AJFXButton;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXMenuButton;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.CloseHBox;
import com.sigrity.acl.jfxui.Separators;
import com.sigrity.acl.jfxui.SlowOperationAlert;
import com.sigrity.acl.jfxui.StringConverters;
import com.sigrity.acl.ui.editors.DbFieldEditor;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ReferencePoint;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.export.DeviceCSVIn;
import com.sigrity.orbit.export.DeviceCSVOut;
import com.sigrity.orbit.jfxui.DevicePathTextBox;
import com.sigrity.orbit.jfxui.EditorTableView;
import com.sigrity.orbit.jfxui.OrbitJFXImages;
import com.sigrity.orbit.ui.DbObjectDetailsUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.TemplateUI;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class EditDeviceUI
extends AJFXDesignDialog {
    private static final String ACTION_TITLE = "Devices Table";
    private static final String DIALOG_TITLE = "Device Table Editor";
    private final Unit mUnit;
    private final DevicePath mInitDevPath;
    private final DeviceTemplate.Type mInitType;

    public static Action getAction() {
        return EditDeviceUI.getAction(null);
    }

    public static Action getAction(DevicePath devPath) {
        return EditDeviceUI.getAction(devPath, null);
    }

    public static Action getAction(final DevicePath devPath, final DeviceTemplate.Type initType) {
        return new AbstractAction(ACTION_TITLE, OrbitIcons.TABLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditDeviceUI.createDialog(OrbitIO.getMainWindow(), OrbitIO.getCurDb(), devPath, initType);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static EditDeviceUI createDialog(Window owner, Db db, String devPathStr, DeviceTemplate.Type initType) {
        return EditDeviceUI.createDialog(owner, db, DevicePath.fromString((Db)db, (String)devPathStr), initType);
    }

    public static EditDeviceUI createDialog(Window owner, Db db, String devPathStr) {
        return EditDeviceUI.createDialog(owner, db, DevicePath.fromString((Db)db, (String)devPathStr));
    }

    public static EditDeviceUI createDialog(Window owner, Db db, DevicePath devPath) {
        return EditDeviceUI.createDialog(owner, db, devPath, null);
    }

    public static EditDeviceUI createDialog(Window owner, Db db, DevicePath devPath, DeviceTemplate.Type initType) {
        if (db == null) {
            ALog.logError((String)"No design is open.");
            return null;
        }
        EditDeviceUI dlg = new EditDeviceUI(owner, db, devPath, initType);
        dlg.setVisible(true);
        return dlg;
    }

    private EditDeviceUI(Window owner, Db db, DevicePath devPath, DeviceTemplate.Type initType) {
        super(db, owner, DIALOG_TITLE);
        this.mUnit = Design.getUnit((Db)db);
        this.mInitDevPath = devPath;
        this.mInitType = initType;
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new EditDevicePanel((Window)((Object)this), this.mUnit, this.mInitDevPath, this.mInitType);
    }

    public static DeviceTableBodyPanel getEditDevicePanel(Window owner, DevicePath path) {
        DeviceTableBodyPanel deviceTableBodyPanel = new DeviceTableBodyPanel(owner, Design.getUnit((Db)path.getDb()), path, null);
        deviceTableBodyPanel.init();
        return deviceTableBodyPanel;
    }

    public static class DeviceTableBodyPanel
    extends AJFXPanel {
        private final Window mOwner;
        private final Unit mUnit;
        private final DevicePath mInitDevPath;
        private final DeviceTemplate.Type mInitType;
        private DevicePathTextBox mDevicePathTextBox;
        private DeviceTableView mDeviceTableView;

        protected DeviceTableBodyPanel(Window owner, Unit unit, DevicePath initDevPath, DeviceTemplate.Type initType) {
            this.mOwner = owner;
            this.mUnit = unit;
            this.mInitDevPath = initDevPath;
            this.mInitType = initType;
        }

        public void updateDevPath(DevicePath path) {
            this.mDevicePathTextBox.setDevicePath(path);
        }

        protected Parent initSceneGraph() {
            VBox pane = new VBox(5.0);
            this.mDevicePathTextBox = new DevicePathTextBox(this.mOwner, this.mInitDevPath){

                @Override
                protected void refreshAssociateNodes() {
                    mDeviceTableView.reloadItems();
                }
            };
            this.mDeviceTableView = new DeviceTableView(this.mOwner, this.mInitType, this.mUnit, this.mDevicePathTextBox);
            Toolbar mToolbar = new Toolbar(this.mOwner, this.mDeviceTableView, this.mDevicePathTextBox);
            VBox.setVgrow((Node)this.mDevicePathTextBox, (Priority)Priority.NEVER);
            pane.getChildren().add((Object)this.mDevicePathTextBox);
            VBox.setVgrow((Node)mToolbar, (Priority)Priority.NEVER);
            pane.getChildren().add((Object)mToolbar);
            VBox.setVgrow((Node)this.mDeviceTableView, (Priority)Priority.ALWAYS);
            pane.getChildren().add((Object)this.mDeviceTableView);
            return pane;
        }

        private static class DeviceTableView
        extends EditorTableView<Device> {
            private final Window mOwner;
            private final DeviceTemplate.Type mInitType;
            private final Unit mUnit;
            private final DevicePathTextBox mDevicePathTextBox;
            private final ReferencePoint mRefP;

            public DeviceTableView(Window owner, DeviceTemplate.Type type, Unit unit, DevicePathTextBox pathBox) {
                this.mDevicePathTextBox = pathBox;
                this.mOwner = owner;
                this.mInitType = type;
                this.mUnit = unit;
                this.mRefP = new ReferencePoint();
                this.reloadItems();
                this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
                this.getSelectionModel().setCellSelectionEnabled(true);
                this.setEditable(true);
                this.setSortedComparator(Device.CompareName);
            }

            private DevicePath getTargetDevicePath() {
                if (this.mDevicePathTextBox == null) {
                    return null;
                }
                return this.mDevicePathTextBox.getDevicePath();
            }

            private DeviceTemplate getTargetDevT() {
                DevicePath path = this.getTargetDevicePath();
                if (path == null) {
                    return null;
                }
                return path.getDeviceTemplate();
            }

            @Override
            protected List<Device> getItemList() {
                DeviceTemplate devT = this.getTargetDevT();
                if (devT == null) {
                    return Collections.emptyList();
                }
                if (this.mInitType == null) {
                    return AUtil.arrayList((Iterator)devT.getChildren());
                }
                return devT.getChildren().stream().filter(dev -> dev.getType() == this.mInitType).collect(Collectors.toList());
            }

            @Override
            protected void initHeader() {
                this.initRowNumCol();
                this.initNameCol();
                this.initTemplateCol();
                this.initTypeCol();
                this.iniPlacementCol();
                Db db = OrbitIO.getCurDb();
                if (db != null && db.getDbClass(Device.class) != null) {
                    for (DbFieldDef def : db.getDbClass(Device.class).getFields()) {
                        if (def.getIsHard()) continue;
                        EditorTableView.EditorTableColumn<String> col = this.initSoftFieldCol(def);
                        col.setVisible(false);
                        this.getTableFilterButton().addFilterCheckBox(def.getName(), col);
                    }
                }
            }

            private EditorTableView.EditorTableColumn<String> initSoftFieldCol(final DbFieldDef def) {
                EditorTableView.EditorTableColumn<String> col = this.addNewEditorTableColumn(def.getName(), name -> name, dev -> {
                    DbFieldEditor editor = DbFieldEditor.getFieldEditor(def, (DbObject)dev);
                    if (editor == null) {
                        return "CANNOT EDIT";
                    }
                    return editor.getOldValueAsString();
                });
                col.setTooltip(def.getDescription());
                col.setCellValueFactory(col.newReadOnlyStringFactory());
                col.setCellFactory(TextFieldTableCell.forTableColumn());
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Device, String>>(){

                    public void handle(TableColumn.CellEditEvent<Device, String> t) {
                        Device dev = (Device)t.getTableView().getItems().get(t.getTablePosition().getRow());
                        String newValue = (String)t.getNewValue();
                        SwingUtilities.invokeLater(() -> this.cpSetValue(dev, newValue));
                        t.getTableView().requestFocus();
                    }

                    private void cpSetValue(Device dev, String newName) {
                        DbFieldEditor editor = DbFieldEditor.getFieldEditor(def, (DbObject)dev);
                        if (editor == null) {
                            return;
                        }
                        editor.getValueEditor().setNewValueAsString(newName);
                        editor.saveNewValue();
                    }
                });
                return col;
            }

            private void initRowNumCol() {
                this.addNewRowNumCol();
            }

            private void initNameCol() {
                EditorTableView.EditorTableColumn<String> col = this.addNewEditorTableColumn("Name", name -> name, Device::getName);
                col.setCellValueFactory(col.newReadOnlyStringFactory());
                col.setCellFactory(TextFieldTableCell.forTableColumn());
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Device, String>>(){

                    public void handle(TableColumn.CellEditEvent<Device, String> t) {
                        Device dev = (Device)t.getTableView().getItems().get(t.getTablePosition().getRow());
                        DeviceTemplate devT = this.getTargetDevT();
                        String newName = (String)t.getNewValue();
                        if (devT != null && devT.getChild(newName) == null) {
                            SwingUtilities.invokeLater(() -> this.cpSetName(dev, newName));
                        } else if (!dev.getName().equals(newName)) {
                            this.showSetNameAlert(newName);
                            t.getTableView().refresh();
                        }
                        t.getTableView().requestFocus();
                    }

                    private void showSetNameAlert(String newName) {
                        String headerTxt = String.format("Invalid device name '%s'", newName);
                        String contactTxt = String.format("'%s' device already exist", newName);
                        AJFXAlerts.showErrorAlert((Window)mOwner, (String)EditDeviceUI.DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
                    }

                    private void cpSetName(Device dev, String newName) {
                        Cp.exec((String)"%s.setName(\"%s\")", (Object[])new Object[]{CpHelper.getObjCmdStr(dev), newName});
                    }
                });
            }

            private void initTemplateCol() {
                EditorTableView.EditorTableColumn<String> col = this.addNewEditorTableColumn("Template", s -> s, d -> {
                    if (d.getDb() == null) {
                        return "<INVALID>";
                    }
                    return d.getTemplate().getName();
                });
                col.setCellValueFactory(col.newSimpleObjectFactory());
                col.setCellFactory(TextFieldTableCell.forTableColumn());
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Device, String>>(){

                    public void handle(TableColumn.CellEditEvent<Device, String> t) {
                        Device dev = (Device)t.getTableView().getItems().get(t.getTablePosition().getRow());
                        String newName = (String)t.getNewValue();
                        if (dev.getSubstrate().getDeviceTemplate(newName) == null) {
                            SwingUtilities.invokeLater(() -> {
                                this.cpSetName(dev, newName);
                                this.refreshFocusLater();
                            });
                        } else if (!dev.getTemplate().getName().equals(newName)) {
                            this.showSetNameAlert(newName);
                            t.getTableView().refresh();
                        }
                        t.getTableView().requestFocus();
                    }

                    private void showSetNameAlert(String newName) {
                        String headerTxt = String.format("Invalid device template name '%s'", newName);
                        String contactTxt = String.format("'%s' device template already exist", newName);
                        AJFXAlerts.showErrorAlert((Window)mOwner, (String)EditDeviceUI.DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
                    }

                    private void cpSetName(Device dev, String newName) {
                        Cp.exec((String)"%s.setName(\"%s\")", (Object[])new Object[]{CpHelper.getObjCmdStr(dev.getTemplate()), newName});
                    }
                });
            }

            private void initTypeCol() {
                EditorTableView.EditorTableColumn<DeviceTemplate.Type> col = this.addNewEditorTableColumn("Type", Enum::name, Device::getType);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                if (this.mInitType != null) {
                    col.setAllShow(false);
                    col.setItemShow(this.mInitType, true);
                }
                ObservableList layerTypes = FXCollections.observableArrayList((Object[])DeviceTemplate.Type.values());
                col.setCellFactory(ComboBoxTableCell.forTableColumn((ObservableList)layerTypes));
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Device, DeviceTemplate.Type>>(){

                    public void handle(TableColumn.CellEditEvent<Device, DeviceTemplate.Type> t) {
                        ObservableList selectedPins = this.getSelectedItems();
                        DeviceTemplate.Type newValue = (DeviceTemplate.Type)t.getNewValue();
                        SwingUtilities.invokeLater(() -> {
                            selectedPins.forEach(layer -> this.cpSetType((Device)layer, newValue));
                            this.refreshFocusLater();
                        });
                    }

                    private void cpSetType(Device dev, DeviceTemplate.Type newValue) {
                        Cp.exec((String)"%s.setType(%s.%s)", (Object[])new Object[]{CpHelper.getObjCmdStr(dev.getTemplate()), DeviceTemplate.Type.class.getName(), newValue});
                    }
                });
            }

            private void iniPlacementCol() {
                String colName = "Placement";
                TableColumn col = new TableColumn(colName);
                this.initXCol((TableColumn<Device, String>)col);
                this.initYCol((TableColumn<Device, String>)col);
                this.initRotateCol((TableColumn<Device, String>)col);
                this.initFlipCol((TableColumn<Device, String>)col);
                this.initMirrorCol((TableColumn<Device, String>)col);
                this.getColumns().add((Object)col);
            }

            private void initXCol(TableColumn<Device, String> parentCol) {
                EditorTableView.EditorTableColumn<Number> col = this.addNewEditorTableColumn("X", Object::toString, l -> {
                    this.mRefP.setDbObj((DbObject)l);
                    return this.mUnit.toUser(l.getLocX() + this.mRefP.getRefX());
                }, parentCol);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleDoubleFactory());
                col.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new StringConverters.DoubleNumberStringConverter()));
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Device, Number>>(){

                    public void handle(TableColumn.CellEditEvent<Device, Number> t) {
                        Number newNumber = (Number)t.getNewValue();
                        if (newNumber == null) {
                            this.showSetLocXAlert(newNumber);
                            this.refreshFocus();
                            return;
                        }
                        ObservableList selectedItems = this.getSelectedItems();
                        double newValue = newNumber.doubleValue();
                        long orbitValue = mUnit.fromUser(newValue);
                        SwingUtilities.invokeLater(() -> {
                            selectedItems.forEach(dev -> {
                                mRefP.setDbObj((DbObject)dev);
                                this.cpSetX((Device)dev, mRefP.toRefX(orbitValue));
                            });
                            this.refreshFocusLater();
                        });
                    }

                    private void showSetLocXAlert(Number newNumber) {
                        String headerTxt = String.format("Invalid device x location %s", newNumber == null ? "" : newNumber.toString());
                        String contactTxt = "X location of device should be a number.";
                        AJFXAlerts.showErrorAlert((Window)OrbitIO.getMainWindow(), (String)EditDeviceUI.DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
                    }

                    private void cpSetX(Device layer, long orbitValue) {
                        Cp.exec((String)"%s.setLocX(%dL)", (Object[])new Object[]{CpHelper.getObjCmdStr(layer), orbitValue});
                    }
                });
            }

            private void initYCol(TableColumn<Device, String> parentCol) {
                EditorTableView.EditorTableColumn<Number> col = this.addNewEditorTableColumn("Y", Object::toString, dev -> {
                    this.mRefP.setDbObj((DbObject)dev);
                    return this.mUnit.toUser(dev.getLocY() + this.mRefP.getRefY());
                }, parentCol);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleDoubleFactory());
                col.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new StringConverters.DoubleNumberStringConverter()));
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Device, Number>>(){

                    public void handle(TableColumn.CellEditEvent<Device, Number> t) {
                        Number newNumber = (Number)t.getNewValue();
                        if (newNumber == null) {
                            this.showSetLocYAlert(newNumber);
                            this.refreshFocus();
                            return;
                        }
                        ObservableList selectedItems = this.getSelectedItems();
                        double newValue = newNumber.doubleValue();
                        long orbitValue = mUnit.fromUser(newValue);
                        SwingUtilities.invokeLater(() -> {
                            selectedItems.forEach(dev -> {
                                mRefP.setDbObj((DbObject)dev);
                                this.cpSetY((Device)dev, mRefP.toRefY(orbitValue));
                            });
                            this.refreshFocusLater();
                        });
                    }

                    private void showSetLocYAlert(Number newNumber) {
                        String headerTxt = String.format("Invalid device y location %s", newNumber == null ? "" : newNumber.toString());
                        String contactTxt = "Y location of device should be a number.";
                        AJFXAlerts.showErrorAlert((Window)mOwner, (String)EditDeviceUI.DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
                    }

                    private void cpSetY(Device layer, long orbitValue) {
                        Cp.exec((String)"%s.setLocY(%dL)", (Object[])new Object[]{CpHelper.getObjCmdStr(layer), orbitValue});
                    }
                });
            }

            private void initRotateCol(TableColumn<Device, String> parentCol) {
                EditorTableView.EditorTableColumn<Number> col = this.addNewEditorTableColumn("Rotate", Object::toString, Device::getRotate, parentCol);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleFloatFactory());
                col.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new StringConverters.FloatNumberStringConverter()));
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Device, Number>>(){

                    public void handle(TableColumn.CellEditEvent<Device, Number> t) {
                        Number newNumber = (Number)t.getNewValue();
                        if (newNumber == null) {
                            this.showSetRotationAlert(newNumber);
                            this.refreshFocus();
                            return;
                        }
                        ObservableList selectedItems = this.getSelectedItems();
                        float newValue = newNumber.floatValue();
                        SwingUtilities.invokeLater(() -> {
                            selectedItems.forEach(dev -> this.cpSetRotation((Device)dev, newValue));
                            this.refreshFocusLater();
                        });
                    }

                    private void showSetRotationAlert(Number newNumber) {
                        String headerTxt = String.format("Invalid device rotation %s", newNumber == null ? "" : newNumber.toString());
                        String contactTxt = "Rotation of device should be a number.";
                        AJFXAlerts.showErrorAlert((Window)mOwner, (String)EditDeviceUI.DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
                    }

                    private void cpSetRotation(Device dev, float value) {
                        Cp.exec((String)"%s.setRotate(%fF)", (Object[])new Object[]{CpHelper.getObjCmdStr(dev), Float.valueOf(value)});
                    }
                });
            }

            private void initFlipCol(TableColumn<Device, String> parentCol) {
                EditorTableView.EditorTableColumn<Boolean> col = this.addNewEditorTableColumn("Flip", b -> b.toString(), d -> d.getFlipped(), parentCol);
                col.setSortable(false);
                col.setCellFactory(CheckBoxTableCell.forTableColumn(col));
                col.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Device, Boolean>, ObservableValue<Boolean>>(){

                    public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<Device, Boolean> param) {
                        final Device dev = (Device)param.getValue();
                        SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(dev.getFlipped());
                        booleanProp.addListener((ChangeListener)new ChangeListener<Boolean>(){

                            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                                SwingUtilities.invokeLater(() -> this.cpSetFlipped(dev, newValue));
                            }
                        });
                        return booleanProp;
                    }

                    private void cpSetFlipped(Device dev, boolean value) {
                        Cp.exec((String)"%s.setFlipped(%b)", (Object[])new Object[]{CpHelper.getObjCmdStr(dev), value});
                    }
                });
            }

            private void initMirrorCol(TableColumn<Device, String> parentCol) {
                EditorTableView.EditorTableColumn<Boolean> col = this.addNewEditorTableColumn("Mirror", b -> b.toString(), d -> d.getMirror(), parentCol);
                col.setSortable(false);
                col.setCellFactory(CheckBoxTableCell.forTableColumn(col));
                col.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Device, Boolean>, ObservableValue<Boolean>>(){

                    public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<Device, Boolean> param) {
                        final Device dev = (Device)param.getValue();
                        SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(dev.getMirror());
                        booleanProp.addListener((ChangeListener)new ChangeListener<Boolean>(){

                            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                                SwingUtilities.invokeLater(() -> this.cpSetMirror(dev, newValue));
                            }
                        });
                        return booleanProp;
                    }

                    private void cpSetMirror(Device dev, boolean value) {
                        Cp.exec((String)"%s.setMirror(%b)", (Object[])new Object[]{CpHelper.getObjCmdStr(dev), value});
                    }
                });
            }

            @Override
            protected void bindKeys() {
            }
        }

        private static class Toolbar
        extends HBox {
            private final DeviceTableView mDeviceTableView;
            private final Window mOwner;
            private final DevicePathTextBox mDevicePathTextBox;
            private final List<CheckMenuItem> mRefsMenu;

            public Toolbar(Window owner, DeviceTableView deviceTableView, DevicePathTextBox pathBox) {
                this.mDeviceTableView = deviceTableView;
                this.mOwner = owner;
                this.mDevicePathTextBox = pathBox;
                this.mRefsMenu = new ArrayList<CheckMenuItem>();
                this.initImportBtn();
                this.initExportBtn();
                this.addSeparator();
                this.initZoomToBtn();
                this.initShowMeBtn();
                this.initSelectBtn();
                this.addSeparator();
                this.initCreateBtn();
                this.initDeleteBtn();
                this.addSeparator();
                this.initReferencePointBtn();
                this.addSeparator();
                this.initInformationBtn();
                this.setAlignment(Pos.CENTER_LEFT);
                HBox rightBar = new HBox();
                rightBar.setAlignment(Pos.CENTER_RIGHT);
                HBox.setHgrow((Node)rightBar, (Priority)Priority.ALWAYS);
                this.getChildren().add((Object)rightBar);
                rightBar.getChildren().add((Object)this.mDeviceTableView.getTableFilterButton());
            }

            private void initImportBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.IMPORT, "Import CSV Devices...");
                btn.transparentBorder();
                btn.setOnAction(this.newImportAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newImportAction() {
                return e -> SwingUtilities.invokeLater(() -> {
                    DeviceCSVIn.showUI(this.mDevicePathTextBox.getDevicePath());
                    Platform.runLater(() -> {
                        this.mDeviceTableView.reloadItems();
                        this.mDeviceTableView.requestFocus();
                        this.mDeviceTableView.clearSelection();
                    });
                });
            }

            private void initExportBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.EXPORT, "Export CSV Devices...");
                btn.transparentBorder();
                btn.setOnAction(this.newExportAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newExportAction() {
                return e -> SwingUtilities.invokeLater(() -> DeviceCSVOut.showUI(this.mDevicePathTextBox.getDevicePath(), this.mDeviceTableView.mInitType));
            }

            private void initCreateBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.INSERT_ROW_ABOVE, "Create device");
                btn.transparentBorder();
                btn.setOnAction(this.newCreateAction());
                this.getChildren().add((Object)btn);
            }

            private void initDeleteBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.DELETE_ROW, "Delete device");
                btn.transparentBorder();
                btn.setOnAction(this.newDeleteAction());
                this.getChildren().add((Object)btn);
            }

            private void initZoomToBtn() {
                AJFXButton zoomToBtn = new AJFXButton(OrbitJFXImages.ZOOM_FIT, "Zoom to");
                zoomToBtn.transparentBorder();
                zoomToBtn.setOnAction(this.newZoomToAction());
                this.getChildren().add((Object)zoomToBtn);
            }

            private void initShowMeBtn() {
                AJFXButton showMeBtn = new AJFXButton(OrbitJFXImages.SHOW_ME, "Show me");
                showMeBtn.transparentBorder();
                showMeBtn.setOnAction(this.newShowMeAction());
                this.getChildren().add((Object)showMeBtn);
            }

            private void initSelectBtn() {
                AJFXButton selectBtn = new AJFXButton(OrbitJFXImages.SELECT_DEVICE, "Select");
                selectBtn.transparentBorder();
                selectBtn.setOnAction(this.newSelectAction());
                this.getChildren().add((Object)selectBtn);
            }

            private void initInformationBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.INFORMATION, "Details");
                btn.transparentBorder();
                btn.setOnAction(this.newShowDetailsAction());
                this.getChildren().add((Object)btn);
            }

            private void initReferencePointBtn() {
                AJFXMenuButton btn = new AJFXMenuButton(OrbitJFXImages.MOVE_DEVICE, "Reference Point");
                btn.transparentBorder();
                for (ReferencePoint.Reference ref : ReferencePoint.Reference.values()) {
                    if (ref == ReferencePoint.Reference.XY) continue;
                    CheckMenuItem menuItem = new CheckMenuItem(ref.getDesc());
                    menuItem.setOnAction(e -> this.setReference(ref));
                    this.addReferenceMenu(menuItem);
                    btn.getItems().add((Object)menuItem);
                }
                this.getChildren().add((Object)btn);
            }

            private void addReferenceMenu(CheckMenuItem menuItem) {
                menuItem.setSelected(menuItem.getText().equals(this.mDeviceTableView.mRefP.getRef().getDesc()));
                this.mRefsMenu.add(menuItem);
            }

            private void setReference(ReferencePoint.Reference ref) {
                this.mDeviceTableView.mRefP.setRef(ref);
                this.mRefsMenu.forEach(m -> m.setSelected(m.getText().equals(ref.getDesc())));
                this.mDeviceTableView.reloadItems();
            }

            private EventHandler<javafx.event.ActionEvent> newCreateAction() {
                return e -> {
                    DevicePath devPath = this.mDevicePathTextBox.getDevicePath();
                    if (devPath == null) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        TemplateUI templateUI = new TemplateUI(this.mOwner, "device");
                        templateUI.setParentDevPath(devPath);
                        templateUI.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent e) {
                                Platform.runLater(mDeviceTableView::reloadItems);
                            }
                        });
                    });
                };
            }

            private EventHandler<javafx.event.ActionEvent> newDeleteAction() {
                return e -> {
                    DevicePath devPath = this.mDevicePathTextBox.getDevicePath();
                    ObservableList items = this.mDeviceTableView.getSelectedItems();
                    if (devPath == null || items == null || items.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        int count = items.size();
                        CpHelper.cpClearSelection();
                        CpHelper.cpSelect(items);
                        Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.DoDevice.Start();", (Object[])new Object[0]);
                        Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.deleteSelected();", (Object[])new Object[0]);
                        Cp.exec((String)"unset(\"_curSelection\")", (Object[])new Object[0]);
                        ALog.logInfo((String)"Delete %d device complete.", (Object[])new Object[]{count});
                        Platform.runLater(this.mDeviceTableView::reloadItems);
                    });
                };
            }

            private EventHandler<javafx.event.ActionEvent> newZoomToAction() {
                return e -> {
                    DevicePath devPath = this.mDevicePathTextBox.getDevicePath();
                    Device dev = (Device)this.mDeviceTableView.getSelectedItem();
                    if (devPath == null || dev == null) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.zoomTo(devPath, dev));
                };
            }

            private EventHandler<javafx.event.ActionEvent> newShowMeAction() {
                return e -> {
                    DevicePath devPath = this.mDevicePathTextBox.getDevicePath();
                    ObservableList devs = this.mDeviceTableView.getSelectedItems();
                    if (devPath == null || devs == null || devs.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.showMe(devPath, (List<Device>)devs));
                };
            }

            private EventHandler<javafx.event.ActionEvent> newSelectAction() {
                return e -> {
                    DevicePath devPath = this.mDevicePathTextBox.getDevicePath();
                    ObservableList devs = this.mDeviceTableView.getSelectedItems();
                    if (devPath == null || devs == null || devs.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.select(devPath, (List<Device>)devs));
                };
            }

            private EventHandler<javafx.event.ActionEvent> newShowDetailsAction() {
                return e -> {
                    Optional result;
                    ObservableList items = this.mDeviceTableView.getSelectedItems();
                    if (items == null || items.isEmpty()) {
                        return;
                    }
                    int itemCount = items.size();
                    if (itemCount > 10 && ((result = SlowOperationAlert.showLargeNumUIAlert((Window)this.mOwner, (int)itemCount)).isEmpty() || result.get() != ButtonType.OK)) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        for (Device net : items) {
                            DbObjectDetailsUI.show(this.mOwner, (DbObject)net, this.mDevicePathTextBox.getDevicePath(), OrbitIO.getCurView());
                        }
                    });
                };
            }

            private void zoomTo(DevicePath devPath, Device dev) {
                ARect bounds = dev.getBounds().transform(devPath.getAFullPath().getTransform()).getBounds();
                if (bounds == null) {
                    return;
                }
                this.zoomToArea(bounds);
            }

            private void zoomToArea(ARect bounds) {
                DesignView2D v = (DesignView2D)OrbitIO.getCurView();
                bounds.changeSizeBy(0.1);
                v.getCanvas().getXForm().setWorld(bounds);
                v.getCanvas().refresh();
                OrbitIO.getApp().refreshCurrentView(false);
            }

            private void showMe(DevicePath devPath, List<Device> devs) {
                for (Device dev : devs) {
                    this.showMe(devPath, dev);
                }
            }

            private void showMe(DevicePath devPath, Device dev) {
                ShowMeTheWay.addDevicePath(new DevicePath(devPath, dev));
            }

            private void select(DevicePath devPath, List<Device> devs) {
                for (Device dev : devs) {
                    this.select(devPath, dev);
                }
            }

            private void select(DevicePath devPath, Device dev) {
                Selection curSelection = Selection.getCurrentSelectionForDb((Db)this.mDevicePathTextBox.getDevicePath().getDb());
                devPath.getAllFullPaths().filter(path -> !curSelection.contains(path, (DbObject)dev)).forEach(path -> curSelection.add(path, (DbObject)dev));
            }

            private void addSeparator() {
                this.getChildren().add((Object)Separators.newToolbarSeparator());
            }
        }
    }

    public static class EditDevicePanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 600;
        private static final int PANEL_HEIGHT = 530;
        private final DeviceTableBodyPanel mDeviceTableBodyPanel;

        public EditDevicePanel(Window owner, Unit unit, DevicePath path, DeviceTemplate.Type type) {
            this.mDeviceTableBodyPanel = new DeviceTableBodyPanel(owner, unit, path, type);
            this.setPreferredSize(new Dimension(600, 530));
        }

        protected Parent initSceneGraph() {
            VBox root = (VBox)this.mDeviceTableBodyPanel.initSceneGraph();
            CloseHBox closeBox = new CloseHBox(this.mDeviceTableBodyPanel.mOwner);
            root.getChildren().add((Object)closeBox);
            return root;
        }
    }
}

