/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.table_editor;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerMaterialTable;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.jfxui.AJFXAlerts;
import com.sigrity.acl.jfxui.AJFXButton;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXFileChooser;
import com.sigrity.acl.jfxui.AJFXKeyCombination;
import com.sigrity.acl.jfxui.AJFXMenuButton;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.CloseHBox;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.jfxui.EditorTableView;
import com.sigrity.orbit.jfxui.OrbitJFXImages;
import com.sigrity.orbit.jfxui.SubstrateChooser;
import com.sigrity.orbit.ui.CreateSubstrateUI;
import com.sigrity.orbit.ui.LefDefUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import javafx.util.converter.NumberStringConverter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class EditLayerUI
extends AJFXDesignDialog {
    private static final String ACTION_TITLE = "Layers Table";
    private static final String DIALOG_TITLE = "Layer Table Editor";
    private static final String DEFAULT_LAYER_BASE_NAME = "LAYER";
    private static final Layer.LayerType DEFAULT_LAYER_TYPE = Layer.LayerType.Signal;
    private static final double DEFAULT_LAYER_THICKNESS = 1.0;
    private static final String MOVE_LAYER_DRAG_ENTER_STYLE = "-fx-border-color: green transparent transparent transparent; -fx-border-width: 2px;";
    private static final String MOVE_LAYER_BOT_DRAG_ENTER_STYLE = "-fx-border-color: transparent transparent green transparent; -fx-border-width: 2px;";
    private Unit mUnit;
    private Substrate mInitSubstrate;

    public static Action getAction() {
        return EditLayerUI.getAction(null);
    }

    public static Action getAction(final Substrate initSubstrate) {
        return new AbstractAction(ACTION_TITLE, OrbitIcons.TABLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditLayerUI.createDialog(OrbitIO.getMainWindow(), OrbitIO.getCurDb(), initSubstrate);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static EditLayerUI createDialog(Window owner, Db db) {
        return EditLayerUI.createDialog(owner, db, null);
    }

    public static EditLayerUI createDialog(Window owner, Db db, Substrate initSubstrate) {
        if (db == null) {
            ALog.logError((String)"No design is open.");
            return null;
        }
        Cp.exec((String)"Substrate.validateAllSubstrates(curDb())", (Object[])new Object[0]);
        EditLayerUI dlg = new EditLayerUI(owner, db, initSubstrate);
        dlg.setVisible(true);
        return dlg;
    }

    private EditLayerUI(Window owner, Db db, Substrate initSubstrate) {
        super(db, owner, DIALOG_TITLE);
        this.mUnit = Design.getUnit((Db)db);
        this.mInitSubstrate = initSubstrate;
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new EditLayerPanel();
    }

    private class EditLayerPanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 600;
        private static final int PANEL_HEIGHT = 530;
        private SubstrateBox mSubstrateBox;
        private Toolbar mToolbar;
        private LayerTableView mLayerTableView;

        public EditLayerPanel() {
            this.setPreferredSize(new Dimension(600, 530));
        }

        protected Parent initSceneGraph() {
            this.checkSubstrateExist();
            VBox pane = new VBox(5.0);
            this.mSubstrateBox = new SubstrateBox();
            VBox.setVgrow((Node)this.mSubstrateBox, (Priority)Priority.NEVER);
            pane.getChildren().add((Object)this.mSubstrateBox);
            this.mToolbar = new Toolbar();
            VBox.setVgrow((Node)this.mToolbar, (Priority)Priority.NEVER);
            pane.getChildren().add((Object)this.mToolbar);
            this.mLayerTableView = new LayerTableView();
            VBox.setVgrow((Node)this.mLayerTableView, (Priority)Priority.ALWAYS);
            pane.getChildren().add((Object)this.mLayerTableView);
            CloseHBox closeHBox = new CloseHBox((Window)((Object)EditLayerUI.this));
            pane.getChildren().add((Object)closeHBox);
            this.mSubstrateBox.setRefreshAction((EventHandler<javafx.event.ActionEvent>)((EventHandler)e -> {
                this.mSubstrateBox.refreshBtnDisable();
                this.mToolbar.refreshBtnDisable();
                this.mLayerTableView.reloadItems();
            }));
            this.mToolbar.addInLeftBar((Node)this.mLayerTableView.getTableFilterButton());
            return pane;
        }

        private Substrate getSelectedSubstrate() {
            return this.mSubstrateBox.getSelectedSubstrate();
        }

        private void checkSubstrateExist() {
            if (!Substrate.getSubstrates((Db)EditLayerUI.this.mDb).hasNext()) {
                this.showInfoDlg();
                this.showCreateSubstrateUI();
            }
        }

        private void showInfoDlg() {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle(EditLayerUI.DIALOG_TITLE);
            alert.setHeaderText("No substrate in current design");
            alert.setContentText("Create a new substrate");
            alert.showAndWait();
        }

        private void showCreateSubstrateUI() {
            SwingUtilities.invokeLater(() -> {
                CreateSubstrateUI.CreateSubstrateDialog dlg = CreateSubstrateUI.showMe(EditLayerUI.this.getDb(), (Window)((Object)EditLayerUI.this));
                dlg.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        Platform.runLater(() -> {
                            EditLayerPanel.this.mSubstrateBox.reload();
                            EditLayerPanel.this.mToolbar.refreshBtnDisable();
                            EditLayerPanel.this.mLayerTableView.reloadItems();
                        });
                    }
                });
            });
        }

        private AJFXButton newIconBtn(Image image, String title) {
            AJFXButton btn = new AJFXButton(image, title);
            btn.transparentBorder();
            return btn;
        }

        private AJFXMenuButton newIconMenuBtn(Image image, String title) {
            AJFXMenuButton btn = new AJFXMenuButton(image, title);
            btn.transparentBorder();
            return btn;
        }

        private Separator newSeparator() {
            Separator separator = new Separator();
            separator.setOrientation(Orientation.VERTICAL);
            separator.setMaxHeight(20.0);
            return separator;
        }

        private class LayerTableView
        extends EditorTableView<Layer> {
            private TableColumn<Layer, String> mGdsCol;
            private TableColumn<Layer, String> mLayerNumCol;
            private TableColumn<Layer, String> mLayerTypeCol;
            private TableColumn<Layer, String> mTextNumCol;
            private TableColumn<Layer, String> mTextTypeCol;
            private TableColumn<Layer, String> mTextUseCol;
            private TableColumn<Layer, String> mMaterialGroupCol;
            private List<Layer> mSnapshotLayers = new LinkedList<Layer>();
            private TableRow<Layer> mLastRow;

            public LayerTableView() {
                this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
                this.getSelectionModel().setCellSelectionEnabled(true);
                this.setEditable(true);
                this.setSortedComparator(Layer.TopFirstSort);
            }

            public void setGDSColVisible(boolean b) {
                this.mGdsCol.setVisible(b);
            }

            public void setMaterialColVisible(boolean b) {
                this.mMaterialGroupCol.setVisible(b);
            }

            @Override
            public void reloadItems() {
                super.reloadItems();
                this.markLastRow();
            }

            @Override
            protected List<Layer> getItemList() {
                Substrate selectedSubstrate = EditLayerPanel.this.getSelectedSubstrate();
                if (selectedSubstrate == null) {
                    return Collections.emptyList();
                }
                return AUtil.arrayList((Iterator)selectedSubstrate.getLayers());
            }

            @Override
            protected void initHeader() {
                this.initOrderCol();
                this.initNameCol();
                this.initTypeCol();
                this.initThicknessCol();
                this.initMaterialGroupCol();
                this.initGDSCol();
            }

            protected void initOrderCol() {
                this.addNewRowNumCol(item -> Integer.toString(item.getOrder()));
            }

            protected void initNameCol() {
                EditorTableView.EditorTableColumn<String> col = this.addNewEditorTableColumn("Name", name -> name, Layer::getName);
                col.setCellValueFactory(col.newReadOnlyStringFactory());
                col.setCellFactory(c -> this.getNameColCellFactory());
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Layer, String>>(){

                    public void handle(TableColumn.CellEditEvent<Layer, String> t) {
                        Layer layer = (Layer)t.getTableView().getItems().get(t.getTablePosition().getRow());
                        String newName = (String)t.getNewValue();
                        if (EditLayerPanel.this.getSelectedSubstrate().getLayer(newName) == null) {
                            SwingUtilities.invokeLater(() -> this.cpSetLayerName(layer, newName));
                        } else if (!layer.getName().equals(newName)) {
                            this.showSetNameAlert(newName);
                            t.getTableView().refresh();
                        }
                        t.getTableView().requestFocus();
                    }

                    private void showSetNameAlert(String newName) {
                        String headerTxt = String.format("Invalid layer name '%s'", newName);
                        String contactTxt = String.format("'%s' layer already exist", newName);
                        AJFXAlerts.showErrorAlert((Window)((Object)EditLayerUI.this), (String)EditLayerUI.DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
                    }

                    private void cpSetLayerName(Layer layer, String newName) {
                        Cp.exec((String)"%s.setName(\"%s\")", (Object[])new Object[]{CpHelper.getObjCmdStr(layer), newName});
                    }
                });
            }

            private TableCell<Layer, String> getNameColCellFactory() {
                TextFieldTableCell cell = new TextFieldTableCell((StringConverter)new DefaultStringConverter());
                cell.setOnDragDetected(this.getDragDetectedHandler((TableCell<Layer, String>)cell));
                cell.setOnDragEntered(this.getDragEnteredHandler((TableCell<Layer, String>)cell));
                cell.setOnDragExited(this.getDragExitedHandler((TableCell<Layer, String>)cell));
                cell.setOnDragOver(this.getDragOverHandler());
                cell.setOnDragDropped(this.getDragDroppedHandler((TableCell<Layer, String>)cell));
                return cell;
            }

            private EventHandler<MouseEvent> getDragDetectedHandler(TableCell<Layer, String> cell) {
                return event -> {
                    if (!cell.isEmpty()) {
                        this.mSnapshotLayers.clear();
                        this.mSnapshotLayers = AUtil.arrayList(this.getSelectedItems());
                        Dragboard db = this.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
                        ClipboardContent content = new ClipboardContent();
                        content.putString("MoveLayer");
                        db.setContent((Map)content);
                    }
                    event.consume();
                };
            }

            private EventHandler<DragEvent> getDragEnteredHandler(TableCell<Layer, String> cell) {
                return event -> {
                    if (cell.isEmpty()) {
                        this.mLastRow.setStyle(EditLayerUI.MOVE_LAYER_BOT_DRAG_ENTER_STYLE);
                    } else {
                        cell.getTableRow().setStyle(EditLayerUI.MOVE_LAYER_DRAG_ENTER_STYLE);
                    }
                };
            }

            private EventHandler<DragEvent> getDragExitedHandler(TableCell<Layer, String> cell) {
                return event -> {
                    if (cell.isEmpty()) {
                        this.mLastRow.setStyle(this.getStyle());
                    } else {
                        cell.getTableRow().setStyle(this.getStyle());
                    }
                };
            }

            private EventHandler<DragEvent> getDragOverHandler() {
                return event -> {
                    Dragboard db = event.getDragboard();
                    if (db.hasString()) {
                        event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                    }
                    event.consume();
                };
            }

            private EventHandler<DragEvent> getDragDroppedHandler(TableCell<Layer, String> cell) {
                return event -> {
                    Collections.sort(this.mSnapshotLayers, Layer.TopFirstSort);
                    ObservableList layers = this.getItems();
                    int index = cell.getTableRow().getIndex();
                    int toOrder = index >= layers.size() ? 0 : ((Layer)layers.get(index)).getOrder() + 1;
                    SwingUtilities.invokeLater(() -> this.lambda$getDragDroppedHandler$9(toOrder, (List)layers));
                    event.setDropCompleted(true);
                    event.consume();
                };
            }

            private void moveLayers(int toOrder) {
                try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)EditLayerUI.this.getDb(), (String)"Move Layers");){
                    this.mSnapshotLayers.forEach(layer -> Cp.exec((String)"%s.insertAtOrder(%d)", (Object[])new Object[]{CpHelper.getObjCmdStr(layer), toOrder}));
                    Cp.exec((String)"%s.validateLayerOrder()", (Object[])new Object[]{CpHelper.getObjCmdStr(EditLayerPanel.this.getSelectedSubstrate())});
                }
            }

            protected void initTypeCol() {
                final EditorTableView.EditorTableColumn<Layer.LayerType> col = this.addNewEditorTableColumn("Type", Enum::name, Layer::getType);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                ObservableList layerTypes = FXCollections.observableArrayList((Object[])Layer.LayerType.values());
                col.setCellFactory(ComboBoxTableCell.forTableColumn((ObservableList)layerTypes));
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Layer, Layer.LayerType>>(){

                    public void handle(TableColumn.CellEditEvent<Layer, Layer.LayerType> t) {
                        List<Layer> selectedLayers = LayerTableView.this.getSelectedLayers(col);
                        Layer.LayerType newType = (Layer.LayerType)t.getNewValue();
                        SwingUtilities.invokeLater(() -> {
                            selectedLayers.forEach(layer -> this.cpSetLayerType((Layer)layer, newType));
                            LayerTableView.this.refreshFocusLater();
                        });
                    }

                    private void cpSetLayerType(Layer layer, Layer.LayerType newValue) {
                        Cp.exec((String)"%s.setType(%s.%s)", (Object[])new Object[]{CpHelper.getObjCmdStr(layer), Layer.LayerType.class.getName(), newValue});
                    }
                });
            }

            protected void initThicknessCol() {
                final EditorTableView.EditorTableColumn<Number> col = this.addNewEditorTableColumn("Thickness", Object::toString, l -> EditLayerUI.this.mUnit.toUser(l.getHeight()));
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleDoubleFactory());
                col.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new NumberStringConverter()));
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Layer, Number>>(){

                    public void handle(TableColumn.CellEditEvent<Layer, Number> t) {
                        Number newNumber = (Number)t.getNewValue();
                        if (newNumber == null || newNumber.doubleValue() < 0.0) {
                            this.showSetThicknessAlert(newNumber);
                            LayerTableView.this.refreshFocus();
                            return;
                        }
                        List<Layer> selectedLayers = LayerTableView.this.getSelectedLayers(col);
                        double newValue = newNumber.doubleValue();
                        long orbitValue = EditLayerUI.this.mUnit.fromUser(newValue);
                        SwingUtilities.invokeLater(() -> {
                            selectedLayers.forEach(layer -> this.cpSetLayerThickness((Layer)layer, orbitValue));
                            LayerTableView.this.refreshFocusLater();
                        });
                    }

                    private void showSetThicknessAlert(Number newNumber) {
                        String headerTxt = String.format("Invalid layer thickness %s", newNumber == null ? "" : newNumber.toString());
                        String contactTxt = "Thickness of layer should be equal or larger than 0.";
                        AJFXAlerts.showErrorAlert((Window)((Object)EditLayerUI.this), (String)EditLayerUI.DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
                    }

                    private void cpSetLayerThickness(Layer layer, long orbitValue) {
                        Cp.exec((String)"%s.setHeight(%dL)", (Object[])new Object[]{CpHelper.getObjCmdStr(layer), orbitValue});
                    }
                });
            }

            private void initMaterialGroupCol() {
                String materialGroupColName = "Layer Material";
                this.mMaterialGroupCol = new TableColumn(materialGroupColName);
                TableColumn<Layer, String> materialCol = this.initMaterialCol();
                this.mMaterialGroupCol.getColumns().add(materialCol);
                TableColumn<Layer, String> conductivityCol = this.initConductivityCol();
                this.mMaterialGroupCol.getColumns().add(conductivityCol);
                TableColumn<Layer, String> dielConstCol = this.initDielConstCol();
                this.mMaterialGroupCol.getColumns().add(dielConstCol);
                TableColumn<Layer, String> lossTangentCol = this.initLossTangentCol();
                this.mMaterialGroupCol.getColumns().add(lossTangentCol);
                this.getColumns().add(this.mMaterialGroupCol);
                this.setMaterialColVisible(false);
                this.getTableFilterButton().addFilterCheckBox(materialGroupColName, this.mMaterialGroupCol);
            }

            private TableColumn<Layer, String> initMaterialCol() {
                TableColumn col = new TableColumn("Material");
                col.setSortable(false);
                col.setCellValueFactory(param -> new SimpleStringProperty(((Layer)param.getValue()).getMaterial()));
                ObservableList allMat = FXCollections.observableArrayList((Collection)LayerMaterialTable.getAllMaterial());
                col.setCellFactory(ComboBoxTableCell.forTableColumn((ObservableList)allMat));
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Layer, String>>(){

                    public void handle(TableColumn.CellEditEvent<Layer, String> t) {
                        Layer layer = (Layer)t.getTableView().getItems().get(t.getTablePosition().getRow());
                        String newMat = (String)t.getNewValue();
                        SwingUtilities.invokeLater(() -> {
                            this.cpSetLayerMaterial(layer, newMat);
                            LayerTableView.this.refreshFocusLater();
                        });
                    }

                    private void cpSetLayerMaterial(Layer layer, String newMat) {
                        Cp.exec((String)"%s.setMaterial(\"%s\")", (Object[])new Object[]{CpHelper.getObjCmdStr(layer), newMat});
                    }
                });
                return col;
            }

            private TableColumn<Layer, String> initConductivityCol() {
                TableColumn col = new TableColumn("Conductivity\n(mho/m)");
                col.setSortable(false);
                col.setCellValueFactory(param -> new SimpleStringProperty(((Layer)param.getValue()).getConductivity()));
                col.setCellFactory(c -> this.getNameColCellFactory());
                col.setEditable(false);
                return col;
            }

            private TableColumn<Layer, String> initDielConstCol() {
                TableColumn col = new TableColumn("Dielectric\nConstant");
                col.setSortable(false);
                col.setCellValueFactory(param -> new SimpleStringProperty(((Layer)param.getValue()).getDielConst()));
                col.setCellFactory(c -> this.getNameColCellFactory());
                col.setEditable(false);
                return col;
            }

            private TableColumn<Layer, String> initLossTangentCol() {
                TableColumn col = new TableColumn("Loss Tangent");
                col.setSortable(false);
                col.setCellValueFactory(param -> new SimpleStringProperty(((Layer)param.getValue()).getLossTangent()));
                col.setCellFactory(c -> this.getNameColCellFactory());
                col.setEditable(false);
                return col;
            }

            private void initGDSCol() {
                String gdsColName = "GDS Layer Map";
                this.mGdsCol = new TableColumn(gdsColName);
                this.mLayerNumCol = this.initLayerNumCol();
                this.mGdsCol.getColumns().add(this.mLayerNumCol);
                this.mLayerTypeCol = this.initLayerTypeCol();
                this.mGdsCol.getColumns().add(this.mLayerTypeCol);
                this.mTextNumCol = this.initTextNumCol();
                this.mGdsCol.getColumns().add(this.mTextNumCol);
                this.mTextTypeCol = this.initTextTypeCol();
                this.mGdsCol.getColumns().add(this.mTextTypeCol);
                this.mTextUseCol = this.initTextUseCol();
                this.mGdsCol.getColumns().add(this.mTextUseCol);
                this.getColumns().add(this.mGdsCol);
                this.setGDSColVisible(false);
                this.getTableFilterButton().addFilterCheckBox(gdsColName, this.mGdsCol);
            }

            private TableColumn<Layer, String> initLayerNumCol() {
                final TableColumn layerNumCol = new TableColumn("Layer\nNumber");
                layerNumCol.setSortable(false);
                layerNumCol.setCellValueFactory(param -> {
                    Integer layerNumber = ((Layer)param.getValue()).getGDSLayerNumber();
                    return new SimpleStringProperty(layerNumber == null ? "" : layerNumber.toString());
                });
                layerNumCol.setCellFactory(TextFieldTableCell.forTableColumn());
                layerNumCol.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Layer, String>>(){

                    public void handle(TableColumn.CellEditEvent<Layer, String> t) {
                        List<Layer> selectedLayers = LayerTableView.this.getSelectedLayers(layerNumCol);
                        String newValue = (String)t.getNewValue();
                        try {
                            int newIntValue = Integer.parseInt(newValue);
                            this.setLayerNumber(selectedLayers, newIntValue);
                        }
                        catch (NumberFormatException e) {
                            if (newValue.isEmpty()) {
                                this.clearLayerNumber(selectedLayers);
                            }
                            this.showSetLayerNumberAlert(newValue);
                            LayerTableView.this.refreshFocus();
                        }
                    }

                    private void clearLayerNumber(List<Layer> selectedLayers) {
                        SwingUtilities.invokeLater(() -> {
                            selectedLayers.forEach(x$0 -> LayerTableView.this.cpClearLayerNumber((Layer)x$0));
                            LayerTableView.this.refreshFocusLater();
                        });
                    }

                    private void setLayerNumber(List<Layer> selectedLayers, int newIntValue) {
                        SwingUtilities.invokeLater(() -> {
                            selectedLayers.forEach(layer -> this.cpSetLayerNumber((Layer)layer, newIntValue));
                            LayerTableView.this.refreshFocusLater();
                        });
                    }

                    private void showSetLayerNumberAlert(String newValue) {
                        String headerTxt = String.format("Invalid layer number '%s'", newValue);
                        String contactTxt = "Layer number should be an integer";
                        AJFXAlerts.showErrorAlert((Window)((Object)EditLayerUI.this), (String)EditLayerUI.DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
                    }

                    private void cpSetLayerNumber(Layer layer, int newValue) {
                        Cp.exec((String)"%s.setGDSLayerNumber(%d)", (Object[])new Object[]{CpHelper.getObjCmdStr(layer), newValue});
                    }
                });
                return layerNumCol;
            }

            private TableColumn<Layer, String> initLayerTypeCol() {
                final TableColumn layerTypeCol = new TableColumn("Layer\nType");
                layerTypeCol.setSortable(false);
                layerTypeCol.setCellValueFactory(param -> {
                    Integer layerType = ((Layer)param.getValue()).getGDSLayerType();
                    return new SimpleStringProperty(layerType == null ? "" : layerType.toString());
                });
                layerTypeCol.setCellFactory(TextFieldTableCell.forTableColumn());
                layerTypeCol.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Layer, String>>(){

                    public void handle(TableColumn.CellEditEvent<Layer, String> t) {
                        List<Layer> selectedLayers = LayerTableView.this.getSelectedLayers(layerTypeCol);
                        String newValue = (String)t.getNewValue();
                        try {
                            int newIntValue = Integer.parseInt(newValue);
                            this.setLayerType(selectedLayers, newIntValue);
                        }
                        catch (NumberFormatException e) {
                            if (newValue.isEmpty()) {
                                this.clearLayerType(selectedLayers);
                            }
                            this.showSetLayerTypeAlert(newValue);
                            LayerTableView.this.refreshFocus();
                        }
                    }

                    private void clearLayerType(List<Layer> selectedLayers) {
                        SwingUtilities.invokeLater(() -> {
                            selectedLayers.forEach(x$0 -> LayerTableView.this.cpClearLayerType((Layer)x$0));
                            LayerTableView.this.refreshFocusLater();
                        });
                    }

                    private void setLayerType(List<Layer> selectedLayers, int newIntValue) {
                        SwingUtilities.invokeLater(() -> {
                            selectedLayers.forEach(layer -> this.cpSetLayerType((Layer)layer, newIntValue));
                            LayerTableView.this.refreshFocusLater();
                        });
                    }

                    private void showSetLayerTypeAlert(String newValue) {
                        String headerTxt = String.format("Invalid layer type '%s'", newValue);
                        String contactTxt = "Layer type should be an integer";
                        AJFXAlerts.showErrorAlert((Window)((Object)EditLayerUI.this), (String)EditLayerUI.DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
                    }

                    private void cpSetLayerType(Layer layer, int newValue) {
                        Cp.exec((String)"%s.setGDSLayerType(%d)", (Object[])new Object[]{CpHelper.getObjCmdStr(layer), newValue});
                    }
                });
                return layerTypeCol;
            }

            private TableColumn<Layer, String> initTextNumCol() {
                final TableColumn textNumCol = new TableColumn("Text\nNumber");
                textNumCol.setSortable(false);
                textNumCol.setCellValueFactory(param -> {
                    Integer num = ((Layer)param.getValue()).getGDSTextNumber();
                    return new SimpleStringProperty(num == null ? "" : num.toString());
                });
                textNumCol.setCellFactory(TextFieldTableCell.forTableColumn());
                textNumCol.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Layer, String>>(){

                    public void handle(TableColumn.CellEditEvent<Layer, String> t) {
                        List<Layer> selectedLayers = LayerTableView.this.getSelectedLayers(textNumCol);
                        String newValue = (String)t.getNewValue();
                        try {
                            int newIntValue = Integer.parseInt(newValue);
                            this.setTextNumber(selectedLayers, newIntValue);
                        }
                        catch (NumberFormatException e) {
                            if (newValue.isEmpty()) {
                                this.clearTextNumber(selectedLayers);
                            }
                            this.showSetTextNumberAlert(newValue);
                            LayerTableView.this.refreshFocus();
                        }
                    }

                    private void clearTextNumber(List<Layer> selectedLayers) {
                        SwingUtilities.invokeLater(() -> {
                            selectedLayers.forEach(x$0 -> LayerTableView.this.cpClearTextNumber((Layer)x$0));
                            LayerTableView.this.refreshFocusLater();
                        });
                    }

                    private void setTextNumber(List<Layer> selectedLayers, int newIntValue) {
                        SwingUtilities.invokeLater(() -> {
                            selectedLayers.forEach(layer -> this.cpSetTextNumber((Layer)layer, newIntValue));
                            LayerTableView.this.refreshFocusLater();
                        });
                    }

                    private void showSetTextNumberAlert(String newValue) {
                        String headerTxt = String.format("Invalid text number '%s'", newValue);
                        String contactTxt = "Text number should be an integer";
                        AJFXAlerts.showErrorAlert((Window)((Object)EditLayerUI.this), (String)EditLayerUI.DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
                    }

                    private void cpSetTextNumber(Layer layer, int newValue) {
                        Cp.exec((String)"%s.setGDSTextNumber(%d)", (Object[])new Object[]{CpHelper.getObjCmdStr(layer), newValue});
                    }
                });
                return textNumCol;
            }

            private TableColumn<Layer, String> initTextTypeCol() {
                final TableColumn textTypeCol = new TableColumn("Text\nType");
                textTypeCol.setSortable(false);
                textTypeCol.setCellValueFactory(param -> {
                    Integer type = ((Layer)param.getValue()).getGDSTextType();
                    return new SimpleStringProperty(type == null ? "" : type.toString());
                });
                textTypeCol.setCellFactory(TextFieldTableCell.forTableColumn());
                textTypeCol.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Layer, String>>(){

                    public void handle(TableColumn.CellEditEvent<Layer, String> t) {
                        List<Layer> selectedLayers = LayerTableView.this.getSelectedLayers(textTypeCol);
                        String newValue = (String)t.getNewValue();
                        try {
                            int newIntValue = Integer.parseInt(newValue);
                            this.setTextType(selectedLayers, newIntValue);
                        }
                        catch (NumberFormatException e) {
                            if (newValue.isEmpty()) {
                                this.clearTextType(selectedLayers);
                            }
                            this.showSetTextTypeAlert(newValue);
                            LayerTableView.this.refreshFocus();
                        }
                    }

                    private void clearTextType(List<Layer> selectedLayers) {
                        SwingUtilities.invokeLater(() -> {
                            selectedLayers.forEach(x$0 -> LayerTableView.this.cpClearTextType((Layer)x$0));
                            LayerTableView.this.refreshFocusLater();
                        });
                    }

                    private void setTextType(List<Layer> selectedLayers, int newIntValue) {
                        SwingUtilities.invokeLater(() -> {
                            selectedLayers.forEach(layer -> this.cpSetTextType((Layer)layer, newIntValue));
                            LayerTableView.this.refreshFocusLater();
                        });
                    }

                    private void showSetTextTypeAlert(String newValue) {
                        String headerTxt = String.format("Invalid text type '%s'", newValue);
                        String contactTxt = "Text type should be an integer";
                        AJFXAlerts.showErrorAlert((Window)((Object)EditLayerUI.this), (String)EditLayerUI.DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
                    }

                    private void cpSetTextType(Layer layer, int newValue) {
                        Cp.exec((String)"%s.setGDSTextType(%d)", (Object[])new Object[]{CpHelper.getObjCmdStr(layer), newValue});
                    }
                });
                return textTypeCol;
            }

            private TableColumn<Layer, String> initTextUseCol() {
                final TableColumn textUseCol = new TableColumn("Text\nUse");
                textUseCol.setSortable(false);
                textUseCol.setCellValueFactory(param -> {
                    String use = ((Layer)param.getValue()).getGDSTextUse();
                    return new SimpleStringProperty(use == null ? "" : use);
                });
                textUseCol.setCellFactory(TextFieldTableCell.forTableColumn());
                textUseCol.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Layer, String>>(){

                    public void handle(TableColumn.CellEditEvent<Layer, String> t) {
                        String newValue = (String)t.getNewValue();
                        List<Layer> selectedLayers = LayerTableView.this.getSelectedLayers(textUseCol);
                        if (newValue.isEmpty()) {
                            this.clearTextUse(selectedLayers);
                        } else {
                            this.setTextUse(selectedLayers, newValue);
                        }
                    }

                    protected void setTextUse(List<Layer> selectedLayers, String newValue) {
                        SwingUtilities.invokeLater(() -> {
                            selectedLayers.forEach(layer -> this.cpSetTextUse((Layer)layer, newValue));
                            LayerTableView.this.refreshFocusLater();
                        });
                    }

                    private void clearTextUse(List<Layer> selectedLayers) {
                        SwingUtilities.invokeLater(() -> {
                            selectedLayers.forEach(x$0 -> LayerTableView.this.cpClearTextUse((Layer)x$0));
                            LayerTableView.this.refreshFocusLater();
                        });
                    }

                    private void cpSetTextUse(Layer layer, String newValue) {
                        Cp.exec((String)"%s.setGDSTextUse(\"%s\")", (Object[])new Object[]{CpHelper.getObjCmdStr(layer), newValue});
                    }
                });
                return textUseCol;
            }

            private void markLastRow() {
                this.setRowFactory(tv -> new TableRow<Layer>(){

                    public void updateIndex(int index) {
                        super.updateIndex(index);
                        Substrate selectedSubstrate = EditLayerPanel.this.getSelectedSubstrate();
                        if (selectedSubstrate != null && index == selectedSubstrate.getLayerCount() - 1) {
                            LayerTableView.this.mLastRow = this;
                        }
                    }
                });
            }

            private List<Layer> getSelectedLayers(TableColumn<Layer, ?> col) {
                return this.getSelectionModel().getSelectedCells().stream().filter(cell -> cell.getTableColumn() == col).map(cell -> (Layer)this.getItems().get(cell.getRow())).collect(Collectors.toList());
            }

            @Override
            protected void bindKeys() {
                this.setOnKeyPressed(e -> {
                    if (e.getCode() == KeyCode.DELETE) {
                        this.bindDeleteKey();
                    } else if (AJFXKeyCombination.UNDO.match(e)) {
                        this.bindUndoKey();
                    }
                });
            }

            private void bindDeleteKey() {
                ArrayList cells = AUtil.arrayList((Collection)this.getSelectionModel().getSelectedCells().filtered(cell -> cell.getTableColumn().getParentColumn() == this.mGdsCol));
                SwingUtilities.invokeLater(() -> {
                    cells.forEach(this::clearCell);
                    this.refreshFocusLater();
                });
            }

            private void bindUndoKey() {
                if (!EditLayerUI.this.getDb().getHistory().canUndo()) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    Cp.exec((String)"curDb().getHistory().undo();", (Object[])new Object[0]);
                    Platform.runLater(() -> {
                        this.reloadItems();
                        this.refreshFocus();
                    });
                });
            }

            protected void clearCell(TablePosition cell) {
                Layer layer = (Layer)cell.getTableView().getItems().get(cell.getRow());
                if (cell.getTableColumn() == this.mLayerNumCol) {
                    this.cpClearLayerNumber(layer);
                } else if (cell.getTableColumn() == this.mLayerTypeCol) {
                    this.cpClearLayerType(layer);
                } else if (cell.getTableColumn() == this.mTextNumCol) {
                    this.cpClearTextNumber(layer);
                } else if (cell.getTableColumn() == this.mTextTypeCol) {
                    this.cpClearTextType(layer);
                } else if (cell.getTableColumn() == this.mTextUseCol) {
                    this.cpClearTextUse(layer);
                }
            }

            private void cpClearLayerNumber(Layer layer) {
                if (layer.getGDSLayerNumber() == null) {
                    return;
                }
                Cp.exec((String)"%s.setGDSLayerNumber(null)", (Object[])new Object[]{CpHelper.getObjCmdStr(layer)});
            }

            private void cpClearLayerType(Layer layer) {
                if (layer.getGDSLayerType() == null) {
                    return;
                }
                Cp.exec((String)"%s.setGDSLayerType(null)", (Object[])new Object[]{CpHelper.getObjCmdStr(layer)});
            }

            private void cpClearTextNumber(Layer layer) {
                if (layer.getGDSTextNumber() == null) {
                    return;
                }
                Cp.exec((String)"%s.setGDSTextNumber(null)", (Object[])new Object[]{CpHelper.getObjCmdStr(layer)});
            }

            private void cpClearTextType(Layer layer) {
                if (layer.getGDSTextType() == null) {
                    return;
                }
                Cp.exec((String)"%s.setGDSTextType(null)", (Object[])new Object[]{CpHelper.getObjCmdStr(layer)});
            }

            private void cpClearTextUse(Layer layer) {
                if (layer.getGDSTextUse() == null) {
                    return;
                }
                Cp.exec((String)"%s.setGDSTextUse(null)", (Object[])new Object[]{CpHelper.getObjCmdStr(layer)});
            }

            private /* synthetic */ void lambda$getDragDroppedHandler$9(int toOrder, List layers) {
                this.moveLayers(toOrder);
                Platform.runLater(() -> {
                    EditLayerPanel.this.mLayerTableView.reloadItems();
                    EditLayerPanel.this.mLayerTableView.clearSelection();
                    this.mSnapshotLayers.forEach(layer -> {
                        int layerIndex = Math.abs(layers.size() - layer.getOrder() - 1);
                        EditLayerPanel.this.mLayerTableView.select(layerIndex);
                    });
                    this.mSnapshotLayers.clear();
                });
            }
        }

        private class Toolbar
        extends HBox {
            private AJFXButton mInsertLayerAboveBtn;
            private AJFXButton mInsertLayerBelowBtn;
            private AJFXButton mDeleteLayerBtn;
            private HBox mLeftBar;

            private Toolbar() {
                HBox layerToolbar = new HBox();
                this.mInsertLayerAboveBtn = this.newInsertLayerAboveBtn();
                layerToolbar.getChildren().add((Object)this.mInsertLayerAboveBtn);
                this.mInsertLayerBelowBtn = this.newInsertLayerBelowBtn();
                layerToolbar.getChildren().add((Object)this.mInsertLayerBelowBtn);
                this.mDeleteLayerBtn = this.newDeleteLayerBtn();
                layerToolbar.getChildren().add((Object)this.mDeleteLayerBtn);
                this.getChildren().add((Object)layerToolbar);
                this.mLeftBar = new HBox();
                this.mLeftBar.setAlignment(Pos.CENTER_RIGHT);
                HBox.setHgrow((Node)this.mLeftBar, (Priority)Priority.ALWAYS);
                this.getChildren().add((Object)this.mLeftBar);
                this.refreshBtnDisable();
            }

            private void refreshBtnDisable() {
                boolean isDisable = EditLayerPanel.this.getSelectedSubstrate() == null;
                this.mInsertLayerAboveBtn.setDisable(isDisable);
                this.mInsertLayerBelowBtn.setDisable(isDisable);
                this.mDeleteLayerBtn.setDisable(isDisable);
            }

            private void addInLeftBar(Node node) {
                this.mLeftBar.getChildren().add((Object)node);
            }

            private AJFXButton newInsertLayerAboveBtn() {
                AJFXButton btn = EditLayerPanel.this.newIconBtn(OrbitJFXImages.INSERT_ROW_ABOVE, "Insert layer above");
                btn.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                    Layer selectedLayer = this.getSelectedLayer();
                    int layerCount = EditLayerPanel.this.getSelectedSubstrate().getLayerCount();
                    int order = selectedLayer == null ? layerCount : selectedLayer.getOrder() + 1;
                    this.cpCreateLayer(order);
                    Platform.runLater(() -> {
                        EditLayerPanel.this.mLayerTableView.reloadItems();
                        EditLayerPanel.this.mLayerTableView.requestFocus();
                        EditLayerPanel.this.mLayerTableView.clearSelection();
                        EditLayerPanel.this.mLayerTableView.select(Math.abs(layerCount - order));
                    });
                }));
                return btn;
            }

            private AJFXButton newInsertLayerBelowBtn() {
                AJFXButton btn = EditLayerPanel.this.newIconBtn(OrbitJFXImages.INSERT_ROW_BELOW, "Insert layer below");
                btn.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                    Layer selectedLayer = this.getSelectedLayer();
                    int layerCount = EditLayerPanel.this.getSelectedSubstrate().getLayerCount();
                    int order = selectedLayer == null ? 0 : selectedLayer.getOrder();
                    this.cpCreateLayer(order);
                    Platform.runLater(() -> {
                        EditLayerPanel.this.mLayerTableView.reloadItems();
                        EditLayerPanel.this.mLayerTableView.requestFocus();
                        EditLayerPanel.this.mLayerTableView.clearSelection();
                        EditLayerPanel.this.mLayerTableView.select(Math.abs(layerCount - order));
                    });
                }));
                return btn;
            }

            private void cpCreateLayer(int order) {
                String substrateName = EditLayerPanel.this.getSelectedSubstrate().getName();
                String layerName = Layer.getUniqueName((Substrate)EditLayerPanel.this.getSelectedSubstrate(), (String)EditLayerUI.DEFAULT_LAYER_BASE_NAME);
                long thickness = EditLayerUI.this.mUnit.fromUser(1.0);
                Cp.exec((String)"Layer.create(curDb(), \"%s\", \"%s\", \"%s\", %dL, %d)", (Object[])new Object[]{substrateName, layerName, DEFAULT_LAYER_TYPE, thickness, order});
            }

            private AJFXButton newDeleteLayerBtn() {
                AJFXButton btn = EditLayerPanel.this.newIconBtn(OrbitJFXImages.DELETE_ROW, "Delete layer");
                btn.setOnAction(e -> this.deleteLayers());
                return btn;
            }

            private void deleteLayers() {
                SwingUtilities.invokeLater(() -> {
                    try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)EditLayerUI.this.getDb(), (String)"Delete layers");){
                        this.getSelectedLayers().forEach(this::cpDeletelayer);
                        this.cpValidLayerOrder();
                    }
                    Platform.runLater(() -> {
                        int index = this.getSelectedIndex();
                        EditLayerPanel.this.mLayerTableView.reloadItems();
                        EditLayerPanel.this.mLayerTableView.requestFocus();
                        EditLayerPanel.this.mLayerTableView.clearSelection();
                        EditLayerPanel.this.mLayerTableView.select(index);
                    });
                });
            }

            private void cpValidLayerOrder() {
                Cp.exec((String)"%s.validateLayerOrder()", (Object[])new Object[]{CpHelper.getObjCmdStr(EditLayerPanel.this.getSelectedSubstrate())});
            }

            private void cpDeletelayer(Layer layer) {
                Cp.exec((String)"%s.deleteFromDb()", (Object[])new Object[]{CpHelper.getObjCmdStr(layer)});
            }

            private int getSelectedIndex() {
                return EditLayerPanel.this.mLayerTableView.getSelectedIndex();
            }

            private List<Layer> getSelectedLayers() {
                return EditLayerPanel.this.mLayerTableView.getSelectedItems();
            }

            private Layer getSelectedLayer() {
                return (Layer)EditLayerPanel.this.mLayerTableView.getSelectedItem();
            }
        }

        private class SubstrateBox
        extends HBox {
            private AJFXButton mRefreshBtn = new AJFXButton(OrbitJFXImages.REFRESH, "Refresh");
            private SubstrateChooser mSubstrateChooser;
            private AJFXButton mDeleteSubstrateBtn;
            private AJFXButton mExportCsvBtn;

            public SubstrateBox() {
                this.mRefreshBtn.transparentBorder();
                this.getChildren().add((Object)this.mRefreshBtn);
                this.mSubstrateChooser = new SubstrateChooser(EditLayerUI.this.getDb(), EditLayerUI.this.mInitSubstrate);
                HBox.setHgrow((Node)this.mSubstrateChooser, (Priority)Priority.ALWAYS);
                this.getChildren().add((Object)this.mSubstrateChooser);
                HBox substrateToolbar = new HBox();
                substrateToolbar.setAlignment(Pos.CENTER);
                substrateToolbar.getChildren().add((Object)this.newAddSubstrateBtn());
                this.mDeleteSubstrateBtn = this.newDeleteSubstrateBtn();
                substrateToolbar.getChildren().add((Object)this.mDeleteSubstrateBtn);
                this.getChildren().add((Object)substrateToolbar);
                this.getChildren().add((Object)EditLayerPanel.this.newSeparator());
                HBox csvToolbar = new HBox();
                csvToolbar.setAlignment(Pos.CENTER);
                csvToolbar.getChildren().add((Object)this.newImportLayersBtn());
                this.mExportCsvBtn = this.newExportCsvBtn();
                csvToolbar.getChildren().add((Object)this.mExportCsvBtn);
                this.getChildren().add((Object)csvToolbar);
                this.setAlignment(Pos.CENTER);
                this.refreshBtnDisable();
            }

            public Substrate getSelectedSubstrate() {
                return this.mSubstrateChooser.getSelectedSubstrate();
            }

            public void reload() {
                this.mSubstrateChooser.refreshSubstrates();
            }

            private void refreshBtnDisable() {
                boolean isDisable = this.getSelectedSubstrate() == null;
                this.mDeleteSubstrateBtn.setDisable(isDisable);
                this.mExportCsvBtn.setDisable(isDisable);
            }

            public void setRefreshAction(EventHandler<javafx.event.ActionEvent> eventHandler) {
                this.mRefreshBtn.setOnAction(eventHandler);
                this.mSubstrateChooser.setOnAction(eventHandler);
            }

            private AJFXMenuButton newImportLayersBtn() {
                AJFXMenuButton btn = EditLayerPanel.this.newIconMenuBtn(OrbitJFXImages.IMPORT, "Import Layers");
                btn.getItems().add((Object)this.newImportLayerFromLEFMenuItem());
                btn.getItems().add((Object)this.newImportLayerCSVMenuItem());
                return btn;
            }

            private MenuItem newImportLayerFromLEFMenuItem() {
                MenuItem menuItem = new MenuItem("From LEF");
                menuItem.setOnAction(e -> LefDefUI.showDialog(OrbitIO.getMainWindow(), this.getSelectedSubstrate()));
                return menuItem;
            }

            private MenuItem newImportLayerCSVMenuItem() {
                MenuItem menuItem = new MenuItem("From Layer CSV");
                menuItem.setOnAction(e -> {
                    AJFXFileChooser fileChooser = new AJFXFileChooser("Import Layer CSV");
                    fileChooser.addChoosableFileFilter(AJFXFileChooser.CSV_FILE_FILTER);
                    File file = fileChooser.showOpenDialog((Window)((Object)EditLayerUI.this));
                    if (file != null) {
                        this.importLayerCSV(file);
                    }
                });
                return menuItem;
            }

            private void importLayerCSV(File file) {
                SwingUtilities.invokeLater(() -> {
                    this.cpImportLayerCsv(file.getPath());
                    Platform.runLater(() -> {
                        this.reload();
                        this.refreshBtnDisable();
                        EditLayerPanel.this.mLayerTableView.reloadItems();
                        EditLayerPanel.this.mLayerTableView.refresh();
                        EditLayerPanel.this.mLayerTableView.requestFocus();
                    });
                });
            }

            private void cpImportLayerCsv(String filePath) {
                Cp.exec((String)"com.cadence.orbit.pi.csvio.LayerCsvImport.importCsv(curDb(), %s)", (Object[])new Object[]{Cp.getFileAsArgument((String)filePath)});
            }

            private AJFXButton newExportCsvBtn() {
                String title = "Export Layer CSV";
                AJFXButton btn = EditLayerPanel.this.newIconBtn(OrbitJFXImages.EXPORT, title);
                btn.setOnAction(e -> {
                    AJFXFileChooser fileChooser = new AJFXFileChooser(title);
                    fileChooser.addChoosableFileFilter(AJFXFileChooser.CSV_FILE_FILTER);
                    File file = fileChooser.showSaveDialog((Window)((Object)EditLayerUI.this));
                    if (file != null) {
                        SwingUtilities.invokeLater(() -> this.cpExportLayerCsv(file.getPath()));
                    }
                });
                return btn;
            }

            private void cpExportLayerCsv(String filePath) {
                Cp.exec((String)"unset(\"_exportCsv\")", (Object[])new Object[0]);
                Cp.exec((String)"_exportCsv = new com.cadence.orbit.pi.csvio.LayerCsvExport(curDb(), \"%s\")", (Object[])new Object[]{filePath});
                Cp.exec((String)"_exportCsv.setIsExportGDSData(%b)", (Object[])new Object[]{EditLayerPanel.this.mLayerTableView.mGdsCol.isVisible()});
                Cp.exec((String)"_exportCsv.execute()", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_exportCsv\")", (Object[])new Object[0]);
            }

            private AJFXButton newAddSubstrateBtn() {
                String title = "Create new substrate";
                AJFXButton btn = EditLayerPanel.this.newIconBtn(OrbitJFXImages.ADD_ROWS, title);
                btn.setOnAction(e -> EditLayerPanel.this.showCreateSubstrateUI());
                return btn;
            }

            private AJFXButton newDeleteSubstrateBtn() {
                String title = "Delete substrate";
                AJFXButton btn = EditLayerPanel.this.newIconBtn(OrbitJFXImages.DELETE_ROWS, title);
                btn.setOnAction(e -> {
                    Substrate selectedSubstrate = this.getSelectedSubstrate();
                    String headerTxt = "OrbitIO will permanently delete this substrate";
                    String contactTxt = "Do you want to continue?";
                    Optional result = AJFXAlerts.showConfirmationAlert((Window)((Object)EditLayerUI.this), (String)EditLayerUI.DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
                    if (result.isPresent() && result.get() == ButtonType.OK) {
                        this.deleteSubstrate(selectedSubstrate);
                    }
                });
                return btn;
            }

            protected void deleteSubstrate(Substrate substrate) {
                assert (substrate != null);
                SwingUtilities.invokeLater(() -> {
                    Cp.exec((String)"%s.deleteFromDb()", (Object[])new Object[]{CpHelper.getObjCmdStr(substrate)});
                    if (substrate.getDb() == null) {
                        Platform.runLater(() -> {
                            this.mSubstrateChooser.removeSubstrate(substrate);
                            EditLayerPanel.this.mLayerTableView.reloadItems();
                        });
                    }
                });
            }
        }
    }
}

