/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.table_editor;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.jfxui.AJFXAlerts;
import com.sigrity.acl.jfxui.AJFXButton;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.CloseHBox;
import com.sigrity.acl.jfxui.Separators;
import com.sigrity.acl.jfxui.SlowOperationAlert;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.NetFilters;
import com.sigrity.orbit.NetGraphPanel;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.cmd.NetCommands;
import com.sigrity.orbit.jfxui.DevicePathTextBox;
import com.sigrity.orbit.jfxui.EditorTableView;
import com.sigrity.orbit.jfxui.OrbitJFXImages;
import com.sigrity.orbit.ui.CSVNetlistInDlg;
import com.sigrity.orbit.ui.CSVNetlistOutDlg;
import com.sigrity.orbit.ui.DbObjectDetailsUI;
import com.sigrity.orbit.ui.NetUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonType;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class EditNetUI
extends AJFXDesignDialog {
    private static final String ACTION_TITLE = "Nets Table";
    private static final String DIALOG_TITLE = "Net Table Editor";
    private final DevicePath mInitDevPath;

    public static Action getAction() {
        return EditNetUI.getAction(null);
    }

    public static Action getAction(final DevicePath devPath) {
        return new AbstractAction(ACTION_TITLE, OrbitIcons.TABLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditNetUI.createDialog(OrbitIO.getMainWindow(), OrbitIO.getCurDb(), devPath);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static EditNetUI createDialog(Window owner, Db db, String devPathStr) {
        return EditNetUI.createDialog(owner, db, DevicePath.fromString((Db)db, (String)devPathStr));
    }

    public static EditNetUI createDialog(Window owner, Db db, DevicePath devPath) {
        if (db == null) {
            ALog.logError((String)"No design is open.");
            return null;
        }
        EditNetUI dlg = new EditNetUI(owner, db, devPath);
        dlg.setVisible(true);
        return dlg;
    }

    private EditNetUI(Window owner, Db db, DevicePath devPath) {
        super(db, owner, DIALOG_TITLE);
        this.mInitDevPath = devPath;
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new EditNetPanel((Window)((Object)this), this.mInitDevPath);
    }

    public static NetTableBodyPanel getEditNetPanel(Window owner, DevicePath path) {
        NetTableBodyPanel netTableBodyPanel = new NetTableBodyPanel(owner, path);
        netTableBodyPanel.init();
        return netTableBodyPanel;
    }

    public static class NetTableBodyPanel
    extends AJFXPanel {
        protected final Window mOwner;
        protected final DevicePath mDevPath;
        private DevicePathTextBox mDevicePathTextBox;
        private NetTableView mNetTableView;

        protected NetTableBodyPanel(Window owner, DevicePath path) {
            this.mOwner = owner;
            this.mDevPath = path;
        }

        public void updateDevPath(DevicePath path) {
            this.mDevicePathTextBox.setDevicePath(path);
        }

        protected Parent initSceneGraph() {
            VBox pane = new VBox(5.0);
            this.mDevicePathTextBox = new DevicePathTextBox(this.mOwner, this.mDevPath){

                @Override
                protected void refreshAssociateNodes() {
                    mNetTableView.reloadItems();
                }
            };
            this.mNetTableView = new NetTableView(this.mOwner, this.mDevicePathTextBox);
            Toolbar mToolbar = new Toolbar(this.mOwner, this.mNetTableView, this.mDevicePathTextBox);
            VBox.setVgrow((Node)this.mDevicePathTextBox, (Priority)Priority.NEVER);
            pane.getChildren().add((Object)this.mDevicePathTextBox);
            VBox.setVgrow((Node)mToolbar, (Priority)Priority.NEVER);
            pane.getChildren().add((Object)mToolbar);
            VBox.setVgrow((Node)this.mNetTableView, (Priority)Priority.ALWAYS);
            pane.getChildren().add((Object)this.mNetTableView);
            return pane;
        }

        private static class NetTableView
        extends EditorTableView<Net> {
            private final Window mOwner;
            private final DevicePathTextBox mDevicePathTextBox;

            public NetTableView(Window owner, DevicePathTextBox pathBox) {
                this.mOwner = owner;
                this.mDevicePathTextBox = pathBox;
                this.reloadItems();
                this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
                this.getSelectionModel().setCellSelectionEnabled(true);
                this.setEditable(true);
                this.setSortedComparator(Net.NameComparator);
            }

            @Override
            protected List<Net> getItemList() {
                DeviceTemplate devT = this.getTargetDevT();
                if (devT == null) {
                    return Collections.emptyList();
                }
                return AUtil.arrayList((Iterator)devT.getNets(NetFilters.NOT_UNUSED));
            }

            @Override
            protected void initHeader() {
                this.initRowNumCol();
                this.initNameCol();
                this.initUseCol();
            }

            @Override
            protected void bindKeys() {
            }

            private void initRowNumCol() {
                this.addNewRowNumCol();
            }

            private void initNameCol() {
                EditorTableView.EditorTableColumn<String> col = this.addNewEditorTableColumn("Name", name -> name, Net::getName);
                col.setCellValueFactory(col.newReadOnlyStringFactory());
                col.setCellFactory(TextFieldTableCell.forTableColumn());
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Net, String>>(){

                    public void handle(TableColumn.CellEditEvent<Net, String> t) {
                        Net net = (Net)t.getTableView().getItems().get(t.getTablePosition().getRow());
                        String newName = (String)t.getNewValue();
                        DeviceTemplate devT = this.getTargetDevT();
                        if (devT != null && devT.getNet(newName) == null) {
                            SwingUtilities.invokeLater(() -> this.cpSetName(net, newName));
                        } else if (!net.getName().equals(newName)) {
                            this.showSetNameAlert(newName);
                            t.getTableView().refresh();
                        }
                        t.getTableView().requestFocus();
                    }

                    private void showSetNameAlert(String newName) {
                        String headerTxt = String.format("Invalid net name '%s'", newName);
                        String contactTxt = String.format("'%s' net already exist", newName);
                        AJFXAlerts.showErrorAlert((Window)mOwner, (String)EditNetUI.DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
                    }

                    private void cpSetName(Net net, String newName) {
                        Cp.exec((String)"%s.setName(\"%s\")", (Object[])new Object[]{CpHelper.getObjCmdStr(net), newName});
                    }
                });
            }

            private void initUseCol() {
                EditorTableView.EditorTableColumn<Net.Use> col = this.addNewEditorTableColumn("Use", Enum::name, Net::getUse);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                ObservableList uses = FXCollections.observableArrayList((Object[])Net.Use.values());
                col.setCellFactory(ComboBoxTableCell.forTableColumn((ObservableList)uses));
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Net, Net.Use>>(){

                    public void handle(TableColumn.CellEditEvent<Net, Net.Use> t) {
                        ObservableList selectedItems = this.getSelectedItems();
                        Net.Use newValue = (Net.Use)t.getNewValue();
                        SwingUtilities.invokeLater(() -> {
                            selectedItems.forEach(i -> this.cpSetUse((Net)i, newValue));
                            this.refreshFocusLater();
                        });
                    }

                    private void cpSetUse(Net item, Net.Use newValue) {
                        Cp.exec((String)"%s.setUse(%s.%s)", (Object[])new Object[]{CpHelper.getObjCmdStr(item), Net.Use.class.getName(), newValue});
                    }
                });
            }

            private DevicePath getTargetDevPath() {
                if (this.mDevicePathTextBox == null) {
                    return null;
                }
                return this.mDevicePathTextBox.getDevicePath();
            }

            private DeviceTemplate getTargetDevT() {
                DevicePath path = this.getTargetDevPath();
                if (path == null) {
                    return null;
                }
                return path.getDeviceTemplate();
            }
        }

        private static class Toolbar
        extends HBox {
            private final NetTableView mNetTableView;
            private final Window mOwner;
            private final DevicePathTextBox mDevicePathTextBox;

            public Toolbar(Window owner, NetTableView netTableView, DevicePathTextBox pathBox) {
                this.mNetTableView = netTableView;
                this.mOwner = owner;
                this.mDevicePathTextBox = pathBox;
                this.initImportBtn();
                this.initExportBtn();
                this.addSeparator();
                this.initShowMeBtn();
                this.initSelectBtn();
                this.addSeparator();
                this.initAddBtn();
                this.initDeleteBtn();
                this.addSeparator();
                this.initSignalBtn();
                this.initPowerBtn();
                this.initGroundBtn();
                this.addSeparator();
                this.initGraphNetBtn();
                this.initInformationBtn();
                this.setAlignment(Pos.CENTER_LEFT);
            }

            private void initImportBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.IMPORT, "Import CSV Netlist...");
                btn.transparentBorder();
                btn.setOnAction(this.newImportAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newImportAction() {
                return e -> SwingUtilities.invokeLater(() -> {
                    CSVNetlistInDlg.showMe(this.mDevicePathTextBox.getDevicePath().toString(), false);
                    Platform.runLater(() -> {
                        this.mNetTableView.reloadItems();
                        this.mNetTableView.requestFocus();
                        this.mNetTableView.clearSelection();
                    });
                });
            }

            private void initExportBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.EXPORT, "Export CSV Netlist...");
                btn.transparentBorder();
                btn.setOnAction(this.newExportAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newExportAction() {
                return e -> SwingUtilities.invokeLater(() -> CSVNetlistOutDlg.showMe(this.mDevicePathTextBox.getDevicePath().toString()));
            }

            private void initAddBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.INSERT_ROW_ABOVE, "Create net");
                btn.transparentBorder();
                btn.setOnAction(this.newCreateNetAction());
                this.getChildren().add((Object)btn);
            }

            private void initDeleteBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.DELETE_ROW, "Delete net");
                btn.transparentBorder();
                btn.setOnAction(this.newDeleteNetAction());
                this.getChildren().add((Object)btn);
            }

            private void initShowMeBtn() {
                AJFXButton showMeBtn = new AJFXButton(OrbitJFXImages.SHOW_ME, "Show me");
                showMeBtn.transparentBorder();
                showMeBtn.setOnAction(this.newShowMeAction());
                this.getChildren().add((Object)showMeBtn);
            }

            private void initSelectBtn() {
                AJFXButton selectBtn = new AJFXButton(OrbitJFXImages.SELECT_NET, "Select");
                selectBtn.transparentBorder();
                selectBtn.setOnAction(this.newSelectAction());
                this.getChildren().add((Object)selectBtn);
            }

            private void initPowerBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.POWER, "Classify as power");
                btn.transparentBorder();
                btn.setOnAction(this.newPowerAction());
                this.getChildren().add((Object)btn);
            }

            private void initGroundBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.GROUND, "Classify as ground");
                btn.transparentBorder();
                btn.setOnAction(this.newGroundAction());
                this.getChildren().add((Object)btn);
            }

            private void initSignalBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.SIGNAL, "Classify as signal");
                btn.transparentBorder();
                btn.setOnAction(this.newSignalAction());
                this.getChildren().add((Object)btn);
            }

            private void initGraphNetBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.GRAPHNET, "Graph net");
                btn.transparentBorder();
                btn.setOnAction(this.newShowGraphNetAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newShowGraphNetAction() {
                return e -> {
                    Optional result;
                    DevicePath devPath = this.mDevicePathTextBox.getDevicePath();
                    ObservableList nets = this.mNetTableView.getSelectedItems();
                    if (devPath == null || nets == null || nets.isEmpty()) {
                        return;
                    }
                    int netCount = nets.size();
                    if (netCount > 10 && ((result = SlowOperationAlert.showLargeNumUIAlert((Window)this.mOwner, (int)netCount)).isEmpty() || result.get() != ButtonType.OK)) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        for (Net net : nets) {
                            NetGraphPanel.showNetGraph(this.mOwner, devPath, net);
                        }
                    });
                };
            }

            private void initInformationBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.INFORMATION, "Details");
                btn.transparentBorder();
                btn.setOnAction(this.newShowDetailsAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newCreateNetAction() {
                return e -> {
                    DevicePath devPath = this.mDevicePathTextBox.getDevicePath();
                    if (devPath == null) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        Net newNet = NetUI.AddNetUI.addNet(this.mOwner, devPath.getDeviceTemplate());
                        if (newNet == null) {
                            return;
                        }
                        Platform.runLater(this.mNetTableView::reloadItems);
                    });
                };
            }

            private EventHandler<javafx.event.ActionEvent> newDeleteNetAction() {
                return e -> {
                    DevicePath devPath = this.mDevicePathTextBox.getDevicePath();
                    ObservableList nets = this.mNetTableView.getSelectedItems();
                    if (devPath == null || nets == null || nets.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        int count = nets.size();
                        CpHelper.cpClearSelection();
                        CpHelper.cpSelect(nets);
                        CpHelper.cpDeleteSelected();
                        ALog.logInfo((String)"Delete %d net complete.", (Object[])new Object[]{count});
                        Platform.runLater(this.mNetTableView::reloadItems);
                    });
                };
            }

            private EventHandler<javafx.event.ActionEvent> newShowMeAction() {
                return e -> {
                    DevicePath devPath = this.mDevicePathTextBox.getDevicePath();
                    ObservableList nets = this.mNetTableView.getSelectedItems();
                    if (devPath == null || nets == null || nets.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.showMe(devPath, (List<Net>)nets));
                };
            }

            private EventHandler<javafx.event.ActionEvent> newSelectAction() {
                return e -> {
                    DevicePath devPath = this.mDevicePathTextBox.getDevicePath();
                    ObservableList nets = this.mNetTableView.getSelectedItems();
                    if (devPath == null || nets == null || nets.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.select(devPath, (List<Net>)nets));
                };
            }

            private void showMe(DevicePath path, List<Net> nets) {
                for (Net net : nets) {
                    this.showMe(path, net);
                }
            }

            private void showMe(DevicePath path, Net net) {
                ShowMeTheWay.addNet(net, path);
            }

            private void select(DevicePath path, List<Net> nets) {
                for (Net net : nets) {
                    this.select(path, net);
                }
            }

            private void select(DevicePath netPath, Net net) {
                Selection curSelection = Selection.getCurrentSelectionForDb((Db)this.mDevicePathTextBox.getDevicePath().getDb());
                netPath.getAllFullPaths().filter(path -> !curSelection.contains(path, (DbObject)net)).forEach(path -> curSelection.add(path, (DbObject)net));
            }

            private EventHandler<javafx.event.ActionEvent> newSignalAction() {
                return e -> {
                    ObservableList nets = this.mNetTableView.getSelectedItems();
                    if (nets == null || nets.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        this.classifySignal((List<Net>)nets);
                        this.mNetTableView.refreshFocusLater();
                    });
                };
            }

            private void classifySignal(List<Net> nets) {
                String actionName = "Classify as signal";
                try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)this.mDevicePathTextBox.getDevicePath().getDb(), (String)actionName);){
                    nets.forEach(this::cpClassifySignal);
                }
            }

            private void cpClassifySignal(Net i) {
                Cp.exec((String)"com.sigrity.orbit.cmd.NetCommands.classifyAsSignal(curDb(), \"%s\")", (Object[])new Object[]{i.getKeyStr()});
            }

            private EventHandler<javafx.event.ActionEvent> newPowerAction() {
                return e -> {
                    ObservableList nets = this.mNetTableView.getSelectedItems();
                    if (nets == null || nets.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        this.classifyPower((List<Net>)nets);
                        this.mNetTableView.refreshFocusLater();
                    });
                };
            }

            private void classifyPower(List<Net> nets) {
                String actionName = "Classify as power";
                try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)this.mDevicePathTextBox.getDevicePath().getDb(), (String)actionName);){
                    this.cpClassifyPower(nets);
                }
            }

            private void cpClassifyPower(List<Net> nets) {
                Cp.exec((String)"_powerNetPersonality = %s.getPowerNetPersonality(\"%s\", \"%s\")", (Object[])new Object[]{NetUI.class.getName(), this.mDevicePathTextBox.getDevicePath().getDeviceTemplate().getKeyStr(), nets.get(0).getName()});
                for (Net net : nets) {
                    Cp.exec((String)"%s.classifyAsPower(%s, _powerNetPersonality)", (Object[])new Object[]{NetCommands.class.getName(), CpHelper.getObjCmdStr(net)});
                }
            }

            private EventHandler<javafx.event.ActionEvent> newGroundAction() {
                return e -> {
                    ObservableList nets = this.mNetTableView.getSelectedItems();
                    if (nets == null || nets.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        this.classifyGround((List<Net>)nets);
                        this.mNetTableView.refreshFocusLater();
                    });
                };
            }

            private void classifyGround(List<Net> nets) {
                String actionName = "Classify as ground";
                try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)this.mDevicePathTextBox.getDevicePath().getDb(), (String)actionName);){
                    this.cpClassifyGround(nets);
                }
            }

            private void cpClassifyGround(List<Net> nets) {
                Cp.exec((String)"_powerNetPersonality = %s.getPowerNetPersonality(\"%s\", \"%s\")", (Object[])new Object[]{NetUI.class.getName(), this.mDevicePathTextBox.getDevicePath().getDeviceTemplate().getKeyStr(), nets.get(0).getName()});
                for (Net net : nets) {
                    Cp.exec((String)"%s.classifyAsGround(%s, _powerNetPersonality)", (Object[])new Object[]{NetCommands.class.getName(), CpHelper.getObjCmdStr(net)});
                }
            }

            private EventHandler<javafx.event.ActionEvent> newShowDetailsAction() {
                return e -> {
                    Optional result;
                    ObservableList nets = this.mNetTableView.getSelectedItems();
                    if (nets == null || nets.isEmpty()) {
                        return;
                    }
                    int netCount = nets.size();
                    if (netCount > 10 && ((result = SlowOperationAlert.showLargeNumUIAlert((Window)this.mOwner, (int)netCount)).isEmpty() || result.get() != ButtonType.OK)) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        for (Net net : nets) {
                            DbObjectDetailsUI.show(this.mOwner, (DbObject)net, this.mDevicePathTextBox.getDevicePath(), OrbitIO.getCurView());
                        }
                    });
                };
            }

            private void addSeparator() {
                this.getChildren().add((Object)Separators.newToolbarSeparator());
            }
        }
    }

    private static class EditNetPanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 600;
        private static final int PANEL_HEIGHT = 530;
        private NetTableBodyPanel mNetTableBodyPanel;

        public EditNetPanel(Window owner, DevicePath path) {
            this.mNetTableBodyPanel = new NetTableBodyPanel(owner, path);
            this.setPreferredSize(new Dimension(600, 530));
        }

        protected Parent initSceneGraph() {
            VBox root = (VBox)this.mNetTableBodyPanel.initSceneGraph();
            CloseHBox closeBox = new CloseHBox(this.mNetTableBodyPanel.mOwner);
            root.getChildren().add((Object)closeBox);
            return root;
        }
    }
}

