/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.table_editor;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.jfxui.AJFXButton;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXFileChooser;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.AJFXTextInputDialog;
import com.sigrity.acl.jfxui.CloseHBox;
import com.sigrity.acl.jfxui.Separators;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.jfxui.DevicePathTextBox;
import com.sigrity.orbit.jfxui.EditorTableView;
import com.sigrity.orbit.jfxui.OrbitJFXImages;
import com.sigrity.orbit.pin_label.ui.PinLabelAttributeValidator;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class EditPinLabelUI
extends AJFXDesignDialog {
    private static final String ACTION_TITLE = "PinLabels Table";
    private static final String DIALOG_TITLE = "PinLabel Table Editor";
    private final DevicePath mInitDevPath;

    public static Action getAction() {
        return EditPinLabelUI.getAction(null);
    }

    public static Action getAction(final DevicePath devPath) {
        return new AbstractAction(ACTION_TITLE, OrbitIcons.TABLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPinLabelUI.createDialog(OrbitIO.getMainWindow(), OrbitIO.getCurDb(), devPath);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static EditPinLabelUI createDialog(Window owner, Db db, String devPathStr) {
        return EditPinLabelUI.createDialog(owner, db, DevicePath.fromString((Db)db, (String)devPathStr));
    }

    public static EditPinLabelUI createDialog(Window owner, Db db, DevicePath devPath) {
        if (db == null) {
            ALog.logError((String)"No design is open.");
            return null;
        }
        EditPinLabelUI dlg = new EditPinLabelUI(owner, db, devPath);
        dlg.setVisible(true);
        return dlg;
    }

    private EditPinLabelUI(Window owner, Db db, DevicePath devPath) {
        super(db, owner, DIALOG_TITLE);
        this.mInitDevPath = devPath;
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new EditPinLabelPanel();
    }

    private class EditPinLabelPanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 600;
        private static final int PANEL_HEIGHT = 530;
        private DevicePathTextBox mDevicePathTextBox;
        private PinLabelTableView mTableEditorView;

        public EditPinLabelPanel() {
            this.setPreferredSize(new Dimension(600, 530));
        }

        protected Parent initSceneGraph() {
            VBox pane = new VBox(5.0);
            this.mDevicePathTextBox = new DevicePathTextBox((Window)((Object)EditPinLabelUI.this), EditPinLabelUI.this.mInitDevPath){

                @Override
                protected void refreshAssociateNodes() {
                    EditPinLabelPanel.this.mTableEditorView.reloadItems();
                }
            };
            VBox.setVgrow((Node)this.mDevicePathTextBox, (Priority)Priority.NEVER);
            pane.getChildren().add((Object)this.mDevicePathTextBox);
            Toolbar toolbar = new Toolbar();
            VBox.setVgrow((Node)toolbar, (Priority)Priority.NEVER);
            pane.getChildren().add((Object)toolbar);
            this.mTableEditorView = new PinLabelTableView();
            VBox.setVgrow((Node)this.mTableEditorView, (Priority)Priority.ALWAYS);
            pane.getChildren().add((Object)this.mTableEditorView);
            CloseHBox closeBox = new CloseHBox((Window)((Object)EditPinLabelUI.this));
            pane.getChildren().add((Object)closeBox);
            return pane;
        }

        private DevicePath getTargetDevPath() {
            return this.mDevicePathTextBox.getDevicePath();
        }

        private DeviceTemplate getTargetDevT() {
            return this.getTargetDevPath().getDeviceTemplate();
        }

        private class PinLabelTableView
        extends EditorTableView<PinLabel> {
            private EditorTableView.EditorTableColumn<DevicePath> mPinPathCol;
            private EditorTableView.EditorTableColumn<PinTemplate> mPinCol;
            private Map<DbFieldDef, EditorTableView.EditorTableColumn<String>> mAttributeField2Column;

            public PinLabelTableView() {
                this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
                this.getSelectionModel().setCellSelectionEnabled(true);
                this.setEditable(true);
                this.setSortedComparator(PinLabel.CompareByPinPathAndPin);
            }

            @Override
            protected List<PinLabel> getItemList() {
                if (EditPinLabelPanel.this.getTargetDevPath() == null) {
                    return Collections.emptyList();
                }
                return AUtil.arrayList((Iterator)PinLabel.get((DeviceTemplate)EditPinLabelPanel.this.getTargetDevT()));
            }

            @Override
            protected void initHeader() {
                this.initRowNumCol();
            }

            @Override
            protected void bindKeys() {
                this.setOnKeyPressed(e -> {
                    if (e.getCode() == KeyCode.DELETE) {
                        this.bindDeleteKey();
                    }
                });
            }

            private void bindDeleteKey() {
                SwingUtilities.invokeLater(() -> {
                    try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)EditPinLabelUI.this.getDb(), (String)"Clear cells");){
                        this.getSelectedCells().forEach(this::clearCell);
                    }
                    this.refreshFocusLater();
                });
            }

            private void clearCell(TablePosition cell) {
                TableColumn col = cell.getTableColumn();
                assert (col instanceof EditorTableView.EditorTableColumn);
                if (col == this.mPinPathCol || col == this.mPinCol) {
                    return;
                }
                PinLabel pinLabel = (PinLabel)cell.getTableView().getItems().get(cell.getRow());
                EditorTableView.EditorTableColumn editCol = (EditorTableView.EditorTableColumn)col;
                Cp.exec((String)"%s.setValue(\"%s\", null)", (Object[])new Object[]{CpHelper.getObjCmdStr(pinLabel), editCol.getTitle()});
            }

            protected void removeColumn(EditorTableView.EditorTableColumn<String> tableColumn) {
                super.removeTableColumn(tableColumn);
                DbClass dbClass = EditPinLabelUI.this.getDb().getDbClass(PinLabel.class);
                assert (dbClass != null);
                DbFieldDef field = dbClass.getField(tableColumn.getTitle());
                this.mAttributeField2Column.remove(field);
            }

            protected EditorTableView.EditorTableColumn<String> getColumn(DbFieldDef field) {
                return this.mAttributeField2Column.get(field);
            }

            private void initRowNumCol() {
                this.addNewRowNumCol();
                this.initPinPathCol();
                this.initPinCol();
                this.initTermCol();
                this.initAttributes();
            }

            private void initPinPathCol() {
                this.mPinPathCol = this.addNewEditorTableColumn("Pin Path", DevicePath::toString, PinLabel::getPinPath);
                this.mPinPathCol.setSortable(false);
                this.mPinPathCol.setCellValueFactory(this.mPinPathCol.newSimpleObjectFactory());
                this.mPinPathCol.setCellFactory(this.mPinPathCol.newValueTextCellFactory());
            }

            private void initPinCol() {
                this.mPinCol = this.addNewEditorTableColumn("Pin", PinTemplate::getName, PinLabel::getPin);
                this.mPinCol.setSortable(false);
                this.mPinCol.setCellValueFactory(this.mPinCol.newSimpleObjectFactory());
                this.mPinCol.setCellFactory(this.mPinCol.newValueTextCellFactory());
            }

            private void initTermCol() {
                EditorTableView.EditorTableColumn<Term> col = this.addNewEditorTableColumn("Term", Term::getName, PinLabel::getTerm);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                col.setCellFactory(col.newValueTextCellFactory());
            }

            private void initAttributes() {
                PinLabel.getAttirbutes((Db)EditPinLabelUI.this.getDb()).forEach(this::initAttributeCol);
            }

            protected void initAttributeCol(DbFieldDef field) {
                final String fieldName = field.getName();
                EditorTableView.EditorTableColumn<String> col = this.addNewEditorTableColumn(field.getUserName(), s -> s, pinlabel -> (String)pinlabel.getValue(fieldName, String.class));
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                col.setCellFactory(TextFieldTableCell.forTableColumn());
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<PinLabel, String>>(){

                    public void handle(TableColumn.CellEditEvent<PinLabel, String> t) {
                        ObservableList selectedItems = PinLabelTableView.this.getSelectedItems();
                        String newName = (String)t.getNewValue();
                        SwingUtilities.invokeLater(() -> {
                            selectedItems.forEach(i -> this.cpSetValue((PinLabel)i, newName));
                            PinLabelTableView.this.refreshFocusLater();
                        });
                    }

                    private void cpSetValue(PinLabel pinLabel, String newValue) {
                        assert (newValue != null);
                        String oldValue = (String)pinLabel.getValue(fieldName, String.class);
                        if (oldValue != null && oldValue.equals(newValue) || oldValue == null && newValue.isEmpty()) {
                            return;
                        }
                        if (newValue.isEmpty()) {
                            Cp.exec((String)"%s.setValue(\"%s\", null)", (Object[])new Object[]{CpHelper.getObjCmdStr(pinLabel), fieldName});
                        } else {
                            Cp.exec((String)"%s.setValue(\"%s\", \"%s\")", (Object[])new Object[]{CpHelper.getObjCmdStr(pinLabel), fieldName, newValue});
                        }
                    }
                });
                if (this.mAttributeField2Column == null) {
                    this.mAttributeField2Column = new HashMap<DbFieldDef, EditorTableView.EditorTableColumn<String>>();
                }
                this.mAttributeField2Column.put(field, col);
            }
        }

        private class Toolbar
        extends HBox {
            private static final String DELETE_ATTRIBUTE_STR = "Delete attribute";
            private static final String EXPORT_PIN_LABEL_STR = "Export pinLabel";
            private static final String IMPORT_PIN_LABEL_STR = "Import pinLabel";

            public Toolbar() {
                this.initImportBtn();
                this.initExportBtn();
                this.addSeparator();
                this.initZoomToBtn();
                this.initShowMeBtn();
                this.initSelectBtn();
                this.addSeparator();
                this.initAddColumnBtn();
                this.initDeleteColumnBtn();
                this.setAlignment(Pos.CENTER_LEFT);
            }

            private void initZoomToBtn() {
                AJFXButton zoomToBtn = new AJFXButton(OrbitJFXImages.ZOOM_FIT, "Zoom to");
                zoomToBtn.transparentBorder();
                zoomToBtn.setOnAction(this.newZoomToAction());
                this.getChildren().add((Object)zoomToBtn);
            }

            private void initShowMeBtn() {
                AJFXButton showMeBtn = new AJFXButton(OrbitJFXImages.SHOW_ME, "Show me");
                showMeBtn.transparentBorder();
                showMeBtn.setOnAction(this.newShowMeAction());
                this.getChildren().add((Object)showMeBtn);
            }

            private void initSelectBtn() {
                AJFXButton selectBtn = new AJFXButton(OrbitJFXImages.SELECT_DEVICE, "Select");
                selectBtn.transparentBorder();
                selectBtn.setOnAction(this.newSelectAction());
                this.getChildren().add((Object)selectBtn);
            }

            private void initAddColumnBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.INSERT_COLUMN_RIGHT, "Add attribute");
                btn.transparentBorder();
                btn.setOnAction(this.newAddAttributeAction());
                this.getChildren().add((Object)btn);
            }

            private void initDeleteColumnBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.DELETE_COLUMN, DELETE_ATTRIBUTE_STR);
                btn.transparentBorder();
                btn.setOnAction(this.newDeleteAttributeAction());
                this.getChildren().add((Object)btn);
            }

            private void initImportBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.IMPORT, IMPORT_PIN_LABEL_STR);
                btn.transparentBorder();
                btn.setOnAction(this.newImportAction());
                this.getChildren().add((Object)btn);
            }

            private void initExportBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.EXPORT, EXPORT_PIN_LABEL_STR);
                btn.transparentBorder();
                btn.setOnAction(this.newExportAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newZoomToAction() {
                return e -> {
                    DevicePath devPath = EditPinLabelPanel.this.getTargetDevPath();
                    PinLabel pinT = (PinLabel)EditPinLabelPanel.this.mTableEditorView.getSelectedItem();
                    if (devPath == null || pinT == null) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.zoomTo(devPath, pinT));
                };
            }

            private void zoomTo(DevicePath devPath, PinLabel pinLabel) {
                PinTemplate pin = pinLabel.getPin();
                DevicePath fullPath = new DevicePath(devPath, pinLabel.getPinPath());
                ARect bounds = pin.getBounds().transform(fullPath.getTransform()).getBounds();
                if (bounds == null) {
                    return;
                }
                this.zoomToArea(bounds);
            }

            private void zoomToArea(ARect bounds) {
                DesignView2D v = (DesignView2D)OrbitIO.getCurView();
                bounds.changeSizeBy(0.1);
                v.getCanvas().getXForm().setWorld(bounds);
                v.getCanvas().refresh();
                OrbitIO.getApp().refreshCurrentView(false);
            }

            private EventHandler<javafx.event.ActionEvent> newShowMeAction() {
                return e -> {
                    DevicePath devPath = EditPinLabelPanel.this.getTargetDevPath();
                    ObservableList pinLabels = EditPinLabelPanel.this.mTableEditorView.getSelectedItems();
                    if (devPath == null || pinLabels == null || pinLabels.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.showMe(devPath, (List<PinLabel>)pinLabels));
                };
            }

            private EventHandler<javafx.event.ActionEvent> newSelectAction() {
                return e -> {
                    DevicePath devPath = EditPinLabelPanel.this.getTargetDevPath();
                    ObservableList pinLabels = EditPinLabelPanel.this.mTableEditorView.getSelectedItems();
                    if (devPath == null || pinLabels == null || pinLabels.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.select(devPath, (List<PinLabel>)pinLabels));
                };
            }

            private EventHandler<javafx.event.ActionEvent> newAddAttributeAction() {
                return e -> {
                    DbClass pinLabelDbClass = EditPinLabelUI.this.mDb.getDbClass(PinLabel.class);
                    if (pinLabelDbClass == null) {
                        return;
                    }
                    String fieldName = this.getFieldName();
                    if (fieldName == null) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        this.cpAddSoftField(fieldName);
                        this.addNewTableColumnLater(fieldName);
                    });
                };
            }

            private String getFieldName() {
                String title = "New Attribute";
                String headerTxt = "Enter an attribute name";
                String contactTxt = "Attribute Name:";
                Optional result = AJFXTextInputDialog.showDlg((Window)((Object)EditPinLabelUI.this), (String)title, (String)headerTxt, (String)contactTxt);
                if (result.isPresent()) {
                    String name = (String)result.get();
                    if (PinLabelAttributeValidator.validate((Window)((Object)EditPinLabelUI.this), EditPinLabelUI.this.getDb(), name)) {
                        return name;
                    }
                }
                return null;
            }

            private void cpAddSoftField(String fieldName) {
                Cp.exec((String)"%s.addSoftField(\"%s\", String.class)", (Object[])new Object[]{CpHelper.getDbClassCmdStr(EditPinLabelUI.this.getDb(), PinLabel.class), fieldName});
            }

            private void addNewTableColumnLater(String fieldName) {
                Platform.runLater(() -> this.addNewTableColumn(fieldName));
            }

            private void addNewTableColumn(String fieldName) {
                DbClass pinLabelDbClass = EditPinLabelUI.this.mDb.getDbClass(PinLabel.class);
                assert (pinLabelDbClass != null);
                DbFieldDef field = pinLabelDbClass.getField(fieldName);
                EditPinLabelPanel.this.mTableEditorView.initAttributeCol(field);
            }

            private EventHandler<javafx.event.ActionEvent> newDeleteAttributeAction() {
                return e -> {
                    DbClass pinLabelDbClass = EditPinLabelUI.this.mDb.getDbClass(PinLabel.class);
                    if (pinLabelDbClass == null) {
                        return;
                    }
                    HashSet cols = new HashSet();
                    HashSet fieldNames = new HashSet();
                    EditPinLabelPanel.this.mTableEditorView.getSelectedCells().forEach(cell -> {
                        EditorTableView.EditorTableColumn col = (EditorTableView.EditorTableColumn)cell.getTableColumn();
                        String fieldName = col.getTitle();
                        DbFieldDef field = pinLabelDbClass.getField(fieldName);
                        if (field != null && field.getIsSoft()) {
                            cols.add(col);
                            fieldNames.add(fieldName);
                        }
                    });
                    SwingUtilities.invokeLater(() -> {
                        this.deleteSoftFields(fieldNames);
                        Platform.runLater(() -> {
                            cols.forEach(EditPinLabelPanel.this.mTableEditorView::removeColumn);
                            EditPinLabelPanel.this.mTableEditorView.refreshFocus();
                        });
                    });
                };
            }

            private void deleteSoftFields(Set<String> fieldNames) {
                try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)EditPinLabelUI.this.getDb(), (String)DELETE_ATTRIBUTE_STR);){
                    fieldNames.forEach(this::cpRemoveSoftField);
                }
            }

            private void cpRemoveSoftField(String fName) {
                Cp.exec((String)"com.sigrity.acl.db.std.PinLabel.deleteAttribute(curDb(), \"%s\")", (Object[])new Object[]{fName});
            }

            private EventHandler<javafx.event.ActionEvent> newImportAction() {
                return e -> {
                    AJFXFileChooser fileChooser = new AJFXFileChooser(IMPORT_PIN_LABEL_STR);
                    fileChooser.addChoosableFileFilter(AJFXFileChooser.CSV_FILE_FILTER);
                    File file = fileChooser.showOpenDialog((Window)((Object)EditPinLabelUI.this));
                    if (file != null) {
                        SwingUtilities.invokeLater(() -> {
                            this.cpImportCsv(file.getPath());
                            Platform.runLater(() -> {
                                PinLabel.getAttirbutes((Db)EditPinLabelUI.this.getDb()).forEach(field -> {
                                    if (EditPinLabelPanel.this.mTableEditorView.getColumn((DbFieldDef)field) == null) {
                                        EditPinLabelPanel.this.mTableEditorView.initAttributeCol((DbFieldDef)field);
                                    }
                                });
                                EditPinLabelPanel.this.mTableEditorView.refreshFocus();
                            });
                        });
                    }
                };
            }

            private void cpImportCsv(String filePath) {
                Cp.exec((String)"unset(\"_importCsv\")", (Object[])new Object[0]);
                Cp.exec((String)"_importCsv = new com.sigrity.orbit.pin_label.PinLabelImport(%s)", (Object[])new Object[]{CpHelper.getObjCmdStr(EditPinLabelPanel.this.getTargetDevT())});
                Cp.exec((String)"_importCsv.importCsv(\"%s\")", (Object[])new Object[]{filePath});
                Cp.exec((String)"unset(\"_importCsv\")", (Object[])new Object[0]);
            }

            private EventHandler<javafx.event.ActionEvent> newExportAction() {
                return e -> {
                    AJFXFileChooser fileChooser = new AJFXFileChooser(EXPORT_PIN_LABEL_STR);
                    fileChooser.addChoosableFileFilter(AJFXFileChooser.CSV_FILE_FILTER);
                    File file = fileChooser.showSaveDialog((Window)((Object)EditPinLabelUI.this));
                    if (file != null) {
                        SwingUtilities.invokeLater(() -> this.cpExportCsv(file.getPath()));
                    }
                };
            }

            private void cpExportCsv(String filePath) {
                Cp.exec((String)"unset(\"_exportCsv\")", (Object[])new Object[0]);
                Cp.exec((String)"_exportCsv = new com.sigrity.orbit.pin_label.PinLabelExport(%s)", (Object[])new Object[]{CpHelper.getObjCmdStr(EditPinLabelPanel.this.getTargetDevT())});
                Cp.exec((String)"_exportCsv.exportCsv(\"%s\")", (Object[])new Object[]{filePath});
                Cp.exec((String)"unset(\"_exportCsv\")", (Object[])new Object[0]);
            }

            private void showMe(DevicePath path, List<PinLabel> pinLabels) {
                for (PinLabel pl : pinLabels) {
                    this.showMe(path, pl);
                }
            }

            private void showMe(DevicePath devPath, PinLabel pinLabel) {
                ShowMeTheWay.addPinLabel(devPath, pinLabel);
            }

            private void select(DevicePath path, List<PinLabel> pinLabels) {
                for (PinLabel pl : pinLabels) {
                    this.select(path, pl);
                }
            }

            private void select(DevicePath devPath, PinLabel pinLabel) {
                Selection curSelection = Selection.getCurrentSelectionForDb((Db)EditPinLabelUI.this.mDb);
                devPath.getAllFullPaths().filter(path -> !curSelection.contains(path, (DbObject)pinLabel)).forEach(path -> curSelection.add(path, (DbObject)pinLabel));
            }

            private void addSeparator() {
                this.getChildren().add((Object)Separators.newToolbarSeparator());
            }
        }
    }
}

