/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.table_editor;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.jfxui.AJFXAlerts;
import com.sigrity.acl.jfxui.AJFXButton;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.CloseHBox;
import com.sigrity.acl.jfxui.Separators;
import com.sigrity.acl.jfxui.SlowOperationAlert;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.jfxui.DevicePathTextBox;
import com.sigrity.orbit.jfxui.EditorTableView;
import com.sigrity.orbit.jfxui.OrbitJFXImages;
import com.sigrity.orbit.ui.CSVPinListUI;
import com.sigrity.orbit.ui.DbObjectDetailsUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.SetPinNetUI;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.orbit.ui.wb_route.PadStackDlg;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonType;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class EditPinUI
extends AJFXDesignDialog {
    private static final String ACTION_TITLE = "Pins Table";
    private static final String DIALOG_TITLE = "Pin Table Editor";
    private final DevicePath mInitDevPath;
    private final Set<PinTemplate.Type> mInitTypes;

    public static Action getAction() {
        return EditPinUI.getAction(null);
    }

    public static Action getAction(DevicePath devPath) {
        return EditPinUI.getAction(devPath, null);
    }

    public static Action getAction(final DevicePath devPath, final Set<PinTemplate.Type> initTypes) {
        return new AbstractAction(ACTION_TITLE, OrbitIcons.TABLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPinUI.createDialog(OrbitIO.getMainWindow(), OrbitIO.getCurDb(), devPath, initTypes);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static EditPinUI createDialog(Window owner, Db db, String devPathStr) {
        return EditPinUI.createDialog(owner, db, DevicePath.fromString((Db)db, (String)devPathStr), null);
    }

    public static EditPinUI createDialog(Window owner, Db db, DevicePath devPath, Set<PinTemplate.Type> initTypes) {
        if (db == null) {
            ALog.logError((String)"No design is open.");
            return null;
        }
        EditPinUI dlg = new EditPinUI(owner, db, devPath, initTypes);
        dlg.setVisible(true);
        return dlg;
    }

    private EditPinUI(Window owner, Db db, DevicePath devPath, Set<PinTemplate.Type> initTypes) {
        super(db, owner, DIALOG_TITLE);
        this.mInitDevPath = devPath;
        this.mInitTypes = initTypes;
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new EditPinPanel((Window)((Object)this), this.mInitDevPath, this.mInitTypes);
    }

    public static PinTableBodyPanel getEditPinPanel(Window owner, DevicePath path) {
        PinTableBodyPanel pinTableBodyPanel = new PinTableBodyPanel(owner, path, null);
        pinTableBodyPanel.init();
        return pinTableBodyPanel;
    }

    public static class PinTableBodyPanel
    extends AJFXPanel {
        private final Window mOwner;
        private final DevicePath mDevPath;
        private final Set<PinTemplate.Type> mInitTypes;
        private DevicePathTextBox mDevicePathTextBox;
        private PinTableView mPinTableView;

        protected PinTableBodyPanel(Window parent, DevicePath path, Set<PinTemplate.Type> initTypes) {
            this.mOwner = parent;
            this.mDevPath = path;
            this.mInitTypes = initTypes;
        }

        public void updateDevPath(DevicePath path) {
            this.mDevicePathTextBox.setDevicePath(path);
        }

        protected Parent initSceneGraph() {
            VBox pane = new VBox(5.0);
            this.mDevicePathTextBox = new DevicePathTextBox(this.mOwner, this.mDevPath){

                @Override
                protected void refreshAssociateNodes() {
                    mPinTableView.reloadItems();
                }
            };
            this.mPinTableView = new PinTableView(this.mOwner, this.mInitTypes, this.mDevicePathTextBox);
            Toolbar mToolbar = new Toolbar(this.mOwner, this.mPinTableView, this.mDevicePathTextBox);
            VBox.setVgrow((Node)this.mDevicePathTextBox, (Priority)Priority.NEVER);
            pane.getChildren().add((Object)this.mDevicePathTextBox);
            VBox.setVgrow((Node)mToolbar, (Priority)Priority.NEVER);
            pane.getChildren().add((Object)mToolbar);
            VBox.setVgrow((Node)this.mPinTableView, (Priority)Priority.ALWAYS);
            pane.getChildren().add((Object)this.mPinTableView);
            return pane;
        }

        private static class PinTableView
        extends EditorTableView<PinTemplate> {
            private Window mOwner;
            private Set<PinTemplate.Type> mInitTypes;
            private DevicePathTextBox mDevicePathTextBox;

            public PinTableView(Window owner, Set<PinTemplate.Type> types, DevicePathTextBox pathBox) {
                this.mOwner = owner;
                this.mInitTypes = types;
                this.mDevicePathTextBox = pathBox;
                this.reloadItems();
                this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
                this.getSelectionModel().setCellSelectionEnabled(true);
                this.setEditable(true);
                this.setSortedComparator(PinTemplate.CompareByDevTAndName);
            }

            @Override
            protected List<PinTemplate> getItemList() {
                DeviceTemplate devT = this.getTargetDevT();
                if (devT == null) {
                    return Collections.emptyList();
                }
                return AUtil.arrayList((Iterator)devT.getPins());
            }

            @Override
            protected void initHeader() {
                this.initRowNumCol();
                this.initNameCol();
                this.initNetCol();
                this.initPadStackCol();
                this.initTypeCol();
                this.initUseCol();
                this.initDirectionCol();
            }

            private void initRowNumCol() {
                this.addNewRowNumCol();
            }

            private void initNameCol() {
                EditorTableView.EditorTableColumn<String> col = this.addNewEditorTableColumn("Name", name -> name, PinTemplate::getName);
                col.setCellValueFactory(col.newReadOnlyStringFactory());
                col.setCellFactory(TextFieldTableCell.forTableColumn());
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<PinTemplate, String>>(){

                    public void handle(TableColumn.CellEditEvent<PinTemplate, String> t) {
                        PinTemplate pinT = (PinTemplate)t.getTableView().getItems().get(t.getTablePosition().getRow());
                        String newName = (String)t.getNewValue();
                        DeviceTemplate devT = this.getTargetDevT();
                        if (devT != null && devT.getPinByName(newName) == null) {
                            SwingUtilities.invokeLater(() -> this.cpSetPinName(pinT, newName));
                        } else if (!pinT.getName().equals(newName)) {
                            this.showSetNameAlert(newName);
                            t.getTableView().refresh();
                        }
                        t.getTableView().requestFocus();
                    }

                    private void showSetNameAlert(String newName) {
                        String headerTxt = String.format("Invalid pin name '%s'", newName);
                        String contactTxt = String.format("'%s' pin already exist", newName);
                        AJFXAlerts.showErrorAlert((Window)mOwner, (String)EditPinUI.DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
                    }

                    private void cpSetPinName(PinTemplate pin, String newName) {
                        Cp.exec((String)"%s.setName(\"%s\")", (Object[])new Object[]{CpHelper.getObjCmdStr(pin), newName});
                    }
                });
            }

            private void initNetCol() {
                EditorTableView.EditorTableColumn<Net> col = this.addNewEditorTableColumn("Net", Net::getName, PinTemplate::getNet);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                col.setCellFactory(col.newValueTextCellFactory(new NetMouseClickHandler()));
            }

            private void initPadStackCol() {
                EditorTableView.EditorTableColumn<PadTemplate> col = this.addNewEditorTableColumn("Pad Stack", PadTemplate::getName, PinTemplate::getPadTemplate);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                col.setCellFactory(col.newValueTextCellFactory(new PadStackMouseClickHandler()));
            }

            private void initTypeCol() {
                final EditorTableView.EditorTableColumn<PinTemplate.Type> col = this.addNewEditorTableColumn("Type", Enum::name, PinTemplate::getType);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                ObservableList layerTypes = FXCollections.observableArrayList((Object[])PinTemplate.Type.values());
                col.setCellFactory(ComboBoxTableCell.forTableColumn((ObservableList)layerTypes));
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<PinTemplate, PinTemplate.Type>>(){

                    public void handle(TableColumn.CellEditEvent<PinTemplate, PinTemplate.Type> t) {
                        List<PinTemplate> selectedPins = this.getSelectedPins(col);
                        PinTemplate.Type newValue = (PinTemplate.Type)t.getNewValue();
                        SwingUtilities.invokeLater(() -> {
                            selectedPins.forEach(layer -> this.cpSetPinType((PinTemplate)layer, newValue));
                            this.refreshFocusLater();
                        });
                    }

                    private void cpSetPinType(PinTemplate pin, PinTemplate.Type newValue) {
                        Cp.exec((String)"%s.setType(%s.%s)", (Object[])new Object[]{CpHelper.getObjCmdStr(pin), PinTemplate.Type.class.getName(), newValue});
                    }
                });
                if (this.mInitTypes != null) {
                    col.setAllShow(false);
                    this.mInitTypes.forEach(type -> col.setItemShow((PinTemplate.Type)type, true));
                }
            }

            private void initUseCol() {
                final EditorTableView.EditorTableColumn<PinTemplate.Use> col = this.addNewEditorTableColumn("Use", Enum::name, PinTemplate::getUse);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                ObservableList layerTypes = FXCollections.observableArrayList((Object[])PinTemplate.Use.values());
                col.setCellFactory(ComboBoxTableCell.forTableColumn((ObservableList)layerTypes));
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<PinTemplate, PinTemplate.Use>>(){

                    public void handle(TableColumn.CellEditEvent<PinTemplate, PinTemplate.Use> t) {
                        List<PinTemplate> selectedPins = this.getSelectedPins(col);
                        PinTemplate.Use newValue = (PinTemplate.Use)t.getNewValue();
                        SwingUtilities.invokeLater(() -> {
                            selectedPins.forEach(layer -> this.cpSetPinUse((PinTemplate)layer, newValue));
                            this.refreshFocusLater();
                        });
                    }

                    private void cpSetPinUse(PinTemplate pin, PinTemplate.Use newValue) {
                        Cp.exec((String)"%s.setUse(%s.%s)", (Object[])new Object[]{CpHelper.getObjCmdStr(pin), PinTemplate.Use.class.getName(), newValue});
                    }
                });
            }

            private void initDirectionCol() {
                final EditorTableView.EditorTableColumn<PinTemplate.Direction> col = this.addNewEditorTableColumn("Direction", Enum::name, PinTemplate::getDirection);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                ObservableList layerTypes = FXCollections.observableArrayList((Object[])PinTemplate.Direction.values());
                col.setCellFactory(ComboBoxTableCell.forTableColumn((ObservableList)layerTypes));
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<PinTemplate, PinTemplate.Direction>>(){

                    public void handle(TableColumn.CellEditEvent<PinTemplate, PinTemplate.Direction> t) {
                        List<PinTemplate> selectedPins = this.getSelectedPins(col);
                        PinTemplate.Direction newValue = (PinTemplate.Direction)t.getNewValue();
                        SwingUtilities.invokeLater(() -> {
                            selectedPins.forEach(layer -> this.cpSetPinUse((PinTemplate)layer, newValue));
                            this.refreshFocusLater();
                        });
                    }

                    private void cpSetPinUse(PinTemplate pin, PinTemplate.Direction newValue) {
                        Cp.exec((String)"%s.setDirection(%s.%s)", (Object[])new Object[]{CpHelper.getObjCmdStr(pin), PinTemplate.Direction.class.getName(), newValue});
                    }
                });
            }

            @Override
            protected void bindKeys() {
            }

            private List<PinTemplate> getSelectedPins(TableColumn<PinTemplate, ?> col) {
                return this.getSelectionModel().getSelectedCells().stream().filter(cell -> cell.getTableColumn() == col).map(cell -> (PinTemplate)this.getItems().get(cell.getRow())).collect(Collectors.toList());
            }

            private DevicePath getTargetDevicePath() {
                if (this.mDevicePathTextBox == null) {
                    return null;
                }
                return this.mDevicePathTextBox.getDevicePath();
            }

            private DeviceTemplate getTargetDevT() {
                DevicePath path = this.getTargetDevicePath();
                return path == null ? null : path.getDeviceTemplate();
            }

            private WindowAdapter newCloseRefreshWindowListener() {
                return new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        this.refreshFocusLater();
                    }
                };
            }

            private class PadStackMouseClickHandler
            implements EditorTableView.MouseClickHandler<PinTemplate, PadTemplate> {
                private PadStackMouseClickHandler() {
                }

                @Override
                public void handle(TableCell<PinTemplate, PadTemplate> tableCell) {
                    PadTemplate padT = (PadTemplate)tableCell.getItem();
                    SwingUtilities.invokeLater(() -> {
                        PadStackDlg dlg = PadStackDlg.createDialog(PinTableView.this.mOwner, PinTableView.this.getTargetDevicePath(), padT);
                        dlg.addWindowListener(PinTableView.this.newCloseRefreshWindowListener());
                        PinTableView.this.refreshFocusLater();
                    });
                }
            }

            private class NetMouseClickHandler
            implements EditorTableView.MouseClickHandler<PinTemplate, Net> {
                private NetMouseClickHandler() {
                }

                @Override
                public void handle(TableCell<PinTemplate, Net> tableCell) {
                    PinTemplate pinT = (PinTemplate)tableCell.getTableRow().getItem();
                    HierInst hpin = HierInst.create((DevicePath)PinTableView.this.getTargetDevicePath(), (DbObject)pinT);
                    SwingUtilities.invokeLater(() -> {
                        SetPinNetUI.SetPinNetDlg dlg = SetPinNetUI.SetPinNetDlg.createDialog(PinTableView.this.mOwner, (HierInst<PinTemplate>)hpin);
                        dlg.addWindowListener(PinTableView.this.newCloseRefreshWindowListener());
                        PinTableView.this.refreshFocusLater();
                    });
                }
            }
        }

        private static class Toolbar
        extends HBox {
            private final Window mOwner;
            private final PinTableView mPinTableView;
            private final DevicePathTextBox mDevicePathTextBox;

            public Toolbar(Window owner, PinTableView tableView, DevicePathTextBox pathBox) {
                this.mOwner = owner;
                this.mPinTableView = tableView;
                this.mDevicePathTextBox = pathBox;
                this.initImportBtn();
                this.initExportBtn();
                this.addSeparator();
                this.initZoomToBtn();
                this.initShowMeBtn();
                this.initSelectBtn();
                this.addSeparator();
                this.initDeleteBtn();
                this.addSeparator();
                this.initInformationBtn();
                this.setAlignment(Pos.CENTER_LEFT);
            }

            private void initImportBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.IMPORT, "Import CSV Pins...");
                btn.transparentBorder();
                btn.setOnAction(this.newImportAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newImportAction() {
                return e -> SwingUtilities.invokeLater(() -> {
                    CSVPinListUI.showPinInDlg(this.mDevicePathTextBox.getDevicePath());
                    Platform.runLater(() -> {
                        this.mPinTableView.reloadItems();
                        this.mPinTableView.requestFocus();
                        this.mPinTableView.clearSelection();
                    });
                });
            }

            private void initExportBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.EXPORT, "Export CSV Pins...");
                btn.transparentBorder();
                btn.setOnAction(this.newExportAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newExportAction() {
                return e -> SwingUtilities.invokeLater(() -> CSVPinListUI.showPinOutDlg(this.mDevicePathTextBox.getDevicePath()));
            }

            private void initDeleteBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.DELETE_ROW, "Delete pin");
                btn.transparentBorder();
                btn.setOnAction(this.newDeleteAction());
                this.getChildren().add((Object)btn);
            }

            private void initZoomToBtn() {
                AJFXButton zoomToBtn = new AJFXButton(OrbitJFXImages.ZOOM_FIT, "Zoom to");
                zoomToBtn.transparentBorder();
                zoomToBtn.setOnAction(this.newZoomToAction());
                this.getChildren().add((Object)zoomToBtn);
            }

            private void initShowMeBtn() {
                AJFXButton showMeBtn = new AJFXButton(OrbitJFXImages.SHOW_ME, "Show me");
                showMeBtn.transparentBorder();
                showMeBtn.setOnAction(this.newShowMeAction());
                this.getChildren().add((Object)showMeBtn);
            }

            private void initSelectBtn() {
                AJFXButton selectBtn = new AJFXButton(OrbitJFXImages.SELECT_PORT, "Select");
                selectBtn.transparentBorder();
                selectBtn.setOnAction(this.newSelectAction());
                this.getChildren().add((Object)selectBtn);
            }

            private void initInformationBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.INFORMATION, "Details");
                btn.transparentBorder();
                btn.setOnAction(this.newShowDetailsAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newDeleteAction() {
                return e -> {
                    DevicePath devPath = this.mDevicePathTextBox.getDevicePath();
                    ObservableList items = this.mPinTableView.getSelectedItems();
                    if (devPath == null || items == null || items.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        int count = items.size();
                        Cp.exec((String)"_curSelection = OrbitIO.getCurDesign().getCurSelection();", (Object[])new Object[0]);
                        Cp.exec((String)"_curSelection.clearSelection();", (Object[])new Object[0]);
                        StringBuilder sb = new StringBuilder();
                        for (PinTemplate i : items) {
                            PinInstance pinInst = devPath.getDevice().getPin(i);
                            sb.append(String.format("_curSelection.setSelected(\"%s\", \"%s\", true);", pinInst.getDbClass().getName(), pinInst.getKeyStr()));
                        }
                        Cp.exec((String)sb.toString(), (Object[])new Object[0]);
                        Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.DoPin.Start();", (Object[])new Object[0]);
                        Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.deleteSelected();", (Object[])new Object[0]);
                        Cp.exec((String)"unset(\"_curSelection\")", (Object[])new Object[0]);
                        ALog.logInfo((String)"Delete %d pin complete.", (Object[])new Object[]{count});
                        Platform.runLater(this.mPinTableView::reloadItems);
                    });
                };
            }

            private EventHandler<javafx.event.ActionEvent> newZoomToAction() {
                return e -> {
                    DevicePath pinPath = this.mDevicePathTextBox.getDevicePath();
                    PinTemplate pinT = (PinTemplate)this.mPinTableView.getSelectedItem();
                    if (pinPath == null || pinT == null) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.zoomTo(pinPath, pinT));
                };
            }

            private EventHandler<javafx.event.ActionEvent> newShowMeAction() {
                return e -> {
                    DevicePath pinPath = this.mDevicePathTextBox.getDevicePath();
                    ObservableList pinTs = this.mPinTableView.getSelectedItems();
                    if (pinPath == null || pinTs == null || pinTs.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.showMe(pinPath, (List<PinTemplate>)pinTs));
                };
            }

            private EventHandler<javafx.event.ActionEvent> newSelectAction() {
                return e -> {
                    DevicePath pinPath = this.mDevicePathTextBox.getDevicePath();
                    ObservableList pinTs = this.mPinTableView.getSelectedItems();
                    if (pinPath == null || pinTs == null || pinTs.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.select(pinPath, (List<PinTemplate>)pinTs));
                };
            }

            private EventHandler<javafx.event.ActionEvent> newShowDetailsAction() {
                return e -> {
                    Optional result;
                    ObservableList items = this.mPinTableView.getSelectedItems();
                    if (items == null || items.isEmpty()) {
                        return;
                    }
                    int itemCount = items.size();
                    if (itemCount > 10 && ((result = SlowOperationAlert.showLargeNumUIAlert((Window)this.mOwner, (int)itemCount)).isEmpty() || result.get() != ButtonType.OK)) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        for (PinTemplate i : items) {
                            DbObjectDetailsUI.show(this.mOwner, (DbObject)i, this.mDevicePathTextBox.getDevicePath(), OrbitIO.getCurView());
                        }
                    });
                };
            }

            private void zoomTo(DevicePath pinPath, PinTemplate pin) {
                ARect bounds = pin.getBounds().transform(pinPath.getAFullPath().getTransform()).getBounds();
                if (bounds == null) {
                    return;
                }
                this.zoomToArea(bounds);
            }

            private void zoomToArea(ARect bounds) {
                DesignView2D v = (DesignView2D)OrbitIO.getCurView();
                bounds.changeSizeBy(0.1);
                v.getCanvas().getXForm().setWorld(bounds);
                v.getCanvas().refresh();
                OrbitIO.getApp().refreshCurrentView(false);
            }

            private void showMe(DevicePath pinPath, List<PinTemplate> pinTs) {
                for (PinTemplate pinT : pinTs) {
                    this.showMe(pinPath, pinT);
                }
            }

            private void showMe(DevicePath pinPath, PinTemplate pin) {
                for (PortTemplate port : pin.getPortTemplates()) {
                    this.showMe(pinPath, port);
                }
            }

            private void showMe(DevicePath portPath, PortTemplate port) {
                for (DevicePath path : (List)portPath.getAllFullPaths().collect(Collectors.toList())) {
                    ShowMeTheWay.addHierPort(path, port);
                }
            }

            private void select(DevicePath pinPath, List<PinTemplate> pinTs) {
                for (PinTemplate pinT : pinTs) {
                    this.select(pinPath, pinT);
                }
            }

            private void select(DevicePath pinPath, PinTemplate pin) {
                Selection curSelection = Selection.getCurrentSelectionForDb((Db)OrbitApp.getCurDb());
                pinPath.getAllFullPaths().filter(path -> !curSelection.contains(path, (DbObject)pin.getPinInstance(path))).forEach(path -> curSelection.add(path, (DbObject)pin.getPinInstance(path)));
            }

            private void addSeparator() {
                this.getChildren().add((Object)Separators.newToolbarSeparator());
            }
        }
    }

    private static class EditPinPanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 600;
        private static final int PANEL_HEIGHT = 530;
        private final PinTableBodyPanel mPinTableBodyPanel;

        public EditPinPanel(Window owner, DevicePath path, Set<PinTemplate.Type> types) {
            this.mPinTableBodyPanel = new PinTableBodyPanel(owner, path, types);
            this.setPreferredSize(new Dimension(600, 530));
        }

        protected Parent initSceneGraph() {
            VBox root = (VBox)this.mPinTableBodyPanel.initSceneGraph();
            CloseHBox closeBox = new CloseHBox(this.mPinTableBodyPanel.mOwner);
            root.getChildren().add((Object)closeBox);
            return root;
        }
    }
}

