/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.table_editor;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.jfxui.AJFXAlerts;
import com.sigrity.acl.jfxui.AJFXButton;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.CloseHBox;
import com.sigrity.acl.jfxui.Separators;
import com.sigrity.acl.jfxui.SlowOperationAlert;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.NetGraphPanel;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.jfxui.DevicePathTextBox;
import com.sigrity.orbit.jfxui.EditorTableView;
import com.sigrity.orbit.jfxui.OrbitJFXImages;
import com.sigrity.orbit.term.ui.TermMapCsvExportUI;
import com.sigrity.orbit.term.ui.TermMapCsvImportUI;
import com.sigrity.orbit.ui.DbObjectDetailsUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonType;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class EditTermUI
extends AJFXDesignDialog {
    private static final String ACTION_TITLE = "Terms Table";
    private static final String DIALOG_TITLE = "Term Table Editor";
    private final DevicePath mInitDevPath;

    public static Action getAction() {
        return EditTermUI.getAction(null);
    }

    public static Action getAction(final DevicePath devPath) {
        return new AbstractAction(ACTION_TITLE, OrbitIcons.TABLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditTermUI.createDialog(OrbitIO.getMainWindow(), OrbitIO.getCurDb(), devPath);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static EditTermUI createDialog(Window owner, Db db, String devPathStr) {
        return EditTermUI.createDialog(owner, db, DevicePath.fromString((Db)db, (String)devPathStr));
    }

    public static EditTermUI createDialog(Window owner, Db db, DevicePath devPath) {
        if (db == null) {
            ALog.logError((String)"No design is open.");
            return null;
        }
        EditTermUI dlg = new EditTermUI(owner, db, devPath);
        dlg.setVisible(true);
        return dlg;
    }

    private EditTermUI(Window owner, Db db, DevicePath devPath) {
        super(db, owner, DIALOG_TITLE);
        this.mInitDevPath = devPath;
        this.init();
    }

    public static TermTableBodyPanel getEditTermPanel(Window owner, DevicePath path) {
        TermTableBodyPanel termTableBodyPanel = new TermTableBodyPanel(owner, path);
        termTableBodyPanel.init();
        return termTableBodyPanel;
    }

    protected AJFXPanel createJfxPanel() {
        return new EditTermPanel((Window)((Object)this), this.mInitDevPath);
    }

    public static class TermTableBodyPanel
    extends AJFXPanel {
        private DevicePathTextBox mDevicePathTextBox;
        private TermTableView mTermTableView;
        private final Window mOwner;
        private final DevicePath mDevPath;

        protected TermTableBodyPanel(Window owner, DevicePath path) {
            this.mOwner = owner;
            this.mDevPath = path;
        }

        public void updateDevPath(DevicePath path) {
            this.mDevicePathTextBox.setDevicePath(path);
        }

        protected Parent initSceneGraph() {
            VBox pane = new VBox(5.0);
            this.mDevicePathTextBox = new DevicePathTextBox(this.mOwner, this.mDevPath){

                @Override
                protected void refreshAssociateNodes() {
                    mTermTableView.reloadItems();
                }
            };
            this.mTermTableView = new TermTableView(this.mOwner, this.mDevicePathTextBox);
            Toolbar toolbar = new Toolbar(this.mOwner, this.mTermTableView, this.mDevicePathTextBox);
            VBox.setVgrow((Node)this.mDevicePathTextBox, (Priority)Priority.NEVER);
            pane.getChildren().add((Object)this.mDevicePathTextBox);
            VBox.setVgrow((Node)toolbar, (Priority)Priority.NEVER);
            pane.getChildren().add((Object)toolbar);
            VBox.setVgrow((Node)this.mTermTableView, (Priority)Priority.ALWAYS);
            pane.getChildren().add((Object)this.mTermTableView);
            return pane;
        }

        private static class TermTableView
        extends EditorTableView<Term> {
            private final DevicePathTextBox mDevicePathTextBox;
            private final Window mOwner;

            public TermTableView(Window owner, DevicePathTextBox pathBox) {
                this.mDevicePathTextBox = pathBox;
                this.mOwner = owner;
                this.reloadItems();
                this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
                this.getSelectionModel().setCellSelectionEnabled(true);
                this.setEditable(true);
                this.setSortedComparator(Term.NAME_COMPARATOR);
            }

            @Override
            protected List<Term> getItemList() {
                DeviceTemplate devT = this.getTargetDevT();
                if (devT == null) {
                    return Collections.emptyList();
                }
                return AUtil.arrayList((Iterator)devT.getTerms());
            }

            @Override
            protected void initHeader() {
                this.initRowNumCol();
                this.initNameCol();
                this.initNetCol();
                this.initTypeCol();
                this.initUseCol();
            }

            @Override
            protected void bindKeys() {
            }

            private void initRowNumCol() {
                this.addNewRowNumCol();
            }

            private void initNameCol() {
                EditorTableView.EditorTableColumn<String> col = this.addNewEditorTableColumn("Name", name -> name, Term::getName);
                col.setCellValueFactory(col.newReadOnlyStringFactory());
                col.setCellFactory(TextFieldTableCell.forTableColumn());
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Term, String>>(){

                    public void handle(TableColumn.CellEditEvent<Term, String> t) {
                        Term term = (Term)t.getTableView().getItems().get(t.getTablePosition().getRow());
                        DeviceTemplate devT = this.getTargetDevT();
                        String newName = (String)t.getNewValue();
                        if (devT != null && devT.getTerm(newName) == null) {
                            SwingUtilities.invokeLater(() -> this.cpSetName(term, newName));
                        } else if (!term.getName().equals(newName)) {
                            this.showSetNameAlert(newName);
                            t.getTableView().refresh();
                        }
                        t.getTableView().requestFocus();
                    }

                    private void showSetNameAlert(String newName) {
                        String headerTxt = String.format("Invalid term name '%s'", newName);
                        String contactTxt = String.format("'%s' term already exist", newName);
                        AJFXAlerts.showErrorAlert((Window)mOwner, (String)EditTermUI.DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
                    }

                    private void cpSetName(Term term, String newName) {
                        Cp.exec((String)"%s.setName(\"%s\")", (Object[])new Object[]{CpHelper.getObjCmdStr(term), newName});
                    }
                });
            }

            private void initNetCol() {
                EditorTableView.EditorTableColumn<Net> col = this.addNewEditorTableColumn("Net", Net::getName, Term::getNet);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                col.setCellFactory(col.newValueTextCellFactory());
            }

            private void initTypeCol() {
                EditorTableView.EditorTableColumn<Term.Type> col = this.addNewEditorTableColumn("Type", Term.Type::getUserName, Term::getType);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                ObservableList uses = FXCollections.observableArrayList((Object[])Term.Type.values());
                col.setCellFactory(ComboBoxTableCell.forTableColumn((ObservableList)uses));
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Term, Term.Type>>(){

                    public void handle(TableColumn.CellEditEvent<Term, Term.Type> t) {
                        ObservableList selectedItems = this.getSelectedItems();
                        Term.Type newValue = (Term.Type)t.getNewValue();
                        SwingUtilities.invokeLater(() -> {
                            selectedItems.forEach(i -> this.cpSetType((Term)i, newValue));
                            this.refreshFocusLater();
                        });
                    }

                    private void cpSetType(Term item, Term.Type newValue) {
                        Cp.exec((String)"%s.setType(%s.%s)", (Object[])new Object[]{CpHelper.getObjCmdStr(item), Term.Type.class.getName(), newValue});
                    }
                });
            }

            private void initUseCol() {
                EditorTableView.EditorTableColumn<Term.Use> col = this.addNewEditorTableColumn("Use", Enum::name, Term::getUse);
                col.setSortable(false);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                ObservableList uses = FXCollections.observableArrayList((Object[])Term.Use.values());
                col.setCellFactory(ComboBoxTableCell.forTableColumn((ObservableList)uses));
                col.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Term, Term.Use>>(){

                    public void handle(TableColumn.CellEditEvent<Term, Term.Use> t) {
                        ObservableList selectedItems = this.getSelectedItems();
                        Term.Use newValue = (Term.Use)t.getNewValue();
                        SwingUtilities.invokeLater(() -> {
                            selectedItems.forEach(i -> this.cpSetUse((Term)i, newValue));
                            this.refreshFocusLater();
                        });
                    }

                    private void cpSetUse(Term item, Term.Use newValue) {
                        Cp.exec((String)"%s.setUse(%s.%s)", (Object[])new Object[]{CpHelper.getObjCmdStr(item), Term.Use.class.getName(), newValue});
                    }
                });
            }

            private DevicePath getTargetDevPath() {
                if (this.mDevicePathTextBox == null) {
                    return null;
                }
                return this.mDevicePathTextBox.getDevicePath();
            }

            private DeviceTemplate getTargetDevT() {
                DevicePath path = this.getTargetDevPath();
                return path == null ? null : path.getDeviceTemplate();
            }
        }

        private static class Toolbar
        extends HBox {
            private final Window mOwner;
            private final TermTableView mTermTableView;
            private final DevicePathTextBox mDevicePathTextBox;

            public Toolbar(Window owner, TermTableView tableView, DevicePathTextBox pathBox) {
                this.mDevicePathTextBox = pathBox;
                this.mOwner = owner;
                this.mTermTableView = tableView;
                this.initImportBtn();
                this.initExportBtn();
                this.addSeparator();
                this.initZoomToBtn();
                this.initShowMeBtn();
                this.initSelectBtn();
                this.addSeparator();
                this.initDeleteBtn();
                this.addSeparator();
                this.initGraphNetBtn();
                this.initInformationBtn();
                this.setAlignment(Pos.CENTER_LEFT);
            }

            private void initImportBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.IMPORT, "Import TermMap CSV");
                btn.transparentBorder();
                btn.setOnAction(this.newImportAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newImportAction() {
                return e -> SwingUtilities.invokeLater(() -> {
                    TermMapCsvImportUI.showUI(this.mOwner, this.mDevicePathTextBox.getDevicePath().getDeviceTemplate());
                    Platform.runLater(() -> {
                        this.mTermTableView.reloadItems();
                        this.mTermTableView.requestFocus();
                        this.mTermTableView.clearSelection();
                    });
                });
            }

            private void initExportBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.EXPORT, "Export TermMap CSV");
                btn.transparentBorder();
                btn.setOnAction(this.newExportAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newExportAction() {
                return e -> SwingUtilities.invokeLater(() -> TermMapCsvExportUI.showUI(this.mDevicePathTextBox.getDevicePath().getDeviceTemplate()));
            }

            private void initDeleteBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.DELETE_ROW, "Delete term");
                btn.transparentBorder();
                btn.setOnAction(this.newDeleteAction());
                this.getChildren().add((Object)btn);
            }

            private void initZoomToBtn() {
                AJFXButton zoomToBtn = new AJFXButton(OrbitJFXImages.ZOOM_FIT, "Zoom to");
                zoomToBtn.transparentBorder();
                zoomToBtn.setOnAction(this.newZoomToAction());
                this.getChildren().add((Object)zoomToBtn);
            }

            private void initShowMeBtn() {
                AJFXButton showMeBtn = new AJFXButton(OrbitJFXImages.SHOW_ME, "Show me");
                showMeBtn.transparentBorder();
                showMeBtn.setOnAction(this.newShowMeAction());
                this.getChildren().add((Object)showMeBtn);
            }

            private void initSelectBtn() {
                AJFXButton selectBtn = new AJFXButton(OrbitJFXImages.SELECT_DEVICE, "Select");
                selectBtn.transparentBorder();
                selectBtn.setOnAction(this.newSelectAction());
                this.getChildren().add((Object)selectBtn);
            }

            private void initGraphNetBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.GRAPHNET, "Graph net");
                btn.transparentBorder();
                btn.setOnAction(this.newShowGraphNetAction());
                this.getChildren().add((Object)btn);
            }

            private void initInformationBtn() {
                AJFXButton btn = new AJFXButton(OrbitJFXImages.INFORMATION, "Details");
                btn.transparentBorder();
                btn.setOnAction(this.newShowDetailsAction());
                this.getChildren().add((Object)btn);
            }

            private EventHandler<javafx.event.ActionEvent> newDeleteAction() {
                return e -> {
                    DevicePath devPath = this.mDevicePathTextBox.getDevicePath();
                    ObservableList items = this.mTermTableView.getSelectedItems();
                    if (devPath == null || items == null || items.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        ArrayList deletedItems = AUtil.arrayList((Collection)items);
                        int count = items.size();
                        for (Term selectedItem : deletedItems) {
                            CpHelper.cpDbObjectDelete((DbObject)selectedItem);
                        }
                        ALog.logInfo((String)"Delete %d term complete.", (Object[])new Object[]{count});
                        Platform.runLater(this.mTermTableView::reloadItems);
                    });
                };
            }

            private EventHandler<javafx.event.ActionEvent> newZoomToAction() {
                return e -> {
                    Term pinT = (Term)this.mTermTableView.getSelectedItem();
                    if (this.mDevicePathTextBox.getDevicePath() == null || pinT == null) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.zoomTo(this.mDevicePathTextBox.getDevicePath(), pinT));
                };
            }

            private void zoomTo(DevicePath devPath, Term term) {
                ARect bounds = null;
                IterableIterator pinLabelItr = PinLabel.get((Term)term);
                while (pinLabelItr.hasNext()) {
                    PinLabel pinLabel = (PinLabel)pinLabelItr.next();
                    DevicePath pinPath = new DevicePath(devPath, pinLabel.getPinPath());
                    PinTemplate pinT = pinLabel.getPin();
                    ARect pinBounds = pinT.getBounds().transform(pinPath.getTransform()).getBounds();
                    if (bounds == null) {
                        bounds = pinBounds;
                        continue;
                    }
                    bounds.expand(pinBounds);
                }
                if (bounds == null) {
                    return;
                }
                this.zoomToArea(bounds);
            }

            private void zoomToArea(ARect bounds) {
                DesignView2D v = (DesignView2D)OrbitIO.getCurView();
                bounds.changeSizeBy(0.1);
                v.getCanvas().getXForm().setWorld(bounds);
                v.getCanvas().refresh();
                OrbitIO.getApp().refreshCurrentView(false);
            }

            private EventHandler<javafx.event.ActionEvent> newShowMeAction() {
                return e -> {
                    ObservableList terms = this.mTermTableView.getSelectedItems();
                    if (this.mDevicePathTextBox.getDevicePath() == null || terms == null || terms.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.showMe(this.mDevicePathTextBox.getDevicePath(), (List<Term>)terms));
                };
            }

            private EventHandler<javafx.event.ActionEvent> newSelectAction() {
                return e -> {
                    ObservableList terms = this.mTermTableView.getSelectedItems();
                    if (this.mDevicePathTextBox.getDevicePath() == null || terms == null || terms.isEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> this.select(this.mDevicePathTextBox.getDevicePath(), (List<Term>)terms));
                };
            }

            private void showMe(DevicePath path, List<Term> terms) {
                for (Term term : terms) {
                    this.showMe(path, term);
                }
            }

            private void showMe(DevicePath devPath, Term term) {
                ShowMeTheWay.addHierTerm(devPath, term);
            }

            private void select(DevicePath path, List<Term> terms) {
                for (Term net : terms) {
                    this.select(path, net);
                }
            }

            private void select(DevicePath netPath, Term term) {
                Selection curSelection = Selection.getCurrentSelectionForDb((Db)this.mDevicePathTextBox.getDevicePath().getDb());
                netPath.getAllFullPaths().filter(path -> !curSelection.contains(path, (DbObject)term)).forEach(path -> curSelection.add(path, (DbObject)term));
            }

            private EventHandler<javafx.event.ActionEvent> newShowGraphNetAction() {
                return e -> {
                    Optional result;
                    DevicePath devPath = this.mDevicePathTextBox.getDevicePath();
                    ObservableList terms = this.mTermTableView.getSelectedItems();
                    if (devPath == null || terms == null || terms.isEmpty()) {
                        return;
                    }
                    int count = terms.size();
                    if (count > 10 && ((result = SlowOperationAlert.showLargeNumUIAlert((Window)this.mOwner, (int)count)).isEmpty() || result.get() != ButtonType.OK)) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        for (Term term : terms) {
                            NetGraphPanel.showNetGraph(this.mOwner, devPath, term.getNet());
                        }
                    });
                };
            }

            private EventHandler<javafx.event.ActionEvent> newShowDetailsAction() {
                return e -> {
                    Optional result;
                    ObservableList items = this.mTermTableView.getSelectedItems();
                    if (items == null || items.isEmpty()) {
                        return;
                    }
                    int itemCount = items.size();
                    if (itemCount > 10 && ((result = SlowOperationAlert.showLargeNumUIAlert((Window)this.mOwner, (int)itemCount)).isEmpty() || result.get() != ButtonType.OK)) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        for (Term i : items) {
                            DbObjectDetailsUI.show(this.mOwner, (DbObject)i, this.mDevicePathTextBox.getDevicePath(), OrbitIO.getCurView());
                        }
                    });
                };
            }

            private void addSeparator() {
                this.getChildren().add((Object)Separators.newToolbarSeparator());
            }
        }
    }

    public static class EditTermPanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 600;
        private static final int PANEL_HEIGHT = 530;
        private final TermTableBodyPanel mTermTableBodyPanel;

        public EditTermPanel(Window owner, DevicePath path) {
            this.mTermTableBodyPanel = new TermTableBodyPanel(owner, path);
            this.setPreferredSize(new Dimension(600, 530));
        }

        protected Parent initSceneGraph() {
            VBox root = (VBox)this.mTermTableBodyPanel.initSceneGraph();
            CloseHBox closeBox = new CloseHBox(this.mTermTableBodyPanel.mOwner);
            root.getChildren().add((Object)closeBox);
            return root;
        }
    }
}

