/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.table_editor;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.jfxui.AJFXButton;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.CloseHBox;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.jfxui.EditorTableView;
import com.sigrity.orbit.jfxui.OrbitJFXImages;
import com.sigrity.orbit.jfxui.SubstrateChooser;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.orbit.ui.wb_route.PadStackDlg;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class EditViaUI
extends AJFXDesignDialog {
    private static final String ACTION_TITLE = "Vias Table";
    private static final String DIALOG_TITLE = "Via Table Editor";
    private static final Color ROUTE_LAYER_COLOR = Color.CHOCOLATE;
    private static final Color CUT_LAYER_COLOR = Color.GREEN;
    private static final Color ARTWORK_LAYER_COLOR = Color.DIMGRAY;
    private static final Color PAD_FILL_COLOR = Color.ORANGE;
    private static final Color PAD_STROKE_COLOR = Color.BLACK;
    private static final double LAYER_RECTANGLE_HEIGHT = 20.0;
    private static final double LAYER_NUM_WIDTH = 30.0;
    private static final double PAD_WIDTH = 20.0;
    private Substrate mInitSubstrate;

    public static Action getAction() {
        return EditViaUI.getAction(null);
    }

    public static Action getAction(final Substrate initSubstrate) {
        return new AbstractAction(ACTION_TITLE, OrbitIcons.TABLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditViaUI.createDialog(OrbitIO.getMainWindow(), OrbitIO.getCurDb(), initSubstrate);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null && OrbitIO.getCurDb().getObjects(Layer.class).hasNext();
            }
        };
    }

    public static EditViaUI createDialog(Window owner, Db db) {
        return EditViaUI.createDialog(owner, db, null);
    }

    public static EditViaUI createDialog(Window owner, Db db, Substrate initSubstrate) {
        if (db == null) {
            ALog.logError((String)"No design is open.");
            return null;
        }
        if (!db.getObjects(Layer.class).hasNext()) {
            ALog.logError((String)"No layer in the current design. Create a layer before edit via");
            return null;
        }
        Substrate.getSubstrates((Db)db).forEach(Substrate::validateLayerOrder);
        EditViaUI dlg = new EditViaUI(owner, db, initSubstrate);
        dlg.setVisible(true);
        return dlg;
    }

    private EditViaUI(Window owner, Db db, Substrate initSubstrate) {
        super(db, (Component)owner, DIALOG_TITLE, Dialog.ModalityType.APPLICATION_MODAL);
        this.mInitSubstrate = initSubstrate;
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new EditViaPanel();
    }

    private class EditViaPanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 800;
        private static final int PANEL_HEIGHT = 400;
        private SubstrateChooser mSubstrateBox;
        private Toolbar mToolbar;
        private SubstrateCanvas mSubstrateCanvas;
        private ViaTableView mViaTableView;

        public EditViaPanel() {
            this.setPreferredSize(new Dimension(800, 400));
        }

        protected Parent initSceneGraph() {
            VBox rootBox = new VBox(5.0);
            this.mSubstrateBox = new SubstrateChooser(EditViaUI.this.getDb(), EditViaUI.this.mInitSubstrate);
            rootBox.getChildren().add((Object)this.mSubstrateBox);
            this.mToolbar = new Toolbar();
            rootBox.getChildren().add((Object)this.mToolbar);
            SplitPane mainBox = new SplitPane();
            VBox.setVgrow((Node)mainBox, (Priority)Priority.ALWAYS);
            rootBox.getChildren().add((Object)mainBox);
            this.mViaTableView = new ViaTableView();
            mainBox.getItems().add((Object)this.mViaTableView);
            this.mSubstrateCanvas = new SubstrateCanvas();
            ScrollPane scrollPane = new ScrollPane();
            scrollPane.setContent((Node)this.mSubstrateCanvas);
            mainBox.getItems().add((Object)scrollPane);
            this.mSubstrateBox.setOnAction((EventHandler<javafx.event.ActionEvent>)((EventHandler)e -> this.refresh()));
            this.mViaTableView.addItemListChangeListener(e -> this.mSubstrateCanvas.reload());
            rootBox.getChildren().add((Object)new CloseHBox((Window)((Object)EditViaUI.this)));
            return rootBox;
        }

        private Substrate getSelectedSubstrate() {
            return this.mSubstrateBox.getSelectedSubstrate();
        }

        private void refreshLater() {
            Platform.runLater(this::refresh);
        }

        private void refresh() {
            this.mViaTableView.reloadItems();
            this.mSubstrateCanvas.reload();
        }

        private WindowAdapter newCloseRefreshWindowListener() {
            return new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    EditViaPanel.this.refreshLater();
                }
            };
        }

        private boolean isDrawLayer(Layer layer) {
            Layer.LayerType type = layer.getType();
            return type == Layer.LayerType.Route || type == Layer.LayerType.Signal || type == Layer.LayerType.Power || type == Layer.LayerType.Mixed || type == Layer.LayerType.Cut || type == Layer.LayerType.Dielectric;
        }

        private class ViaTableView
        extends EditorTableView<PadTemplate> {
            public ViaTableView() {
                this.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
                this.getSelectionModel().setCellSelectionEnabled(false);
                this.setRowFactory();
                this.setSortedComparator(PadTemplate.TopLayerSorter.reversed());
                this.reloadItems();
            }

            public List<PadTemplate> getVias() {
                return this.getItems();
            }

            @Override
            protected void initHeader() {
                this.initNumCol();
                this.initNameCol();
                this.initPadLayer();
            }

            private void initNumCol() {
                this.addNewRowNumCol();
            }

            private void initNameCol() {
                EditorTableView.EditorTableColumn<String> col = this.addNewEditorTableColumn("Name", n -> n, PadTemplate::getName);
                col.setCellValueFactory(col.newReadOnlyStringFactory());
            }

            protected void initPadLayer() {
                TableColumn layerCol = new TableColumn("Pad Layer");
                this.initTopLayerCol((TableColumn<PadTemplate, String>)layerCol);
                this.initBotLayerCol((TableColumn<PadTemplate, String>)layerCol);
                this.getColumns().add((Object)layerCol);
            }

            private void initTopLayerCol(TableColumn<PadTemplate, String> layerCol) {
                EditorTableView.EditorTableColumn<Layer> col = this.addNewEditorTableColumn("Top", Layer::getName, PadTemplate::getTopRoutableLayer, layerCol);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                col.setCellFactory(col.newValueTextCellFactory());
            }

            private void initBotLayerCol(TableColumn<PadTemplate, String> layerCol) {
                EditorTableView.EditorTableColumn<Layer> col = this.addNewEditorTableColumn("Bottom", Layer::getName, PadTemplate::getBottomRoutableLayer, layerCol);
                col.setCellValueFactory(col.newSimpleObjectFactory());
                col.setCellFactory(col.newValueTextCellFactory());
            }

            @Override
            protected List<PadTemplate> getItemList() {
                Substrate selectedSubstrate = EditViaPanel.this.getSelectedSubstrate();
                if (selectedSubstrate == null) {
                    return Collections.emptyList();
                }
                return EditViaUI.this.getDb().getObjects(PadTemplate.class).stream().filter(padT -> padT.getSubstrate() == selectedSubstrate).filter(this::isVia).sorted(PadTemplate.TopLayerSorter.reversed()).collect(Collectors.toList());
            }

            private boolean isVia(PadTemplate padT) {
                return padT.getLayers().stream().filter(x$0 -> EditViaPanel.this.isDrawLayer((Layer)x$0)).count() > 1L;
            }

            private void setRowFactory() {
                this.setRowFactory(tv -> {
                    TableRow row = new TableRow();
                    row.setOnMouseClicked(event -> {
                        if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2 && !row.isEmpty()) {
                            PadTemplate padT = (PadTemplate)row.getItem();
                            PadStackDlg dlg = PadStackDlg.createDialog((Window)((Object)EditViaUI.this), EditViaPanel.this.getSelectedSubstrate(), padT);
                            dlg.addWindowListener(EditViaPanel.this.newCloseRefreshWindowListener());
                        }
                    });
                    return row;
                });
            }

            @Override
            protected void bindKeys() {
            }
        }

        private class SubstrateCanvas
        extends GridPane {
            private Map<Layer, Integer> mLayer2GridY = new HashMap<Layer, Integer>();

            public SubstrateCanvas() {
                this.reload();
            }

            public void reload() {
                this.mLayer2GridY.clear();
                this.getChildren().clear();
                this.initLayers();
                this.intiVias();
            }

            private void initLayers() {
                this.setHgap(5.0);
                this.setVgap(3.0);
                this.setPadding(new Insets(5.0));
                int i = 1;
                int columnSpan = Math.max(this.getViaCount(), 5);
                double rectangleWidth = 30.0 * (double)columnSpan + this.getHgap() * (double)columnSpan;
                for (Layer l : this.getDrawLayers()) {
                    Label layerNameLabel = new Label(l.getName());
                    layerNameLabel.setMinWidth(Double.NEGATIVE_INFINITY);
                    this.add((Node)layerNameLabel, 0, i);
                    Rectangle r1 = new Rectangle(rectangleWidth, 20.0);
                    r1.setFill((Paint)this.getRectColor(l));
                    this.add((Node)r1, 1, i, columnSpan, 1);
                    this.mLayer2GridY.put(l, i);
                    ++i;
                }
            }

            private List<Layer> getDrawLayers() {
                return EditViaPanel.this.getSelectedSubstrate().getLayers().stream().filter(x$0 -> EditViaPanel.this.isDrawLayer((Layer)x$0)).sorted(Layer.TopFirstSort).collect(Collectors.toList());
            }

            private void intiVias() {
                int padTIndex = 0;
                for (PadTemplate padT : this.getVias()) {
                    int gridX = padTIndex + 1;
                    Label numLabel = new Label(Integer.toString(padTIndex));
                    numLabel.setMinWidth(30.0);
                    numLabel.setAlignment(Pos.CENTER);
                    GridPane.setHalignment((Node)numLabel, (HPos)HPos.CENTER);
                    this.add((Node)numLabel, gridX, 0);
                    this.drawTroughRect(gridX, padT);
                    this.drawPadRect(gridX, padT);
                    ++padTIndex;
                }
            }

            private void drawPadRect(int i, PadTemplate padT) {
                for (Layer l : padT.getLayers()) {
                    Integer layerIndex = this.mLayer2GridY.get(l);
                    if (layerIndex == null) continue;
                    Rectangle r = new Rectangle(this.getPadWidth(l), 20.0);
                    r.setFill((Paint)PAD_FILL_COLOR);
                    r.setStroke((Paint)PAD_STROKE_COLOR);
                    GridPane.setHalignment((Node)r, (HPos)HPos.CENTER);
                    this.add((Node)r, i, layerIndex);
                }
            }

            private double getPadWidth(Layer layer) {
                Layer.LayerType type = layer.getType();
                switch (type) {
                    case Route: 
                    case Signal: 
                    case Power: 
                    case Mixed: {
                        return 20.0;
                    }
                    case Cut: 
                    case Dielectric: {
                        return 10.0;
                    }
                }
                return 0.0;
            }

            private void drawTroughRect(int i, PadTemplate padT) {
                Layer topLayer = padT.getTopRoutableLayer();
                int topLayerY = this.mLayer2GridY.get(topLayer);
                Layer botLayer = padT.getBottomRoutableLayer();
                int botLayerY = this.mLayer2GridY.get(botLayer);
                int diffOrder = botLayerY - topLayerY + 1;
                double h = 20.0 * (double)diffOrder + this.getVgap() * (double)(diffOrder - 1);
                Rectangle r = new Rectangle(6.666666666666667, h);
                r.setFill((Paint)PAD_FILL_COLOR);
                r.setStroke((Paint)PAD_STROKE_COLOR);
                GridPane.setHalignment((Node)r, (HPos)HPos.CENTER);
                this.add((Node)r, i, topLayerY, 1, diffOrder);
            }

            private Color getRectColor(Layer layer) {
                Layer.LayerType type = layer.getType();
                switch (type) {
                    case Route: 
                    case Signal: 
                    case Power: 
                    case Mixed: {
                        return ROUTE_LAYER_COLOR;
                    }
                    case Cut: 
                    case Dielectric: {
                        return CUT_LAYER_COLOR;
                    }
                }
                return ARTWORK_LAYER_COLOR;
            }

            private int getViaCount() {
                return this.getVias().size();
            }

            private List<PadTemplate> getVias() {
                return EditViaPanel.this.mViaTableView.getVias();
            }
        }

        private class Toolbar
        extends HBox {
            private Toolbar() {
                this.getChildren().add((Object)this.newCreateNewPadBtn());
                this.getChildren().add((Object)this.newAutoCreateViaBtn());
            }

            private AJFXButton newCreateNewPadBtn() {
                String title = "Edit padstack";
                AJFXButton btn = new AJFXButton(OrbitJFXImages.EDIT, title);
                btn.transparentBorder();
                btn.setOnAction(e -> this.showPadStackDlg());
                return btn;
            }

            private void showPadStackDlg() {
                PadStackDlg dlg = PadStackDlg.createDialog((Window)((Object)EditViaUI.this), EditViaPanel.this.getSelectedSubstrate());
                dlg.addWindowListener(EditViaPanel.this.newCloseRefreshWindowListener());
            }

            private AJFXButton newAutoCreateViaBtn() {
                String title = "Auto-create via pads";
                AJFXButton btn = new AJFXButton(OrbitJFXImages.ADD_ROWS, title);
                btn.transparentBorder();
                btn.setOnAction(e -> SwingUtilities.invokeLater(() -> {
                    this.cpAutoCreateVia();
                    EditViaPanel.this.refreshLater();
                }));
                return btn;
            }

            private void cpAutoCreateVia() {
                try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)EditViaUI.this.getDb(), (String)"Auto-create via pads");){
                    Cp.exec((String)"_viaGenerator = new com.sigrity.orbit.automation.ViaGenerator(%s)", (Object[])new Object[]{CpHelper.getObjCmdStr(EditViaPanel.this.getSelectedSubstrate())});
                    Cp.exec((String)"_viaGenerator.execute()", (Object[])new Object[0]);
                    Cp.exec((String)"unset(\"_viaGenerator\");", (Object[])new Object[0]);
                }
            }
        }
    }
}

