/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AColorChooserDlg;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.SimpleConstraintFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class BondRingDefinitionEditDlg
extends ADialog {
    protected AAppView mView;
    protected Personality mPersonality = null;
    protected JTextField mTxtName;
    protected JTextField mFingerWidth;
    protected AColorIcon mIconColor;
    protected JRadioButton mMetalRing;
    protected JRadioButton mFingerRing;
    protected boolean mAccepted = false;
    protected SimpleConstraintFrame simpleConstraintFrame;
    protected boolean mSaveOnlyChanged;
    protected Substrate mSubstrate = null;
    protected BondRingDialogType mDialogType = null;
    protected ActionListener mChangeColor = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AColorChooserDlg ccd = AColorChooserDlg.createDialog((Component)((Object)BondRingDefinitionEditDlg.this), "Select Color", BondRingDefinitionEditDlg.this.mIconColor.getColor());
            ccd.setShowOpacity(true);
            Color c = ccd.doModal();
            if (c != null) {
                BondRingDefinitionEditDlg.this.mIconColor.setColor(c);
            }
        }
    };
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AFieldValidator.validateText((JTextComponent)BondRingDefinitionEditDlg.this.mTxtName);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            BondRingDefinitionEditDlg.this.apply();
            UIUtil.closeWindow((Window)((Object)BondRingDefinitionEditDlg.this));
        }
    };
    protected ActionListener mApply = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AFieldValidator.validateText((JTextComponent)BondRingDefinitionEditDlg.this.mTxtName);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            BondRingDefinitionEditDlg.this.apply();
        }
    };

    public static BondRingDefinitionEditDlg createDialog(Window owner, String title, Personality personality, Substrate substrate, boolean isAFinger, boolean saveOnlyChanged, BondRingDialogType dialogType) {
        BondRingDefinitionEditDlg dlg = null;
        dlg = new BondRingDefinitionEditDlg(owner);
        dlg.setTitle(title);
        dlg.init(personality, substrate, isAFinger, saveOnlyChanged, dialogType);
        return dlg;
    }

    public BondRingDefinitionEditDlg(Window owner) throws HeadlessException {
        super(owner);
        this.setRecallBounds(false);
    }

    public boolean getAccepted() {
        return this.mAccepted;
    }

    public String getPersonalityName() {
        return this.mTxtName.getText();
    }

    public Color getPersonalityColor() {
        return this.mIconColor.getColor();
    }

    protected void init(Personality personality, Substrate substrate, boolean isAFinger, boolean saveOnlyChanged, BondRingDialogType dialogType) {
        this.mView = OrbitIO.getCurView();
        this.mPersonality = personality;
        this.mSaveOnlyChanged = saveOnlyChanged;
        this.mSubstrate = substrate;
        this.mDialogType = dialogType;
        this.setTitle("Bond Ring Descriptor");
        GridBagManager l = new GridBagManager(this.getContentPane());
        Border etch = BorderFactory.createEtchedBorder();
        JPanel ringBasicPanel = new JPanel();
        ringBasicPanel.setBorder(BorderFactory.createTitledBorder(etch, "Ring Info"));
        l.push((Container)ringBasicPanel, (GridBagConstraints)GridBagManager.LEFT);
        l.add("Name:");
        this.mTxtName = new JTextField(20);
        this.mTxtName.setMinimumSize(this.getPreferredSize());
        l.add((Component)this.mTxtName, (GridBagConstraints)GridBagManager.LEFT);
        l.pop();
        l.newline();
        Constraint.DescriptorList descList = new Constraint.DescriptorList();
        if (isAFinger) {
            descList.add((Object)Constraint.RING_GEOM);
            descList.add((Object)Constraint.BOND_SIDE);
            descList.add((Object)Constraint.BONDFINGER_WIDTH);
            descList.add((Object)Constraint.BONDFINGER_LENGTH);
            descList.add((Object)Constraint.BONDFINGER_TIER_DIST);
            descList.add((Object)Constraint.BONDFINGER_ANGLE);
            descList.add((Object)Constraint.BONDMAX_LENGTH);
            descList.add((Object)Constraint.BONDMIN_LENGTH);
            descList.add((Object)Constraint.BONDFINGER_SEPARATION);
            descList.add((Object)Constraint.BONDWIRE_TO_BONDWIRE_CLR);
            descList.add((Object)Constraint.BONDMIN_ANGLE);
            descList.add((Object)Constraint.BONDWIRE_WIDTH);
            descList.add((Object)Constraint.WIREBOND_LAYER);
            descList.add((Object)Constraint.BONDFINGER_LAYER);
        } else {
            descList.add((Object)Constraint.METALRING_WIDTH);
            descList.add((Object)Constraint.METALRING_DIST);
            descList.add((Object)Constraint.BONDFINGER_SEPARATION);
            descList.add((Object)Constraint.BONDWIRE_TO_BONDWIRE_CLR);
            descList.add((Object)Constraint.BONDMIN_ANGLE);
            descList.add((Object)Constraint.BONDWIRE_WIDTH);
            descList.add((Object)Constraint.WIREBOND_LAYER);
            descList.add((Object)Constraint.BONDFINGER_LAYER);
        }
        this.simpleConstraintFrame = new SimpleConstraintFrame(descList, (DbObject)personality, substrate, dialogType);
        this.simpleConstraintFrame.setOpaque(true);
        l.add((Component)this.simpleConstraintFrame, (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnApply = new JButton("Apply");
        l.add((Component)btnApply, (GridBagConstraints)GridBagManager.RIGHT);
        btnApply.addActionListener(this.mApply);
        btnApply.setEnabled(this.mDialogType == BondRingDialogType.Edit);
        JButton btnOk = new JButton("OK");
        l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
        btnOk.addActionListener(this.mOk);
        JButton btnClose = new JButton("Cancel");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
        this.updateUI();
    }

    protected void updateUI() {
        if (this.mPersonality == null) {
            return;
        }
        this.mTxtName.setText(this.mPersonality.getName());
        this.mTxtName.setEnabled(false);
    }

    protected void apply() {
        block5: {
            block6: {
                block4: {
                    this.mAccepted = true;
                    if (this.mDialogType != BondRingDialogType.Edit) break block4;
                    this.simpleConstraintFrame.doSave((DbObject)this.mPersonality, this.mSubstrate, false);
                    Cp.exec((String)"com.sigrity.orbit.automation.wirebonder.WireBonder.unBondRing(\"%s\")", (Object[])new Object[]{this.mPersonality.getKeyStr()});
                    Cp.exec((String)"com.sigrity.orbit.automation.wirebonder.WireBonder.bondRing(\"%s\")", (Object[])new Object[]{this.mPersonality.getKeyStr()});
                    Cp.exec((String)"UserCommands.removeConnections();", (Object[])new Object[0]);
                    break block5;
                }
                if (this.mDialogType != BondRingDialogType.NewMetal) break block6;
                for (DeviceTemplate devTemp : this.mSubstrate.getDeviceTemplates()) {
                    if (devTemp.getType() != DeviceTemplate.Type.PACKAGE) continue;
                    Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.addWireBondRingDefinition(\"%s\",\"%s\")", (Object[])new Object[]{this.getPersonalityName(), devTemp.getKeyStr()});
                }
                for (DeviceTemplate devTemp : this.mSubstrate.getDeviceTemplates()) {
                    Optional pOpt;
                    if (devTemp.getType() != DeviceTemplate.Type.PACKAGE || !(pOpt = Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.BONDRING, (String)this.getPersonalityName())).isPresent()) continue;
                    Personality personality = (Personality)pOpt.get();
                    Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(\"%s\", \"%s\", \"BondRingType\", \"METAL\")", (Object[])new Object[]{personality.getDbClass().getName(), personality.getKeyStr()});
                    this.simpleConstraintFrame.doSave((DbObject)personality, this.mSubstrate, this.mSaveOnlyChanged);
                }
                break block5;
            }
            if (this.mDialogType != BondRingDialogType.NewFinger) break block5;
            for (DeviceTemplate devTemp : this.mSubstrate.getDeviceTemplates()) {
                if (devTemp.getType() != DeviceTemplate.Type.PACKAGE) continue;
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.addWireBondRingDefinition(\"%s\",\"%s\")", (Object[])new Object[]{this.getPersonalityName(), devTemp.getKeyStr()});
            }
            for (DeviceTemplate devTemp : this.mSubstrate.getDeviceTemplates()) {
                Optional pOpt;
                if (devTemp.getType() != DeviceTemplate.Type.PACKAGE || !(pOpt = Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.BONDRING, (String)this.getPersonalityName())).isPresent()) continue;
                Personality personality = (Personality)pOpt.get();
                Constraint.getOrCreate((DbObject)personality, (Constraint.Descriptor)Constraint.BONDRING_TYPE, (Object)Constraint.RingType.FINGER);
                Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(\"%s\", \"%s\", \"BondRingType\", \"FINGER\")", (Object[])new Object[]{personality.getDbClass().getName(), personality.getKeyStr()});
                this.simpleConstraintFrame.doSave((DbObject)personality, this.mSubstrate, this.mSaveOnlyChanged);
            }
        }
    }

    public static enum BondRingDialogType {
        NewFinger,
        NewMetal,
        Edit;

    }
}

