/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.edaMgrs.NameGenerator;
import com.sigrity.acl.ui.AColorChooserDlg;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AGroupableTableHeader;
import com.sigrity.acl.ui.ASeparator;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.cmd.BundleCommands;
import com.sigrity.orbit.cmd.BundleLengths;
import com.sigrity.orbit.ui.BundleUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BundleEditorDlg
extends DbDialog {
    static final int COL_ADD_TO_BUNDLE = 0;
    static final int COL_REMOVE_FROM_BUNDLE = 1;
    static final int COL_BUNDLE_NAME = 2;
    static final int COL_TEMPLATE = 3;
    static final int COL_COLOR = 4;
    static final int COL_VISIBLE = 5;
    static final int COL_WIDTH = 6;
    static final int COL_COMPLETE = 7;
    static final int COL_WIRE_WIDTH = 8;
    static final int COL_WIRE_CLEARANCE = 9;
    static final int COL_ROUTED_FIXED = 10;
    static final int COL_ROUTED_FREE = 11;
    static final int COL_UNROUTED_FIXED = 12;
    static final int COL_UNROUTED_FREE = 13;
    static final int COL_CROSS_FIXED = 14;
    static final int COL_CROSS_FREE = 15;
    static final int COL_SKEW = 16;
    static final int COL_MIN_LENGTH = 17;
    static final int COL_MAX_LENGTH = 18;
    static BundleEditorDlg theDialog = null;
    static ABundleChangedListener mBundleChangeListener = null;
    protected static HistoryListener mHL = null;
    protected static String mFloatDisplayFormat = null;
    protected static DecimalFormat mDecimalFormat = null;
    protected static DesignView2D mView = null;
    protected JTable mTable;
    protected JButton mSwapButton;
    protected JButton mFixUpButton;
    protected PinSelectionListener mSelectionListener;
    protected BundleListener mBL;
    protected HashMap<Bundle, AddRemove> mSelectedPinsOnBundle = new HashMap();
    protected boolean selectionChanging = false;
    protected TableCellRenderer tcr;
    protected BundleList mBundleListModel;
    protected ActionListener swapSelectedPins = e -> {
        Bundle firstBundle = null;
        HashSet<HierPin> firstSet = new HashSet<HierPin>();
        HashSet<HierPin> secondSet = new HashSet<HierPin>();
        for (Bundle b : this.mDb.getObjects(Bundle.class)) {
            if (this.mSelectedPinsOnBundle.get((Object)b).remPins.isEmpty()) continue;
            if (firstSet.isEmpty()) {
                firstSet.addAll(this.mSelectedPinsOnBundle.get((Object)b).remPins);
                firstBundle = b;
                this.removePins(b, this.mSelectedPinsOnBundle.get((Object)b).remPins);
                continue;
            }
            secondSet.addAll(this.mSelectedPinsOnBundle.get((Object)b).remPins);
            this.removePins(b, this.mSelectedPinsOnBundle.get((Object)b).remPins);
            this.addPins(b, firstSet);
        }
        this.addPins(firstBundle, secondSet);
        this.updateBasedOn();
        OrbitIO.getApp().refreshCurrentView(false);
        this.mTable.repaint();
    };

    public static BundleEditorDlg createDialog(Window owner, Db db) {
        BundleEditorDlg dlg = null;
        if (db == null) {
            return null;
        }
        theDialog = dlg = new BundleEditorDlg(db, owner);
        dlg.init();
        mBundleChangeListener = new ABundleChangedListener();
        Bundle.addBundleChangedListener((Bundle.Listener)mBundleChangeListener);
        DbHistory h = db.getHistory();
        mHL = new HistoryListener();
        h.addListener((DbHistory.Listener)mHL);
        mView = (DesignView2D)OrbitIO.getCurView();
        mFloatDisplayFormat = "%,.1f";
        mDecimalFormat = new DecimalFormat("#%");
        dlg.addWindowListener(new WindowAdapter(){
            BundleEditorDlg mDlg;

            public WindowAdapter init(BundleEditorDlg dlg) {
                this.mDlg = dlg;
                return this;
            }

            @Override
            public void windowClosing(WindowEvent we) {
                Bundle.remBundleChangedListener((Bundle.Listener)mBundleChangeListener);
                Selection s = Selection.getCurrentSelectionForDb((Db)this.mDlg.mDb);
                s.addSelectionListener((Selection.SelectionListener)this.mDlg.mSelectionListener);
                s.removeSelectionListener((Selection.SelectionListener)this.mDlg.mSelectionListener);
                DbClass clazz1 = this.mDlg.mDb.getDbClass("Bundle");
                clazz1.removeObjectListener((DbClass.DbObjectListener)this.mDlg.mBL, DbClass.DbObjectEventType.getUpdated());
            }
        }.init(dlg));
        return dlg;
    }

    public BundleEditorDlg(Db db, Window owner) {
        super(db, (Component)owner);
    }

    protected void init() {
        this.setTitle("Bundle Editor");
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.pushNoFill();
        this.mSwapButton = new JButton("Swap Pins Between Bundles");
        l.add((Component)this.mSwapButton);
        this.mSwapButton.addActionListener(this.swapSelectedPins);
        this.mFixUpButton = new JButton(new ActionFixUpBundle());
        this.mFixUpButton.setToolTipText("Force to fix up bundle via/wire connection");
        l.add((Component)this.mFixUpButton);
        l.pop();
        l.newline();
        JPanel bundleList = new JPanel();
        l.push((Container)bundleList, (GridBagConstraints)GridBagManager.FILLALL);
        Border etch = BorderFactory.createEtchedBorder();
        bundleList.setBorder(BorderFactory.createTitledBorder(etch, "Bundles"));
        this.mTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new AGroupableTableHeader(this.columnModel);
            }
        };
        JTableHeader jth = this.mTable.getTableHeader();
        this.tcr = jth.getDefaultRenderer();
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int columnWidth = metrics.charWidth('m');
        int desireWidth = 80;
        int desiredHeight = 200;
        this.mTable.setPreferredScrollableViewportSize(new Dimension(desireWidth * columnWidth, desiredHeight));
        this.mTable.setFillsViewportHeight(true);
        this.mTable.setRowSelectionAllowed(false);
        this.mTable.setAutoResizeMode(4);
        this.mTable.setAutoResizeMode(0);
        this.mBundleListModel = new BundleList();
        this.mTable.setModel(this.mBundleListModel);
        this.mTable.addMouseListener(new TableButtonMouseListener(this.mTable));
        this.mTable.setSelectionMode(0);
        this.mTable.addMouseMotionListener(new TableMouseMotionListener(this.mTable));
        this.mTable.setRowHeight(this.mTable.getRowHeight() + 8);
        ColumnHeaderRender chr = new ColumnHeaderRender();
        TableColumn col = this.mTable.getColumnModel().getColumn(0);
        col.setPreferredWidth(4 * columnWidth);
        col.setMinWidth(2 * columnWidth);
        col.setMaxWidth(8 * columnWidth);
        col.setIdentifier(0);
        col.setResizable(false);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(1);
        col.setPreferredWidth(4 * columnWidth);
        col.setMinWidth(2 * columnWidth);
        col.setMaxWidth(8 * columnWidth);
        col.setIdentifier(1);
        col.setResizable(false);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(2);
        col.setPreferredWidth(16 * columnWidth);
        col.setMinWidth(8 * columnWidth);
        col.setIdentifier(2);
        col.setResizable(true);
        col.setCellEditor(new BundleNameEditor());
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(3);
        col.setPreferredWidth(12 * columnWidth);
        col.setMinWidth(8 * columnWidth);
        col.setIdentifier(3);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(4);
        col.setPreferredWidth(4 * columnWidth);
        col.setMinWidth(2 * columnWidth);
        col.setMaxWidth(8 * columnWidth);
        col.setIdentifier(4);
        col.setResizable(false);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(5);
        col.setCellRenderer(new BundleVisibleRenderer());
        col.setPreferredWidth(5 * columnWidth);
        col.setMinWidth(2 * columnWidth);
        col.setMaxWidth(8 * columnWidth);
        col.setIdentifier(5);
        col.setResizable(false);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(6);
        col.setPreferredWidth(4 * columnWidth);
        col.setIdentifier(6);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(7);
        col.setPreferredWidth(8 * columnWidth);
        col.setIdentifier(7);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(8);
        col.setPreferredWidth(5 * columnWidth);
        col.setIdentifier(8);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(9);
        col.setPreferredWidth(5 * columnWidth);
        col.setIdentifier(9);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(10);
        col.setPreferredWidth(5 * columnWidth);
        col.setIdentifier(10);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(11);
        col.setPreferredWidth(5 * columnWidth);
        col.setIdentifier(11);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(12);
        col.setPreferredWidth(5 * columnWidth);
        col.setIdentifier(12);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(13);
        col.setPreferredWidth(5 * columnWidth);
        col.setIdentifier(13);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(16);
        col.setPreferredWidth(9 * columnWidth);
        col.setIdentifier(16);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(17);
        col.setPreferredWidth(9 * columnWidth);
        col.setIdentifier(17);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(18);
        col.setPreferredWidth(9 * columnWidth);
        col.setIdentifier(18);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(14);
        col.setPreferredWidth(5 * columnWidth);
        col.setIdentifier(14);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(15);
        col.setPreferredWidth(5 * columnWidth);
        col.setIdentifier(15);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        this.mTable.setDefaultRenderer(Object.class, new BundleRowRenderer());
        this.mTable.setRowSelectionAllowed(true);
        this.mTable.setColumnSelectionAllowed(false);
        AGroupableTableHeader gHeader = (AGroupableTableHeader)this.mTable.getTableHeader();
        TableColumnModel cm = this.mTable.getColumnModel();
        AGroupableTableHeader aGroupableTableHeader = gHeader;
        Objects.requireNonNull(aGroupableTableHeader);
        AGroupableTableHeader.ColumnGroup cg = new AGroupableTableHeader.ColumnGroup(aGroupableTableHeader, "Pin");
        cg.add(cm.getColumn(0));
        cg.add(cm.getColumn(1));
        gHeader.addColumnGroup(cg);
        AGroupableTableHeader aGroupableTableHeader2 = gHeader;
        Objects.requireNonNull(aGroupableTableHeader2);
        cg = new AGroupableTableHeader.ColumnGroup(aGroupableTableHeader2, "Properties");
        cg.add(cm.getColumn(3));
        cg.add(cm.getColumn(4));
        cg.add(cm.getColumn(5));
        cg.add(cm.getColumn(6));
        gHeader.addColumnGroup(cg);
        AGroupableTableHeader aGroupableTableHeader3 = gHeader;
        Objects.requireNonNull(aGroupableTableHeader3);
        cg = new AGroupableTableHeader.ColumnGroup(aGroupableTableHeader3, "Wire");
        cg.add(cm.getColumn(8));
        cg.add(cm.getColumn(9));
        gHeader.addColumnGroup(cg);
        AGroupableTableHeader aGroupableTableHeader4 = gHeader;
        Objects.requireNonNull(aGroupableTableHeader4);
        cg = new AGroupableTableHeader.ColumnGroup(aGroupableTableHeader4, "Routed");
        cg.add(cm.getColumn(10));
        cg.add(cm.getColumn(11));
        gHeader.addColumnGroup(cg);
        AGroupableTableHeader aGroupableTableHeader5 = gHeader;
        Objects.requireNonNull(aGroupableTableHeader5);
        cg = new AGroupableTableHeader.ColumnGroup(aGroupableTableHeader5, "Unrouted");
        cg.add(cm.getColumn(12));
        cg.add(cm.getColumn(13));
        gHeader.addColumnGroup(cg);
        AGroupableTableHeader aGroupableTableHeader6 = gHeader;
        Objects.requireNonNull(aGroupableTableHeader6);
        cg = new AGroupableTableHeader.ColumnGroup(aGroupableTableHeader6, "Cross");
        cg.add(cm.getColumn(14));
        cg.add(cm.getColumn(15));
        gHeader.addColumnGroup(cg);
        AGroupableTableHeader aGroupableTableHeader7 = gHeader;
        Objects.requireNonNull(aGroupableTableHeader7);
        cg = new AGroupableTableHeader.ColumnGroup(aGroupableTableHeader7, "Schedule Connection");
        cg.add(cm.getColumn(16));
        cg.add(cm.getColumn(17));
        cg.add(cm.getColumn(18));
        gHeader.addColumnGroup(cg);
        JScrollPane scrollPane = new JScrollPane(this.mTable);
        l.add((Component)scrollPane, (GridBagConstraints)GridBagManager.FILLALL);
        l.pop();
        l.newline();
        this.mBundleListModel.buildTable();
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
        this.mSelectionListener = new PinSelectionListener();
        Selection s = Selection.getCurrentSelectionForDb((Db)this.mDb);
        s.addSelectionListener((Selection.SelectionListener)this.mSelectionListener);
        this.mBL = new BundleListener();
        DbClass clazz1 = this.mDb.getDbClass("Bundle");
        clazz1.addObjectListener((DbClass.DbObjectListener)this.mBL, DbClass.DbObjectEventType.getUpdated());
        this.updateBasedOn();
    }

    public void removeNotify() {
        DbHistory h;
        super.removeNotify();
        Selection s = Selection.getCurrentSelectionForDb((Db)this.mDb);
        if (s != null && this.mSelectionListener != null) {
            s.removeSelectionListener((Selection.SelectionListener)this.mSelectionListener);
        }
        if (mBundleChangeListener != null) {
            Bundle.remBundleChangedListener((Bundle.Listener)mBundleChangeListener);
            mBundleChangeListener = null;
        }
        if (mHL != null && (h = this.mDb.getHistory()) != null) {
            h.removeListener((DbHistory.Listener)mHL);
        }
    }

    protected void updateBasedOn() {
        Selection s = Selection.getCurrentSelectionForDb((Db)this.mDb);
        for (Bundle b : this.mDb.getObjects(Bundle.class)) {
            if (this.mSelectedPinsOnBundle.get(b) == null) {
                this.mSelectedPinsOnBundle.put(b, new AddRemove());
            }
            this.mSelectedPinsOnBundle.get((Object)b).addPins = new HashSet();
            this.mSelectedPinsOnBundle.get((Object)b).remPins = new HashSet();
        }
        for (PinInstance pi : s.get(PinInstance.class)) {
            for (DevicePath dp : s.getSelectedPaths((DbObject)pi)) {
                for (Bundle b : this.mDb.getObjects(Bundle.class)) {
                    if (b.getLocked()) continue;
                    DevicePath relPath = dp.getRelativePathFromAnchor(b.getTemplate());
                    HierPin hp = new HierPin(relPath, pi);
                    List involvedBundles = Bundle.bundlesUsingFreeHierPin((HierPin)hp);
                    if (involvedBundles.contains(b)) {
                        this.mSelectedPinsOnBundle.get((Object)b).remPins.add(hp);
                        continue;
                    }
                    this.mSelectedPinsOnBundle.get((Object)b).addPins.add(hp);
                }
            }
        }
        for (Bundle b : this.mDb.getObjects(Bundle.class)) {
            int toBeAdded = this.mSelectedPinsOnBundle.get((Object)b).addPins.size();
            if (toBeAdded <= b.getDefinedArity() - b.getCompleted()) continue;
            this.mSelectedPinsOnBundle.get((Object)b).addPins.clear();
        }
        int numBundles = 0;
        int numPins = 0;
        boolean samePins = false;
        for (Bundle b : this.mDb.getObjects(Bundle.class)) {
            int pins = this.mSelectedPinsOnBundle.get((Object)b).remPins.size();
            if (pins <= 0) continue;
            if (++numBundles >= 2) {
                if (numPins != pins) continue;
                samePins = true;
                continue;
            }
            numPins = pins;
        }
        this.mSwapButton.setEnabled(numBundles == 2 && samePins);
        this.mTable.repaint();
    }

    public static void test() {
        BundleEditorDlg dlg = BundleEditorDlg.createDialog(OrbitIO.getMainWindow(), OrbitIO.getCurDb());
        if (dlg != null) {
            dlg.setVisible(true);
        }
    }

    protected void removePins(Bundle b, HashSet<HierPin> pins) {
        for (SchedConn sc : b.getSchedConn()) {
            if (!pins.contains(sc.getDPPB())) continue;
            Cp.exec((String)"com.sigrity.orbit.ui.wb_route.BundleEditorDlg.removePinFromBundleCmd (\"%s\");", (Object[])new Object[]{sc.getKeyStr()});
        }
    }

    public static void removePinFromBundleCmd(String schedConnKeyStr) {
        Net childNet;
        Device childDevice;
        Net parentNet;
        Db db = OrbitIO.getCurDb();
        SchedConn sc = (SchedConn)db.getByKeyStr(SchedConn.class, schedConnKeyStr);
        PinInstance pinInstance = sc.getDPPB().getPin();
        PinTemplate pinTemplate = pinInstance.getPinTemplate();
        if (!AUtil.moreThanOne((Iterator)pinTemplate.getDeviceTemplate().getDeviceInstances())) {
            pinTemplate.setNet(pinTemplate.getDeviceTemplate().getNetUnused());
        } else if (!sc.getPathB().getPath().isEmpty() && (parentNet = NetMap.getParentNet((Device)(childDevice = pinInstance.getDevice()), (Net)(childNet = pinTemplate.getNet()))) != null) {
            NetMap.unmap((Device)childDevice, (Net)childNet, (Net)parentNet);
        }
        sc.setPathB(null);
        sc.setPortB(null);
    }

    protected void addPins(Bundle b, HashSet<HierPin> pins) {
        block0: for (HierPin hp : pins) {
            for (SchedConn sc : b.getSchedConn()) {
                if (sc.getPathB() != null) continue;
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.BundleEditorDlg.addPinToBundleCmd (\"%s\",  \"%s\", \"%s\");", (Object[])new Object[]{sc.getKeyStr(), ((PinInstance)hp.second).getPinTemplate().getFirstPortTemplate().getKeyStr(), hp.getPath().escapedString()});
                continue block0;
            }
        }
    }

    public static void addPinToBundleCmd(String schedConnKeyStr, String portTemplateKey, String pathToAddedPinKeyStr) {
        Db db = OrbitIO.getCurDb();
        SchedConn sc = (SchedConn)db.getByKeyStr(SchedConn.class, schedConnKeyStr);
        DevicePath devicePath = DevicePath.fromEscapedString((Db)db, (String)pathToAddedPinKeyStr);
        PortTemplate portTemplate = (PortTemplate)db.getByKeyStr(PortTemplate.class, portTemplateKey);
        sc.setPortB(devicePath, portTemplate);
        BundleEditorDlg.connectPins(sc, true);
    }

    public static void connectPins(SchedConn sc, boolean fromA) {
        DevicePath pathA = sc.getDevicePathA();
        PinTemplate pinTemplateA = sc.getDPPA().getPinTemplate();
        PinTemplate pinTemplateB = sc.getDPPB().getPinTemplate();
        DeviceTemplate deviceTemplateB = pinTemplateB.getDeviceTemplate();
        if (fromA) {
            pinTemplateB.setNet(deviceTemplateB.getNetUnused());
            Net netA = pinTemplateA.getNet();
            if (!netA.isUnused()) {
                boolean mappedToTemplate = false;
                for (HierInst hNet : NetMap.getConnectedNetHierarcy((DevicePath)sc.getDevicePathA(), (Net)((PinInstance)sc.getDPPA().second).getNet())) {
                    if (!hNet.getPath().getDeviceTemplate().equals(deviceTemplateB)) continue;
                    pinTemplateB.setNet((Net)hNet.getDbObject());
                    mappedToTemplate = true;
                    break;
                }
                if (!mappedToTemplate) {
                    NameGenerator ng = new NameGenerator(netA.getName() + "_");
                    String netName = Net.findAUniqueNetName((DeviceTemplate)deviceTemplateB, (NameGenerator)ng);
                    Net net = Net.create((DeviceTemplate)deviceTemplateB, (String)netName);
                    NetMap.mapUpTo((DevicePath)pathA, (Net)netA, (Net)net);
                    pinTemplateB.setNet(net);
                }
            }
        }
    }

    class TableMouseMotionListener
    implements MouseMotionListener {
        protected JTable table;

        public TableMouseMotionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            TableColumnModel columnModel = this.table.getColumnModel();
            int column = columnModel.getColumnIndexAtX(e.getX());
            int row = e.getY() / this.table.getRowHeight();
            if (row >= BundleEditorDlg.this.mTable.getRowCount()) {
                return;
            }
            if (column == 0 || column == 1 || column == 2) {
                BundleEditorDlg.this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                BundleEditorDlg.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    class TableButtonMouseListener
    extends MouseAdapter {
        protected JTable table;
        JPopupMenu popup;

        public TableButtonMouseListener(JTable table) {
            this.table = table;
        }

        protected void showPopup(MouseEvent e) {
            int row = e.getY() / this.table.getRowHeight();
            if (row >= this.table.getRowCount()) {
                return;
            }
            Bundle b = BundleEditorDlg.this.mBundleListModel.getRow(row);
            if (b == null) {
                return;
            }
            this.popup = new JPopupMenu();
            JMenuItem showMax = new JMenuItem(new BundleUI.ActionShowMaxLength(b));
            this.popup.add(showMax);
            JMenuItem showMin = new JMenuItem(new BundleUI.ActionShowMinLength(b));
            this.popup.add(showMin);
            this.popup.add(ObjectActionRegistry.getJMenuItem(new BundleUI.ActionZoomBundle(b)));
            this.popup.add((Component)new ASeparator(BundleUI.ViewActionFactory.getGroupName()));
            OrbitGuiWS gws = OrbitIO.getOrbitIO().getWorkspace();
            ObjectActionRegistry oar = gws.getObjectActionRegistry();
            for (JMenuItem jMenuItem : oar.getJMenuItems(HierInst.create((DevicePath)b.getTemplate().getPathToPresentUser(), (DbObject)b))) {
                this.popup.add(jMenuItem);
            }
            this.popup.addSeparator();
            OrbitIO.getGuiWorkspace().beautify(this.popup);
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            } else {
                Bundle b;
                TableColumnModel columnModel = this.table.getColumnModel();
                int column = columnModel.getColumnIndexAtX(e.getX());
                int row = e.getY() / this.table.getRowHeight();
                if (e.getClickCount() != 2 || e.getButton() != 1 || !e.isConsumed()) {
                    // empty if block
                }
                if (column == 1) {
                    b = BundleEditorDlg.this.mBundleListModel.getRow(row);
                    if (b == null) {
                        return;
                    }
                    BundleEditorDlg.this.removePins(b, BundleEditorDlg.this.mSelectedPinsOnBundle.get((Object)b).remPins);
                    Bundle.fixUpBundles((Db)b.getDb());
                    BundleEditorDlg.this.updateBasedOn();
                    OrbitIO.getApp().refreshCurrentView(false);
                    BundleEditorDlg.this.mTable.repaint();
                }
                if (column == 0) {
                    b = BundleEditorDlg.this.mBundleListModel.getRow(row);
                    if (b == null) {
                        return;
                    }
                    BundleEditorDlg.this.addPins(b, BundleEditorDlg.this.mSelectedPinsOnBundle.get((Object)b).addPins);
                    Cp.exec((String)"Bundle.fixUpBundles(OrbitIO.getApp().getCurDb())", (Object[])new Object[0]);
                    BundleEditorDlg.this.updateBasedOn();
                    OrbitIO.getApp().refreshCurrentView(false);
                    BundleEditorDlg.this.mTable.repaint();
                } else if (column == 5) {
                    Bundle bundle = BundleEditorDlg.this.mBundleListModel.getRow(row);
                    Cp.exec((String)"_bundle = %s", (Object[])new Object[]{CpHelper.getObjCmdStr(bundle)});
                    Cp.exec((String)"_bundle.setIsVisible (%b);", (Object[])new Object[]{!bundle.getIsVisible()});
                    Cp.exec((String)"unset (\"_bundle\");", (Object[])new Object[0]);
                    BundleEditorDlg.this.mTable.repaint();
                    OrbitIO.getApp().refreshCurrentView(false);
                } else if (column == 4) {
                    b = BundleEditorDlg.this.mBundleListModel.getRow(row);
                    if (b == null) {
                        return;
                    }
                    if (!b.getLocked()) {
                        AColorChooserDlg ccd = AColorChooserDlg.createDialog((Component)((Object)BundleEditorDlg.this), "Select Color", b.getColor());
                        ccd.setShowOpacity(true);
                        Color c = ccd.doModal();
                        if (c != null) {
                            b.setColor(c);
                        }
                        OrbitIO.getApp().refreshCurrentView(false);
                    }
                } else if (column == 14) {
                    b = BundleEditorDlg.this.mBundleListModel.getRow(row);
                    if (b == null) {
                        return;
                    }
                    BundleUI.ActionZoomBundle.zoomTo(b, b.getFixedRakePtsList());
                } else if (column == 15) {
                    b = BundleEditorDlg.this.mBundleListModel.getRow(row);
                    if (b == null) {
                        return;
                    }
                    BundleUI.ActionZoomBundle.zoomTo(b, b.getFreeRakePtsList());
                }
            }
        }
    }

    static class EditorBorder
    extends AbstractBorder {
        protected Insets editorBorderInsets = new Insets(4, 2, 4, 0);

        EditorBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 0, 0, h - 2);
            g.drawLine(0, h - 2, w - 1, h - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(1, 1, w - 1, 1);
            g.drawLine(1, 1, 1, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(1, h - 2, 1, h - 2);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.editorBorderInsets;
        }
    }

    public class BundleColorEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component = new JTextField();

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            Bundle bundle = BundleEditorDlg.this.mBundleListModel.getRow(rowIndex);
            if (bundle == null) {
                return this.component;
            }
            boolean locked = bundle.getLocked();
            if (locked) {
                return this.component;
            }
            table.clearSelection();
            AColorChooserDlg ccd = AColorChooserDlg.createDialog((Component)((Object)BundleEditorDlg.this), "Select Color", bundle.getColor());
            ccd.setShowOpacity(true);
            Color c = ccd.doModal();
            bundle.setColor(c);
            table.repaint();
            OrbitIO.getApp().refreshCurrentView(false);
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return new AColorIcon(16, 16, Color.black);
        }
    }

    public class BundleNameEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component = new JTextField();

        public BundleNameEditor() {
            JTextField ftf = (JTextField)this.component;
            ftf.setBorder(new EditorBorder());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            Bundle bundle = BundleEditorDlg.this.mBundleListModel.getRow(rowIndex);
            if (bundle == null) {
                return this.component;
            }
            ((JTextField)this.component).setText(bundle.getName());
            boolean locked = bundle.getLocked();
            if (locked) {
                ((JTextField)this.component).setEditable(false);
                ((JTextField)this.component).setBorder(null);
            } else {
                ((JTextField)this.component).setEditable(true);
                ((JTextField)this.component).setBorder(new EditorBorder());
            }
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return ((JTextField)this.component).getText();
        }
    }

    public static class BundleSorter
    implements Comparator<Bundle> {
        @Override
        public int compare(Bundle b0, Bundle b1) {
            String t1;
            String t0;
            AAlphaNumComp c = AAlphaNumComp.get();
            int ct = c.compare((Object)(t0 = b0.getTemplate().getName()), (Object)(t1 = b1.getTemplate().getName()));
            if (ct != 0) {
                return ct;
            }
            return c.compare((Object)b0.getName(), (Object)b1.getName());
        }
    }

    public class BundleRowRenderer
    extends DefaultTableCellRenderer {
        protected ArrayList<PinTemplate> ioPorts = null;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
            Bundle bundle = BundleEditorDlg.this.mBundleListModel.getRow(row);
            this.setIcon(null);
            this.setText(null);
            this.setForeground(Color.BLACK);
            this.setBackground(Color.WHITE);
            this.setHorizontalAlignment(4);
            this.setToolTipText("");
            if (isSelected) {
                this.setBackground(Color.ORANGE);
            }
            Unit unit = Design.getUnit((Db)bundle.getDb());
            if (column == 0) {
                HashSet<HierPin> adds = BundleEditorDlg.this.mSelectedPinsOnBundle.get((Object)bundle).addPins;
                int size = adds.size();
                Object text = "";
                if (size > 0) {
                    text = "+" + size;
                }
                text = String.format("<html><a href='#'>%s</a></html>", AUtil.escapeHtml((String)text));
                this.setText((String)text);
            } else if (column == 1) {
                HashSet<HierPin> rems = BundleEditorDlg.this.mSelectedPinsOnBundle.get((Object)bundle).remPins;
                int size = rems.size();
                Object text = "";
                if (size > 0) {
                    text = "-" + size;
                }
                text = String.format("<html><a href='#'>%s</a></html>", AUtil.escapeHtml((String)text));
                this.setText((String)text);
            } else if (column == 2) {
                this.setText(bundle.getName());
                this.setHorizontalAlignment(2);
            } else if (column == 3) {
                DeviceTemplate dt = bundle.getTemplate();
                if (dt.hasMoreThanOneDeviceInstance()) {
                    this.setText(bundle.getTemplate().getName());
                } else {
                    Device d = dt.getAnInstance();
                    this.setText(d.getName());
                }
                this.setHorizontalAlignment(2);
            } else if (column == 4) {
                this.setIcon((Icon)new AColorIcon(16, 16, bundle.getColor()));
                this.setHorizontalAlignment(0);
            } else if (column == 5) {
                this.setText(bundle.getIsVisible() ? "True" : "False");
                this.setHorizontalAlignment(0);
            } else if (column == 6) {
                this.setText("" + bundle.getDefinedArity());
            } else if (column == 7) {
                int numCompleted = 0;
                for (SchedConn sc : bundle.getSchedConn()) {
                    if (!sc.isValidBoth()) continue;
                    ++numCompleted;
                }
                if (numCompleted != bundle.getDefinedArity()) {
                    this.setForeground(Color.red);
                } else {
                    this.setForeground(Color.black);
                }
                this.setText("" + numCompleted);
            } else if (column == 8) {
                this.setText(unit.toUserStr(bundle.getWireWidth()));
            } else if (column == 9) {
                this.setText(unit.toUserStr(bundle.getWireClr()));
            } else if (column == 10 || column == 12) {
                boolean completed;
                int numSchedConn = 0;
                int numRouted = 0;
                for (SchedConn sc : bundle.getSchedConn()) {
                    ++numSchedConn;
                    if (!sc.isValidBoth() || BundleCommands.getRoutes(sc.getDPPA(), sc.getOwningTemplate(), bundle).isEmpty()) continue;
                    ++numRouted;
                }
                int percent = numSchedConn == 0 ? 100 : numRouted * 100 / numSchedConn;
                boolean bl = completed = percent == 100;
                if (column == 12) {
                    numRouted = numSchedConn - numRouted;
                    percent = 100 - percent;
                }
                String text = String.format("%d (%d%%)", numRouted, percent);
                this.setText(text);
                if (completed) {
                    this.setForeground(new Color(0, 130, 60));
                } else {
                    this.setForeground(Color.RED);
                }
            } else if (column == 11 || column == 13) {
                boolean completed;
                int numSchedConn = 0;
                int numRouted = 0;
                for (SchedConn sc : bundle.getSchedConn()) {
                    ++numSchedConn;
                    if (!sc.isValidBoth() || BundleCommands.getRoutes(sc.getDPPB(), sc.getOwningTemplate(), bundle).isEmpty()) continue;
                    ++numRouted;
                }
                int percent = numSchedConn == 0 ? 100 : numRouted * 100 / numSchedConn;
                boolean bl = completed = percent == 100;
                if (column == 13) {
                    numRouted = numSchedConn - numRouted;
                    percent = 100 - percent;
                }
                String text = String.format("%d (%d%%)", numRouted, percent);
                this.setText(text);
                if (completed) {
                    this.setForeground(new Color(0, 130, 60));
                } else {
                    this.setForeground(Color.RED);
                }
            } else if (column == 16) {
                double deviationLength = 0.0;
                long skewLength = 0L;
                long avgLength = 0L;
                BundleLengths bundleLengths = BundleLengths.getBundleLengths(bundle, null, null);
                if (bundleLengths != null) {
                    skewLength = bundleLengths.getSkewLength();
                    avgLength = bundleLengths.getAverageLength();
                    if (avgLength != 0L) {
                        deviationLength = (double)skewLength * 1.0 / (double)avgLength;
                    }
                }
                double userSkewLength = mView.getCanvas().worldToUserDist(skewLength);
                this.setText(String.format(mFloatDisplayFormat, userSkewLength) + " (" + mDecimalFormat.format(deviationLength) + ")");
            } else if (column == 18) {
                long maxLength = 0L;
                BundleLengths bundleLengths = BundleLengths.getBundleLengths(bundle, null, null);
                if (bundleLengths != null) {
                    maxLength = bundleLengths.getMaxLength();
                }
                double userMaxLength = mView.getCanvas().worldToUserDist(maxLength);
                this.setText(String.format(mFloatDisplayFormat, userMaxLength));
            } else if (column == 17) {
                long minLength = 0L;
                BundleLengths bundleLengths = BundleLengths.getBundleLengths(bundle, null, null);
                if (bundleLengths != null) {
                    minLength = bundleLengths.getMinLength();
                }
                double userMaxLength = mView.getCanvas().worldToUserDist(minLength);
                this.setText(String.format(mFloatDisplayFormat, userMaxLength));
            } else if (column == 14) {
                int c = bundle.crosses(true);
                this.setText("" + c);
            } else if (column == 15) {
                int c = bundle.crosses(false);
                this.setText("" + c);
            }
            return this;
        }
    }

    public class ColumnHeaderRender
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (BundleEditorDlg.this.tcr == null) {
                return null;
            }
            Component component = BundleEditorDlg.this.tcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel label = null;
            if (!(component instanceof JLabel)) {
                return null;
            }
            label = (JLabel)component;
            label.setToolTipText(null);
            if (column == 0) {
                label.setText("");
                label.setIcon(OrbitIcons.ADD);
                label.setToolTipText("Add Selected pins to this bundle, and remove them from any prexisting bundle");
            } else if (column == 1) {
                label.setText("");
                label.setIcon(OrbitIcons.DELETE);
                label.setToolTipText("Remove selected pins from the bundle");
            } else if (column == 2) {
                label.setText("Name");
                label.setIcon(null);
                label.setToolTipText("Bundle Name");
            } else if (column == 3) {
                label.setText("Template");
                label.setIcon(null);
                label.setToolTipText("The name of the template owning the bundle, or the name of an instance if there is only one");
            } else if (column == 4) {
                label.setText("Color");
                label.setIcon(null);
                label.setToolTipText("The color the bundle will be drawn");
            } else if (column == 5) {
                label.setText("Visible");
                label.setIcon(null);
                label.setToolTipText("Visibility toggle of the bundle");
            } else if (column == 6) {
                label.setText("Width");
                label.setIcon(null);
                label.setToolTipText("The number of connections in the bundle");
            } else if (column == 7) {
                label.setText("Complete");
                label.setIcon(null);
                label.setToolTipText("The number of connections completed in the bundle");
            } else if (column == 10) {
                label.setText("Fixed");
                label.setIcon(null);
                label.setToolTipText("Is the bundle Routed in fixed end");
            } else if (column == 11) {
                label.setText("Free");
                label.setIcon(null);
                label.setToolTipText("Is the bundle Routed in free end");
            } else if (column == 12) {
                label.setText("Fixed");
                label.setIcon(null);
                label.setToolTipText("Is the bundle Unrouted in fixed end");
            } else if (column == 13) {
                label.setText("Free");
                label.setIcon(null);
                label.setToolTipText("Is the bundle Unrouted in free end");
            } else if (column == 16) {
                label.setText("Breakout Skew");
                label.setIcon(null);
                label.setToolTipText("Bundle breakout skew (difference between the lengths of the longest and shortest schedule connections). The deviation is the ratio of the skew to mean lengths expressed as a percentage.");
            } else if (column == 18) {
                label.setText("Max Length");
                label.setIcon(null);
                label.setToolTipText("Maximum length of a schedule connection of the bundle.");
            }
            return component;
        }
    }

    public class BundleVisibleRenderer
    extends JCheckBox
    implements TableCellRenderer {
        BundleVisibleRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            Bundle bundle = BundleEditorDlg.this.mBundleListModel.getRow(row);
            this.setSelected(bundle.getIsVisible());
            return this;
        }
    }

    class BundleList
    extends AbstractTableModel {
        LinkedList<Bundle> bundleRows = new LinkedList();
        private String[] columnNames = new String[]{"Add", "Remove", "Name", "Template", "Color", "Visible", "Width", "Complete", "Width", "Clearance", "Fixed", "Free", "Fixed", "Free", "Fixed", "Free", "Breakout Skew", "Min Length", "Max Length"};

        BundleList() {
        }

        public Bundle getRow(int row) {
            if (row < this.bundleRows.size()) {
                return this.bundleRows.get(row);
            }
            return null;
        }

        public void buildTable() {
            this.bundleRows.clear();
            BundleEditorDlg.this.mTable.clearSelection();
            LinkedList<Bundle> bundles = new LinkedList<Bundle>();
            for (Bundle b : BundleEditorDlg.this.mDb.getObjects(Bundle.class)) {
                if (b.getTemplate() == null) continue;
                bundles.add(b);
                BundleEditorDlg.this.mSelectedPinsOnBundle.put(b, new AddRemove());
                BundleEditorDlg.this.mSelectedPinsOnBundle.get((Object)b).addPins = new HashSet();
                BundleEditorDlg.this.mSelectedPinsOnBundle.get((Object)b).remPins = new HashSet();
            }
            Collections.sort(bundles, new BundleSorter());
            for (Bundle bundle : bundles) {
                this.bundleRows.add(bundle);
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 2) {
                Bundle bundle = BundleEditorDlg.this.mBundleListModel.getRow(row);
                return bundle != null && !bundle.getLocked();
            }
            return col == 8 || col == 9;
        }

        @Override
        public int getRowCount() {
            return this.bundleRows.size();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Bundle bundle = BundleEditorDlg.this.mBundleListModel.getRow(row);
            if (bundle == null) {
                return;
            }
            Unit unit = Design.getUnit((Db)bundle.getDb());
            if (col == 2) {
                String newValue = (String)value;
                if ((newValue = newValue.replace(" ", "")).isEmpty()) {
                    return;
                }
                if (Bundle.getBundle((Db)BundleEditorDlg.this.mDb, (String)newValue, (DeviceTemplate)bundle.getTemplate()) != null) {
                    return;
                }
                Cp.exec((String)"_bundle = %s", (Object[])new Object[]{CpHelper.getObjCmdStr(bundle)});
                Cp.exec((String)"_bundle.setName (\"%s\");", (Object[])new Object[]{newValue});
                Cp.exec((String)"unset (\"_bundle\");", (Object[])new Object[0]);
            } else if (col == 8) {
                Double val = AUtil.parseDouble((String)("" + value));
                if (val == null) {
                    return;
                }
                Cp.exec((String)"%s.setWireWidth(%dL)", (Object[])new Object[]{CpHelper.getObjCmdStr(bundle), unit.fromUser(val.doubleValue())});
            } else if (col == 9) {
                Double val = AUtil.parseDouble((String)("" + value));
                if (val == null) {
                    return;
                }
                Cp.exec((String)"%s.setWireClr(%dL)", (Object[])new Object[]{CpHelper.getObjCmdStr(bundle), unit.fromUser(val.doubleValue())});
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Bundle bundle = BundleEditorDlg.this.mBundleListModel.getRow(rowIndex);
            if (bundle == null) {
                return null;
            }
            Unit unit = Design.getUnit((Db)bundle.getDb());
            if (columnIndex == 8) {
                return unit.toUser(bundle.getWireWidth());
            }
            if (columnIndex == 9) {
                return unit.toUser(bundle.getWireClr());
            }
            return null;
        }
    }

    protected class ActionFixUpBundle
    extends AbstractAction {
        public ActionFixUpBundle() {
            super("Fixed Up Bundles");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"Bundle.fixUpBundles(OrbitIO.getCurDb())", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    static class AddRemove {
        HashSet<HierPin> addPins = new HashSet();
        HashSet<HierPin> remPins = new HashSet();

        AddRemove() {
        }
    }

    class PinSelectionListener
    implements Selection.SelectionListener {
        PinSelectionListener() {
        }

        public void selectionChanged(HashMap<DbClass, Selection.SelSet> set) {
            if (BundleEditorDlg.this.selectionChanging) {
                return;
            }
            BundleEditorDlg.this.selectionChanging = true;
            EventQueue.invokeLater(() -> {
                BundleEditorDlg.this.updateBasedOn();
                BundleEditorDlg.this.selectionChanging = false;
            });
        }
    }

    protected class BundleListener
    implements DbClass.DbObjectListener {
        protected BundleListener() {
        }

        public boolean addingObject(DbClass.ObjectAdd add) {
            return false;
        }

        public boolean changingObject(DbClass.ObjectChange change) {
            return false;
        }

        public boolean removingObject(DbClass.ObjectRemove remove) {
            return false;
        }

        public void addedObject(DbClass.ObjectAdd add) {
            BundleEditorDlg.this.mBundleListModel.buildTable();
            BundleEditorDlg.this.mTable.repaint();
        }

        public void changedObject(DbClass.ObjectChange change) {
            BundleEditorDlg.this.mBundleListModel.buildTable();
            BundleEditorDlg.this.mTable.repaint();
        }

        public void removedObject(DbClass.ObjectRemove remove) {
            BundleEditorDlg.this.mBundleListModel.buildTable();
            BundleEditorDlg.this.mTable.repaint();
        }
    }

    static class ABundleChangedListener
    implements Bundle.Listener {
        ABundleChangedListener() {
        }

        public void react(String s) {
            BundleEditorDlg.theDialog.mTable.updateUI();
        }
    }

    protected static class HistoryListener
    extends DbHistory.ListenerAdapter {
        protected HistoryListener() {
        }

        public void endUndoRedo(boolean isRedo) {
            BundleEditorDlg.theDialog.mTable.updateUI();
        }
    }
}

