/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.AExpression;
import com.sigrity.acl.AHashCollection;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.MutableBoolean;
import com.sigrity.acl.Stopwatch;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.DevicePathPortPair;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.RuleSetMgr;
import com.sigrity.orbit.UserCommands;
import com.sigrity.orbit.automation.router.PrettyRouter;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import com.sigrity.orbit.automation.router.Topstacle;
import com.sigrity.orbit.factory.ViaFactory;
import com.sigrity.orbit.ui.wb_route.RouteQueue;
import com.sigrity.orbit.ui.wb_route.RouterInterface;
import com.sigrity.orbit.util.PinUtil;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

public class BundleEscapeInterface {
    public static final int MAX_PASS = 10;
    public static final String FLD_CREATOR = "Creator";
    public static final String CONTACT_CONTEXT_NAME = "router";
    public static final String CREATOR_PROCESS = "router";
    LinkedList<String> personalityKeys = new LinkedList();
    DevicePath routeOnPath = null;

    public void addPersonality(String key) {
        this.personalityKeys.add(key);
    }

    public void setRoutingPath(String path) {
        this.routeOnPath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)path);
        if (this.routeOnPath == null) {
            this.routeOnPath = DevicePath.fromEscapedString((Db)OrbitIO.getCurDb(), (String)path);
        }
    }

    protected LinkedList<APair<DbObject, Layer>> personalitiesToValidSchedConn(Db db, LinkedList<String> personalityKeys) {
        LinkedList<APair<DbObject, Layer>> validSchedConn = new LinkedList<APair<DbObject, Layer>>();
        for (String pString : personalityKeys) {
            Personality p = Personality.getByKeyStr((Db)db, (String)pString);
            List orderedConnections = p.getSchedConns().stream().collect(Collectors.toList());
            Collections.sort(orderedConnections, new RouteQueue.SchedConnRouterSorter(true));
            for (SchedConn sc : orderedConnections) {
                RuleSet thisRs;
                if (!sc.isValidBoth() || RouteQueue.getIgnore(sc) || sc.getHierPortA().getPinTemplate().getNet().isUnused() || (thisRs = RuleSetMgr.getMyRuleSet((DbObject)sc.getHierPortA().getPin())) == null) continue;
                validSchedConn.add((APair<DbObject, Layer>)new APair((Object)sc, null));
            }
        }
        return validSchedConn;
    }

    public int route() {
        return this.route(true);
    }

    public int route(boolean refreshDisplay) {
        Db db = OrbitIO.getCurDb();
        LinkedList<APair<DbObject, Layer>> validSchedConn = this.personalitiesToValidSchedConn(db, this.personalityKeys);
        return this.routeConns(validSchedConn, null, -1L, -1L, -1L, refreshDisplay, true);
    }

    private static HierPin getRouteFromPin(DbObject routeObj) {
        if (routeObj instanceof SchedConn) {
            return ((SchedConn)routeObj).getDPPA();
        }
        if (routeObj instanceof Connection) {
            return ((Connection)routeObj).getDPPA();
        }
        ALog.logError((String)"Cannot find the route from-pin.");
        return null;
    }

    private static HierPin getRouteToPin(DbObject routeObj) {
        if (routeObj instanceof SchedConn) {
            return ((SchedConn)routeObj).getDPPB();
        }
        if (routeObj instanceof Connection) {
            return ((Connection)routeObj).getDPPB();
        }
        ALog.logError((String)"Cannot find the route to-pin.");
        return null;
    }

    public int routeConns(List<APair<DbObject, Layer>> conns, String layerName, long iTraceToBumpClearance, long iWireWireClearance, long iWireWidth, boolean refreshDisplay, boolean addToDb) {
        if (conns == null || conns.isEmpty()) {
            ALog.logInfo((String)"No connection to route.");
            return 0;
        }
        Db db = OrbitIO.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        Random mRandom = new Random(127L);
        LinkedList<Layer> layers = new LinkedList<Layer>();
        HashMap<Layer, RuleSet> layersRuleSets = new HashMap<Layer, RuleSet>();
        AHashCollection layersToRoutes = new AHashCollection();
        for (APair<DbObject, Layer> pair : conns) {
            Long traceToPad;
            ARect largestShape;
            HierPin relativeFrom = BundleEscapeInterface.getRouteFromPin((DbObject)pair.first);
            HierPin relativeTo = BundleEscapeInterface.getRouteToPin((DbObject)pair.first);
            if (relativeFrom == null || relativeTo == null || !addToDb && relativeFrom.second == null) continue;
            Layer layer = (Layer)pair.second;
            Substrate substrate = ((PinInstance)relativeFrom.second).getPinTemplate().getSubstrate();
            RuleSet thisRuleSet = RuleSetMgr.getMyRuleSet((DbObject)relativeFrom.getDbObject());
            List<Layer> layerSet = new LinkedList<Layer>();
            if (layer != null) {
                layerSet.add(layer);
            } else if (layerName != null) {
                Layer l = substrate.getLayer(layerName);
                if (l != null) {
                    layerSet.add(l);
                }
            } else {
                layerSet = RuleSet.getRoutingLayers((RuleSet)thisRuleSet);
                if (layerSet == null || layerSet.isEmpty()) {
                    layerSet = AUtil.linkedList((Iterator)substrate.getLayers());
                }
                Collections.sort(layerSet);
            }
            if (layerSet == null || layerSet.isEmpty()) continue;
            int num = layerSet.size();
            int nth = mRandom.nextInt(num);
            Layer thisLayer = (Layer)layerSet.get(nth);
            DevicePathPortPair dppp = new DevicePathPortPair(relativeFrom, relativeTo);
            SingleLayerRouter.RouteInformation ri = new SingleLayerRouter.RouteInformation();
            ri.setRuleSet(thisRuleSet);
            AExpression expr = null;
            if (iWireWidth == -1L && thisRuleSet != null) {
                Layer ruleLayer = null;
                if (layerSet.size() == 1) {
                    ruleLayer = (Layer)layerSet.iterator().next();
                }
                expr = (AExpression)RuleSetMgr.getConstraintValue((RuleSet)thisRuleSet, (Constraint.Descriptor)Constraint.WIRE_WIDTH, ruleLayer);
            }
            String padstack = "Default";
            if (thisRuleSet != null) {
                padstack = (String)RuleSetMgr.getConstraintValue((RuleSet)thisRuleSet, (Constraint.Descriptor)Constraint.PADSTACK, (Layer)thisLayer);
            }
            ri.setWidth(iWireWidth != -1L ? iWireWidth : unit.fromUserString((String)expr.evaluate()));
            DeviceTemplate routingTemplate = this.routeOnPath.getDeviceTemplate();
            HierPin fromRoutePin = PinUtil.getWireEnd((HierPin)dppp.getDPPA(), (DeviceTemplate)routingTemplate);
            DevicePath aPath = (DevicePath)fromRoutePin.first;
            PinTemplate aPin = ((PinInstance)fromRoutePin.second).getPinTemplate();
            Net substrateNet = NetMap.getNetAt((Net)aPin.getNet(), (DevicePath)aPath, (DeviceTemplate)routingTemplate);
            assert (substrateNet.getDeviceTemplate() == routingTemplate) : String.format("%s %s %s %s", aPin.getNet(), aPath, routingTemplate, substrateNet);
            HierPin contactPad = this.getPinToRouteTo(this.routeOnPath, fromRoutePin, thisLayer, substrateNet, padstack);
            if (contactPad == null) {
                HierInst hPinT = PinUtil.getBundlePin((HierPin)fromRoutePin, (boolean)false);
                if (hPinT != null) {
                    PinInstance pinI = PinInstance.getPinInstance((HierInst)hPinT, (boolean)true);
                    if (pinI != null) {
                        contactPad = new HierPin((DevicePath)hPinT.first, pinI);
                    }
                } else {
                    ALog.logWarn((String)("No Pad on layer " + thisLayer.getName() + " for pin " + fromRoutePin.getPin().getName() + ". Ignoring route"));
                    continue;
                }
            }
            if ((largestShape = (contactPad = new HierPin(contactPad.getPath().getRelativePathFromAnchor(routingTemplate), contactPad.getPin())).getPinTemplate().getBoundsOfLargestGeom(thisLayer)) == null) continue;
            ri.setFrom(Topstacle.fromDevicePathPort(contactPad, thisLayer));
            ri.getFrom().setShape((AGeom)largestShape);
            ri.setNet(substrateNet);
            PadTemplate pt = dppp.getDPPB().getPinTemplate().getPadTemplate();
            LayerShape ls = pt.getLayerShapes().findFirst().orElse(null);
            if (ls == null) continue;
            AGeom geom = ls.getGeom();
            AGeom aPadShape = null;
            if (geom instanceof ACircle) {
                aPadShape = ls.getGeom().copy();
            } else if (geom instanceof ARect) {
                aPadShape = ls.getGeom().copy();
            } else if (geom instanceof APath || geom instanceof APolygon) {
                aPadShape = ls.getGeom().toPoly();
            }
            for (LayerShape lsShape : AUtil.arrayList((Iterator)pt.getLayerShapes(thisLayer))) {
                if (!addToDb) continue;
                lsShape.deleteFromDb();
            }
            if (addToDb) {
                LayerShape.create((Db)db, (Layer)thisLayer, (DbObject)pt, (AGeom)aPadShape);
            }
            HierPin contactPadTo = dppp.getDPPB();
            contactPadTo = new HierPin(contactPadTo.getPath().getRelativePathFromAnchor(routingTemplate), contactPadTo.getPin());
            largestShape = contactPadTo.getPinTemplate().getBoundsOfLargestGeom(thisLayer);
            if (!addToDb && largestShape == null) continue;
            ri.setTo(Topstacle.fromDevicePathPort(contactPadTo, thisLayer));
            ri.getTo().setShape((AGeom)largestShape);
            Long wireWire = iWireWireClearance;
            if (wireWire == -1L) {
                wireWire = (Long)RuleSetMgr.getConstraintValue((RuleSet)thisRuleSet, (Constraint.Descriptor)Constraint.WIRE_CLEAR, (Layer)thisLayer);
            }
            if ((traceToPad = Long.valueOf(iTraceToBumpClearance)) == -1L) {
                traceToPad = (Long)RuleSetMgr.getConstraintValue((RuleSet)thisRuleSet, (Constraint.Descriptor)Constraint.DEF_TRACE_TO_BUMP_CLEAR, (Layer)thisLayer);
            }
            ri.setClear(wireWire == null ? 0L : Math.max(wireWire, 0L));
            ri.setTraceToPad(traceToPad == null ? 0L : Math.max(traceToPad, 0L));
            ri.setMaxWidth(ri.getWidth());
            ri.setPinExitLength(0L);
            ri.setConn((DbObject)pair.first);
            if (!layers.contains(thisLayer)) {
                layers.add(thisLayer);
                layersRuleSets.put(thisLayer, thisRuleSet);
            }
            layersToRoutes.add((Object)thisLayer, (Object)ri);
        }
        ALog.logInfo((String)"Using Pretty Router ...");
        int totalFailures = 0;
        for (Layer l : layers) {
            ArrayList<SingleLayerRouter.RouteInformation> ris = new ArrayList<SingleLayerRouter.RouteInformation>();
            ris.addAll((Collection)layersToRoutes.get((Object)l));
            Collections.sort(ris, new RISorter());
            RuleSet aRuleSet = (RuleSet)layersRuleSets.get(l);
            if (refreshDisplay) {
                ALog.logInfo((String)"Routing Layer '%s'", (Object[])new Object[]{l.getName()});
            }
            this.routeThisLayerIteratively(ris, l, aRuleSet, refreshDisplay, addToDb);
            totalFailures += this.failures(ris);
        }
        PadTemplate.releaseAdoptContext((Db)db, (String)"router");
        if (addToDb) {
            PrettyRouter.clearAllPrettyRouters();
        }
        if (refreshDisplay && addToDb) {
            UserCommands.removeConnections();
        }
        return totalFailures;
    }

    protected int failures(List<SingleLayerRouter.RouteInformation> ris) {
        int failures = 0;
        for (SingleLayerRouter.RouteInformation ri : ris) {
            if (ri.getSucess()) continue;
            ++failures;
        }
        return failures;
    }

    protected ArrayList<SingleLayerRouter.RouteInformation> permuteFailures(ArrayList<SingleLayerRouter.RouteInformation> ris) {
        SingleLayerRouter.RouteInformation ri;
        int i;
        ArrayList<SingleLayerRouter.RouteInformation> copy = new ArrayList<SingleLayerRouter.RouteInformation>(ris);
        ArrayList<SingleLayerRouter.RouteInformation> permuted = new ArrayList<SingleLayerRouter.RouteInformation>();
        for (i = 0; i < ris.size(); ++i) {
            ri = copy.get(i);
            if (ri.getSucess()) continue;
            permuted.add(ri);
        }
        for (i = 0; i < ris.size(); ++i) {
            ri = copy.get(i);
            if (!ri.getSucess()) continue;
            permuted.add(ri);
        }
        return permuted;
    }

    protected ARect deriveRestrictedBounds(ArrayList<SingleLayerRouter.RouteInformation> toBeRouted) {
        ARect bounds = new ARect();
        boolean first = true;
        for (SingleLayerRouter.RouteInformation ri : toBeRouted) {
            ALine l;
            Connection con;
            SchedConn sc = ri.getConn() instanceof SchedConn ? (SchedConn)ri.getConn() : null;
            Connection connection = con = ri.getConn() instanceof Connection ? (Connection)ri.getConn() : null;
            if (sc == null && con == null) {
                ALog.logWarn((Throwable)new Exception(), (String)"Invalid connection object status in route info", (Object[])new Object[0]);
                continue;
            }
            ALine aLine = l = sc != null ? sc.getLineOnTemplate(this.routeOnPath.getDeviceTemplate()) : con.getLineOnTemplate(this.routeOnPath.getDeviceTemplate());
            if (first) {
                bounds.setLL(Math.min(l.getP0().getX(), l.getP1().getX()), Math.min(l.getP0().getY(), l.getP1().getY()));
                bounds.setUR(Math.max(l.getP0().getX(), l.getP1().getX()), Math.max(l.getP0().getY(), l.getP1().getY()));
                first = false;
                continue;
            }
            bounds.expand(l.getP0());
            bounds.expand(l.getP1());
        }
        return bounds.expandBy(bounds.width(), bounds.height());
    }

    protected int routeThisLayerIteratively(ArrayList<SingleLayerRouter.RouteInformation> toBeRouted, Layer l, RuleSet aRuleSet, boolean refreshDisplay, boolean addToDb) {
        Db db = l.getDb();
        PrettyRouter.clearAllPrettyRouters();
        PrettyRouter pr = PrettyRouter.getPrettyRouter(this.routeOnPath.getDeviceTemplate(), l, true);
        ArrayList<Topstacle> obstacles = new ArrayList<Topstacle>();
        ARect restrictedBounds = this.deriveRestrictedBounds(toBeRouted);
        RouterInterface.extractObstacles(obstacles, this.routeOnPath, l, restrictedBounds);
        pr.setDB(db);
        pr.setParent(this.routeOnPath);
        pr.setLayer(l);
        pr.setObstacles(obstacles);
        pr.debugView();
        pr.setToBeRouted(toBeRouted);
        Constraint.RouteAngle angle = Constraint.RouteAngle.Any;
        Constraint.FinishingFunction ff = Constraint.FinishingFunction.Default;
        if (toBeRouted.get(0).getConn() instanceof SchedConn) {
            angle = (Constraint.RouteAngle)RuleSetMgr.getConstraintValue((RuleSet)aRuleSet, (Constraint.Descriptor)Constraint.ROUTE_ANGLE, (Layer)l);
            ff = (Constraint.FinishingFunction)RuleSetMgr.getConstraintValue((RuleSet)aRuleSet, (Constraint.Descriptor)Constraint.FINISHING_FUNCTION, (Layer)l);
        }
        pr.setAngle(angle);
        pr.setFinishingFunction(ff);
        pr.setRouteType(PrettyRouter.RouteType.RDL);
        pr.allowBackDoor(true);
        Integer failures = null;
        Integer bestFailures = null;
        int bestPass = 0;
        int pass = 1;
        ArrayList<SingleLayerRouter.RouteInformation> bestOrder = new ArrayList<SingleLayerRouter.RouteInformation>();
        Stopwatch stopWatch = new Stopwatch();
        int max_pass = 10;
        if (!addToDb) {
            max_pass = 1;
        }
        while (failures == null || failures > 0 && pass <= max_pass) {
            pr.globalRoute(true, addToDb);
            failures = this.failures(toBeRouted);
            if (bestFailures == null || failures < bestFailures) {
                bestFailures = failures;
                bestOrder.clear();
                bestOrder.addAll(toBeRouted);
                bestPass = pass;
            }
            if (refreshDisplay) {
                ALog.logInfo((String)"Layer: '%s', Route Pass: %d, Attempted: %d, Failures: %d", (Object[])new Object[]{l.getName(), pass, toBeRouted.size(), failures});
            }
            if (failures > 0 && pass + 1 <= max_pass) {
                if (addToDb) {
                    pr.clearRoutes();
                }
                toBeRouted = this.permuteFailures(toBeRouted);
                pr.setToBeRouted(toBeRouted);
            }
            ++pass;
        }
        if (bestFailures > 0 && pass - 1 != bestPass) {
            if (addToDb) {
                pr.clearRoutes();
            }
            if (refreshDisplay) {
                ALog.logInfo((String)("Returning to pass " + bestPass));
            }
            toBeRouted = bestOrder;
            pr.setToBeRouted(toBeRouted);
            pr.globalRoute(true, addToDb);
            failures = this.failures(toBeRouted);
            pass = bestPass;
            if (refreshDisplay) {
                ALog.logInfo((String)"Layer: '%s', Route Pass: %d, Attempted: %d, Failures: %d", (Object[])new Object[]{l.getName(), pass, toBeRouted.size(), failures});
            }
        }
        if (addToDb) {
            pr.detailRoute();
        }
        int i = 0;
        for (SingleLayerRouter.RouteInformation ri : toBeRouted) {
            if (!(ri.getConn() instanceof SchedConn)) continue;
            RouteQueue.setPriority((SchedConn)ri.getConn(), i++);
        }
        for (SingleLayerRouter.RouteInformation ri : toBeRouted) {
            if (!ri.getSucess() || !(ri.getConn() instanceof SchedConn)) continue;
            RuleSetMgr.setMyRuleSet((RuleSet)ri.getRuleSet(), (DbObject)ri.getWire());
            SchedConn sc = (SchedConn)ri.getConn();
            Bundle bundle = null;
            if (sc != null) {
                DbObject owner = sc.getOwner();
                if (owner instanceof Personality) {
                    bundle = Bundle.getBundle((Personality)((Personality)owner));
                } else if (owner instanceof Bundle) {
                    bundle = (Bundle)owner;
                }
            }
            if (bundle == null) {
                ALog.logInfo((String)"Error. Not able to derive bundle or personality during routing.");
                return failures;
            }
            bundle.setMyWire(ri.getWire());
            SchedConn bundleSchedConn = bundle.getSchedConnOfA(sc.getDPPA());
            if (bundleSchedConn == null) continue;
            bundleSchedConn.setValue("Bundle.Layer", (Object)l);
        }
        double totalLength = 0.0;
        for (SingleLayerRouter.RouteInformation ri : toBeRouted) {
            if (!ri.getSucess()) continue;
            totalLength += (double)Design.micronToInternal((Db)db, (double)ri.getWire().getPath().getLength());
        }
        if (refreshDisplay) {
            Unit unit = Design.getUnit((Db)db);
            ALog.logInfo((String)"Total Trace Length: %s (%s)", (Object[])new Object[]{unit.toUser((long)totalLength), unit.getUserName()});
        }
        stopWatch.stop();
        if (refreshDisplay) {
            ALog.logInfo((String)"Route time: %s (second)", (Object[])new Object[]{Stopwatch.formatTime((long)stopWatch.elapsed())});
        }
        return failures;
    }

    public static HierPin makeContactPad(HierPin pin, Layer l, Long defaultWidth) {
        DevicePath devicePath;
        PinInstance pinInstance = (PinInstance)pin.second;
        DevicePath diePath = devicePath = (DevicePath)pin.first;
        PinInstance contactPinInst = pinInstance.getFirstExternallyConnected();
        if (contactPinInst == null) {
            if (pinInstance.hasShapeOnLayer(l)) {
                return new HierPin(devicePath, pinInstance);
            }
        } else if (contactPinInst.hasShapeOnLayer(l)) {
            return new HierPin(diePath, contactPinInst);
        }
        HierPin dppIOPad = new HierPin(devicePath, pinInstance);
        HierPin via = ViaFactory.instantiateAVia(diePath, dppIOPad, l, null, null, defaultWidth);
        pinInstance.setChildExternallyConnected(via.getPin());
        return via;
    }

    protected HierPin instantiateContactPad(HierPin bumpPin, Layer packageLayer, DevicePath packagePath, Net n, AGeom g, int i) {
        Db db = packageLayer.getDb();
        APoint2D bumpLocInWorld = bumpPin.getWorldLoc();
        PinTemplate pt = PinTemplate.create((Net)n, (String)("contact" + i));
        pt.setType(PinTemplate.Type.CONTACT);
        PortTemplate.create((PinTemplate)pt);
        DbClass dbClass = db.getDbClass("LayerShape");
        LayerShape ls = (LayerShape)dbClass.createInstance();
        ls.setLayer(packageLayer);
        ls.setGeom(g);
        LinkedList<LayerShape> shapes = new LinkedList<LayerShape>();
        shapes.add(ls);
        AffineTransform t = packagePath.getInverseTransform();
        MutableBoolean created = new MutableBoolean();
        PadTemplate pad = PadTemplate.getEquiv((Db)db, (String)"router", (Substrate)pt.getSubstrate(), shapes, (String)"cp", (MutableBoolean)created);
        pt.setLoc(bumpLocInWorld.transform(t));
        pt.setPadTemplate(pad);
        Device d = null;
        d = packagePath.getIsAbsolute() ? packagePath.getLast() : packagePath.getRoot().getAnInstance();
        PinInstance pi = PinInstance.create((Db)db, (String)"", (Device)d, (PinTemplate)pt);
        return new HierPin(packagePath, pi);
    }

    protected void addShapeToPin(Layer l, AGeom g, PadTemplate pad) {
        LayerShape ls = LayerShape.create((Db)l.getDb(), (Layer)l, (DbObject)pad, (AGeom)g);
        ls.setValue(FLD_CREATOR, (Object)"router");
    }

    protected HierPin getPinToRouteTo(DevicePath theRoutingPath, HierPin pinFromSourceComponent, Layer theRoutingLayer, Net theRoutingNet, String padstack) {
        PinInstance pinInstance = (PinInstance)pinFromSourceComponent.second;
        Db db = pinInstance.getDb();
        HierPin theMainPin = null;
        DeviceTemplate theRoutingTemplate = theRoutingNet.getDeviceTemplate();
        if (theRoutingTemplate.getSubstrate() != pinInstance.getSubstrate()) {
            PinInstance contactPinInstance = pinInstance.getFirstExternallyConnected();
            if (contactPinInstance == null) {
                return null;
            }
            DevicePath path = contactPinInstance.getDevice().getADevicePath();
            path = path.getRelativePathFromAnchor(theRoutingPath.getDeviceTemplate());
            theMainPin = new HierPin(path, contactPinInstance);
        } else {
            theMainPin = pinFromSourceComponent;
        }
        if (padstack != null && padstack.equals("Default")) {
            APair info = theMainPin.getPinTemplate().getLargestGeom(theRoutingLayer);
            if (info == null) {
                return null;
            }
            return theMainPin;
        }
        String viaName = "Via:" + theMainPin.getPin().getName();
        PinTemplate viaTemplate = PinTemplate.create((Net)theMainPin.getNet(), (String)viaName);
        viaTemplate.setType(PinTemplate.Type.VIA);
        viaTemplate.setValue("creatorProcess", (Object)"router");
        PortTemplate portTemplate = PortTemplate.create((PinTemplate)viaTemplate);
        portTemplate.setLoc(theMainPin.getPinTemplate().getLoc());
        PadTemplate pt = PadTemplate.get((Db)db, (Substrate)portTemplate.getSubstrate(), (String)padstack);
        portTemplate.setPadTemplate(pt);
        PinInstance viaInstance = PinInstance.create((Db)db, (String)viaTemplate.getName(), (Device)theMainPin.getPin().getDevice(), (PinTemplate)viaTemplate);
        viaInstance.setChildExternallyConnected((PinInstance)theMainPin.second);
        HierPin viaHierPin = new HierPin(theMainPin.getPath(), viaInstance);
        PadTemplate padT = viaHierPin.getPin().getPadTemplate();
        if (padT == null) {
            return null;
        }
        APair info = padT.getLargestGeom(theRoutingLayer);
        if (info == null) {
            return null;
        }
        return viaHierPin;
    }

    public static class RISorter
    implements Comparator<SingleLayerRouter.RouteInformation> {
        @Override
        public int compare(SingleLayerRouter.RouteInformation rI0, SingleLayerRouter.RouteInformation rI1) {
            return Long.compare(rI0.length(), rI1.length());
        }
    }
}

