/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.RuleSetMgr;
import com.sigrity.orbit.automation.router.BundleRoutePrep;
import com.sigrity.orbit.ui.wb_route.BundleEscapeInterface;
import com.sigrity.orbit.ui.wb_route.RouteQueue;
import com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI;
import java.awt.Color;
import java.util.HashMap;

public class BundleRouteSweep {
    public double sweep(DevicePath path, Bundle bundle, String ruleName, boolean isFixed, Double min, Double max, Double incr, boolean topLayer) {
        BundleRoutePrep.prepareForRouting(bundle.getDb(), bundle.getKeyStr(), isFixed, false);
        Personality personality = null;
        personality = isFixed ? bundle.getRouteGroup() : bundle.getRouteGroupFree();
        DeviceTemplate dt = bundle.getTemplate();
        Substrate s = dt.getSubstrate();
        RuleSet rs = RuleSet.get((String)ruleName, (String)s.getKeyStr());
        if (RuleSet.get((String)ruleName, (String)s.getKeyStr()) == null) {
            rs = RuleSet.create((String)ruleName, (String)s.getKeyStr());
            rs.setColor(Color.blue);
        }
        Layer layer = s.getTopLayer();
        if (!topLayer) {
            layer = s.getBottomLayer();
        }
        this.addRulesToObjects(rs, personality);
        SweepState sweepState = SweepState.Increasing;
        double nom = min;
        while (true) {
            this.setRules(rs, layer, nom);
            int failures = this.routeWithRules(personality, path);
            if (sweepState.equals((Object)SweepState.GoingBack)) {
                return nom;
            }
            if (failures == 0) {
                min = nom;
            } else {
                max = nom;
            }
            double newNom = min + (max - min) / 2.0;
            newNom = Math.floor(newNom);
            if (newNom == nom || newNom == min) {
                return min;
            }
            nom = newNom;
        }
    }

    protected int routeWithRules(Personality p, DevicePath path) {
        WbFcFeasibilityUI.unRouteRDLPersonality(p.getKeyStr(), true);
        BundleEscapeInterface router = new BundleEscapeInterface();
        router.addPersonality(p.getKeyStr());
        router.setRoutingPath(path.escapedString());
        int failures = router.route(false);
        return failures;
    }

    protected void setRules(RuleSet rs, Layer l, Double nom) {
        Unit unit = Design.getUnit((Db)rs.getDb());
        RuleSetMgr.setConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.ROUTE_LAYER, null, (Object)l);
        RuleSetMgr.setConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.WIRE_WIDTH, null, (Object)nom);
        RuleSetMgr.setConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.WIRE_CLEAR, null, (Object)unit.fromUser(nom.doubleValue()));
        RuleSetMgr.setConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.DEF_TRACE_TO_BUMP_CLEAR, null, (Object)unit.fromUser(nom.doubleValue()));
        RuleSetMgr.setConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.PADSTACK, (Layer)l, (Object)"Default");
        RuleSetMgr.clrRoutingLayers((RuleSet)rs);
        RuleSetMgr.addRoutingLayer((RuleSet)rs, (Layer)l);
    }

    protected void addRulesToObjects(RuleSet rs, Personality p) {
        for (SchedConn scto : p.getSchedConns()) {
            if (!scto.getHierPortA().complete()) continue;
            RouteQueue.addToRuleSet(rs.getKeyStr(), scto.getHierPortA().getPin().getKeyStr());
        }
    }

    public static void testMe(String pathString) {
        Db db = OrbitIO.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)pathString);
        if (devicePath == null) {
            ALog.logError((String)"'%s' is not a valid device path", (Object[])new Object[]{pathString});
            return;
        }
        HashMap<Bundle, APair> max = new HashMap<Bundle, APair>();
        BundleRouteSweep brs1 = new BundleRouteSweep();
        for (Bundle b : devicePath.getDeviceTemplate().getBundles()) {
            if (!b.validate()) continue;
            double fixed = brs1.sweep(devicePath, b, b.getName() + "_fixed", true, 10.0, 20.0, 1.0, true);
            double free = brs1.sweep(devicePath, b, b.getName() + "_free", false, 10.0, 200.0, 1.0, true);
            max.put(b, new APair((Object)fixed, (Object)free));
        }
        OrbitIO.getApp().refreshCurrentView(false);
        for (Bundle b : max.keySet()) {
            APair fixedFree = (APair)max.get(b);
            ALog.logInfo((String)("Bundle: " + b.getName() + " Fixed: " + ((Double)fixedFree.first).toString() + " Free: " + ((Double)fixedFree.second).toString()));
        }
    }

    public static enum SweepState {
        Increasing,
        GoingBack,
        AllDone;

    }
}

