/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.optimizer.genetic.GeneticFinishingFunction;
import com.sigrity.acl.optimizer.genetic.GeneticOptimizationControllerThread;
import com.sigrity.acl.optimizer.genetic.GeneticOptimizerBroker;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AMultiLineDynamicGraph;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class EvolveConnSolutionDlg
extends ADialog
implements GeneticFinishingFunction {
    protected Substrate mSubstrate;
    protected JButton mBtnEvolve = new JButton("Go");
    protected JButton mBtnCancel = new JButton("Close");
    protected JComboBox<Effort> mTime;
    protected AMultiLineDynamicGraph mGOG;
    protected boolean mStopState = false;
    public boolean mIsWb;
    protected ActionListener mEvolveButtonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!EvolveConnSolutionDlg.this.mStopState) {
                EvolveConnSolutionDlg.this.evolve();
            } else {
                GeneticOptimizationControllerThread.stopEvolution(OrbitIO.getCurDb().toString());
                EvolveConnSolutionDlg.this.mStopState = false;
                EvolveConnSolutionDlg.this.mBtnEvolve.setText("Go");
            }
        }
    };

    public static void showMe(Window owner, String substrateKey, boolean isWb) {
        Substrate s = (Substrate)OrbitIO.getCurDb().getByKeyStr(Substrate.class, substrateKey);
        if (s == null) {
            ALog.logWarn((String)"Substrate not found");
            return;
        }
        EvolveConnSolutionDlg ui = new EvolveConnSolutionDlg(owner, s, isWb);
        ui.setVisible(true);
    }

    protected EvolveConnSolutionDlg(Window owner, Substrate s, boolean isWb) {
        super(owner);
        this.mIsWb = isWb;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                GeneticOptimizationControllerThread.stopEvolution(OrbitIO.getCurDb().toString());
                GeneticOptimizerBroker.removeMultiLineGraph(OrbitIO.getCurDb().toString());
            }
        });
        this.mSubstrate = s;
        this.init();
    }

    protected void evolve() {
        Effort e = (Effort)((Object)this.mTime.getSelectedItem());
        if (e.getTime() == 0) {
            Cp.exec((String)"com.sigrity.orbit.automation.wirebonder.CreateConnections.createBallNetListQuick(\"%s\", %b)", (Object[])new Object[]{this.mSubstrate.getKeyStr(), this.mIsWb});
        } else {
            GeneticOptimizerBroker.addFinishingFunction(OrbitIO.getCurDb().toString(), this);
            Cp.exec((String)"com.sigrity.orbit.automation.wirebonder.CreateConnections.createBallNetListEvolve(\"%s\", true, %d, %d, %b)", (Object[])new Object[]{this.mSubstrate.getKeyStr(), e.getTime() * 60, e.getMaxPopulation(), this.mIsWb});
            this.mStopState = true;
            this.mBtnEvolve.setEnabled(true);
            this.mBtnEvolve.setText("Stop!");
        }
    }

    protected void init() {
        DevicePath aDevicePath = this.mSubstrate.getInstancePaths().stream().findAny().orElse(null);
        String title = "Evolve Connection Solution for ";
        title = String.format("%s '%s'", title, aDevicePath);
        this.setTitle(title);
        GridBagManager l = new GridBagManager((Container)((Object)this));
        l.pushFillXRemainX("Evolve Parameters:");
        JLabel label1 = new JLabel("Effort:");
        l.add((Component)label1, (GridBagConstraints)GridBagManager.LEFT);
        this.mTime = new JComboBox();
        this.mTime.setRenderer(new EffortComboBoxRender());
        l.add(this.mTime, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        l.popNl();
        for (int i = 0; i < Effort.values().length; ++i) {
            this.mTime.addItem(Effort.values()[i]);
        }
        this.mGOG = new AMultiLineDynamicGraph();
        GeneticOptimizerBroker.removeMultiLineGraph(OrbitIO.getCurDb().toString());
        GeneticOptimizerBroker.addMultiLineGraph(OrbitIO.getCurDb().toString(), this.mGOG);
        l.pushFill("Fitness");
        l.add((Component)this.mGOG, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        l.popNl();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        l.add((Component)this.mBtnEvolve, (GridBagConstraints)GridBagManager.RIGHT);
        l.add((Component)this.mBtnCancel, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        l.pop();
        this.setModal(true);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)this.mBtnCancel, (JButton)this.mBtnEvolve);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
        this.mBtnEvolve.addActionListener(this.mEvolveButtonListener);
    }

    @Override
    public void onGeneticOptimizationFinished() {
        GeneticOptimizationControllerThread.stopEvolution(OrbitIO.getCurDb().toString());
        this.mStopState = false;
        this.mBtnEvolve.setText("Go");
    }

    public static class EffortComboBoxRender
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    list.setToolTipText(Effort.values()[index].getToolTip());
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    public static enum Effort {
        E1("Quick", 0, 0, "A deterministic solution requiring only seconds"),
        E2("Short (2 minutes)", 2, 1, "A Solution requiring about 2 minutes"),
        E3("Medium (5 minutes)", 5, 2, "A Solution requiring about 5 minutes"),
        E4("Long (30 minutes)", 30, 15, "A Solution requiring about 30 minutes"),
        E5("Exhaustive (6 hours)", 720, 4096, "A Solution requiring about 6 Hours");

        private String longDescriptor;
        private int minutes;
        private String toolTip;
        private int maxPopulation;

        private Effort(String ld, int time, int mp, String tt) {
            this.longDescriptor = ld;
            this.minutes = time;
            this.toolTip = tt;
            this.maxPopulation = mp;
        }

        public String toString() {
            return this.longDescriptor;
        }

        public int getTime() {
            return this.minutes;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public int getMaxPopulation() {
            return this.maxPopulation;
        }
    }
}

