/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AButtonGroup;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AHistoryTextField;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.FanOutFactory;
import com.sigrity.orbit.automation.router.PrettyRouter;
import com.sigrity.orbit.automation.wirebonder.WireBonder;
import com.sigrity.orbit.ui.wb_route.RouterInterface;
import com.sigrity.zexample.SendMail;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JRadioButton;

public class EvolveWBSolutionDlg
extends ADialog {
    protected Substrate mSubstrate;
    protected JButton mBtnReplace = new JButton("Evolve");
    protected JButton mBtnCancel = new JButton("Cancel");
    protected JCheckBox mEvolveRingDistance = new JCheckBox("Evolve Ring Distance from Die Edge");
    protected JCheckBox mEvolveRingAngle = new JCheckBox("Evolve Maximum Bond Finger Angle");
    protected JCheckBox mEvolveChangeIO = new JCheckBox("Evolve IO Cell Locations");
    protected JRadioButton mFirstRoutableSolutionFound = new JRadioButton("First routable solution is found");
    protected JRadioButton mBestSolutionFound = new JRadioButton("Best solution is found");
    protected JCheckBox mEmailMe = new JCheckBox("Email when a solution found");
    protected AHistoryTextField mEmailAddress = new AHistoryTextField("MRU", "Email_Address", 12);
    protected JCheckBox mIncludePicture = new JCheckBox("Include Picture of solution");
    protected ActionListener mEvolveButtonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            EvolveWBSolutionDlg.this.mEmailAddress.saveCurrentEntryToHistory();
            EvolveWBSolutionDlg.this.evolve();
        }
    };

    public static void showMe(Window owner, String substrateKey) {
        Substrate s = (Substrate)OrbitIO.getCurDb().getByKeyStr(Substrate.class, substrateKey);
        if (s == null) {
            ALog.logWarn((String)"Substrate not found");
            return;
        }
        EvolveWBSolutionDlg ui = new EvolveWBSolutionDlg(owner, s);
        ui.setVisible(true);
    }

    protected EvolveWBSolutionDlg(Window owner, Substrate s) {
        super(owner);
        this.mSubstrate = s;
        this.init();
    }

    protected Personality getSignalPersonality() {
        for (DeviceTemplate devTemp : this.mSubstrate.getDeviceTemplates()) {
            Optional<Personality> ring = Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.BONDRING).filter(p -> {
                Constraint.RingType rt = (Constraint.RingType)Constraint.getValue((Db)OrbitIO.getCurDb(), (DbObject)p, (Constraint.Descriptor)Constraint.BONDRING_TYPE);
                return rt == Constraint.RingType.FINGER;
            }).findFirst();
            if (!ring.isPresent()) continue;
            return ring.get();
        }
        return null;
    }

    protected void evolve() {
        Long viaMin;
        Long viaClr;
        Personality signals;
        if (!this.mEmailAddress.getText().isEmpty()) {
            SendMail.send(this.mEmailAddress.getText(), "Evolution Started", "A Wirebond Solution was started by " + System.getProperty("user.name") + "\n");
        }
        if ((signals = this.getSignalPersonality()) == null) {
            return;
        }
        String signalsKeyStr = signals.getKeyStr();
        OrbitIO.getOrbitIO().saveCurrentDesignAs("evolve.oio");
        Long min = (Long)Constraint.getValue((Db)OrbitIO.getCurDb(), (DbObject)signals, (Constraint.Descriptor)Constraint.BONDMIN_LENGTH);
        Long max = (Long)Constraint.getValue((Db)OrbitIO.getCurDb(), (DbObject)signals, (Constraint.Descriptor)Constraint.BONDMAX_LENGTH);
        Layer bondFingerLayer = (Layer)Constraint.getValue((Db)OrbitIO.getCurDb(), (DbObject)signals, (Constraint.Descriptor)Constraint.BONDFINGER_LAYER);
        Layer ballLayer = (Layer)Constraint.getValue((Db)OrbitIO.getCurDb(), (DbObject)signals, (Constraint.Descriptor)Constraint.BALL_LAYER);
        Long viaDiameter = (Long)Constraint.getValue((Db)OrbitIO.getCurDb(), (DbObject)signals, (Constraint.Descriptor)Constraint.VIA_DIAMETER);
        if (viaDiameter == null) {
            viaDiameter = 0L;
        }
        if ((viaClr = (Long)Constraint.getValue((Db)OrbitIO.getCurDb(), (DbObject)signals, (Constraint.Descriptor)Constraint.VIA_CLEAR)) == null) {
            viaClr = 0L;
        }
        if ((viaMin = (Long)Constraint.getValue((Db)OrbitIO.getCurDb(), (DbObject)signals, (Constraint.Descriptor)Constraint.VIA_MIN_DISTANCE_FROM_BALL)) == null) {
            viaMin = 0L;
        }
        Double minAngle = (Double)Constraint.getValue((Db)OrbitIO.getCurDb(), (DbObject)signals, (Constraint.Descriptor)Constraint.BONDMIN_ANGLE);
        double maxAngle = 60.0;
        long distIncr = (max - min) / 8L;
        double angleIncr = 2.0;
        int generation = 0;
        long bestDist = 0L;
        double bestAngle = 0.0;
        boolean solutionFound = false;
        int attempts = 0;
        int completed = 0;
        for (long dist = min.longValue(); !solutionFound && dist < max; dist += distIncr) {
            for (double angle = maxAngle; !solutionFound && angle > minAngle; angle -= angleIncr) {
                OrbitIO.getOrbitIO().closeCurrentDesign();
                OrbitIO.getOrbitIO().openDesign("evolve.oio");
                ++generation;
                Constraint.setConstraint((DbObject)signals, (Constraint.Descriptor)Constraint.BONDMIN_LENGTH, (Object)dist);
                Constraint.setConstraint((DbObject)signals, (Constraint.Descriptor)Constraint.BONDMIN_ANGLE, (Object)angle);
                WireBonder.unBondRing(signalsKeyStr);
                WireBonder.bondRing(signalsKeyStr);
                DeviceTemplate devTemp = signals.getOwner();
                FanOutFactory.doBallPads(devTemp.getSubstrate(), bondFingerLayer.getName(), ballLayer.getName(), (long)viaDiameter, (long)viaMin, viaDiameter * 10L, (long)viaClr, false);
                Constraint.setConstraintValue((DbObject)signals, (Constraint.Descriptor)Constraint.ROUTE_STRATEGY, (Object)Constraint.RouteStrategy.GlobalRoute);
                DevicePath dp = RouterInterface.determinePathOfSubstrate(devTemp);
                RouterInterface.routeGroupOfBondPadsToBalls(signalsKeyStr, false);
                PrettyRouter pr = PrettyRouter.getPrettyRouter(dp.getLast().getTemplate(), bondFingerLayer, true);
                attempts = pr == null ? 0 : pr.getAttempts();
                completed = pr == null ? 0 : pr.getCompletedCount();
                Db db = OrbitIO.getCurDb();
                Connection.removeAll((Db)db);
                OrbitIO.getOrbitIO().refreshCurrentView(false);
                OrbitIO.getOrbitIO().zoomFitCurrentView();
                if (attempts != completed) continue;
                bestAngle = angle;
                bestDist = dist;
                solutionFound = true;
            }
        }
        OrbitIO.getOrbitIO().snapShotCurrentView("generation" + generation + ".png", "Angle = " + bestAngle + "Distance = " + bestDist);
        if (!this.mEmailAddress.getText().isEmpty()) {
            SendMail.send(this.mEmailAddress.getText(), "Evolution Done", generation + " generations completed \n");
        }
    }

    protected void init() {
        String title = "Evolve WB Solution for ";
        if (this.mSubstrate != null) {
            title = String.format("%s '%s'", title, this.getAnyDeviceUsingThisSubstrate(this.mSubstrate));
        }
        this.setTitle(title);
        GridBagManager l = new GridBagManager((Container)((Object)this));
        l.pushFillXRemainX("Evolve Parameters:");
        this.mEvolveRingDistance.setToolTipText("Allow the solution to be found by altering the distance from die edge");
        l.addNl((Component)this.mEvolveRingDistance, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        this.mEvolveRingAngle.setToolTipText("A Solution Will be found by changing bond wire angle");
        l.addNl((Component)this.mEvolveRingAngle, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        this.mEvolveChangeIO.setToolTipText("A Solution Will be found by changing IO Pad Locations");
        l.addNl((Component)this.mEvolveChangeIO, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        this.mEvolveChangeIO.setEnabled(false);
        l.popNl();
        l.pushFillXRemainX("Stopping Criteria:");
        this.mFirstRoutableSolutionFound.setToolTipText("Stop when first routable solution is found");
        l.addNl((Component)this.mFirstRoutableSolutionFound, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        this.mBestSolutionFound.setToolTipText("Keep evolving until the best solution is found");
        l.addNl((Component)this.mBestSolutionFound, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        AButtonGroup g = new AButtonGroup();
        g.add(this.mFirstRoutableSolutionFound);
        g.add(this.mBestSolutionFound);
        this.mBestSolutionFound.setSelected(true);
        l.popNl();
        l.pushFillXRemainX("Results:");
        this.mEmailMe.setToolTipText("Email me when a solution is found");
        l.add((Component)this.mEmailMe, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        l.add("Email Address:");
        l.add((Component)((Object)this.mEmailAddress), (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.indent();
        l.add((Component)this.mIncludePicture);
        l.popNl();
        l.addFillAll();
        l.newline();
        l.addFillX();
        l.add((Component)this.mBtnReplace, (GridBagConstraints)GridBagManager.RIGHT);
        l.add((Component)this.mBtnCancel, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        this.setModal(true);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)this.mBtnCancel, (JButton)this.mBtnReplace);
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.mBtnReplace.addActionListener(this.mEvolveButtonListener);
    }

    protected String getAnyDeviceUsingThisSubstrate(Substrate s) {
        for (Device d : OrbitIO.getCurDb().getObjects(Device.class)) {
            if (!d.getIsSubstrate() || d.getSubstrate() != s) continue;
            return d.getName();
        }
        return "";
    }
}

