/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.RuleSetMgr;
import com.sigrity.orbit.ui.wb_route.PadStackDlg;
import com.sigrity.orbit.ui.wb_route.PadTemplateComboBox;
import com.sigrity.orbit.ui.wb_route.RDLRuleSetDlg;
import com.sigrity.orbit.ui.wb_route.RouterRuleSetDlg;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComboBox;

public class GeneralBundleRuleSetDlg
extends RDLRuleSetDlg {
    protected JButton mMakePadstack;
    protected PadTemplateComboBox mComboPadTemplate;
    protected ActionListener mMakePadStackListener = e -> {
        PadStackDlg psd = PadStackDlg.createDialog((Window)((Object)this), "RouteVia", this.substrate.getADevicePathUsing());
        PadTemplate pt = psd.getActivePadTemplate();
        this.mComboPadTemplate.populatePadTemplates();
        this.mComboPadTemplate.setSelectedItem(pt);
    };

    public GeneralBundleRuleSetDlg(Window owner) {
        super(owner);
    }

    protected void loadViaPadstackBoard(GridBagManager l) {
        DevicePath aPath = this.substrate.getADevicePathUsing();
        l.pushFillX("Via Padstack");
        l.add("Via Padstack");
        this.mComboPadTemplate = (PadTemplateComboBox)l.add((Component)new PadTemplateComboBox(aPath), (GridBagConstraints)GridBagManager.FILLX);
        this.mComboPadTemplate.addActionListener(new PadStackSelectedListener());
        this.mMakePadstack = new JButton("New");
        this.mMakePadstack.addActionListener(this.mMakePadStackListener);
        l.add((Component)this.mMakePadstack);
        l.pop();
        this.pLayer.addActionListener(e -> this.updateViaDefinition(this.mComboPadTemplate));
        l.newline();
    }

    @Override
    protected void loadContentPane(GridBagManager l, RouterRuleSetDlg.DialogMode mode, RuleSet rs) {
        this.mSingleLayerMode = true;
        this.loadConfigurationBoard(l, rs);
        this.loadViaPadstackBoard(l);
        this.loadLastActionButtons(l);
        if (mode == RouterRuleSetDlg.DialogMode.CreateARule) {
            this.setTitle("Bundle Routing Rules - " + this.substrate.getName());
        } else if (mode == RouterRuleSetDlg.DialogMode.EditAnyRule) {
            this.setTitle("Edit Die Escape Rule Sets - " + this.substrate.getName());
        } else if (mode == RouterRuleSetDlg.DialogMode.EditARule) {
            this.setTitle("Edit Die Escape Rule Set " + rs.getName());
        }
    }

    @Override
    protected void putUIToDb() {
        super.putUIToDb();
        Layer primaryLayer = (Layer)this.pLayer.getSelectedItem();
        if (this.mComboPadTemplate.getSelectedItem() == null) {
            this.saveStringConstraint(this.editingRuleSet, Constraint.PADSTACK, "Default", primaryLayer);
        } else {
            this.saveStringConstraint(this.editingRuleSet, Constraint.PADSTACK, ((PadTemplate)this.mComboPadTemplate.getSelectedItem()).getName(), primaryLayer);
        }
    }

    protected List<PadTemplate> getViaTemplates(Substrate s) {
        Db db = s.getDb();
        return db.getObjects(PadTemplate.class).stream().filter(pad -> pad.getLayers().size() > 1 && pad.getSubstrate() == s).collect(Collectors.toList());
    }

    protected void updateViaDefinition(JComboBox<PadTemplate> box) {
        List<Object> vias = this.getViaTemplates(this.substrate);
        Layer layer = (Layer)this.pLayer.getSelectedItem();
        vias = vias.stream().filter(pad -> pad.getLayerShapes(layer).hasNext()).collect(Collectors.toList());
        Collections.sort(vias, PadTemplate.TopLayerSorter.reversed());
        box.removeAllItems();
        box.addItem(null);
        for (PadTemplate padTemplate : vias) {
            box.addItem(padTemplate);
        }
    }

    @Override
    protected void loadComboBoxes(RouterRuleSetDlg.DialogMode mode) {
        super.loadComboBoxes(mode);
        this.updateViaDefinition(this.mComboPadTemplate);
    }

    @Override
    protected void putDbToUI(RuleSet rs) {
        String padstack;
        this.substrate = rs.getSubstrate();
        this.updateViaDefinition(this.mComboPadTemplate);
        super.putDbToUI(rs);
        this.sLayer.setSelectedItem(null);
        List layers = RuleSet.getRoutingLayers((RuleSet)this.editingRuleSet);
        if (!layers.isEmpty() && (padstack = (String)RuleSetMgr.getConstraintValue((RuleSet)this.editingRuleSet, (Constraint.Descriptor)Constraint.PADSTACK, (Layer)((Layer)layers.get(0)))) != null) {
            this.mComboPadTemplate.setSelectedItem(PadTemplate.get((Db)rs.getDb(), (Substrate)((Layer)layers.get(0)).getSubstrate(), (String)padstack));
        }
    }

    protected class PadStackSelectedListener
    implements ActionListener {
        protected PadStackSelectedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GeneralBundleRuleSetDlg.this.repaint();
        }
    }
}

