/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.AColor;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AMutableReference;
import com.sigrity.acl.APair;
import com.sigrity.acl.ASingletonItr;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.automation.router.PrettyRouter;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import com.sigrity.orbit.automation.router.Topstacle;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.route_edit.EditRouteMode;
import com.sigrity.orbit.ui.route_edit.RoutingOverlay;
import com.sigrity.orbit.ui.wb_route.RouterInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class InteractiveGuidedRouter
implements EditRouteMode.SubMode {
    static final Color COLOR_PROPOSED_ROUTE = Color.RED;
    static final Color COLOR_DRAG_ROUTE = Color.ORANGE;
    static final Color COLOR_MARKER_CENTER = Color.WHITE;
    static final Color COLOR_MARKER_OUTLINE = Color.BLACK;
    protected static HashMap<Key, InteractiveGuidedRouter> mRouters = new HashMap();
    protected int SUGGEST_ROUTE_COUNT = 50;
    protected EditRouteMode mParent;
    protected DesignView2D mView = null;
    protected DesignView2D.ViewMode mPriorViewMode = null;
    protected PrettyRouter mRouter = null;
    protected LinkedList<Segment> mSegments = new LinkedList();
    protected Point mRoutingCursorLoc = null;
    protected IGROverlay mOverlay = null;
    protected boolean mAnimatePotentialPaths = false;
    protected Action mCommitWire = new AbstractAction("Save Wire"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!InteractiveGuidedRouter.this.mSegments.isEmpty()) {
                LinkedList<SingleLayerRouter.RouteInformation> routeInfos = new LinkedList<SingleLayerRouter.RouteInformation>();
                for (Segment s : InteractiveGuidedRouter.this.mSegments) {
                    routeInfos.add(s.getRouteInformation());
                }
                InteractiveGuidedRouter.this.mRouter.addWireFromPotentialPath(routeInfos);
                InteractiveGuidedRouter.this.mView.getCanvas().refresh();
            }
            InteractiveGuidedRouter.this.mCancelRoute.actionPerformed(e);
        }
    };
    protected Action mCancelRoute = new AbstractAction("Cancel Route"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (InteractiveGuidedRouter.this.mView.getCurMode() instanceof IGRMode) {
                InteractiveGuidedRouter.this.mView.setMode(InteractiveGuidedRouter.this.mPriorViewMode);
            }
        }
    };
    static final Color[] COLORS = new Color[]{Color.WHITE, Color.PINK, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.MAGENTA, Color.CYAN, Color.BLUE};

    public static InteractiveGuidedRouter getRouter(DesignView2D view, DevicePath path, Layer layer, boolean create) {
        Key key = new Key(path, layer);
        InteractiveGuidedRouter r = mRouters.get((Object)key);
        if (r == null && create) {
            r = new InteractiveGuidedRouter(view, path, layer);
            mRouters.put(key, r);
        } else if (r != null && r.mView != view) {
            r.mView = view;
        }
        return r;
    }

    public static void releaseRouter(InteractiveGuidedRouter router) {
        Key key = new Key(router.mRouter.getParent(), router.mRouter.getLayer());
        mRouters.remove((Object)key);
    }

    public InteractiveGuidedRouter(DesignView2D view, DevicePath path, Layer layer) {
        this.mRouter = PrettyRouter.getPrettyRouter(path.getLast().getTemplate(), layer, true);
        this.mView = view;
        this.mRouter.setDB(layer.getDb());
        this.mRouter.setParent(path);
        this.mRouter.setLayer(layer);
        ArrayList<Topstacle> obstacles = new ArrayList<Topstacle>();
        RouterInterface.extractObstacles(obstacles, path, layer);
        this.mRouter.setObstacles(obstacles);
        this.mRouter.debugView();
    }

    @Override
    public boolean install(EditRouteMode erm) {
        this.mParent = erm;
        return true;
    }

    @Override
    public void uninstall() {
    }

    @Override
    public LinkedList<Component> getContextMenu(Point loc) {
        LinkedList<Component> items = new LinkedList<Component>();
        DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
        APoint2D worldCursorLoc = xform.getWorldPt(loc);
        APair<Draggable, Point> item = this.getIGROverlay().getPickupItem(xform, worldCursorLoc);
        if (item != null && item.first instanceof Tack) {
            items.add(new JMenuItem(new RemoveTackAction((Tack)item.first)));
        }
        items.add(new JMenuItem(this.mCommitWire));
        items.add(new JMenuItem(this.mCancelRoute));
        return items;
    }

    @Override
    public APoint2D mouseClicked(int button, APoint2D location) {
        return null;
    }

    @Override
    public APoint2D mouseMoved(APoint2D oldLoc, APoint2D newLoc) {
        return null;
    }

    @Override
    public void paintOverlay(Graphics2D g, Rectangle bounds) {
    }

    public void startRoute(HierPin from, HierPin to) {
        Personality routeGroup = from.getDbObject().getRouteGroup();
        if (routeGroup == null) {
            routeGroup = to.getDbObject().getRouteGroup();
        }
        if (routeGroup == null) {
            ALog.logWarn((String)"Cannot route from pin '%s' to pin '%s', unable to determine routing parameters (RouteGroup).", (Object[])new Object[]{from.getDbObject().getName(), to.getDbObject().getName()});
            return;
        }
        Db db = from.getDbObject().getDb();
        Long w = Constraint.getRouteWidth(null, null, (Personality)routeGroup);
        if (w == null) {
            ALog.logWarn((String)"Cannot route from pin '%s' to pin '%s', unable to determine routing wire width (no WIRE_WIDTH constraint on RouteGroup '%s').", (Object[])new Object[]{from.getDbObject().getName(), to.getDbObject().getName(), routeGroup.getName()});
            return;
        }
        Constraint cwc = Constraint.getConstraint((Db)db, (DbObject)routeGroup, (Constraint.Descriptor)Constraint.WIRE_CLEAR);
        if (cwc == null) {
            ALog.logWarn((String)"Cannot route from pin '%s' to pin '%s', unable to determine routing wire clearance (no WIRE_CLEAR constraint on RouteGroup '%s').", (Object[])new Object[]{from.getDbObject().getName(), to.getDbObject().getName(), routeGroup.getName()});
            return;
        }
        Topstacle tFrom = Topstacle.fromDevicePathPort(from);
        tFrom.setShape(from.getDbObject().getWorldShapeOnLayer(from.getPath(), this.mRouter.getLayer()));
        Topstacle tTo = Topstacle.fromDevicePathPort(to);
        tTo.setShape(to.getDbObject().getWorldShapeOnLayer(to.getPath(), this.mRouter.getLayer()));
        Segment seg = new Segment(tFrom, tTo, w, (Long)cwc.getValue());
        this.mSegments.clear();
        this.mSegments.add(seg);
        DesignView2D.ViewMode currentMode = this.mView.getCurMode();
        IGRMode erm = null;
        if (currentMode instanceof IGRMode) {
            IGRMode curIGRMode = (IGRMode)currentMode;
            if (curIGRMode.getOwner() == this) {
                erm = curIGRMode;
            }
        } else {
            erm = new IGRMode();
            erm.setContext(this.mRouter.getParent(), this.mRouter.getLayer());
            this.mView.setMode(erm);
            erm.startSubmode(this);
        }
    }

    protected boolean isFirstSegment(Segment s) {
        return !this.mSegments.isEmpty() && this.mSegments.get(0) == s;
    }

    protected boolean isLastSegment(Segment s) {
        int c = this.mSegments.size();
        return c > 0 && this.mSegments.get(c - 1) == s;
    }

    protected ALine getClosestPathPoint(APoint2D from) {
        return this.getClosestPathPoint(from, null);
    }

    protected ALine getClosestPathPoint(APoint2D from, AMutableReference<Segment> closestSeg) {
        ALine closest = null;
        for (Segment seg : this.mSegments) {
            ALine l = seg.getClosestPoint(from);
            if (l == null) {
                if (closestSeg != null) {
                    closestSeg.set((Object)seg);
                }
                return null;
            }
            if (closest != null && l.getLength() >= closest.getLength()) continue;
            if (closestSeg != null) {
                closestSeg.set((Object)seg);
            }
            closest = l;
        }
        return closest;
    }

    protected APoint2D getClosestPathVertex(APoint2D from) {
        APoint2D closest = null;
        long dist = 0L;
        for (Segment seg : this.mSegments) {
            APoint2D pt = seg.getClosestVertex(from);
            long d = from.distance(pt);
            if (closest != null && d >= dist) continue;
            closest = pt;
            dist = d;
        }
        return closest;
    }

    protected ALine getClosestPreferredRoutePoint(APoint2D from) {
        return this.getClosestPreferredRoutePoint(from, null);
    }

    protected ALine getClosestPreferredRoutePoint(APoint2D from, AMutableReference<Segment> closestSeg) {
        ALine closest = null;
        for (Segment seg : this.mSegments) {
            ALine l = seg.getClosestPreferredRoutePoint(from);
            if (l == null) {
                if (closestSeg != null) {
                    closestSeg.set((Object)seg);
                }
                return null;
            }
            if (closest != null && l.getLength() >= closest.getLength()) continue;
            if (closestSeg != null) {
                closestSeg.set((Object)seg);
            }
            closest = l;
        }
        return closest;
    }

    protected IGRMode getIGRMode() {
        return (IGRMode)this.mParent;
    }

    protected IGROverlay getIGROverlay() {
        return this.getIGRMode().getIGROverlay();
    }

    public static boolean equalPoint(Point p1, Point p2) {
        if (p1 == null && p2 == null) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        return p1.equals(p2);
    }

    public static int radius(Shape s) {
        Rectangle b = s.getBounds();
        return (int)Math.hypot(b.width, b.height) / 2;
    }

    public static class TwoAPoints2D
    extends APair<APoint2D, APoint2D> {
        public TwoAPoints2D(APair<APoint2D, APoint2D> src) {
            super(src);
        }

        public TwoAPoints2D(APoint2D first, APoint2D second) {
            super((Object)first, (Object)second);
        }
    }

    public static class TwoPoints
    extends APair<Point, Point> {
        public TwoPoints(APair<Point, Point> src) {
            super(src);
        }

        public TwoPoints(Point first, Point second) {
            super((Object)first, (Object)second);
        }
    }

    protected class IGROverlay
    extends RoutingOverlay {
        protected Draggable mDragItem;
        protected IGRKeyListener mIGRKeyListener;
        protected IGRMouseAdapter mIGRMouseListener;
        final Shape CURSOR_SHAPE_ROUTE;
        final Shape CURSOR_SHAPE_TACK;
        final Shape TACK_SHAPE;
        Rectangle CURSOR_BOUNDS;

        public IGROverlay(EditRouteMode erm, NamedGrid grid) {
            super(erm, grid);
            this.mDragItem = null;
            this.mIGRKeyListener = new IGRKeyListener();
            this.mIGRMouseListener = new IGRMouseAdapter();
            this.CURSOR_SHAPE_ROUTE = new Rectangle(-4, -4, 9, 9);
            this.CURSOR_SHAPE_TACK = new Polygon(new int[]{0, 5, 0, -5}, new int[]{-5, 0, 5, 0}, 4);
            this.TACK_SHAPE = new Polygon(new int[]{0, 4, 0, -4}, new int[]{-4, 0, 4, 0}, 4);
            this.CURSOR_BOUNDS = this.CURSOR_SHAPE_ROUTE.getBounds();
            this.CURSOR_BOUNDS.add(this.CURSOR_SHAPE_TACK.getBounds());
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.mView.getCanvas().addKeyListener(this.mIGRKeyListener);
        }

        @Override
        public void removeNotify() {
            this.mView.getCanvas().removeKeyListener(this.mIGRKeyListener);
            super.removeNotify();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void paintComponent(Graphics graphics) {
            if (!(graphics instanceof Graphics2D)) {
                assert (false);
                return;
            }
            Graphics2D g = (Graphics2D)graphics;
            DesignCanvas2D.prepareGraphics(g);
            DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
            Color oldColor = g.getColor();
            Area area = new Area(this.getBounds());
            for (Segment segment : InteractiveGuidedRouter.this.mSegments) {
                for (APath aPath : segment.getPotentialPaths()) {
                    Shape screenPath = xform.getScreenShape((AGeom)aPath);
                    area.subtract(new Area(screenPath));
                }
            }
            g.setColor((Color)AColor.withAlpha((Color)Color.BLACK, (int)192));
            g.fill(area);
            if (InteractiveGuidedRouter.this.mAnimatePotentialPaths) {
                int i = 0;
                for (Segment seg : InteractiveGuidedRouter.this.mSegments) {
                    for (APath geom : seg.getPotentialPaths()) {
                        Shape screenPath = xform.getScreenShape((AGeom)geom);
                        g.setColor(COLORS[++i % COLORS.length]);
                        g.fill(screenPath);
                    }
                }
            }
            for (Segment segment : InteractiveGuidedRouter.this.mSegments) {
                APath path = segment.getProposedRoute();
                Shape shape = xform.getScreenShape((AGeom)path);
                if (this.isDragSegment(segment)) {
                    g.setColor((Color)AColor.withAlpha((Color)COLOR_PROPOSED_ROUTE, (int)85));
                } else {
                    g.setColor(COLOR_PROPOSED_ROUTE);
                }
                g.fill(shape);
                if (!InteractiveGuidedRouter.this.isFirstSegment(segment)) {
                    APoint2D p1 = segment.getFromPt();
                    this.paintTack(g, xform.getScreenPt(p1), this.isDragTack(p1));
                }
                if (InteractiveGuidedRouter.this.isLastSegment(segment)) continue;
                APoint2D p2 = segment.getToPt();
                this.paintTack(g, xform.getScreenPt(p2), this.isDragTack(p2));
            }
            if (InteractiveGuidedRouter.this.mRoutingCursorLoc != null) {
                void var7_15;
                APair<Draggable, Point> pu;
                Point p = InteractiveGuidedRouter.this.mRoutingCursorLoc;
                InteractiveGuidedRouter.this.mRoutingCursorLoc = null;
                Draggable draggable = this.mDragItem;
                if (draggable == null && (pu = this.getPickupItem(xform, xform.getWorldPt(p))) != null) {
                    Draggable draggable2 = (Draggable)pu.first;
                }
                this.paintRoutingCursor(g, p, (Draggable)var7_15);
            }
            g.setColor(oldColor);
        }

        @Override
        protected MouseListener getMouseListener() {
            return this.mIGRMouseListener;
        }

        @Override
        protected MouseMotionListener getMouseMotionListener() {
            return this.mIGRMouseListener;
        }

        protected void updateMouseCursor(int x, int y) {
            if (InteractiveGuidedRouter.this.mSegments.isEmpty()) {
                return;
            }
            DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
            Point cursorLoc = new Point(x, y);
            APoint2D worldCursorLoc = xform.getWorldPt(cursorLoc);
            if (this.inDrag()) {
                APoint2D snap = InteractiveGuidedRouter.this.getClosestPathVertex(worldCursorLoc);
                cursorLoc = xform.getScreenPt(snap);
                this.paintRoutingCursor(null, cursorLoc, this.mDragItem);
            } else {
                APair<Draggable, Point> pickup = this.getPickupItem(xform, worldCursorLoc);
                if (pickup != null) {
                    this.paintRoutingCursor(null, (Point)pickup.second, (Draggable)pickup.first);
                }
                if (pickup != null && cursorLoc.distance((Point2D)pickup.second) <= (double)InteractiveGuidedRouter.radius(this.CURSOR_SHAPE_ROUTE)) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    this.setCursor(null);
                }
            }
        }

        protected void startDrag(int x, int y) {
            Point cursorLoc;
            APoint2D worldCursorLoc;
            if (InteractiveGuidedRouter.this.mSegments.isEmpty()) {
                return;
            }
            DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
            APair<Draggable, Point> pickupPoint = this.getPickupItem(xform, worldCursorLoc = xform.getWorldPt(cursorLoc = new Point(x, y)));
            if (pickupPoint != null && cursorLoc.distance((Point2D)pickupPoint.second) <= (double)InteractiveGuidedRouter.radius(this.CURSOR_SHAPE_ROUTE)) {
                this.setCursor(Cursor.getPredefinedCursor(13));
                this.mDragItem = (Draggable)pickupPoint.first;
            }
        }

        protected void abortDrag() {
            if (!this.inDrag()) {
                return;
            }
            this.mDragItem = null;
            InteractiveGuidedRouter.this.mParent.repaintOverlay(true);
            Point mouseLoc = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(mouseLoc, this.mView.getCanvas());
            this.updateMouseCursor(mouseLoc.x, mouseLoc.y);
        }

        protected void endDrag(int x, int y) {
            Point cursorLoc;
            if (!this.inDrag()) {
                return;
            }
            DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
            APoint2D worldCursorLoc = xform.getWorldPt(cursorLoc = new Point(x, y));
            APoint2D tackAt = InteractiveGuidedRouter.this.getClosestPathVertex(worldCursorLoc);
            if (tackAt != null) {
                SingleLayerRouter.RouteInformation from;
                TwoAPoints2D endPoints = this.mDragItem.getEndPoints();
                if (tackAt.equals(endPoints.first) || tackAt.equals(endPoints.second)) {
                    return;
                }
                SingleLayerRouter.RouteInformation to = from = ((Segment)this.mDragItem.getSegments().next()).getRouteInformation();
                int startIdx = -1;
                for (Segment s : this.mDragItem.getSegments()) {
                    if (s.getRouteInformation() != to) {
                        to = s.getRouteInformation();
                    }
                    int idx = InteractiveGuidedRouter.this.mSegments.indexOf(s);
                    if (startIdx < 0) {
                        startIdx = idx;
                    }
                    InteractiveGuidedRouter.this.mSegments.remove(idx);
                }
                for (Topstacle t : this.mDragItem.getTacks()) {
                    InteractiveGuidedRouter.this.mRouter.removeTackPoint(t);
                }
                Topstacle tack = InteractiveGuidedRouter.this.mRouter.addTackPoint(tackAt);
                Segment s1 = new Segment(from.getFrom(), tack, from.getWidth(), from.getClear());
                InteractiveGuidedRouter.this.mSegments.add(startIdx, s1);
                Segment s2 = new Segment(tack, to.getTo(), to.getWidth(), to.getClear());
                InteractiveGuidedRouter.this.mSegments.add(startIdx + 1, s2);
            }
            this.setCursor(null);
            this.mDragItem = null;
            this.updateMouseCursor(x, y);
        }

        protected boolean inDrag() {
            return this.mDragItem != null;
        }

        protected boolean isDragSegment(Segment s) {
            return this.mDragItem != null && this.mDragItem.contains(s);
        }

        protected boolean isDragTack(Topstacle t) {
            return this.mDragItem != null && this.mDragItem.contains(t);
        }

        protected boolean isDragTack(APoint2D p) {
            Tack t;
            APoint2D pt;
            return this.mDragItem instanceof Tack && (pt = (t = (Tack)this.mDragItem).getTackItem().getPoint()).equals((Object)p);
        }

        protected APair<Draggable, Point> getPickupItem(DesignCanvas2D.XForm xform, APoint2D worldCursorLoc) {
            long away;
            APoint2D pt;
            long dist;
            long d;
            int screenDist;
            Point closestPoint = null;
            AMutableReference segRef = new AMutableReference();
            ALine l = InteractiveGuidedRouter.this.getClosestPreferredRoutePoint(worldCursorLoc, (AMutableReference<Segment>)segRef);
            Segment seg = (Segment)segRef.get();
            if (l == null) {
                l = new ALine(worldCursorLoc, worldCursorLoc);
            }
            if ((screenDist = xform.getScreenLength(d = l.getLength())) < 18) {
                APoint2D pointOnPath = l.getP1();
                closestPoint = xform.getScreenPt(pointOnPath);
            }
            if (closestPoint == null) {
                return null;
            }
            Draggable t = null;
            long wThreshold = xform.getWorldLength(8);
            if (!InteractiveGuidedRouter.this.isFirstSegment(seg) && (dist = (pt = seg.getFromPt()).distance(worldCursorLoc)) < wThreshold) {
                d = dist;
                closestPoint = xform.getScreenPt(pt);
                t = new Tack(seg, false);
            }
            if (!(InteractiveGuidedRouter.this.isLastSegment(seg) || (away = (pt = seg.getToPt()).distance(worldCursorLoc)) >= wThreshold && away >= d)) {
                d = away;
                closestPoint = xform.getScreenPt(pt);
                t = new Tack(seg, true);
            }
            return new APair((Object)(t != null ? t : seg), (Object)closestPoint);
        }

        public void paintRoutingCursor(Graphics2D g, Point newLoc, Draggable dragItem) {
            Point end;
            if (InteractiveGuidedRouter.equalPoint(InteractiveGuidedRouter.this.mRoutingCursorLoc, newLoc)) {
                return;
            }
            Graphics2D g2 = g != null ? g : (Graphics2D)this.getGraphics();
            DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
            TwoAPoints2D changeEnds = dragItem == null ? null : dragItem.getEndPoints();
            Point start = changeEnds == null ? null : xform.getScreenPt((APoint2D)changeEnds.first);
            Point point = end = changeEnds == null ? null : xform.getScreenPt((APoint2D)changeEnds.second);
            if (InteractiveGuidedRouter.this.mRoutingCursorLoc != null) {
                Rectangle b = new Rectangle(this.CURSOR_BOUNDS);
                ++b.width;
                ++b.height;
                b.translate(InteractiveGuidedRouter.this.mRoutingCursorLoc.x, InteractiveGuidedRouter.this.mRoutingCursorLoc.y);
                if (changeEnds != null) {
                    b.add(start);
                    b.add(end);
                }
                this.repaint(b);
            }
            if (newLoc != null) {
                Shape shape = dragItem instanceof Tack ? this.CURSOR_SHAPE_TACK : this.CURSOR_SHAPE_ROUTE;
                g2.setColor(COLOR_MARKER_CENTER);
                AffineTransform oldXform = g2.getTransform();
                g2.translate(newLoc.x, newLoc.y);
                g2.fill(shape);
                g2.setColor(COLOR_MARKER_OUTLINE);
                g2.draw(shape);
                g2.setTransform(oldXform);
                if (this.inDrag() && start != null) {
                    g2.setColor(COLOR_DRAG_ROUTE);
                    g2.drawLine(start.x, start.y, newLoc.x, newLoc.y);
                    g2.drawLine(newLoc.x, newLoc.y, end.x, end.y);
                }
            }
            InteractiveGuidedRouter.this.mRoutingCursorLoc = newLoc;
            if (g == null) {
                g2.dispose();
            }
        }

        public void paintTack(Graphics2D g2, Point loc, boolean dragTack) {
            g2.setColor(COLOR_MARKER_CENTER);
            AffineTransform oldXform = g2.getTransform();
            g2.translate(loc.x, loc.y);
            g2.setColor((Color)(dragTack ? AColor.withAlpha((Color)COLOR_MARKER_CENTER, (int)192) : COLOR_MARKER_CENTER));
            g2.fill(this.TACK_SHAPE);
            g2.setColor((Color)(dragTack ? AColor.withAlpha((Color)COLOR_MARKER_OUTLINE, (int)192) : COLOR_MARKER_OUTLINE));
            g2.draw(this.TACK_SHAPE);
            g2.setTransform(oldXform);
        }

        protected class IGRMouseAdapter
        extends MouseAdapter {
            protected IGRMouseAdapter() {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                IGROverlay.this.updateMouseCursor(e.getX(), e.getY());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                IGROverlay.this.updateMouseCursor(e.getX(), e.getY());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    return;
                }
                if (e.getButton() != 1) {
                    return;
                }
                IGROverlay.this.startDrag(e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                IGROverlay.this.endDrag(e.getX(), e.getY());
            }
        }

        protected class IGRKeyListener
        extends KeyAdapter {
            protected IGRKeyListener() {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27 && IGROverlay.this.inDrag()) {
                    IGROverlay.this.abortDrag();
                }
            }
        }
    }

    protected class IGRMode
    extends EditRouteMode {
        protected IGRMode() {
        }

        @Override
        public void installMode(DesignView2D view) {
            InteractiveGuidedRouter.this.mPriorViewMode = view.getPriorMode();
            super.installMode(view);
        }

        @Override
        protected RoutingOverlay createOverlay(NamedGrid grid) {
            return new IGROverlay(this, grid);
        }

        @Override
        protected void removingMode() {
            super.removingMode();
            InteractiveGuidedRouter.releaseRouter(InteractiveGuidedRouter.this);
        }

        public InteractiveGuidedRouter getOwner() {
            return InteractiveGuidedRouter.this;
        }

        @Override
        protected void createOptionsDisplay() {
        }

        @Override
        protected void concatMenuItems(JPopupMenu menu, Collection<Component> items) {
            int idx = 0;
            for (Component c : items) {
                menu.insert(c, idx++);
            }
            menu.insert(new JSeparator(), idx++);
        }

        public IGROverlay getIGROverlay() {
            return (IGROverlay)this.mRoutingOverLay;
        }
    }

    protected class Tack
    implements Draggable {
        protected Topstacle mTackItem;
        protected APair<Segment, Segment> mTackSegs = null;

        public Tack(Topstacle tackItem, Segment seg1, Segment seg2) {
            this.mTackItem = tackItem;
            this.mTackSegs = new APair((Object)seg1, (Object)seg2);
        }

        public Tack(Segment seg, boolean firstSeg) {
            if (firstSeg) {
                int idx1 = InteractiveGuidedRouter.this.mSegments.indexOf(seg);
                Segment seg2 = InteractiveGuidedRouter.this.mSegments.get(idx1 + 1);
                this.mTackSegs = new APair((Object)seg, (Object)seg2);
                this.mTackItem = seg.getTo();
            } else {
                int idx2 = InteractiveGuidedRouter.this.mSegments.indexOf(seg);
                Segment seg1 = InteractiveGuidedRouter.this.mSegments.get(idx2 - 1);
                this.mTackSegs = new APair((Object)seg1, (Object)seg);
                this.mTackItem = seg.getFrom();
            }
        }

        public Topstacle getTackItem() {
            return this.mTackItem;
        }

        public Segment getFirstSegment() {
            return (Segment)this.mTackSegs.first;
        }

        public Segment getSecondSegment() {
            return (Segment)this.mTackSegs.second;
        }

        @Override
        public boolean contains(Segment s) {
            return this.mTackSegs.first == s || this.mTackSegs.second == s;
        }

        @Override
        public boolean contains(Topstacle t) {
            return this.mTackItem == t;
        }

        @Override
        public TwoAPoints2D getEndPoints() {
            return new TwoAPoints2D(this.getFirstSegment().getFromPt(), this.getSecondSegment().getToPt());
        }

        @Override
        public IterableIterator<Segment> getSegments() {
            return new AIterableItr((Object[])new Segment[]{(Segment)this.mTackSegs.first, (Segment)this.mTackSegs.second});
        }

        @Override
        public IterableIterator<Topstacle> getTacks() {
            return new ASingletonItr((Object)this.mTackItem);
        }
    }

    protected class Segment
    implements Draggable {
        protected SingleLayerRouter.RouteInformation mRouteInfo = null;
        protected LinkedList<APath> mPotentialPaths = new LinkedList();
        protected APath mProposedRoute = null;
        protected SingleLayerRouter.PotentialPathListener mPotentialPathListener = new SingleLayerRouter.PotentialPathListener(){

            @Override
            public boolean notifyPotentialPath(APath path) {
                Segment.this.mPotentialPaths.add(path);
                if (Segment.this.mProposedRoute == null) {
                    Segment.this.mProposedRoute = path.copy();
                    Segment.this.mProposedRoute.setWidth(Segment.this.mRouteInfo.getWidth());
                }
                if (InteractiveGuidedRouter.this.mParent != null) {
                    if (!InteractiveGuidedRouter.this.mAnimatePotentialPaths) {
                        InteractiveGuidedRouter.this.mParent.repaintView();
                    } else {
                        InteractiveGuidedRouter.this.mParent.repaintOverlay(true);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                return Segment.this.mPotentialPaths.size() < InteractiveGuidedRouter.this.SUGGEST_ROUTE_COUNT;
            }
        };

        public Segment(Topstacle from, Topstacle to, long width, long clear) {
            this.mRouteInfo = new SingleLayerRouter.RouteInformation();
            this.mRouteInfo.setFrom(from);
            this.mRouteInfo.setTo(to);
            this.mRouteInfo.setWidth(width);
            this.mRouteInfo.setClear(clear);
            this.mRouteInfo.setPinExitLength(0L);
            this.update();
        }

        public SingleLayerRouter.RouteInformation getRouteInformation() {
            return this.mRouteInfo;
        }

        public Iterable<APath> getPotentialPaths() {
            return this.mPotentialPaths;
        }

        public APath getProposedRoute() {
            return this.mProposedRoute;
        }

        public Topstacle getFrom() {
            return this.mRouteInfo.getFrom();
        }

        public Topstacle getTo() {
            return this.mRouteInfo.getTo();
        }

        public APoint2D getFromPt() {
            return this.mRouteInfo.getFrom().getPoint();
        }

        public APoint2D getToPt() {
            return this.mRouteInfo.getTo().getPoint();
        }

        public ALine getClosestPoint(APoint2D from) {
            ALine closest = null;
            for (APath path : this.mPotentialPaths) {
                ALine l = path.distanceToCenterLine(from);
                if (l == null) {
                    return null;
                }
                if (closest != null && l.getLength() >= closest.getLength()) continue;
                closest = l;
            }
            return closest;
        }

        public APoint2D getClosestVertex(APoint2D from) {
            APoint2D closest = null;
            long dist = 0L;
            for (APath path : this.mPotentialPaths) {
                for (APoint2D pt : path.getPoints()) {
                    long d = from.distance(pt);
                    if (closest != null && d >= dist) continue;
                    closest = pt;
                    dist = d;
                }
            }
            return closest;
        }

        public ALine getClosestPreferredRoutePoint(APoint2D from) {
            if (this.mProposedRoute == null) {
                return null;
            }
            return this.mProposedRoute.distanceToCenterLine(from);
        }

        protected void update() {
            this.mProposedRoute = null;
            this.mPotentialPaths.clear();
            InteractiveGuidedRouter.this.mRouter.suggestRoutes(this.mRouteInfo, this.mPotentialPathListener);
        }

        @Override
        public boolean contains(Segment s) {
            return s == this;
        }

        @Override
        public boolean contains(Topstacle t) {
            return false;
        }

        public String toString() {
            return String.format("%s from %s to %s", super.toString(), this.getFromPt(), this.getToPt());
        }

        @Override
        public TwoAPoints2D getEndPoints() {
            return new TwoAPoints2D(this.getFromPt(), this.getToPt());
        }

        @Override
        public IterableIterator<Segment> getSegments() {
            return new ASingletonItr((Object)this);
        }

        @Override
        public IterableIterator<Topstacle> getTacks() {
            return AEmptyItr.create();
        }
    }

    protected static interface Draggable {
        public TwoAPoints2D getEndPoints();

        public IterableIterator<Segment> getSegments();

        public IterableIterator<Topstacle> getTacks();

        public boolean contains(Segment var1);

        public boolean contains(Topstacle var1);
    }

    protected class RemoveTackAction
    extends AbstractAction {
        protected Tack mTack;

        public RemoveTackAction(Tack tack) {
            super("Remove tack");
            this.mTack = tack;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int idx = InteractiveGuidedRouter.this.mSegments.indexOf(this.mTack.mTackSegs.first);
            if (idx < 0) {
                ALog.logError((String)"Error removing tack.");
                assert (false);
                return;
            }
            SingleLayerRouter.RouteInformation from = this.mTack.getFirstSegment().getRouteInformation();
            Topstacle to = this.mTack.getSecondSegment().getTo();
            InteractiveGuidedRouter.this.mSegments.remove(idx);
            InteractiveGuidedRouter.this.mSegments.remove(idx);
            InteractiveGuidedRouter.this.mRouter.removeTackPoint(this.mTack.mTackItem);
            Segment s = new Segment(from.getFrom(), to, from.getWidth(), from.getClear());
            InteractiveGuidedRouter.this.mSegments.add(idx, s);
        }
    }

    protected static class Key
    extends APair<DevicePath, Layer> {
        public Key(APair<DevicePath, Layer> src) {
            super(src);
        }

        public Key(DevicePath first, Layer second) {
            super((Object)first, (Object)second);
        }
    }
}

