/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.router.PrettyRouter;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class IterativeRouterInterface {
    protected Constraint.RouteStrategy mStrategy;
    protected PrettyRouter mRouter;
    protected boolean mDebug = false;
    Random mR = new Random(34L);

    public IterativeRouterInterface(Constraint.RouteStrategy strategy, PrettyRouter router) {
        this.mStrategy = strategy;
        this.mRouter = router;
    }

    public int numberUnroutable(ArrayList<SingleLayerRouter.RouteInformation> toBeRouted) {
        int num = 0;
        for (SingleLayerRouter.RouteInformation ri : toBeRouted) {
            if (this.goodRoute(ri)) continue;
            ++num;
        }
        return num;
    }

    protected void cloneOrder(ArrayList<SingleLayerRouter.RouteInformation> from, ArrayList<SingleLayerRouter.RouteInformation> to) {
        to.clear();
        for (SingleLayerRouter.RouteInformation ri : from) {
            SingleLayerRouter.RouteInformation copy = new SingleLayerRouter.RouteInformation(ri);
            copy.removeWire();
            to.add(copy);
        }
    }

    public void routeByCompletion(ArrayList<SingleLayerRouter.RouteInformation> toBeRouted) {
        OrbitIO.getCurDb().setHistoryEnabled(false);
        int maxPass = 3;
        this.mRouter.globalRoute(true);
        int numUnrouted = this.numberUnroutable(toBeRouted);
        int pass = 1;
        SingleLayerRouter.updateProgress(false, (double)pass / (double)maxPass, "Unrouted: " + numUnrouted);
        ArrayList<SingleLayerRouter.RouteInformation> bestOrder = new ArrayList<SingleLayerRouter.RouteInformation>();
        this.cloneOrder(toBeRouted, bestOrder);
        int bestUnrouteCount = numUnrouted;
        while (numUnrouted > 0 && pass < maxPass) {
            this.sortWithXings(toBeRouted);
            this.mRouter.clearRoutes();
            this.mRouter.route(true, ++pass);
            numUnrouted = this.numberUnroutable(toBeRouted);
            this.mRouter.clearRoutes();
            if (numUnrouted <= bestUnrouteCount) {
                bestUnrouteCount = numUnrouted;
                this.cloneOrder(toBeRouted, bestOrder);
            } else {
                this.cloneOrder(bestOrder, toBeRouted);
                numUnrouted = this.numberUnroutable(toBeRouted);
            }
            SingleLayerRouter.updateProgress(false, (double)pass / (double)maxPass, "Unrouted: " + numUnrouted);
        }
        this.mRouter.clearRoutes();
        this.cloneOrder(bestOrder, toBeRouted);
        this.mRouter.setToBeRouted(toBeRouted);
        this.mRouter.route(true, pass);
        SingleLayerRouter.updateProgress(true, 100.0, "Unrouted: " + numUnrouted);
    }

    protected boolean efficientRoute(SingleLayerRouter.RouteInformation ri) {
        return !(ri.getEfficiency() < 0.4);
    }

    protected boolean loopiRoute(SingleLayerRouter.RouteInformation ri) {
        return ri.getLoopiness() >= 0.4;
    }

    protected boolean goodRoute(SingleLayerRouter.RouteInformation ri) {
        return ri.getSucess() && this.efficientRoute(ri);
    }

    private boolean isAGoodRoute(SingleLayerRouter.RouteInformation r) {
        if (r.getWire() == null) {
            return false;
        }
        return r.getSucess();
    }

    private void sortWithXings(ArrayList<SingleLayerRouter.RouteInformation> toBeRouted) {
        int size = toBeRouted.size();
        ArrayList<SingleLayerRouter.RouteInformation> badRoutes = new ArrayList<SingleLayerRouter.RouteInformation>();
        ArrayList<SingleLayerRouter.RouteInformation> goodRoutes = new ArrayList<SingleLayerRouter.RouteInformation>();
        HashMap<SingleLayerRouter.RouteInformation, Integer> numCrossed = new HashMap<SingleLayerRouter.RouteInformation, Integer>();
        int lastBadRouteIndex = 0;
        for (int i = 1; i < size; ++i) {
            SingleLayerRouter.RouteInformation ri = toBeRouted.get(i);
            if (!ri.getSucess()) {
                badRoutes.add(ri);
                lastBadRouteIndex = i;
                continue;
            }
            goodRoutes.add(ri);
        }
        for (SingleLayerRouter.RouteInformation badRoute : badRoutes) {
            ALine l = new ALine(badRoute.getFrom().getPoint(), badRoute.getTo().getPoint());
            for (int i = 0; i < lastBadRouteIndex; ++i) {
                SingleLayerRouter.RouteInformation goodRoute = toBeRouted.get(i);
                if (!this.isAGoodRoute(goodRoute)) continue;
                if (l == null || goodRoute == null || goodRoute.getWire() == null) {
                    ALog.logInfo((String)"");
                }
                if (!l.intersects((AGeom)goodRoute.getWire().getPath())) continue;
                Integer nc = (Integer)numCrossed.get(goodRoute);
                if (nc == null) {
                    nc = 1;
                } else {
                    Integer n = nc;
                    Integer n2 = nc = Integer.valueOf(nc + 1);
                }
                numCrossed.put(goodRoute, nc);
            }
        }
        SingleLayerRouter.RouteInformation mostCrossed = null;
        Integer mostCrossedNum = 0;
        for (SingleLayerRouter.RouteInformation goodRoute : goodRoutes) {
            Integer nc = (Integer)numCrossed.get(goodRoute);
            if (nc == null || nc <= mostCrossedNum) continue;
            mostCrossedNum = nc;
            mostCrossed = goodRoute;
        }
        if (mostCrossed != null) {
            toBeRouted.remove(mostCrossed);
            toBeRouted.add(lastBadRouteIndex, mostCrossed);
        }
    }
}

