/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.APatternColor;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;

public class LayerSelectorCombo
extends JComboBox<Layer> {
    Substrate mSubstrate = null;

    public LayerSelectorCombo(Substrate s) {
        this.mSubstrate = s;
        this.updateLayerCombo(s);
        this.setRenderer(new LayerRenderer());
    }

    protected void updateLayerCombo(Substrate s) {
        ArrayList<Layer> sortedLayers = new ArrayList<Layer>();
        for (Layer l : s.getLayers()) {
            sortedLayers.add(l);
        }
        Collections.sort(sortedLayers);
        Collections.reverse(sortedLayers);
        for (Layer l : sortedLayers) {
            this.addItem(l);
        }
    }

    class LayerRenderer
    extends DefaultListCellRenderer {
        LayerRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof Layer) {
                APatternColor color;
                Layer l = (Layer)value;
                this.setText(l.getName());
                ViewColorizer colorizer = OrbitIO.getCurColorizer();
                DevicePath path = l.getSubstrate().getADevicePathUsing();
                APatternColor aPatternColor = color = path == null ? null : colorizer.getColor(path, l, true);
                if (color != null) {
                    this.setIcon((Icon)new AColorIcon(16, 16, color.getColor()));
                }
            }
            if (value == null) {
                this.setText("No Layer");
            }
            return c;
        }
    }
}

