/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.APair;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.ACheckBoxList;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.ATristateCheckBox;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.SubstrateTemplate;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class LayerSelectorDlg
extends ADialog {
    protected ATristateCheckBox mCbSelectAll;
    protected JButton mBtnApply;
    protected boolean mUserOked = false;
    protected Layer.LayerType mType = null;
    protected final DefaultListModel<Layer> mLm = new DefaultListModel();
    protected final ACheckBoxList<Layer> mList = new ACheckBoxList<Layer>((ListModel<Layer>)this.mLm);
    protected boolean mInStateUpdate = false;
    protected ActionListener mOk = e -> {
        Set<Layer> curSel;
        boolean nonRouteLayer;
        this.mUserOked = true;
        if (this.mType != null && this.mType.equals((Object)Layer.LayerType.Route) && (nonRouteLayer = (curSel = this.getSelected()).stream().anyMatch(l -> !l.isRoutable()))) {
            String msg = "Non-route layers selected. Note that this could cause problems when exported to other tools.";
            JOptionPane.showMessageDialog(null, msg, "Warning", 2);
        }
        UIUtil.closeWindow((Window)((Object)this));
    };
    private static final Comparator<SubstrateTemplate> ALPHA_NUMERIC_ORDER = (e1, e2) -> {
        AAlphaNumComp c = AAlphaNumComp.get();
        return c.compare((Object)((Substrate)e1.first).getName(), (Object)((Substrate)e2.first).getName());
    };

    public static LayerSelectorDlg showMe(AAppView view, Substrate s, Set<Layer> initSel, Layer.LayerType type) {
        LayerSelectorDlg lsd = new LayerSelectorDlg(view, s, initSel, type);
        lsd.setVisible(true);
        return lsd;
    }

    public static LayerSelectorDlg showMe(AAppView view, Substrate s, Set<Layer> initSel) {
        return LayerSelectorDlg.showMe(view, s, initSel, null);
    }

    protected LayerSelectorDlg(AAppView view, Substrate s, Set<Layer> initSel, Layer.LayerType type) {
        super(view.getComponent());
        this.setModal(true);
        this.setTitle((String)(type == null ? "Select Layers" : "Select " + type.name() + " Layers"));
        this.mType = type;
        final ViewColorizer colorizer = view instanceof DesignView2D ? ((DesignView2D)view).getCanvas().getColorizer() : ViewColorizer.getDefaultColorizer();
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        this.mCbSelectAll = (ATristateCheckBox)l.add((Component)new ATristateCheckBox("All"), (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetBottom(0));
        l.newline();
        this.mList.setCellRenderer(new ACheckBoxList.CheckBoxListCellRenderer<Layer>(){

            @Override
            public Boolean isChecked(int idx) {
                return LayerSelectorDlg.this.mList.isChecked(idx);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends Layer> list, Layer layer, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, null, index, isSelected, cellHasFocus);
                Layer.LayerType type = layer.getType();
                APatternColor color = colorizer.getColor(null, layer, true);
                if (color != null) {
                    this.mLabel.setIcon((Icon)new AColorIcon(16, 16, color.getColor()));
                }
                this.mLabel.setText(layer.getName() + " (" + type.name() + ")");
                this.mLabel.setEnabled(LayerSelectorDlg.this.mType == null || type == LayerSelectorDlg.this.mType);
                return this;
            }
        });
        this.mList.setSelectionMode(0);
        l.add((Component)new JScrollPane(this.mList), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.newline();
        l.push((GridBagConstraints)GridBagManager.RIGHT);
        this.mBtnApply = (JButton)l.add((Component)new JButton("Ok"), (GridBagConstraints)GridBagManager.RIGHT);
        this.mBtnApply.addActionListener(this.mOk);
        JButton btnClose = new JButton("Cancel");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        if (s != null) {
            s.getLayers(Layer.TopFirstSort).stream().forEach(layer -> this.mLm.addElement((Layer)layer));
        } else {
            AUtil.linkedList(SubstrateTemplate.getSubstrateInstances(OrbitIO.getCurDb(), true, false, null)).stream().sorted(ALPHA_NUMERIC_ORDER).forEach(dbObj -> {
                Substrate sub = (Substrate)dbObj.first;
                sub.getLayers(Layer.TopFirstSort).stream().forEach(layer -> this.mLm.addElement((Layer)layer));
            });
        }
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)this.mBtnApply);
        this.pack();
        this.setMinimumSize(this.getMinimumSize());
        UIUtil.center((Component)((Object)this));
        this.mList.addCheckListener(idx -> this.stateUpdate(() -> {
            boolean allSel = true;
            boolean noneSel = true;
            Set<Layer> curSel = this.getSelected();
            for (Layer lyr : AIterableItr.itr(this.mLm.elements())) {
                if (curSel.contains(lyr)) {
                    noneSel = false;
                    continue;
                }
                allSel = false;
            }
            Boolean newState = null;
            if (allSel) {
                newState = true;
            } else if (noneSel) {
                newState = false;
            }
            this.mCbSelectAll.setState(newState);
        }));
        this.mCbSelectAll.addActionListener(ae -> this.stateUpdate(() -> {
            if (this.mCbSelectAll.getState() == null) {
                this.mCbSelectAll.setSelected(true);
            }
            this.mList.checkAll(this.mCbSelectAll.isSelected());
        }));
        this.setChecked(initSel);
    }

    protected void stateUpdate(Runnable r) {
        if (this.mInStateUpdate) {
            return;
        }
        this.mInStateUpdate = true;
        try {
            r.run();
        }
        finally {
            this.mInStateUpdate = false;
        }
    }

    protected Integer getIndexOfLayer(LinkedList<APair<Integer, Layer>> pairs, Layer layer) {
        for (APair aPair : pairs) {
            if (aPair.second != layer) continue;
            return (Integer)aPair.first;
        }
        return null;
    }

    protected void setChecked(Set<Layer> layers) {
        if (layers == null) {
            return;
        }
        LinkedList pairs = new LinkedList();
        this.mList.getIndexedItems().forEach(p -> pairs.add(p));
        this.mList.clearChecked();
        layers.forEach(l -> {
            Integer idx = this.getIndexOfLayer(pairs, (Layer)l);
            if (idx != null) {
                this.mList.setChecked(idx, true);
            }
        });
    }

    public Set<Layer> getSelected() {
        return this.mList.getCheckedItems().stream().collect(Collectors.toSet());
    }

    public List<Layer> getSelectedInOrder() {
        return this.mList.getCheckedItems().stream().collect(Collectors.toList());
    }

    public boolean getUserOked() {
        return this.mUserOked;
    }
}

