/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.AExpression;
import com.sigrity.acl.AHashArray;
import com.sigrity.acl.AHashCollection;
import com.sigrity.acl.ALog;
import com.sigrity.acl.Stopwatch;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.DevicePathPortPair;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.RuleSetMgr;
import com.sigrity.orbit.UserCommands;
import com.sigrity.orbit.automation.router.PrettyRouter;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import com.sigrity.orbit.automation.router.Topstacle;
import com.sigrity.orbit.factory.RDLViaPlacementFactory;
import com.sigrity.orbit.factory.ViaFactory;
import com.sigrity.orbit.ui.wb_route.RouteQueue;
import com.sigrity.orbit.ui.wb_route.RouterInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;

public class PackageRouterInterface {
    static int viaStyle;
    public static int RDL_MAX_PASS;
    LinkedList<String> personalityKeys = new LinkedList();
    DevicePath diePath = null;
    DevicePath routeOnPath = null;

    public static void setViaStyle(int s) {
        viaStyle = s;
    }

    public void addPersonality(String key) {
        this.personalityKeys.add(key);
    }

    public void setDiePath(String path) {
        this.routeOnPath = this.diePath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)path);
    }

    protected Constraint.LayerUseStrategy getViaStrategy() {
        Db db = OrbitIO.getCurDb();
        for (String pString : this.personalityKeys) {
            Personality p = Personality.getByKeyStr((Db)db, (String)pString);
            LinkedList<SchedConn> orderedConnections = new LinkedList<SchedConn>();
            for (SchedConn sc : p.getSchedConns()) {
                orderedConnections.add(sc);
            }
            for (SchedConn sc : orderedConnections) {
                RuleSet ruleSet;
                if (sc.getPortA() == null || sc.getPortB() == null || RouteQueue.getIgnore(sc) || (ruleSet = RuleSetMgr.getMyRuleSet((DbObject)sc.getHierPortA().getPin())) == null) continue;
                return (Constraint.LayerUseStrategy)RuleSetMgr.getConstraintValue((RuleSet)ruleSet, (Constraint.Descriptor)Constraint.LAYER_USE_STRATEGY, null);
            }
        }
        return null;
    }

    public void route() {
        ArrayList<SingleLayerRouter.RouteInformation> secondaryLayerRoutes = new ArrayList<SingleLayerRouter.RouteInformation>();
        ArrayList<SingleLayerRouter.RouteInformation> primaryLayerRoutes = new ArrayList<SingleLayerRouter.RouteInformation>();
        RDLViaPlacementFactory rvpf = new RDLViaPlacementFactory();
        rvpf.start();
        Db db = OrbitIO.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        LinkedList<SchedConn> validSchedConn = new LinkedList<SchedConn>();
        Substrate substrate = null;
        for (String pString : this.personalityKeys) {
            Personality p = Personality.getByKeyStr((Db)db, (String)pString);
            LinkedList<SchedConn> orderedConnections = new LinkedList<SchedConn>();
            for (SchedConn sc : p.getSchedConns()) {
                orderedConnections.add(sc);
            }
            Collections.sort(orderedConnections, new RouteQueue.SchedConnRouterSorter(false));
            for (SchedConn sc : orderedConnections) {
                RuleSet thisRs;
                if (sc.getPortA() == null || sc.getPortB() == null || RouteQueue.getIgnore(sc) || sc.getHierPortA().getPinTemplate().getNet().isUnused() || (thisRs = RuleSetMgr.getMyRuleSet((DbObject)sc.getHierPortA().getPin())) == null) continue;
                validSchedConn.add(sc);
                if (substrate != null) continue;
                substrate = p.getOwner().getSubstrate();
            }
        }
        int ith = 0;
        RuleSet aRuleSet = null;
        Layer aPrimaryLayer = null;
        Layer aSecondaryLayer = null;
        for (SchedConn sc : validSchedConn) {
            AExpression expr;
            DevicePathPortPair dppp;
            Constraint.LayerUseStrategy lus;
            RuleSet mainRuleSet;
            ++ith;
            HierPin relativeFrom = sc.getDPPA();
            DevicePath rPath = (DevicePath)relativeFrom.first;
            rPath = rPath.pathToParent(substrate);
            relativeFrom = new HierPin(rPath, relativeFrom.getPin());
            aRuleSet = mainRuleSet = RuleSetMgr.getMyRuleSet((DbObject)sc.getHierPortA().getPin());
            Layer primaryLayer = (Layer)RuleSetMgr.getConstraintValue((RuleSet)mainRuleSet, (Constraint.Descriptor)Constraint.ROUTE_LAYER, null);
            Layer secondaryLayer = (Layer)RuleSetMgr.getConstraintValue((RuleSet)mainRuleSet, (Constraint.Descriptor)Constraint.SEC_ROUTE_LAYER, null);
            if (primaryLayer != null) {
                aPrimaryLayer = primaryLayer;
            }
            if (secondaryLayer != null) {
                aSecondaryLayer = secondaryLayer;
            }
            if ((lus = (Constraint.LayerUseStrategy)RuleSetMgr.getConstraintValue((RuleSet)mainRuleSet, (Constraint.Descriptor)Constraint.LAYER_USE_STRATEGY, null)) == null || lus.equals((Object)Constraint.LayerUseStrategy.JustPrimary)) {
                dppp = new DevicePathPortPair(relativeFrom, sc.getDPPB());
                SingleLayerRouter.RouteInformation ri = new SingleLayerRouter.RouteInformation();
                ri.setRuleSet(mainRuleSet);
                expr = (AExpression)RuleSetMgr.getConstraintValue((RuleSet)mainRuleSet, (Constraint.Descriptor)Constraint.WIRE_WIDTH, (Layer)primaryLayer);
                ri.setWidth(unit.fromUserString((String)expr.evaluate()));
                HierPin viaOnIOPad = this.getOrMakeAVia(dppp.getDPPA(), primaryLayer, true, ri.getWidth());
                ri.setFrom(Topstacle.fromDevicePathPort(viaOnIOPad, primaryLayer));
                ri.getFrom().setShape((AGeom)viaOnIOPad.getPinTemplate().getBoundsOfLargestGeom(primaryLayer));
                HierPin viaOnBump = this.getOrMakeAVia(dppp.getDPPB(), primaryLayer, false, ri.getWidth());
                ri.setTo(Topstacle.fromDevicePathPort(viaOnBump, primaryLayer));
                ri.getTo().setShape((AGeom)viaOnBump.getPinTemplate().getBoundsOfLargestGeom(primaryLayer));
                ri.setClear((Long)RuleSetMgr.getConstraintValue((RuleSet)mainRuleSet, (Constraint.Descriptor)Constraint.WIRE_CLEAR, (Layer)primaryLayer));
                Long traceToPad = (Long)RuleSetMgr.getConstraintValue((RuleSet)mainRuleSet, (Constraint.Descriptor)Constraint.DEF_TRACE_TO_BUMP_CLEAR, (Layer)primaryLayer);
                ri.setTraceToPad(traceToPad == null ? 0L : traceToPad);
                ri.setMaxWidth((Long)RuleSetMgr.getConstraintValue((RuleSet)mainRuleSet, (Constraint.Descriptor)Constraint.MAX_WIRE_WIDTH, (Layer)primaryLayer));
                ri.setPinExitLength(0L);
                ri.setConn((DbObject)sc);
                if (sc != null && RouteQueue.getIgnore(sc)) {
                    ri.setIgnore(true);
                }
                primaryLayerRoutes.add(ri);
                continue;
            }
            dppp = new DevicePathPortPair(relativeFrom, sc.getDPPB());
            SingleLayerRouter.RouteInformation primaryRI = new SingleLayerRouter.RouteInformation();
            primaryRI.setRuleSet(mainRuleSet);
            expr = (AExpression)RuleSetMgr.getConstraintValue((RuleSet)mainRuleSet, (Constraint.Descriptor)Constraint.WIRE_WIDTH, (Layer)primaryLayer);
            primaryRI.setWidth(unit.fromUserString((String)expr.evaluate()));
            SingleLayerRouter.RouteInformation secondaryRI = new SingleLayerRouter.RouteInformation();
            secondaryRI.setRuleSet(mainRuleSet);
            expr = (AExpression)RuleSetMgr.getConstraintValue((RuleSet)mainRuleSet, (Constraint.Descriptor)Constraint.WIRE_WIDTH, (Layer)secondaryLayer);
            secondaryRI.setWidth(unit.fromUserString((String)expr.evaluate()));
            HierPin viaOnIOPad = PackageRouterInterface.makeIoPadVia(dppp.getDPPA(), secondaryLayer, secondaryRI.getWidth());
            secondaryRI.setFrom(Topstacle.fromDevicePathPort(viaOnIOPad, secondaryLayer));
            secondaryRI.getFrom().setShape((AGeom)viaOnIOPad.getPinTemplate().getBoundsOfLargestGeom(secondaryLayer));
            long maxWidth = Math.max(primaryRI.getWidth(), secondaryRI.getWidth());
            HierPin viaOnBump = this.makeMainRDLVia(rvpf, lus, dppp.getDPPB(), secondaryLayer, primaryLayer, dppp.getDPPA(), maxWidth);
            if (viaOnBump == null) {
                ALog.logWarn((String)("Could not find a via location for " + sc.getPathA().toString() + " -> " + sc.getPathB().toString()));
                continue;
            }
            secondaryRI.setTo(Topstacle.fromDevicePathPort(viaOnBump, secondaryLayer));
            secondaryRI.getTo().setShape((AGeom)viaOnBump.getPinTemplate().getBoundsOfLargestGeom(secondaryLayer));
            secondaryRI.setClear((Long)RuleSetMgr.getConstraintValue((RuleSet)mainRuleSet, (Constraint.Descriptor)Constraint.WIRE_CLEAR, (Layer)secondaryLayer));
            Long traceToPad = (Long)RuleSetMgr.getConstraintValue((RuleSet)mainRuleSet, (Constraint.Descriptor)Constraint.DEF_TRACE_TO_BUMP_CLEAR, (Layer)secondaryLayer);
            secondaryRI.setTraceToPad(traceToPad == null ? 0L : traceToPad);
            secondaryRI.setMaxWidth((Long)RuleSetMgr.getConstraintValue((RuleSet)mainRuleSet, (Constraint.Descriptor)Constraint.MAX_WIRE_WIDTH, (Layer)secondaryLayer));
            secondaryRI.setPinExitLength(0L);
            secondaryRI.setConn((DbObject)sc);
            if (sc != null && RouteQueue.getIgnore(sc)) {
                secondaryRI.setIgnore(true);
            }
            secondaryLayerRoutes.add(secondaryRI);
            primaryRI.setFrom(Topstacle.fromDevicePathPort(viaOnBump, secondaryLayer));
            primaryRI.getFrom().setShape((AGeom)viaOnBump.getPinTemplate().getBoundsOfLargestGeom(primaryLayer));
            HierPin theBump = dppp.getDPPB();
            primaryRI.setTo(Topstacle.fromDevicePathPort(theBump, primaryLayer));
            primaryRI.getTo().setShape((AGeom)theBump.getPinTemplate().getBoundsOfLargestGeom(primaryLayer));
            primaryRI.setClear((Long)RuleSetMgr.getConstraintValue((RuleSet)mainRuleSet, (Constraint.Descriptor)Constraint.WIRE_CLEAR, (Layer)primaryLayer));
            traceToPad = (Long)RuleSetMgr.getConstraintValue((RuleSet)mainRuleSet, (Constraint.Descriptor)Constraint.DEF_TRACE_TO_BUMP_CLEAR, (Layer)primaryLayer);
            primaryRI.setTraceToPad(traceToPad == null ? 0L : traceToPad);
            secondaryRI.setMaxWidth((Long)RuleSetMgr.getConstraintValue((RuleSet)mainRuleSet, (Constraint.Descriptor)Constraint.MAX_WIRE_WIDTH, (Layer)primaryLayer));
            primaryRI.setPinExitLength(0L);
            primaryRI.setConn((DbObject)sc);
            if (sc != null && RouteQueue.getIgnore(sc)) {
                secondaryRI.setIgnore(true);
            }
            primaryLayerRoutes.add(primaryRI);
        }
        this.routeThisLayerIteratively(primaryLayerRoutes, aPrimaryLayer, aRuleSet);
        if (secondaryLayerRoutes.size() > 0) {
            this.routeThisLayerIteratively(secondaryLayerRoutes, aSecondaryLayer, aRuleSet);
        }
    }

    protected int failures(ArrayList<SingleLayerRouter.RouteInformation> ris) {
        int failures = 0;
        for (SingleLayerRouter.RouteInformation ri : ris) {
            if (ri.getSucess()) continue;
            ++failures;
        }
        return failures;
    }

    protected ArrayList<SingleLayerRouter.RouteInformation> permuteFailures(ArrayList<SingleLayerRouter.RouteInformation> ris) {
        SingleLayerRouter.RouteInformation ri;
        int i;
        ArrayList<SingleLayerRouter.RouteInformation> copy = new ArrayList<SingleLayerRouter.RouteInformation>();
        ArrayList<SingleLayerRouter.RouteInformation> permuted = new ArrayList<SingleLayerRouter.RouteInformation>();
        copy.addAll(ris);
        for (i = 0; i < ris.size(); ++i) {
            ri = (SingleLayerRouter.RouteInformation)copy.get(i);
            if (ri.getSucess()) continue;
            permuted.add(ri);
        }
        for (i = 0; i < ris.size(); ++i) {
            ri = (SingleLayerRouter.RouteInformation)copy.get(i);
            if (!ri.getSucess()) continue;
            permuted.add(ri);
        }
        return permuted;
    }

    protected void routeTheseLayers(AHashCollection<Layer, SchedConn> layerToSC) {
        AHashCollection schedConnToVias = new AHashCollection();
        Db db = OrbitIO.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        AHashArray layerToRI = new AHashArray();
        RuleSet aRuleSet = null;
        for (Layer l : layerToSC.keySet()) {
            for (SchedConn sc : (LinkedList)layerToSC.get((Object)l)) {
                Substrate s = l.getSubstrate();
                HierPin relativeFrom = sc.getDPPA();
                DevicePath rPath = (DevicePath)relativeFrom.first;
                rPath = rPath.pathToParent(s);
                relativeFrom = new HierPin(rPath, relativeFrom.getPin());
                DevicePathPortPair dppp = new DevicePathPortPair(relativeFrom, sc.getDPPB());
                SingleLayerRouter.RouteInformation ri = new SingleLayerRouter.RouteInformation();
                RuleSet ruleSet = RuleSetMgr.getMyRuleSet((DbObject)sc.getHierPortA().getPin());
                ri.setRuleSet(ruleSet);
                aRuleSet = ruleSet;
                AExpression expr = (AExpression)RuleSetMgr.getConstraintValue((RuleSet)ruleSet, (Constraint.Descriptor)Constraint.WIRE_WIDTH, (Layer)l);
                ri.setWidth(unit.fromUserString((String)expr.evaluate()));
                HierPin viaOnIOPad = this.getOrMakeAVia(dppp.getDPPA(), l, true, ri.getWidth());
                if (((PinInstance)viaOnIOPad.second).getType().equals((Object)PinTemplate.Type.VIA)) {
                    schedConnToVias.add((Object)sc, (Object)viaOnIOPad);
                }
                ri.setFrom(Topstacle.fromDevicePathPort(viaOnIOPad, l));
                ri.getFrom().setShape((AGeom)viaOnIOPad.getPinTemplate().getBoundsOfLargestGeom(l));
                HierPin viaOnBump = this.getOrMakeAVia(dppp.getDPPB(), l, false, ri.getWidth());
                if (((PinInstance)viaOnBump.second).getType().equals((Object)PinTemplate.Type.VIA)) {
                    schedConnToVias.add((Object)sc, (Object)viaOnBump);
                }
                ri.setTo(Topstacle.fromDevicePathPort(viaOnBump, l));
                ri.getTo().setShape((AGeom)viaOnBump.getPinTemplate().getBoundsOfLargestGeom(l));
                ri.setClear((Long)RuleSetMgr.getConstraintValue((RuleSet)ruleSet, (Constraint.Descriptor)Constraint.WIRE_CLEAR, (Layer)l));
                Long traceToPad = (Long)RuleSetMgr.getConstraintValue((RuleSet)ruleSet, (Constraint.Descriptor)Constraint.DEF_TRACE_TO_BUMP_CLEAR, (Layer)l);
                ri.setTraceToPad(traceToPad == null ? 0L : traceToPad);
                ri.setMaxWidth((Long)RuleSetMgr.getConstraintValue((RuleSet)ruleSet, (Constraint.Descriptor)Constraint.MAX_WIRE_WIDTH, (Layer)l));
                ri.setPinExitLength(0L);
                ri.setConn((DbObject)sc);
                if (sc != null && RouteQueue.getIgnore(sc)) {
                    ri.setIgnore(true);
                }
                layerToRI.add((Object)l, (Object)ri);
            }
        }
        for (Layer l : layerToRI.keySet()) {
            this.routeThisLayerIteratively((ArrayList)layerToRI.get((Object)l), l, aRuleSet);
        }
    }

    protected int routeThisLayerIteratively(ArrayList<SingleLayerRouter.RouteInformation> toBeRouted, Layer l, RuleSet aRuleSet) {
        int pass;
        Db db = l.getDb();
        PrettyRouter.clearAllPrettyRouters();
        PrettyRouter pr = PrettyRouter.getPrettyRouter(this.routeOnPath.getLast().getTemplate(), l, true);
        ArrayList<Topstacle> obstacles = new ArrayList<Topstacle>();
        RouterInterface.extractObstacles(obstacles, this.routeOnPath, l);
        pr.setDB(db);
        pr.setParent(this.diePath);
        pr.setLayer(l);
        pr.setObstacles(obstacles);
        pr.debugView();
        pr.setToBeRouted(toBeRouted);
        Constraint.RouteAngle angle = (Constraint.RouteAngle)RuleSetMgr.getConstraintValue((RuleSet)aRuleSet, (Constraint.Descriptor)Constraint.ROUTE_ANGLE, (Layer)l);
        Constraint.FinishingFunction ff = (Constraint.FinishingFunction)RuleSetMgr.getConstraintValue((RuleSet)aRuleSet, (Constraint.Descriptor)Constraint.FINISHING_FUNCTION, (Layer)l);
        pr.setAngle(angle);
        pr.setFinishingFunction(ff);
        pr.setRouteType(PrettyRouter.RouteType.RDL);
        Integer failures = null;
        Integer bestFailures = null;
        int bestPass = 0;
        ArrayList<SingleLayerRouter.RouteInformation> bestOrder = new ArrayList<SingleLayerRouter.RouteInformation>();
        Stopwatch stopWatch = new Stopwatch();
        for (pass = 1; failures == null || failures > 0 && pass <= RDL_MAX_PASS; ++pass) {
            pr.globalRoute(true);
            failures = this.failures(toBeRouted);
            if (bestFailures == null || failures < bestFailures) {
                bestFailures = failures;
                bestOrder.clear();
                bestOrder.addAll(toBeRouted);
                bestPass = pass;
            }
            ALog.logInfo((String)("Layer: " + l.getName() + " Route Pass " + pass + " Attempted: " + toBeRouted.size() + " Failures: " + failures));
            if (failures <= 0 || pass + 1 > RDL_MAX_PASS) continue;
            pr.clearRoutes();
            toBeRouted = this.permuteFailures(toBeRouted);
            pr.setToBeRouted(toBeRouted);
        }
        if (bestFailures > 0 && pass - 1 != bestPass) {
            pr.clearRoutes();
            ALog.logInfo((String)("Returning to pass " + bestPass));
            toBeRouted = bestOrder;
            pr.setToBeRouted(toBeRouted);
            pr.globalRoute(true);
            failures = this.failures(toBeRouted);
            pass = bestPass;
            ALog.logInfo((String)("Layer: " + l.getName() + " Route Pass " + pass + " Attempted: " + toBeRouted.size() + " Failures: " + failures));
        }
        pr.detailRoute();
        int i = 0;
        for (SingleLayerRouter.RouteInformation routeInformation : toBeRouted) {
            RouteQueue.setPriority((SchedConn)routeInformation.getConn(), i++);
        }
        Selection selection = Design.getSelection((Db)db);
        Selection.clearSelection();
        UserCommands.removeConnections();
        for (SingleLayerRouter.RouteInformation ri : toBeRouted) {
            if (!ri.getSucess()) {
                Connection c = Connection.create((Db)db, (HierPin)((HierPin)ri.getFrom().getOwner()), (HierPin)((HierPin)ri.getTo().getOwner()));
                selection.add((DbObject)c);
                Integer n = failures;
                Integer n2 = failures = Integer.valueOf(failures + 1);
                continue;
            }
            RuleSetMgr.setMyRuleSet((RuleSet)ri.getRuleSet(), (DbObject)ri.getWire());
        }
        double d = 0.0;
        for (SingleLayerRouter.RouteInformation ri : toBeRouted) {
            if (!ri.getSucess()) continue;
            d += (double)Design.micronToInternal((Db)db, (double)ri.getWire().getPath().getLength());
        }
        ALog.logInfo((String)("Total Trace Length: " + d));
        stopWatch.stop();
        ALog.logInfo((String)("Route time: " + Stopwatch.formatTime((long)stopWatch.elapsed())));
        OrbitIO.getApp().refreshCurrentView(true);
        return failures;
    }

    public static HierPin makeIoPadVia(HierPin pin, Layer l, Long defaultWidth) {
        PinInstance pinInstance = (PinInstance)pin.second;
        DevicePath devicePath = (DevicePath)pin.first;
        DevicePath diePath = devicePath.pathToLowestDie();
        if (pinInstance.getFirstExternallyConnected() == null) {
            if (!pinInstance.hasShapeOnLayer(l)) {
                HierPin dppIOPad = new HierPin(devicePath, pinInstance);
                HierPin via = ViaFactory.instantiateAVia(diePath, dppIOPad, l, null, null, defaultWidth);
                pinInstance.setChildExternallyConnected(via.getPin());
                return via;
            }
            HierPin dppIOPad = new HierPin(devicePath, pinInstance);
            return dppIOPad;
        }
        HierPin via = new HierPin(diePath, ((PinInstance)pin.second).getFirstExternallyConnected());
        if (((PinInstance)via.second).hasShapeOnLayer(l)) {
            return via;
        }
        HierPin dppIOPad = new HierPin(devicePath, pinInstance);
        via = ViaFactory.instantiateAVia(diePath, dppIOPad, l, null, null, defaultWidth);
        pinInstance.setChildExternallyConnected(via.getPin());
        return via;
    }

    protected HierPin makeMainRDLVia(RDLViaPlacementFactory rvpf, Constraint.LayerUseStrategy vs, HierPin bump, Layer sLayer, Layer pLayer, HierPin ioPort, long defaultWidth) {
        Set ls;
        PinInstance pinInstance = (PinInstance)bump.second;
        DevicePath devicePath = (DevicePath)bump.first;
        this.diePath = devicePath.pathToLowestDie();
        PinInstance pi = ((PinInstance)bump.second).getFirstExternallyConnected();
        if (pi != null && (ls = pi.getLayersInUse().collect(Collectors.toSet())).contains(sLayer) && ls.contains(pLayer)) {
            return new HierPin(this.diePath, pi);
        }
        HierPin dppBumpPad = new HierPin(devicePath, pinInstance);
        HierPin via = ViaFactory.instantiateAVia(this.diePath, dppBumpPad, pLayer, sLayer, null, defaultWidth);
        PinTemplate viaTemplate = via.getPinTemplate();
        APoint2D bumpLoc = rvpf.findRDLViaLoc(via, bump, ioPort, Design.micronToInternal((Db)pinInstance.getDb(), (double)4.0));
        if (bumpLoc == null) {
            return null;
        }
        viaTemplate.setLoc(bumpLoc);
        pinInstance.setChildExternallyConnected(via.getPin());
        via = new HierPin(this.diePath, ((PinInstance)bump.second).getFirstExternallyConnected());
        return via;
    }

    protected HierPin getOrMakeAVia(HierPin pin, Layer l, boolean forIOpad, Long defaultWidth) {
        HierPin via;
        PinInstance pinInstance = (PinInstance)pin.second;
        DevicePath devicePath = (DevicePath)pin.first;
        this.diePath = devicePath.pathToLowestDie();
        if (pinInstance.getFirstExternallyConnected() == null && !pinInstance.hasShapeOnLayer(l)) {
            HierPin dppIOPad = new HierPin(devicePath, pinInstance);
            via = ViaFactory.instantiateAVia(this.diePath, dppIOPad, l, null, null, defaultWidth);
            pinInstance.setChildExternallyConnected(via.getPin());
        }
        if (pinInstance.getFirstExternallyConnected() != null) {
            via = new HierPin(this.diePath, ((PinInstance)pin.second).getFirstExternallyConnected());
            return via;
        }
        return pin;
    }

    static {
        RDL_MAX_PASS = 10;
    }

    public static class RISorter
    implements Comparator<SingleLayerRouter.RouteInformation> {
        @Override
        public int compare(SingleLayerRouter.RouteInformation rI0, SingleLayerRouter.RouteInformation rI1) {
            return Long.compare(rI0.length(), rI1.length());
        }
    }
}

