/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.ACompositeGeom;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AOctagon;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AComboBoxUtil;
import com.sigrity.acl.ui.ADecoratedIcon;
import com.sigrity.acl.ui.AGeomIcon;
import com.sigrity.acl.ui.ATextField;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.CleanupPadTemplateUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.orbit.ui.wb_route.PadTemplateComboBox;
import com.sigrity.tools.dbexplorer.DBEResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PadStackDlg
extends DbDialog {
    protected Substrate mSubstrate;
    protected DevicePath mDevicePath;
    protected boolean mDirty = false;
    protected PadTemplateComboBox mComboPadTemplate;
    protected JButton mDeleteButton;
    protected JButton mCopyButton;
    protected JButton mReplaceButton;
    protected JButton mCloseBtn;
    protected JButton mSaveBtn;
    protected JButton mRevertBtn;
    protected JButton mDeleteUnusedBtn;
    protected JTable mTable;
    protected TableCellRenderer tcr;
    protected LayerListModel mLayerListModel;
    protected PadTemplate mActivePadStack;
    protected boolean mNewSavedPadTemplate = false;
    protected PinSelectionListener mSelectionListener;
    protected boolean selectionChanging = false;
    protected JLabel explanationLabel;
    static final int layerNameColumn = 0;
    static final int viaShapeColumn = 1;
    static final int viaSizeColumn = 2;
    private static final String TITLE = "Edit Padstacks";
    ActionListener SaveAction = ae -> {
        this.mTable.getColumnModel().getColumn(2).getCellEditor().stopCellEditing();
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Saving Changes");){
            Cp.exec((String)"_padstack = %s;", (Object[])new Object[]{CpHelper.getObjCmdStr(this.mActivePadStack)});
            for (LayerListModel.LayerInfo l : this.mLayerListModel.layerInfoRows) {
                if (l.shape == null || l.shape.isEmpty() || l.shape.equals("Complex")) continue;
                Cp.exec((String)"_layer = %s;", (Object[])new Object[]{CpHelper.getObjCmdStr(l.layer)});
                Cp.exec((String)"_padstack.removeLayerShapes (_layer);", (Object[])new Object[0]);
                if (l.shape.equals("Empty")) continue;
                if (!GeomNameTranslator.createGeom(l.shape, l.size)) {
                    ALog.logWarn((String)("Could not create geometry on on layer " + l.layer.getName()));
                }
                Cp.exec((String)"com.sigrity.acl.db.std.LayerShape.create(OrbitIO.getCurDb(), _layer, _padstack, _geom);", (Object[])new Object[0]);
            }
        }
        this.setDirtyStatus(false);
        if (this.mDevicePath != null) {
            this.mDevicePath.getDeviceTemplate().invalidateAll2DIndices();
        }
        this.mNewSavedPadTemplate = true;
        OrbitIO.getApp().refreshCurrentView(false);
    };

    public PadStackDlg(Db db, Window owner) {
        super(db, (Component)owner);
    }

    public static PadStackDlg createDialog(Window owner, DevicePath dp) {
        return PadStackDlg.createDialog(owner, dp, null);
    }

    public static PadStackDlg createDialog(Window owner, Substrate substrate) {
        return PadStackDlg.createDialog(owner, substrate, Design.getDesignPath((Db)substrate.getDb()), null);
    }

    public static PadStackDlg createDialog(Window owner, Substrate substrate, String name) {
        return PadStackDlg.createDialog(owner, substrate, Design.getDesignPath((Db)substrate.getDb()), name);
    }

    public static PadStackDlg createDialog(Window owner, String name, DevicePath dp) {
        if (dp == null) {
            return null;
        }
        return PadStackDlg.createDialog(owner, dp.getSubstrate(), dp, name);
    }

    public static PadStackDlg createDialog(Window owner, Substrate substrate, DevicePath dp, String name) {
        if (substrate == null || dp == null) {
            return null;
        }
        if (!dp.isDesign() && dp.getSubstrate() != substrate) {
            ALog.logError((String)"Attempt to create pad stack editor with a device path('%s') from a different Substrate ('%s') than specified ('%s').", (Object[])new Object[]{dp, dp.getSubstrate().getName(), substrate.getName()});
            return null;
        }
        PadStackDlg dlg = new PadStackDlg(dp.getDb(), owner);
        dlg.init(dp, substrate, null, name);
        return dlg;
    }

    public static PadStackDlg createDialog(Window owner, DevicePath dp, PadTemplate padT) {
        if (dp == null) {
            return null;
        }
        Substrate s = dp.getSubstrate();
        if (s == null && padT != null) {
            s = padT.getSubstrate();
        }
        return PadStackDlg.createDialog(owner, dp, s, padT);
    }

    public static PadStackDlg createDialog(Window owner, Substrate substrate, PadTemplate padT) {
        if (substrate == null) {
            return null;
        }
        return PadStackDlg.createDialog(owner, Design.getDesignPath((Db)substrate.getDb()), substrate, padT);
    }

    private static PadStackDlg createDialog(Window owner, DevicePath dp, Substrate substrate, PadTemplate padT) {
        if (dp == null || substrate == null) {
            return null;
        }
        if (padT != null && padT.getSubstrate() != substrate) {
            ALog.logError((String)"Attempt to create pad stack editor with a pad from a different Substrate ('%s') than specified ('%s').", (Object[])new Object[]{padT.getSubstrate().getName(), substrate.getName()});
            return null;
        }
        if (!dp.isDesign() && dp.getSubstrate() != substrate) {
            ALog.logError((String)"Attempt to create pad stack editor with a device path('%s') from a different Substrate ('%s') than specified ('%s').", (Object[])new Object[]{dp, dp.getSubstrate().getName(), substrate.getName()});
            return null;
        }
        PadStackDlg dlg = new PadStackDlg(dp.getDb(), owner);
        dlg.init(dp, substrate, padT, null);
        return dlg;
    }

    protected void init(DevicePath dp, PadTemplate padT, String newName) {
        Substrate s;
        Substrate substrate = s = dp == null ? null : dp.getSubstrate();
        if (s == null && padT != null) {
            s = padT.getSubstrate();
        }
        if (s == null) {
            return;
        }
        this.init(dp, s, padT, newName);
    }

    protected void init(DevicePath dp, Substrate substrate, PadTemplate padT, String newName) {
        GeomNameTranslator.init();
        this.mDevicePath = dp;
        this.mSubstrate = substrate;
        this.setModal(true);
        if (dp.isDesign()) {
            this.setTitle(String.format("%s (Substrate: %s)", TITLE, this.mSubstrate.getName()));
        } else {
            this.setTitle(String.format("%s (%s)", TITLE, dp));
        }
        GridBagManager l = new GridBagManager(this.getContentPane());
        JPanel topButtons = new JPanel();
        l.push((Container)topButtons, (GridBagConstraints)GridBagManager.LEFT);
        this.mComboPadTemplate = (PadTemplateComboBox)l.add((Component)new PadTemplateComboBox(this.mDevicePath, this.mSubstrate), (GridBagConstraints)GridBagManager.FILLX);
        AComboBoxUtil.setupKeySearch((JComboBox)this.mComboPadTemplate);
        this.mComboPadTemplate.addActionListener(new PadStackSelectedListener());
        JButton newPadstack = new JButton(new NewPadstackAction());
        JButton delPadstack = new JButton(new DeletePadstackAction());
        newPadstack.setToolTipText("Create new padstack");
        newPadstack.setText("");
        delPadstack.setToolTipText("Delete current selected padstack");
        delPadstack.setText("");
        UIUtil.makeToolBarButton((AbstractButton)newPadstack);
        UIUtil.makeToolBarButton((AbstractButton)delPadstack);
        l.add((Component)newPadstack, (GridBagConstraints)GridBagManager.LEFT.insets(0));
        l.add((Component)delPadstack, (GridBagConstraints)GridBagManager.LEFT.insets(0));
        l.addFillX();
        l.pop();
        l.newline();
        this.mTable = new JTable();
        JTableHeader jth = this.mTable.getTableHeader();
        this.tcr = jth.getDefaultRenderer();
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int columnWidth = metrics.charWidth('m');
        int desiredWidth = 30;
        int desiredHeight = 200;
        this.mTable.setPreferredScrollableViewportSize(new Dimension(desiredWidth * columnWidth, desiredHeight));
        this.mTable.setFillsViewportHeight(true);
        this.mTable.setRowSelectionAllowed(false);
        this.mTable.setAutoResizeMode(4);
        this.mLayerListModel = new LayerListModel();
        this.mTable.setModel(this.mLayerListModel);
        this.mTable.addMouseListener(new TableButtonMouseListener(this.mTable));
        this.mTable.setSelectionMode(0);
        this.mTable.setRowHeight(40);
        ColumnHeaderRender chr = new ColumnHeaderRender();
        TableColumn col = this.mTable.getColumnModel().getColumn(0);
        col.setPreferredWidth(8 * columnWidth);
        col.setMinWidth(8 * columnWidth);
        col.setIdentifier(0);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(1);
        col.setPreferredWidth(6 * columnWidth);
        col.setMinWidth(6 * columnWidth);
        col.setIdentifier(1);
        col.setResizable(true);
        JComboBox<Object> box = new JComboBox<Object>();
        for (String s : GeomNameTranslator.getValues()) {
            box.addItem(s);
        }
        col.setCellEditor(new ShapeComboBoxEditor(box));
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(2);
        col.setPreferredWidth(8 * columnWidth);
        col.setMinWidth(8 * columnWidth);
        col.setIdentifier(2);
        col.setResizable(true);
        col.setCellEditor(new GeomDimensionEditor());
        col.setHeaderRenderer(chr);
        this.mTable.setDefaultRenderer(Object.class, new PadStackLayerRenderer());
        this.mTable.setRowSelectionAllowed(true);
        this.mTable.setColumnSelectionAllowed(false);
        l.pushFillAllRemainX("Pad Definition");
        JScrollPane scrollPane = new JScrollPane(this.mTable);
        scrollPane.setMinimumSize(new Dimension(desiredWidth, desiredHeight));
        l.add((Component)scrollPane, (GridBagConstraints)GridBagManager.FILLALL);
        final JPanel previewPanel = new JPanel();
        previewPanel.setPreferredSize(new Dimension(200, 300));
        l.add((Component)previewPanel, (GridBagConstraints)GridBagManager.FILLALL);
        l.pop();
        l.newline();
        this.mTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = PadStackDlg.this.mTable.getSelectedRow();
                if (index < 0 || index >= PadStackDlg.this.mLayerListModel.getRowCount()) {
                    return;
                }
                LayerListModel.LayerInfo layerInfo = PadStackDlg.this.mLayerListModel.getRow(index);
                AGeom[] geoms = layerInfo.getGeoms();
                Layer l = layerInfo.layer;
                ViewColorizer colorizer = OrbitIO.getCurColorizer();
                DevicePath path = l.getSubstrate().getADevicePathUsing();
                APatternColor color = path == null ? null : colorizer.getColor(path, l, true);
                int width = 200;
                int height = 300;
                AGeomIcon icon = null;
                if (geoms.length > 0) {
                    icon = new AGeomIcon(width, height, color == null ? null : color.getColor(), geoms);
                }
                JLabel label = icon != null ? new JLabel((Icon)icon) : new JLabel("No Content");
                previewPanel.removeAll();
                previewPanel.add(label);
                previewPanel.revalidate();
                previewPanel.repaint();
            }
        });
        JPanel btnPanel = new JPanel();
        GridBagManager lBtn = new GridBagManager((Container)btnPanel);
        this.mReplaceButton = new JButton(new ReplacePadStackAction());
        lBtn.add((Component)this.mReplaceButton, (GridBagConstraints)GridBagManager.LEFT);
        lBtn.addFillX();
        this.mDeleteUnusedBtn = new JButton("Delete Unused");
        this.mDeleteUnusedBtn.addActionListener(new DeleteUnusedAction());
        lBtn.add((Component)this.mDeleteUnusedBtn, (GridBagConstraints)GridBagManager.LEFT);
        this.mRevertBtn = new JButton("Revert");
        this.mRevertBtn.addActionListener(new RevertAction());
        lBtn.add((Component)this.mRevertBtn, (GridBagConstraints)GridBagManager.LEFT);
        this.mSaveBtn = new JButton("Save");
        lBtn.add((Component)this.mSaveBtn, (GridBagConstraints)GridBagManager.LEFT);
        this.mSaveBtn.addActionListener(this.SaveAction);
        this.mCloseBtn = new JButton("Save & Close");
        lBtn.add((Component)this.mCloseBtn, (GridBagConstraints)GridBagManager.LEFT);
        l.add((Component)btnPanel, (GridBagConstraints)GridBagManager.FILLX);
        this.mActivePadStack = (PadTemplate)this.mComboPadTemplate.getSelectedItem();
        this.mLayerListModel.buildTable(this.mActivePadStack);
        this.updateLabelsForSelection();
        this.mSelectionListener = new PinSelectionListener();
        Selection s = Selection.getCurrentSelectionForDb((Db)OrbitIO.getCurDb());
        s.addSelectionListener((Selection.SelectionListener)this.mSelectionListener);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)this.mCloseBtn, (JButton)this.mSaveBtn);
        this.pack();
        this.setDirtyStatus(false);
        if (padT != null) {
            this.mComboPadTemplate.setSelectedItem(padT);
        }
        UIUtil.center((Component)((Object)this));
        this.setVisible(true);
    }

    public void removeNotify() {
        super.removeNotify();
        if (OrbitIO.getCurDb() == null) {
            return;
        }
        Selection s = Selection.getCurrentSelectionForDb((Db)OrbitIO.getCurDb());
        if (s != null && this.mSelectionListener != null) {
            s.removeSelectionListener((Selection.SelectionListener)this.mSelectionListener);
        }
    }

    protected void updateLabelsForSelection() {
        int myCount = 0;
        Selection s = Selection.getCurrentSelectionForDb((Db)OrbitIO.getCurDb());
        for (DbObject dbo : s.get(PinInstance.class)) {
            for (DevicePath dp : s.getSelectedPaths(dbo)) {
                if (dp.getSubstrate() != this.mDevicePath.getSubstrate()) continue;
                ++myCount;
            }
        }
        this.mReplaceButton.setText("Replace Selected (" + myCount + ")");
        this.mReplaceButton.setEnabled(myCount != 0);
    }

    protected boolean validatePositiveDouble(String s) {
        ParsePosition parsePosition;
        s = s.trim();
        NumberFormat nf = NumberFormat.getNumberInstance();
        Number n = nf.parse(s, parsePosition = new ParsePosition(0));
        if (n != null) {
            double d = n.doubleValue();
            return d > 0.0 && parsePosition.getIndex() == s.length();
        }
        return false;
    }

    protected boolean validateRowForSize(int row, String overrideString) {
        String shapeString;
        String sizeString = this.mLayerListModel.getRow((int)row).size;
        if (overrideString != null) {
            sizeString = overrideString;
        }
        if ((shapeString = this.mLayerListModel.getRow((int)row).shape).equals("Circle") || shapeString.equals("Octagon")) {
            return this.validatePositiveDouble(sizeString);
        }
        if (shapeString.equals("Rectangle")) {
            int space = sizeString.indexOf(32);
            if (space > 0) {
                String sw = sizeString.substring(0, space);
                String sh = sizeString.substring(space + 1);
                return this.validatePositiveDouble(sw) && this.validatePositiveDouble(sh);
            }
            return false;
        }
        return true;
    }

    public PadTemplate getActivePadTemplate() {
        return this.mActivePadStack;
    }

    protected void setIsEverythignOkStatus() {
        for (int row = 0; row < this.mLayerListModel.getRowCount(); ++row) {
            if (this.validateRowForSize(row, null)) continue;
            this.setCloseState(false);
            this.mSaveBtn.setEnabled(false);
            return;
        }
    }

    protected void setDirtyStatus(boolean dirty) {
        this.mDirty = dirty;
        if (this.mDirty) {
            this.setCloseState(true);
            this.mSaveBtn.setEnabled(true);
            this.mComboPadTemplate.setEnabled(false);
            this.mRevertBtn.setEnabled(true);
            this.mReplaceButton.setEnabled(false);
            this.setIsEverythignOkStatus();
        } else {
            this.setCloseState(false);
            this.mSaveBtn.setEnabled(false);
            this.mComboPadTemplate.setEnabled(true);
            this.mRevertBtn.setEnabled(false);
            this.mReplaceButton.setEnabled(true);
        }
        this.repaint();
    }

    void setCloseState(boolean isSave) {
        if (isSave) {
            this.mCloseBtn.setText("Save & Close");
            this.mCloseBtn.addActionListener(this.SaveAction);
        } else {
            this.mCloseBtn.setText("Close");
            this.mCloseBtn.removeActionListener(this.SaveAction);
        }
    }

    public static void setPadTemplate(String pinTemplateKeyStr, String padTemplateKeyStr) {
        Db db = OrbitIO.getCurDb();
        PinTemplate pinTemplate = (PinTemplate)db.getByKeyStr(PinTemplate.class, pinTemplateKeyStr);
        PadTemplate padTemplate = (PadTemplate)db.getByKeyStr(PadTemplate.class, padTemplateKeyStr);
        pinTemplate.setPadTemplate(padTemplate);
    }

    List<LayerShape> getLayerShapes(Layer l, PadTemplate pt) {
        LinkedList<LayerShape> lss = new LinkedList<LayerShape>();
        if (pt != null) {
            for (LayerShape ls : this.mActivePadStack.getLayerShapes(l)) {
                lss.add(ls);
            }
        }
        return lss;
    }

    class TableButtonMouseListener
    extends MouseAdapter {
        protected JTable table;
        protected JPopupMenu popup;

        public TableButtonMouseListener(JTable table) {
            this.table = table;
        }

        protected void showPopup(MouseEvent e) {
            if (e.getButton() == 3) {
                TableColumnModel columnModel = this.table.getColumnModel();
                int c = columnModel.getColumnIndexAtX(e.getX());
                int r = e.getY() / this.table.getRowHeight();
                if (c == 0) {
                    PopUp p = new PopUp(r, c);
                    p.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public void build(int menuitemdown, int r, int menuitemup) {
            int i;
            int j;
            if (menuitemup == 0) {
                for (j = 1; j < 3; ++j) {
                    for (i = r + 1; i <= menuitemdown; ++i) {
                        PadStackDlg.this.mLayerListModel.setValueAt(PadStackDlg.this.mLayerListModel.getValueAt(r, j), i, j);
                    }
                }
            }
            if (menuitemdown == 0) {
                for (j = 1; j < 3; ++j) {
                    for (i = menuitemup; i < r; ++i) {
                        PadStackDlg.this.mLayerListModel.setValueAt(PadStackDlg.this.mLayerListModel.getValueAt(r, j), i, j);
                    }
                }
            }
            PadStackDlg.this.mTable.clearSelection();
            PadStackDlg.this.setDirtyStatus(true);
            OrbitIO.getApp().refreshCurrentView(false);
        }

        class PopUp
        extends JPopupMenu {
            public PopUp(int r, int c) {
                int count = -1;
                for (Layer L : PadStackDlg.this.mSubstrate.getLayers(Layer.TopFirstSort)) {
                    String str = L.getName();
                    JMenuItem item = new JMenuItem(str);
                    if (++count == r) {
                        item.setOpaque(true);
                        item.setBackground(Color.GRAY);
                    }
                    this.add(item);
                    item.addActionListener(e -> {
                        int num = 0;
                        for (Layer L1 : PadStackDlg.this.mSubstrate.getLayers(Layer.TopFirstSort)) {
                            if (e.getActionCommand().equals(L1.getName())) break;
                            ++num;
                        }
                        if (r <= num) {
                            TableButtonMouseListener.this.build(num, r, 0);
                        } else {
                            TableButtonMouseListener.this.build(0, r, num);
                        }
                    });
                }
            }
        }
    }

    class PadStackInfo {
        List<LayerShape> lss = new LinkedList<LayerShape>();
        int uses;

        PadStackInfo() {
        }
    }

    public class PadStackLayerRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
            LayerListModel.LayerInfo layerInfo = PadStackDlg.this.mLayerListModel.getRow(row);
            this.setIcon(null);
            this.setText(null);
            this.setForeground(Color.black);
            this.setBackground(Color.white);
            this.setToolTipText("");
            if (isSelected) {
                this.setBackground(this.getBackground());
            }
            if (column == 0) {
                Layer l = layerInfo.layer;
                this.setText(l.getName());
                ViewColorizer colorizer = OrbitIO.getCurColorizer();
                DevicePath path = l.getSubstrate().getADevicePathUsing();
                APatternColor pcolor = path == null ? null : colorizer.getColor(path, l, true);
                Color color = pcolor == null ? null : pcolor.getColor();
                int iconWidth = 30;
                if (color == null) {
                    color = Color.black;
                }
                if (layerInfo.shape.equals("Rectangle")) {
                    this.setIcon((Icon)new AColorIcon(30, 30, color, this.getBackground()));
                } else if (layerInfo.shape.equals("Circle")) {
                    this.setIcon((Icon)new AColorIcon(30, color));
                } else if (layerInfo.shape.equals("Octagon")) {
                    this.setIcon((Icon)new AColorIcon(30, color, 8));
                } else {
                    AGeom[] geoms = layerInfo.getGeoms();
                    if (geoms.length > 0) {
                        this.setIcon((Icon)new AGeomIcon(30, 30, color, geoms));
                    } else {
                        this.setIcon((Icon)new AColorIcon(30, 30, this.getBackground(), Color.LIGHT_GRAY));
                    }
                }
                return this;
            }
            if (column == 1) {
                if (!layerInfo.shape.equals("Empty")) {
                    this.setText(layerInfo.shape);
                } else {
                    this.setText("");
                }
            } else if (column == 2) {
                if (layerInfo.shape.equals("Empty")) {
                    this.setText("");
                } else {
                    this.setText(layerInfo.size);
                }
                if (!PadStackDlg.this.validateRowForSize(row, null)) {
                    this.setBackground(Color.pink);
                }
            }
            return this;
        }
    }

    public class ColumnHeaderRender
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (PadStackDlg.this.tcr == null) {
                return null;
            }
            Component component = PadStackDlg.this.tcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel label = null;
            if (!(component instanceof JLabel)) {
                return null;
            }
            label = (JLabel)component;
            label.setToolTipText("");
            if (column == 0) {
                label.setText("Layer");
                label.setToolTipText("");
            }
            if (column == 1) {
                label.setText("Shape");
                label.setIcon(null);
                label.setToolTipText("");
            } else if (column == 2) {
                label.setText("Size");
                label.setIcon(null);
                label.setToolTipText("");
            }
            return component;
        }
    }

    class LayerListModel
    extends AbstractTableModel {
        List<LayerInfo> layerInfoRows = new LinkedList<LayerInfo>();
        private String[] columnNames = new String[]{"Layer", "Shape", "Size"};

        public LayerInfo getRow(int row) {
            return this.layerInfoRows.get(row);
        }

        public void buildTable(PadTemplate pt) {
            this.layerInfoRows.clear();
            PadStackDlg.this.mTable.clearSelection();
            for (Layer l : PadStackDlg.this.mSubstrate.getLayers(Layer.TopFirstSort)) {
                List<LayerShape> lss = PadStackDlg.this.getLayerShapes(l, PadStackDlg.this.mActivePadStack);
                if (lss.size() == 1) {
                    LayerShape ls = lss.get(0);
                    String geomName = GeomNameTranslator.geomToCommonName(ls.getGeom());
                    String sizeName = GeomNameTranslator.geomToSizeString(ls.getGeom());
                    this.layerInfoRows.add(new LayerInfo(l, geomName, sizeName, ls.getGeom()));
                    continue;
                }
                if (lss.size() > 1) {
                    AGeom[] geoms = lss.stream().map(LayerShape::getGeom).collect(Collectors.toList()).toArray(new AGeom[0]);
                    this.layerInfoRows.add(new LayerInfo(l, "Complex", "", geoms));
                    continue;
                }
                this.layerInfoRows.add(new LayerInfo(l, "", ""));
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (PadStackDlg.this.mActivePadStack == null) {
                return false;
            }
            if (col == 0) {
                return false;
            }
            if (this.layerInfoRows.get((int)row).shape.equals("Complex")) {
                return false;
            }
            if (this.layerInfoRows.get((int)row).shape.equals("") && col == 2) {
                return false;
            }
            return !this.layerInfoRows.get((int)row).shape.equals("Empty") || col != 2;
        }

        @Override
        public int getRowCount() {
            return this.layerInfoRows.size();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                this.layerInfoRows.get((int)row).shape = (String)value;
            }
            if (col == 2) {
                this.layerInfoRows.get((int)row).size = (String)value;
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.layerInfoRows.get((int)rowIndex).layer.getName();
            }
            if (columnIndex == 1) {
                return this.layerInfoRows.get((int)rowIndex).shape;
            }
            return this.layerInfoRows.get((int)rowIndex).size;
        }

        class LayerInfo {
            protected Layer layer;
            protected String shape;
            protected String size;
            protected List<AGeom> geomList = new ArrayList<AGeom>();

            public LayerInfo(Layer layer, String shape, String size) {
                this.layer = layer;
                this.shape = shape;
                this.size = size;
            }

            public LayerInfo(Layer layer, String shape, String size, AGeom ... geoms) {
                this(layer, shape, size);
                this.geomList = Arrays.asList(geoms);
            }

            public AGeom[] getGeoms() {
                return this.geomList.toArray(new AGeom[0]);
            }
        }
    }

    class DeletePadstackAction
    extends AbstractAction {
        public DeletePadstackAction() {
            super("Delete Padstack", OrbitIcons.CROSS);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PadStackDlg.this.mActivePadStack = (PadTemplate)PadStackDlg.this.mComboPadTemplate.getSelectedItem();
            if (PadStackDlg.this.mActivePadStack == null) {
                return;
            }
            Cp.exec((String)"%s.deleteFromDb();", (Object[])new Object[]{CpHelper.getObjCmdStr(PadStackDlg.this.mActivePadStack)});
            PadStackDlg.this.mComboPadTemplate.removeItem(PadStackDlg.this.mActivePadStack);
            PadStackDlg.this.mComboPadTemplate.setSelectedItem(null);
            PadStackDlg.this.mActivePadStack = null;
        }
    }

    class NewPadstackAction
    extends AbstractAction {
        public NewPadstackAction() {
            super("New Padstack", (Icon)new ADecoratedIcon(DBEResources.ICON_TSV, UIUtil.getScaledIcon((Icon)OrbitIcons.ADD, (int)10, (int)10), ADecoratedIcon.POSX.RIGHT, ADecoratedIcon.POSY.BOTTOM));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NewPadstackDialog dialog = new NewPadstackDialog(PadStackDlg.this.mDb, (Component)((Object)PadStackDlg.this));
            dialog.setVisible(true);
            String baseName = dialog.getPadName();
            if (baseName == null) {
                return;
            }
            if (baseName.isEmpty()) {
                baseName = "newPadTemplate";
            }
            Cp.exec((String)"_padtemplate = PadTemplate.create(OrbitIO.getCurDb(), %s, \"%s\");", (Object[])new Object[]{CpHelper.getObjCmdStr(PadStackDlg.this.mSubstrate), baseName});
            PadTemplate thisPadTemplate = (PadTemplate)Cp.exec((String)"_padtemplate", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"_padtemplate\");", (Object[])new Object[0]);
            PadStackDlg.this.mComboPadTemplate.addItem(thisPadTemplate);
            PadStackDlg.this.mComboPadTemplate.setSelectedItem(thisPadTemplate);
            PadStackDlg.this.mActivePadStack = thisPadTemplate;
            PadStackDlg.this.setDirtyStatus(true);
            PadStackDlg.this.repaint();
        }
    }

    public static class NewPadstackDialog
    extends DbDialog {
        JTextField mName;
        boolean mApply = false;

        public NewPadstackDialog(Db db, Component owner) {
            super(db, owner);
            this.setTitle("Create New Padstack");
            this.setModal(true);
            GridBagManager l = new GridBagManager((Container)((Object)this));
            this.mName = new JTextField(20);
            this.mName.setText("newPadTemplate");
            l.pushFillX("Pad Definition");
            l.add("Pad Name:");
            l.add((Component)this.mName);
            l.pop();
            JButton cancelBtn = new JButton("Cancel");
            JButton applyBtn = new JButton("Apply");
            l.newline();
            l.addFillX();
            l.add((Component)applyBtn);
            l.add((Component)cancelBtn);
            applyBtn.addActionListener(e -> {
                this.mApply = true;
                this.dispatchEvent(new WindowEvent((Window)((Object)this), 201));
            });
            cancelBtn.addActionListener(e -> {
                this.mApply = false;
                this.dispatchEvent(new WindowEvent((Window)((Object)this), 201));
            });
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)cancelBtn, (JButton)applyBtn);
            this.pack();
            UIUtil.center((Component)((Object)this));
        }

        String getPadName() {
            return this.mApply ? this.mName.getText().trim() : null;
        }
    }

    class PadStackSelectedListener
    implements ActionListener {
        PadStackSelectedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PadStackDlg.this.mActivePadStack = (PadTemplate)PadStackDlg.this.mComboPadTemplate.getSelectedItem();
            PadStackDlg.this.mLayerListModel.buildTable(PadStackDlg.this.mActivePadStack);
            PadStackDlg.this.setDirtyStatus(false);
            PadStackDlg.this.repaint();
        }
    }

    class ReplacePadStackAction
    extends AbstractAction {
        public ReplacePadStackAction() {
            super("Replace Selected");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Db db = OrbitIO.getCurDb();
            Selection s = Design.getSelection((Db)db);
            HashSet<HierPin> pins = new HashSet<HierPin>();
            for (PinInstance pinInst : s.get(PinInstance.class)) {
                for (DevicePath dp : s.getSelectedPaths((DbObject)pinInst)) {
                    pins.add(new HierPin(dp, pinInst));
                }
            }
            for (HierPin hp : pins) {
                PinTemplate pinTemplate = hp.getPinTemplate();
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.PadStackDlg.setPadTemplate (\"%s\", \"%s\");", (Object[])new Object[]{pinTemplate.getKeyStr(), PadStackDlg.this.mActivePadStack.getKeyStr()});
            }
            PadStackDlg.this.setDirtyStatus(false);
            PadStackDlg.this.repaint();
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    class DeleteUnusedAction
    implements ActionListener {
        DeleteUnusedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new CleanupPadTemplateUI(OrbitIO.getMainWindow(), PadStackDlg.this.mDevicePath, PadStackDlg.this.mSubstrate);
        }
    }

    class RevertAction
    implements ActionListener {
        RevertAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PadStackDlg.this.mLayerListModel.buildTable(PadStackDlg.this.mActivePadStack);
            PadStackDlg.this.setDirtyStatus(false);
        }
    }

    class ComboChanged
    implements ActionListener {
        JComboBox<String> box;

        public ComboChanged(JComboBox<String> box, int row) {
            this.box = box;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PadStackDlg.this.setDirtyStatus(false);
        }
    }

    class ShapeComboBoxEditor
    extends DefaultCellEditor {
        JComboBox<Object> myBox;
        int myRow;

        public ShapeComboBoxEditor(JComboBox<Object> box) {
            super(box);
            this.myRow = -1;
            this.myBox = box;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.myRow = row;
            return this.myBox;
        }

        @Override
        public boolean stopCellEditing() {
            boolean state = super.stopCellEditing();
            if (this.myRow >= 0) {
                PadStackDlg.this.mLayerListModel.getRow((int)this.myRow).shape = (String)this.myBox.getSelectedItem();
                PadStackDlg.this.setDirtyStatus(true);
            }
            return state;
        }
    }

    public class GeomDimensionEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component = new ATextField();
        ATextField ftf = (ATextField)this.component;
        int mRow = -1;
        protected Runnable newShapeSize = () -> this.handleNewShapeSize(this.ftf.getText());

        protected void handleNewShapeSize(String soFar) {
            PadStackDlg.this.mSaveBtn.setEnabled(true);
            if (PadStackDlg.this.validateRowForSize(this.mRow, soFar)) {
                PadStackDlg.this.setCloseState(true);
                PadStackDlg.this.mSaveBtn.setEnabled(true);
                this.ftf.setBackground(Color.green);
            } else {
                PadStackDlg.this.setCloseState(false);
                PadStackDlg.this.mSaveBtn.setEnabled(false);
                this.ftf.setBackground(Color.pink);
            }
        }

        public GeomDimensionEditor() {
            this.ftf = (ATextField)this.component;
            this.ftf.setActionHandler(this.newShapeSize);
            this.ftf.setInvokeActionOnTextUpdate(true);
            this.ftf.setBorder(new EditorBorder());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            ((ATextField)this.component).setText(GeomNameTranslator.geomNameToDimension(PadStackDlg.this.mLayerListModel.getRow((int)rowIndex).shape));
            ((ATextField)this.component).setEditable(true);
            ((ATextField)this.component).setBorder(new EditorBorder());
            this.mRow = rowIndex;
            if (!PadStackDlg.this.validateRowForSize(rowIndex, null)) {
                PadStackDlg.this.setBackground(Color.pink);
            }
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return ((ATextField)this.component).getText();
        }

        @Override
        public boolean stopCellEditing() {
            boolean state = super.stopCellEditing();
            if (this.mRow >= 0) {
                PadStackDlg.this.mLayerListModel.getRow((int)this.mRow).size = ((JTextField)this.component).getText();
                PadStackDlg.this.setDirtyStatus(true);
            }
            return state;
        }
    }

    static class EditorBorder
    extends AbstractBorder {
        protected Insets editorBorderInsets = new Insets(4, 2, 4, 0);

        EditorBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 0, 0, h - 2);
            g.drawLine(0, h - 2, w - 1, h - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(1, 1, w - 1, 1);
            g.drawLine(1, 1, 1, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(1, h - 2, 1, h - 2);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.editorBorderInsets;
        }
    }

    public static class GeomNameTranslator {
        static Map<Class<?>, String> geomToName = new HashMap();
        static Map<String, String> geomToDimension = new HashMap<String, String>();
        public static final String RectString = "Rectangle";
        public static final String CircleString = "Circle";
        public static final String OctagonString = "Octagon";
        public static final String OblongString = "Oblong";
        public static final String EmptyString = "Empty";
        public static final String ComplexString = "Complex";

        private GeomNameTranslator() {
        }

        public static List<String> getValues() {
            LinkedList sortedNames = AUtil.linkedList((Object[])new String[0]);
            sortedNames.add(CircleString);
            sortedNames.add(OctagonString);
            sortedNames.add(RectString);
            sortedNames.add(OblongString);
            sortedNames.add(EmptyString);
            return sortedNames;
        }

        public static void init() {
            geomToName.put(ARect.class, RectString);
            geomToDimension.put(geomToName.get(ARect.class), "width height");
            geomToName.put(ACircle.class, CircleString);
            geomToDimension.put(geomToName.get(ACircle.class), "diameter");
            geomToName.put(AOctagon.class, OctagonString);
            geomToDimension.put(geomToName.get(AOctagon.class), "diameter");
            geomToName.put(APolygon.class, ComplexString);
            geomToDimension.put(geomToName.get(AOctagon.class), "");
            geomToName.put(APath.class, OblongString);
            geomToDimension.put(geomToName.get(APath.class), "width height");
            geomToName.put(ACompositeGeom.class, ComplexString);
            geomToDimension.put(geomToName.get(AOctagon.class), "");
            geomToName.put(null, EmptyString);
        }

        public static String geomNameToDimension(String geomName) {
            String name = geomToDimension.get(geomName);
            if (name == null) {
                return "";
            }
            if (name.equalsIgnoreCase(EmptyString)) {
                return "";
            }
            return name;
        }

        public static String geomToCommonName(AGeom geom) {
            if (geom == null) {
                return "";
            }
            if (geom instanceof APath) {
                APath path = (APath)geom;
                if (path.getPointCount() == 2 && path.getExtStyle() == APath.ExtStyle.ROUND) {
                    return OblongString;
                }
                return ComplexString;
            }
            String name = geomToName.get(geom.getClass());
            if (name == null) {
                return ComplexString;
            }
            return name;
        }

        public static boolean createGeom(String geom, String dimensions) {
            int space;
            Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
            AGeom g = null;
            if (geom.equalsIgnoreCase(RectString)) {
                int space2 = dimensions.indexOf(32);
                if (space2 > 0) {
                    String sw = dimensions.substring(0, space2);
                    String sh = dimensions.substring(space2 + 1);
                    long w = unit.fromUserString(sw);
                    long h = unit.fromUserString(sh);
                    g = PadTemplate.PadShapeStyle.createShape((PadTemplate.PadShapeStyle)PadTemplate.PadShapeStyle.Rect, (Object[])new Object[]{w, h});
                }
            } else if (geom.equalsIgnoreCase(CircleString)) {
                long d = unit.fromUserString(dimensions);
                g = PadTemplate.PadShapeStyle.createShape((PadTemplate.PadShapeStyle)PadTemplate.PadShapeStyle.Circle, (Object[])new Object[]{d});
            } else if (geom.equalsIgnoreCase(OctagonString)) {
                long d = unit.fromUserString(dimensions);
                g = PadTemplate.PadShapeStyle.createShape((PadTemplate.PadShapeStyle)PadTemplate.PadShapeStyle.Octagon, (Object[])new Object[]{d});
            } else if (geom.equalsIgnoreCase(OblongString) && (space = dimensions.indexOf(32)) > 0) {
                String sw = dimensions.substring(0, space);
                String sh = dimensions.substring(space + 1);
                long w = unit.fromUserString(sw);
                long h = unit.fromUserString(sh);
                g = PadTemplate.PadShapeStyle.createShape((PadTemplate.PadShapeStyle)PadTemplate.PadShapeStyle.Oblong, (Object[])new Object[]{w, h});
            }
            if (g != null) {
                Cp.exec((String)"_geom = %s;", (Object[])new Object[]{g.getAsStringArg()});
                return true;
            }
            return false;
        }

        public static String geomToSizeString(AGeom geom) {
            Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
            if (geom instanceof ARect) {
                long w = ((ARect)geom).width();
                long h = ((ARect)geom).height();
                return unit.toUserStr(w) + " " + unit.toUserStr(h);
            }
            if (geom instanceof ACircle) {
                long d = ((ACircle)geom).getR() * 2L;
                return unit.toUserStr(d);
            }
            if (geom instanceof AOctagon) {
                AOctagon octagon = (AOctagon)geom;
                long r = octagon.radius();
                if (r == 0L) {
                    r = octagon.getBounds().width() / 2L;
                }
                long d = r * 2L;
                return unit.toUserStr(d);
            }
            if (geom instanceof APolygon) {
                return "";
            }
            if (geom instanceof ACompositeGeom) {
                return "";
            }
            if (geom instanceof APath) {
                APath path = (APath)geom;
                if (path.isOblong()) {
                    long h = path.getBounds().height();
                    long w = path.getBounds().width();
                    return unit.toUserStr(w) + " " + unit.toUserStr(h);
                }
                return "";
            }
            return "";
        }
    }

    class PinSelectionListener
    implements Selection.SelectionListener {
        PinSelectionListener() {
        }

        public void selectionChanged(HashMap<DbClass, Selection.SelSet> set) {
            if (PadStackDlg.this.selectionChanging) {
                return;
            }
            PadStackDlg.this.selectionChanging = true;
            EventQueue.invokeLater(() -> {
                PadStackDlg.this.updateLabelsForSelection();
                PadStackDlg.this.selectionChanging = false;
            });
        }
    }
}

