/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.ui.ACheckBoxList;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.ATristateCheckBox;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.ui.wb_route.PadStackDlg;
import com.sigrity.orbit.ui.wb_route.PadTemplateComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class PadStackSelectorDlg
extends ADialog {
    protected ATristateCheckBox mCbSelectAll;
    protected JButton mBtnEdit;
    protected JButton mBtnApply;
    protected boolean mUserOked = false;
    protected DevicePath mDevicePath;
    protected final DefaultListModel<PadTemplate> mPm = new DefaultListModel();
    protected final ACheckBoxList<PadTemplate> mList = new ACheckBoxList<PadTemplate>((ListModel<PadTemplate>)this.mPm);
    private ActionListener mEditPadStackAction = ae -> {
        PadStackDlg.createDialog((Window)((Object)this), this.mDevicePath);
        this.setupModel(this.mDevicePath);
    };
    protected boolean mInStateUpdate = false;
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PadStackSelectorDlg.this.mUserOked = true;
            UIUtil.closeWindow((Window)((Object)PadStackSelectorDlg.this));
        }
    };

    public static PadStackSelectorDlg showMe(Window owner, DevicePath dp, Set<PadTemplate> initSel) {
        PadStackSelectorDlg lsd = new PadStackSelectorDlg(owner, dp, initSel);
        lsd.setVisible(true);
        return lsd;
    }

    private void setupModel(DevicePath dp) {
        this.mPm.clear();
        if (dp != null) {
            PadTemplateComboBox.findPadTemplates(dp, new HashMap<PadTemplate, Integer>()).stream().forEach(pt -> this.mPm.addElement((PadTemplate)pt));
        } else {
            ALog.logWarn((String)"Empty substrate");
        }
    }

    public PadStackSelectorDlg(Window owner, DevicePath dp, Set<PadTemplate> initSel) {
        super(owner);
        this.mDevicePath = dp;
        this.setModal(true);
        this.setTitle("Select Padstacks");
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        this.mCbSelectAll = (ATristateCheckBox)l.add((Component)new ATristateCheckBox("All"), (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetBottom(0));
        l.newline();
        this.mList.setCellRenderer(new ACheckBoxList.CheckBoxListCellRenderer<PadTemplate>(){

            @Override
            public Boolean isChecked(int idx) {
                return PadStackSelectorDlg.this.mList.isChecked(idx);
            }

            private String usageLayer(PadTemplate pt) {
                StringBuilder s = new StringBuilder();
                ArrayList layers = new ArrayList(pt.getLayers());
                Collections.sort(layers);
                for (Layer l : layers) {
                    if (s.length() > 0) {
                        s.append('/');
                    }
                    s.append(l.getName());
                }
                return s.toString();
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends PadTemplate> list, PadTemplate pt, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, null, index, isSelected, cellHasFocus);
                String text = String.format("<html>%s <font color='gray'>(%s)</font></html>", pt.getName(), this.usageLayer(pt));
                this.mLabel.setText(text);
                return this;
            }
        });
        this.mList.setSelectionMode(0);
        l.add((Component)new JScrollPane(this.mList), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.newline();
        l.push((GridBagConstraints)GridBagManager.RIGHT);
        this.mBtnEdit = (JButton)l.add((Component)new JButton("Edit Padstacks"), (GridBagConstraints)GridBagManager.LEFT);
        this.mBtnEdit.addActionListener(this.mEditPadStackAction);
        this.mBtnApply = (JButton)l.add((Component)new JButton("OK"), (GridBagConstraints)GridBagManager.RIGHT);
        this.mBtnApply.addActionListener(this.mOk);
        JButton btnClose = new JButton("Cancel");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        this.setupModel(dp);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)this.mBtnApply);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
        this.mList.addCheckListener(idx -> this.stateUpdate(() -> {
            boolean allSel = true;
            boolean noneSel = true;
            Set<PadTemplate> curSel = this.getSelected();
            for (PadTemplate pt : AIterableItr.itr(this.mPm.elements())) {
                if (curSel.contains(pt)) {
                    noneSel = false;
                    continue;
                }
                allSel = false;
            }
            Boolean newState = null;
            if (allSel) {
                newState = true;
            } else if (noneSel) {
                newState = false;
            }
            this.mCbSelectAll.setState(newState);
        }));
        this.mCbSelectAll.addActionListener(ae -> this.stateUpdate(() -> {
            if (this.mCbSelectAll.getState() == null) {
                this.mCbSelectAll.setSelected(true);
            }
            this.mList.checkAll(this.mCbSelectAll.isSelected());
        }));
        this.setChecked(initSel);
    }

    protected void stateUpdate(Runnable r) {
        if (this.mInStateUpdate) {
            return;
        }
        this.mInStateUpdate = true;
        try {
            r.run();
        }
        finally {
            this.mInStateUpdate = false;
        }
    }

    protected Integer getIndexOfPadTemplate(LinkedList<APair<Integer, PadTemplate>> pairs, PadTemplate pt) {
        for (APair aPair : pairs) {
            if (aPair.second != pt) continue;
            return (Integer)aPair.first;
        }
        return null;
    }

    protected void setChecked(Set<PadTemplate> pts) {
        if (pts == null) {
            return;
        }
        LinkedList pairs = new LinkedList();
        this.mList.getIndexedItems().forEach(p -> pairs.add(p));
        this.mList.clearChecked();
        pts.forEach(pt -> {
            Integer idx = this.getIndexOfPadTemplate(pairs, (PadTemplate)pt);
            if (idx != null) {
                this.mList.setChecked(idx, true);
            }
        });
    }

    public Set<PadTemplate> getSelected() {
        return this.mList.getCheckedItems().stream().collect(Collectors.toSet());
    }

    public List<PadTemplate> getSelectedInOrder() {
        return this.mList.getCheckedItems().stream().collect(Collectors.toList());
    }

    public boolean getUserOked() {
        return this.mUserOked;
    }
}

