/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AutoCompletion;
import com.sigrity.orbit.DevicePath;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;

public class PadTemplateComboBox
extends JComboBox<PadTemplate> {
    protected HashMap<PadTemplate, Integer> mPadUses = new HashMap();
    DevicePath mDevicePath;
    Substrate mSubstrate;

    public PadTemplateComboBox(DevicePath devicePath, Layer startLayer, Layer endLayer) {
        this(devicePath, devicePath.getSubstrate(), startLayer, endLayer);
    }

    public PadTemplateComboBox(DevicePath devicePath) {
        this(devicePath, null, null);
    }

    public PadTemplateComboBox(DevicePath devicePath, Substrate substrate) {
        this(devicePath, substrate, null, null);
    }

    public PadTemplateComboBox(DevicePath devicePath, Substrate substrate, Layer startLayer, Layer endLayer) {
        this.mDevicePath = devicePath;
        this.mSubstrate = substrate;
        this.mPadUses.clear();
        this.populatePadTemplates(startLayer, endLayer);
        this.setRenderer(new PadTemplateRenderer());
        this.setMinimumSize(new Dimension(200, 24));
        this.setPreferredSize(new Dimension(200, 24));
    }

    public void populatePadTemplates(Layer startLayer, Layer endLayer) {
        this.setModel(new DefaultComboBoxModel());
        if (this.mDevicePath == null) {
            return;
        }
        LinkedList<PadTemplate> elems = new LinkedList<PadTemplate>();
        for (PadTemplate pt : PadTemplateComboBox.findPadTemplates(this.mDevicePath, this.mSubstrate, this.mPadUses)) {
            if (startLayer != null && (!pt.getLayerShapes(startLayer).hasNext() || !pt.getLayerShapes(endLayer).hasNext())) continue;
            elems.add(pt);
        }
        elems.add(null);
        this.setModel(new DefaultComboBoxModel<PadTemplate>(elems.toArray(new PadTemplate[elems.size()])));
        if (this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void populatePadTemplates() {
        this.populatePadTemplates(null, null);
    }

    public Map<PadTemplate, Integer> getPadUses() {
        return this.mPadUses;
    }

    public static List<PadTemplate> findPadTemplates(DevicePath path, Map<PadTemplate, Integer> padUses) {
        if (path == null) {
            assert (false);
            return Collections.emptyList();
        }
        Substrate s = path.getSubstrate();
        if (s == null) {
            assert (false);
            return Collections.emptyList();
        }
        return PadTemplateComboBox.findPadTemplates(path, s, padUses);
    }

    public static List<PadTemplate> findPadTemplates(DevicePath path, Substrate s, Map<PadTemplate, Integer> padUses) {
        if (path == null || s == null) {
            assert (false);
            return Collections.emptyList();
        }
        HashSet<PadTemplate> padTemplates = new HashSet<PadTemplate>();
        for (Layer l : s.getLayers()) {
            for (LayerShape ls : l.getLayerShapes()) {
                DbObject dbo = ls.getOwner();
                if (!(dbo instanceof PadTemplate)) continue;
                padTemplates.add((PadTemplate)dbo);
            }
        }
        ArrayList listOfSortedTemplates = AUtil.arrayList(padTemplates);
        PadTemplateComboBox.calcPadUses(path, s, padUses);
        Collections.sort(listOfSortedTemplates, new PadTemplateSorter(padUses));
        Collections.reverse(listOfSortedTemplates);
        return listOfSortedTemplates;
    }

    public static void calcPadUses(DevicePath devicePath, Map<PadTemplate, Integer> mPadUses) {
        mPadUses.clear();
        Substrate s = devicePath.getSubstrate();
        PadTemplateComboBox.calcPadUses(devicePath, s, mPadUses);
    }

    public static void calcPadUses(DevicePath devicePath, Substrate substrate, Map<PadTemplate, Integer> mPadUses) {
        if (devicePath == null || substrate == null) {
            return;
        }
        for (DevicePath dp : devicePath.getDescendants()) {
            if (dp.getSubstrate() != substrate) continue;
            for (PinTemplate pt : dp.getDeviceTemplate().getPins()) {
                PadTemplate padTemplate = pt.getPadTemplate();
                PadTemplateComboBox.incrUses(padTemplate, mPadUses);
            }
        }
    }

    public static void incrUses(PadTemplate pt, Map<PadTemplate, Integer> uses) {
        Integer use = uses.get(pt);
        use = use == null ? Integer.valueOf(1) : Integer.valueOf(use + 1);
        uses.put(pt, use);
    }

    public void changeDevicePath(DevicePath devicePath) {
        this.changeDevicePath(devicePath, null, null);
    }

    public void changeDevicePath(DevicePath devicePath, Layer startLayer, Layer endLayer) {
        if (devicePath == null) {
            return;
        }
        this.mDevicePath = devicePath;
        this.mSubstrate = devicePath.getSubstrate();
        this.mPadUses.clear();
        this.populatePadTemplates(startLayer, endLayer);
        this.setRenderer(new PadTemplateRenderer());
    }

    public PadTemplate getSelectedPad() {
        return (PadTemplate)this.getSelectedItem();
    }

    public static class PadSearchableComboBox
    extends JComboBox<CPadTemplate> {
        protected Map<PadTemplate, Integer> mPadUses = new HashMap<PadTemplate, Integer>();
        protected DevicePath mDevicePath;
        protected AutoCompletion mAuto;

        public Map<PadTemplate, Integer> getPadUses() {
            return this.mPadUses;
        }

        public PadSearchableComboBox(DevicePath devicePath, Layer startLayer, Layer endLayer) {
            this.mDevicePath = devicePath;
            this.mPadUses.clear();
            this.populatePadTemplates(startLayer, endLayer);
            this.setRenderer(new PadSearchRenderer());
        }

        public PadSearchableComboBox(DevicePath devicePath) {
            this(devicePath, null, null);
        }

        public void populatePadTemplates(Layer startLayer, Layer endLayer) {
            this.setModel(new DefaultComboBoxModel());
            if (this.mAuto != null) {
                this.mAuto.close();
                this.mAuto = null;
            }
            if (this.mDevicePath == null) {
                return;
            }
            LinkedList<CPadTemplate> elems = new LinkedList<CPadTemplate>();
            for (PadTemplate pt : PadTemplateComboBox.findPadTemplates(this.mDevicePath, this.mPadUses)) {
                if (startLayer != null && (!pt.getLayerShapes(startLayer).hasNext() || !pt.getLayerShapes(endLayer).hasNext())) continue;
                elems.add(new CPadTemplate(pt));
            }
            elems.add(null);
            this.setModel(new DefaultComboBoxModel<CPadTemplate>(elems.toArray(new CPadTemplate[elems.size()])));
            if (this.getItemCount() > 0) {
                this.setSelectedIndex(0);
                this.mAuto = AutoCompletion.enable((JComboBox)this);
            }
        }

        public void changeDevicePath(DevicePath devicePath, Layer startLayer, Layer endLayer) {
            this.mDevicePath = devicePath;
            this.mPadUses.clear();
            this.populatePadTemplates(startLayer, endLayer);
        }

        public PadTemplate getSelectedPad() {
            return ((CPadTemplate)this.getSelectedItem()).pad;
        }

        public class PadSearchRenderer
        extends DefaultListCellRenderer {
            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
                CPadTemplate pt = (CPadTemplate)value;
                if (pt == null) {
                    this.setText("No Via");
                } else {
                    Integer uses = PadSearchableComboBox.this.mPadUses.get(pt.pad);
                    if (uses == null) {
                        uses = 0;
                    }
                    String num = " (" + uses + ")";
                    this.setText(pt.getName() + num);
                }
                return this;
            }
        }
    }

    private static class CPadTemplate {
        private PadTemplate pad;

        CPadTemplate(PadTemplate pt) {
            this.pad = pt;
        }

        public String getName() {
            return this.pad.getName();
        }

        public String toString() {
            return this.getName();
        }
    }

    private static class PadTemplateSorter
    implements Comparator<PadTemplate> {
        Map<PadTemplate, Integer> uses;

        public PadTemplateSorter(Map<PadTemplate, Integer> uses) {
            this.uses = uses;
        }

        @Override
        public int compare(PadTemplate p1, PadTemplate p2) {
            return p2.getName().compareTo(p1.getName());
        }
    }

    private class PadTemplateRenderer
    extends DefaultListCellRenderer {
        private PadTemplateRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
            PadTemplate pt = (PadTemplate)value;
            if (pt == null) {
                this.setText("No Via");
            } else {
                Integer uses = PadTemplateComboBox.this.mPadUses.get(pt);
                if (uses == null) {
                    uses = 0;
                }
                String num = " (" + uses + ")";
                this.setText(pt.getName() + num);
            }
            return this;
        }
    }
}

