/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.TemplateListRenderer;
import com.sigrity.orbit.DevicePath;
import java.awt.Dimension;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class PinDeviceComboBox
extends JComboBox<DeviceTemplate> {
    DevicePath mDevicePath;

    public PinDeviceComboBox(DevicePath devicePath, Layer startLayer, Layer endLayer) {
        this.mDevicePath = devicePath;
        this.populateDevices(startLayer, endLayer);
        this.setRenderer(new TemplateListRenderer("NO PIN DEVICE"));
        this.setPreferredSize(new Dimension(200, 24));
        this.setMinimumSize(new Dimension(200, 24));
    }

    public PinDeviceComboBox(DevicePath devicePath) {
        this.mDevicePath = devicePath;
        this.populateDevices();
        this.setRenderer(new TemplateListRenderer("NO PIN DEVICE"));
        this.setPreferredSize(new Dimension(200, 24));
        this.setMinimumSize(new Dimension(200, 24));
    }

    public void populateDevices(Layer startLayer, Layer endLayer) {
        this.setModel(new DefaultComboBoxModel());
        if (this.mDevicePath == null) {
            this.addItem(null);
            return;
        }
        Substrate s = this.mDevicePath.getSubstrate();
        LinkedList<DeviceTemplate> elems = new LinkedList<DeviceTemplate>();
        for (DeviceTemplate dt : s.getDeviceTemplates()) {
            boolean containStartLayer;
            if (dt.getType() != DeviceTemplate.Type.BUMP || !(containStartLayer = startLayer == null || dt.getPins().stream().flatMap(pinT -> pinT.getPortTemplates().stream()).flatMap(portT -> portT.getLayers().stream()).anyMatch(l -> l == startLayer))) continue;
            elems.add(dt);
        }
        elems.add(null);
        this.setModel(new DefaultComboBoxModel<DeviceTemplate>(elems.toArray(new DeviceTemplate[elems.size()])));
        if (this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void populateDevices() {
        this.populateDevices(null, null);
    }

    public void changeDevicePath(DevicePath devicePath, Layer startLayer, Layer endLayer) {
        this.mDevicePath = devicePath;
        this.populateDevices(startLayer, endLayer);
    }

    public void changeDevicePath(DevicePath devicePath) {
        this.mDevicePath = devicePath;
        this.populateDevices(null, null);
    }

    public static class DeviceSorter
    implements Comparator<Device> {
        @Override
        public int compare(Device p1, Device p2) {
            return p2.getName().compareTo(p1.getName());
        }
    }
}

