/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AColorChooserDlg;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.SimpleConstraintFrame;
import com.sigrity.orbit.ui.wb_route.BondRingDefinitionEditDlg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

class RDLRouteGroupDefinitionDialog
extends ADialog {
    protected AAppView mView;
    protected Personality mPersonality = null;
    protected JTextField mTxtName;
    protected JTextField mFingerWidth;
    protected AColorIcon mIconColor;
    protected JRadioButton mMetalRing;
    protected JRadioButton mFingerRing;
    protected boolean mAccepted = false;
    protected SimpleConstraintFrame simpleConstraintFrame;
    protected boolean mSaveOnlyChanged;
    protected Substrate mSubstrate = null;
    protected ActionListener mChangeColor = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AColorChooserDlg ccd = AColorChooserDlg.createDialog((Component)((Object)RDLRouteGroupDefinitionDialog.this), "Select Color", RDLRouteGroupDefinitionDialog.this.mIconColor.getColor());
            ccd.setShowOpacity(true);
            Color c = ccd.doModal();
            if (c != null) {
                RDLRouteGroupDefinitionDialog.this.mIconColor.setColor(c);
            }
        }
    };
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AFieldValidator.validateText((JTextComponent)RDLRouteGroupDefinitionDialog.this.mTxtName);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            RDLRouteGroupDefinitionDialog.this.mAccepted = true;
            UIUtil.closeWindow((Window)((Object)RDLRouteGroupDefinitionDialog.this));
        }
    };
    protected ActionListener mApply = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AFieldValidator.validateText((JTextComponent)RDLRouteGroupDefinitionDialog.this.mTxtName);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            if (RDLRouteGroupDefinitionDialog.this.mPersonality != null) {
                RDLRouteGroupDefinitionDialog.this.simpleConstraintFrame.doSave((DbObject)RDLRouteGroupDefinitionDialog.this.mPersonality, RDLRouteGroupDefinitionDialog.this.mSubstrate, RDLRouteGroupDefinitionDialog.this.mSaveOnlyChanged);
            }
            RDLRouteGroupDefinitionDialog.this.mAccepted = true;
        }
    };

    public static RDLRouteGroupDefinitionDialog createDialog(Window owner, String title, Personality personality, Substrate substrate, boolean saveOnlyChanged) {
        RDLRouteGroupDefinitionDialog dlg = null;
        dlg = new RDLRouteGroupDefinitionDialog(owner);
        dlg.setTitle(title);
        dlg.init(personality, substrate, saveOnlyChanged);
        return dlg;
    }

    public RDLRouteGroupDefinitionDialog(Window owner) throws HeadlessException {
        super(owner);
        this.setRecallBounds(false);
    }

    public boolean getAccepted() {
        return this.mAccepted;
    }

    public String getPersonalityName() {
        return this.mTxtName.getText();
    }

    public Color getPersonalityColor() {
        return this.mIconColor.getColor();
    }

    protected void init(Personality personality, Substrate substrate, boolean saveOnlyChanged) {
        this.mView = OrbitIO.getCurView();
        this.mPersonality = personality;
        this.mSaveOnlyChanged = saveOnlyChanged;
        this.mSubstrate = substrate;
        this.setTitle("RDL Route Group Descriptor");
        this.setModal(true);
        GridBagManager l = new GridBagManager(this.getContentPane());
        Border etch = BorderFactory.createEtchedBorder();
        JPanel ringBasicPanel = new JPanel();
        ringBasicPanel.setBorder(BorderFactory.createTitledBorder(etch, "Route Info"));
        l.push((Container)ringBasicPanel, (GridBagConstraints)GridBagManager.LEFT);
        l.add("Name:");
        this.mTxtName = new JTextField(10);
        l.add((Component)this.mTxtName, (GridBagConstraints)GridBagManager.FILLX);
        l.pop();
        l.newline();
        Constraint.DescriptorList descList = new Constraint.DescriptorList();
        descList.add((Object)Constraint.BUMP_LAYER);
        descList.add((Object)Constraint.ROUTE_LAYER);
        descList.add((Object)Constraint.WIRE_WIDTH);
        descList.add((Object)Constraint.WIRE_CLEAR);
        this.simpleConstraintFrame = new SimpleConstraintFrame(descList, (DbObject)personality, substrate, BondRingDefinitionEditDlg.BondRingDialogType.Edit);
        this.simpleConstraintFrame.setOpaque(true);
        l.add((Component)this.simpleConstraintFrame, (GridBagConstraints)GridBagManager.FILLY);
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnApply = new JButton("Apply");
        l.add((Component)btnApply, (GridBagConstraints)GridBagManager.RIGHT);
        btnApply.addActionListener(this.mApply);
        JButton btnOk = new JButton("OK");
        l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
        btnOk.addActionListener(this.mOk);
        JButton btnClose = new JButton("Cancel");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
        this.setMinimumSize(this.getPreferredSize());
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.updateUI();
    }

    protected void updateUI() {
        if (this.mPersonality == null) {
            return;
        }
        this.mTxtName.setText(this.mPersonality.getName());
        this.mTxtName.setEnabled(false);
    }
}

