/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.AExpression;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.LayerListRenderer;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.ui.AColorChooserDlg;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.RuleSetMgr;
import com.sigrity.orbit.ui.wb_route.RouterRuleSetDlg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RDLRuleSetDlg
extends RouterRuleSetDlg {
    RouterRuleSetDlg.DialogMode mode;
    protected boolean mSingleLayerMode = false;
    JTextField ruleName;
    JComboBox<Object> cloneFrom;
    JComboBox<Object> editRuleSetCombo;
    JComboBox<Constraint.LayerUseStrategy> lStrategy;
    JComboBox<Constraint.MaxRoutesPerBump> maxRoutesPerBump;
    AColorIcon mIconColor;
    JComboBox<Layer> pLayer;
    JComboBox<Layer> sLayer;
    JTextField pMaxWidth;
    JTextField sMaxWidth;
    JTextField pDefWidth;
    JTextField sDefWidth;
    JTextField pDefClr;
    JTextField sDefClr;
    JTextField sDefTPClr;
    JTextField pDefTPClr;
    JComboBox<Constraint.RouteAngle> pAngle;
    JComboBox<Constraint.RouteAngle> sAngle;
    JComboBox<Constraint.FinishingFunction> pFinishingFunction;
    JComboBox<Constraint.FinishingFunction> sFinishingFunction;
    protected Substrate substrate;
    protected RuleSet editingRuleSet;
    JLabel messageLabel;
    JLabel gridDef;
    JButton btnApply;
    LinkedList<JTextField> doubleFields = new LinkedList();
    protected ActionListener mApply = e -> {
        Db db = OrbitIO.getCurDb();
        DbHistory history = db.getHistory();
        try (DbHistory.DbTransaction transaction = history.newDbTransaction("Apply Constraint");){
            this.putUIToDb();
        }
    };
    protected ActionListener ruleNameChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            RDLRuleSetDlg.this.validate();
        }
    };
    protected ActionListener validateListener = e -> this.validateInput();
    protected ActionListener cloneListener = e -> {
        if (this.cloneFrom.getSelectedItem() instanceof RuleSet) {
            RuleSet cloneFromSet = (RuleSet)this.cloneFrom.getSelectedItem();
            this.putDbToUI(cloneFromSet);
        }
    };
    protected ActionListener editListener = e -> {
        Object selItem = this.editRuleSetCombo.getSelectedItem();
        if (selItem instanceof RuleSet) {
            this.editingRuleSet = (RuleSet)selItem;
            this.putDbToUI(this.editingRuleSet);
        } else {
            this.editingRuleSet = null;
        }
    };
    protected ActionListener mChangeColor = e -> {
        AColorChooserDlg ccd = AColorChooserDlg.createDialog((Component)((Object)this), "Select Color", this.mIconColor.getColor());
        ccd.setShowOpacity(true);
        Color c = ccd.doModal();
        if (c != null) {
            this.mIconColor.setColor(c);
        }
    };
    protected Timer mUpdateTimer = null;
    protected DocumentListener mFilterChanged = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            RDLRuleSetDlg.this.scheduleFilteredDataUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            RDLRuleSetDlg.this.scheduleFilteredDataUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            RDLRuleSetDlg.this.scheduleFilteredDataUpdate();
        }
    };
    protected ActionListener mUpdateAction = e -> this.validateInput();

    public RDLRuleSetDlg(Window owner) {
        super(owner);
    }

    protected void loadLastActionButtons(GridBagManager l) {
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT);
        this.messageLabel = new JLabel("");
        l.add((Component)this.messageLabel, (GridBagConstraints)GridBagManager.LEFT);
        Font btnFont = this.messageLabel.getFont();
        this.messageLabel.setFont(btnFont.deriveFont((float)btnFont.getSize() - 4.0f));
        this.btnApply = new JButton("Apply");
        l.add((Component)this.btnApply, (GridBagConstraints)GridBagManager.RIGHT);
        this.btnApply.addActionListener(this.mApply);
        JButton btnClose = new JButton("Close");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)this.btnApply);
    }

    protected void loadConfigurationBoard(GridBagManager l, RuleSet rs) {
        GridBagConstraints gridLeft = new GridBagConstraints();
        gridLeft.anchor = 17;
        gridLeft.fill = 2;
        gridLeft.gridwidth = 1;
        gridLeft.weightx = 0.9;
        gridLeft.insets = new Insets(2, 8, 2, 8);
        LayerListRenderer layerRenderer = new LayerListRenderer();
        if (this.mode == RouterRuleSetDlg.DialogMode.CreateARule) {
            this.setTitle("Create new RDL Rule - " + this.substrate.getName());
            l.pushFillX("New Rule Set");
            String ruleSetName = "Name";
            l.add((Component)new JLabel(ruleSetName));
            this.ruleName = new JTextField(10);
            this.ruleName.getDocument().addDocumentListener(this.mFilterChanged);
            l.add((Component)this.ruleName);
            l.add((Component)new JLabel("Seed From"));
            this.cloneFrom = new JComboBox();
            this.cloneFrom.setRenderer(new RuleSetRenderer());
            l.add(this.cloneFrom);
            l.pop();
        } else if (this.mode == RouterRuleSetDlg.DialogMode.EditAnyRule) {
            this.setTitle("Edit RDL Rule Sets - " + this.substrate.getName());
            l.pushFillX("Edit Rule Set");
            this.editRuleSetCombo = new JComboBox();
            this.editRuleSetCombo.setRenderer(new RuleSetRenderer());
            l.add(this.editRuleSetCombo, gridLeft);
            l.pop();
        } else if (this.mode == RouterRuleSetDlg.DialogMode.EditARule) {
            this.editingRuleSet = rs;
            this.setTitle("Edit RDL Rule Set " + rs.getName());
        }
        l.newline();
        l.pushFillX("Global Rules For This Route Group");
        l.add((Component)new JLabel("Layer Strategy"), (GridBagConstraints)GridBagManager.LEFT);
        this.lStrategy = new JComboBox();
        l.add(this.lStrategy, gridLeft);
        l.newline();
        l.add((Component)new JLabel("Max Routes Per Bump On Net"), (GridBagConstraints)GridBagManager.LEFT);
        this.maxRoutesPerBump = new JComboBox();
        l.add(this.maxRoutesPerBump, gridLeft);
        l.newline();
        l.add("Color");
        this.mIconColor = new AColorIcon(16, 16, this.getBackground());
        if (this.mode == RouterRuleSetDlg.DialogMode.CreateARule) {
            this.mIconColor.setColor(RuleSetMgr.nextColor());
        }
        if (this.mode == RouterRuleSetDlg.DialogMode.EditARule) {
            this.mIconColor.setColor(rs.getColor());
        }
        JButton mBtnColor = new JButton((Icon)this.mIconColor);
        mBtnColor.setContentAreaFilled(false);
        l.add((Component)mBtnColor, gridLeft);
        mBtnColor.addActionListener(this.mChangeColor);
        l.newline();
        this.gridDef = new JLabel("Grid");
        Font f = this.gridDef.getFont();
        this.gridDef.setFont(f.deriveFont((float)f.getSize() - 4.0f));
        l.add((Component)this.gridDef);
        l.pop();
        l.newline();
        l.pushFillX("Layer Rules For This Route Group");
        l.add((Component)new JLabel(""), (GridBagConstraints)GridBagManager.LEFT);
        l.add((Component)new JLabel("Primary Layer"), (GridBagConstraints)GridBagManager.FILLX);
        if (!this.mSingleLayerMode) {
            l.add((Component)new JLabel("Secondary Layer"));
        }
        l.newline();
        l.add((Component)new JLabel("Layer"), (GridBagConstraints)GridBagManager.LEFT);
        this.pLayer = new JComboBox();
        this.pLayer.setRenderer(layerRenderer);
        this.pLayer.addActionListener(this.validateListener);
        l.add(this.pLayer);
        this.sLayer = new JComboBox();
        this.sLayer.setRenderer(layerRenderer);
        this.sLayer.addActionListener(this.validateListener);
        if (!this.mSingleLayerMode) {
            l.add(this.sLayer);
        }
        l.newline();
        l.newline();
        l.add((Component)new JLabel("Max Trace Width"), (GridBagConstraints)GridBagManager.LEFT);
        this.pMaxWidth = new JTextField(10);
        l.add((Component)this.pMaxWidth);
        this.doubleFields.add(this.pMaxWidth);
        this.sMaxWidth = new JTextField(10);
        if (!this.mSingleLayerMode) {
            l.add((Component)this.sMaxWidth);
        }
        this.doubleFields.add(this.sMaxWidth);
        l.newline();
        l.add((Component)new JLabel("Default Trace Width"), (GridBagConstraints)GridBagManager.LEFT);
        this.pDefWidth = new JTextField(10);
        l.add((Component)this.pDefWidth);
        this.doubleFields.add(this.pDefWidth);
        this.sDefWidth = new JTextField(10);
        if (!this.mSingleLayerMode) {
            l.add((Component)this.sDefWidth);
        }
        this.doubleFields.add(this.sDefWidth);
        l.newline();
        l.add((Component)new JLabel("Default Trace-Trace Clr"), (GridBagConstraints)GridBagManager.LEFT);
        this.pDefClr = new JTextField(10);
        l.add((Component)this.pDefClr);
        this.doubleFields.add(this.pDefClr);
        this.sDefClr = new JTextField(10);
        if (!this.mSingleLayerMode) {
            l.add((Component)this.sDefClr);
        }
        this.doubleFields.add(this.sDefClr);
        l.newline();
        l.add((Component)new JLabel("Default Trace-Bump Clr"), (GridBagConstraints)GridBagManager.LEFT);
        this.pDefTPClr = new JTextField(10);
        l.add((Component)this.pDefTPClr);
        this.doubleFields.add(this.pDefTPClr);
        this.sDefTPClr = new JTextField(10);
        if (!this.mSingleLayerMode) {
            l.add((Component)this.sDefTPClr);
        }
        this.doubleFields.add(this.sDefTPClr);
        l.pop();
        l.newline();
        l.pushFillX("Layer Dependent Rules For All Route Groups");
        l.add((Component)new JLabel(""));
        l.add((Component)new JLabel("Primary Layer"));
        if (!this.mSingleLayerMode) {
            l.add((Component)new JLabel("Secondary Layer"));
        }
        l.newline();
        l.add((Component)new JLabel("Angle"), (GridBagConstraints)GridBagManager.LEFT);
        this.pAngle = new JComboBox();
        l.add(this.pAngle, gridLeft);
        this.sAngle = new JComboBox();
        if (!this.mSingleLayerMode) {
            l.add(this.sAngle, gridLeft);
        }
        l.newline();
        l.add((Component)new JLabel("Finishing "), (GridBagConstraints)GridBagManager.LEFT);
        this.pFinishingFunction = new JComboBox();
        l.add(this.pFinishingFunction, gridLeft);
        this.sFinishingFunction = new JComboBox();
        if (!this.mSingleLayerMode) {
            l.add(this.sFinishingFunction, gridLeft);
        }
        l.pop();
        l.newline();
    }

    protected void loadContentPane(GridBagManager l, RouterRuleSetDlg.DialogMode mode, RuleSet rs) {
        this.loadConfigurationBoard(l, rs);
        this.loadLastActionButtons(l);
    }

    public void showMe(String substrateKey, RouterRuleSetDlg.DialogMode mode, RuleSet rs) {
        this.substrate = (Substrate)OrbitIO.getCurDb().getByKeyStr(Substrate.class, substrateKey);
        this.mode = mode;
        if (this.substrate == null) {
            ALog.logWarn((String)"Substrate not found");
            return;
        }
        this.setModal(true);
        GridBagManager l = new GridBagManager(this.getContentPane());
        this.loadContentPane(l, mode, rs);
        this.setMinimumSize(this.getPreferredSize());
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.loadComboBoxes(mode);
        if (mode == RouterRuleSetDlg.DialogMode.CreateARule) {
            this.cloneFrom.addActionListener(this.cloneListener);
            this.sLayer.setSelectedItem(null);
        } else if (mode == RouterRuleSetDlg.DialogMode.EditAnyRule) {
            this.editRuleSetCombo.addActionListener(this.editListener);
        } else if (mode == RouterRuleSetDlg.DialogMode.EditARule) {
            this.putDbToUI(this.editingRuleSet);
        }
        for (JTextField tf : this.doubleFields) {
            tf.getDocument().addDocumentListener(this.mFilterChanged);
        }
        this.validateInput();
        this.updateGrid();
        this.setMinimumSize(this.getPreferredSize());
        this.setVisible(true);
    }

    @Override
    public RuleSet getRuleSet() {
        return this.editingRuleSet;
    }

    protected void saveUnitConstraint(RuleSet rs, Constraint.Descriptor<?> d, JTextField textField, Layer layer) {
        Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
        if (d.getType().equals(Long.class)) {
            Cp.exec((String)"cstr = com.sigrity.orbit.RuleSetMgr.setConstraintValue(\"%s\", \"%s\", \"%s\", (Long) %dL)", (Object[])new Object[]{rs.getKeyStr(), d.getName(), layer.getKeyStr(), unit.fromUserString(textField.getText())});
        } else if (d.getType().equals(AExpression.class)) {
            Cp.exec((String)"cstr = com.sigrity.orbit.RuleSetMgr.setConstraintValue(\"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{rs.getKeyStr(), d.getName(), layer.getKeyStr(), textField.getText()});
        }
    }

    protected void saveARuleForAllRulesSetsInvolvingThisLayer(Constraint.Descriptor<?> desc, JComboBox<?> combo, Layer layer) {
        LinkedList<RuleSet> toProcess = new LinkedList<RuleSet>();
        for (RuleSet rs : RuleSet.getRuleSets((Substrate)this.substrate)) {
            if (rs.getParent() != null) continue;
            toProcess.add(rs);
        }
        for (RuleSet rs : toProcess) {
            this.saveComboConstraint(rs, desc, combo, layer);
        }
    }

    protected void saveComboConstraint(RuleSet rs, Constraint.Descriptor<?> desc, JComboBox<?> combo, Layer layer) {
        Object o = combo.getSelectedItem();
        String s = ((Enum)o).name();
        if (layer != null) {
            Cp.exec((String)"cstr = com.sigrity.orbit.RuleSetMgr.setConstraintValue(\"%s\",\"%s\", \"%s\", \"%s\");", (Object[])new Object[]{rs.getKeyStr(), desc.getName(), layer.getKeyStr(), s});
        } else {
            Cp.exec((String)"cstr = com.sigrity.orbit.RuleSetMgr.setConstraintValue(\"%s\", \"%s\", null, \"%s\");", (Object[])new Object[]{rs.getKeyStr(), desc.getName(), s});
        }
    }

    protected void saveIntegerConstraint(RuleSet rs, Constraint.Descriptor<?> desc, JTextField f, Layer layer) {
        String s = f.getText();
        Integer i = Integer.parseInt(s);
        if (layer != null) {
            Cp.exec((String)"cstr = com.sigrity.orbit.RuleSetMgr.setConstraintValue(\"%s\",\"%s\",  \"%s\", %d);", (Object[])new Object[]{rs.getKeyStr(), desc.getName(), layer.getKeyStr(), i});
        } else {
            Cp.exec((String)"cstr = com.sigrity.orbit.RuleSetMgr.setConstraintValue(\"%s\",\"%s\",  null, %d);", (Object[])new Object[]{rs.getKeyStr(), desc.getName(), i});
        }
    }

    protected void saveComboConstraint(RuleSet rs, Constraint.Descriptor<?> desc, JComboBox<?> combo) {
        Object o = combo.getSelectedItem();
        String s = ((Enum)o).name();
        Cp.exec((String)"cstr = com.sigrity.orbit.RuleSetMgr.setConstraintValue(\"%s\", \"%s\", null, \"%s\");", (Object[])new Object[]{rs.getKeyStr(), desc.getName(), s});
    }

    protected void saveStringConstraint(RuleSet rs, Constraint.Descriptor<?> desc, String s, Layer layer) {
        if (layer != null) {
            Cp.exec((String)"cstr = com.sigrity.orbit.RuleSetMgr.setConstraintValue(\"%s\",\"%s\",  \"%s\", \"%s\");", (Object[])new Object[]{rs.getKeyStr(), desc.getName(), layer.getKeyStr(), s});
        }
    }

    protected void putUIToDb() {
        String name;
        if (this.mode == RouterRuleSetDlg.DialogMode.CreateARule) {
            name = this.ruleName.getText();
        } else {
            if (this.editingRuleSet == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "No current rule set.", "Error", 0);
                return;
            }
            name = this.editingRuleSet.getName();
        }
        if (this.pLayer.getSelectedItem() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No primary layer.", "Error", 0);
            return;
        }
        if (this.mode == RouterRuleSetDlg.DialogMode.CreateARule) {
            Cp.exec((String)"com.sigrity.acl.db.std.RuleSet.create (\"%s\", \"%s\");", (Object[])new Object[]{name, this.substrate.getKeyStr()});
        }
        Cp.exec((String)"rs = com.sigrity.acl.db.std.RuleSet.get (\"%s\", \"%s\");", (Object[])new Object[]{name, this.substrate.getKeyStr()});
        Cp.exec((String)"rs.clearConstraints();", (Object[])new Object[0]);
        Cp.exec((String)"rs.setColor (\"%s\");", (Object[])new Object[]{AUtil.colorToString((Color)this.mIconColor.getColor())});
        this.editingRuleSet = RuleSet.get((String)name, (String)this.substrate.getKeyStr());
        Cp.exec((String)"com.sigrity.orbit.RuleSetMgr.clrRoutingLayers(rs);", (Object[])new Object[0]);
        Cp.exec((String)"com.sigrity.orbit.RuleSetMgr.setConstraintValue(\"%s\", \"%s\", null, \"%s\");", (Object[])new Object[]{this.editingRuleSet.getKeyStr(), "RouteLayer", ((Layer)this.pLayer.getSelectedItem()).getKeyStr()});
        if (this.sLayer.getSelectedItem() != null) {
            Cp.exec((String)"com.sigrity.orbit.RuleSetMgr.setConstraintValue(\"%s\", \"%s\", null, \"%s\");", (Object[])new Object[]{this.editingRuleSet.getKeyStr(), "SecRouteLayer", ((Layer)this.sLayer.getSelectedItem()).getKeyStr()});
        } else {
            Cp.exec((String)"com.sigrity.orbit.RuleSetMgr.setConstraintValue(\"%s\", \"%s\", null, null);", (Object[])new Object[]{this.editingRuleSet.getKeyStr(), "SecRouteLayer", null, null});
        }
        for (int layer = 0; layer < 2; ++layer) {
            Layer thisLayer;
            if (layer == 0) {
                thisLayer = (Layer)this.pLayer.getSelectedItem();
            } else {
                thisLayer = (Layer)this.sLayer.getSelectedItem();
                if (thisLayer == null) continue;
            }
            boolean isPrimaryLayer = layer == 0;
            this.saveUnitConstraint(this.editingRuleSet, Constraint.MIN_WIRE_WIDTH, isPrimaryLayer ? this.pDefWidth : this.sDefWidth, thisLayer);
            this.saveUnitConstraint(this.editingRuleSet, Constraint.WIRE_WIDTH, isPrimaryLayer ? this.pDefWidth : this.sDefWidth, thisLayer);
            this.saveUnitConstraint(this.editingRuleSet, Constraint.MAX_WIRE_WIDTH, isPrimaryLayer ? this.pMaxWidth : this.sMaxWidth, thisLayer);
            this.saveUnitConstraint(this.editingRuleSet, Constraint.MIN_WIRE_CLEAR, isPrimaryLayer ? this.pDefClr : this.sDefClr, thisLayer);
            this.saveUnitConstraint(this.editingRuleSet, Constraint.WIRE_CLEAR, isPrimaryLayer ? this.pDefClr : this.sDefClr, thisLayer);
            this.saveUnitConstraint(this.editingRuleSet, Constraint.MAX_WIRE_CLEAR, isPrimaryLayer ? this.pDefClr : this.sDefClr, thisLayer);
            this.saveUnitConstraint(this.editingRuleSet, Constraint.DEF_TRACE_TO_BUMP_CLEAR, isPrimaryLayer ? this.pDefTPClr : this.sDefTPClr, thisLayer);
            this.saveComboConstraint(this.editingRuleSet, Constraint.ROUTE_ANGLE, isPrimaryLayer ? this.pAngle : this.sAngle, thisLayer);
            this.saveARuleForAllRulesSetsInvolvingThisLayer(Constraint.ROUTE_ANGLE, isPrimaryLayer ? this.pAngle : this.sAngle, thisLayer);
            this.saveComboConstraint(this.editingRuleSet, Constraint.FINISHING_FUNCTION, isPrimaryLayer ? this.pFinishingFunction : this.sFinishingFunction, thisLayer);
            this.saveARuleForAllRulesSetsInvolvingThisLayer(Constraint.FINISHING_FUNCTION, isPrimaryLayer ? this.pFinishingFunction : this.sFinishingFunction, thisLayer);
        }
        this.saveComboConstraint(this.editingRuleSet, Constraint.MAX_WIRE_PER_PIN, this.maxRoutesPerBump, null);
        this.saveComboConstraint(this.editingRuleSet, Constraint.LAYER_USE_STRATEGY, this.lStrategy, null);
    }

    protected static <T> void updateEnumCombo(JComboBox<T> box, Constraint.Descriptor<T> c) {
        Class classType = c.getType();
        for (Object l : classType.getEnumConstants()) {
            box.addItem(l);
        }
    }

    protected static void updateLayerCombo(Substrate s, JComboBox<Layer> box) {
        ArrayList<Layer> sortedLayers = new ArrayList<Layer>();
        for (Layer l : s.getLayers()) {
            if (!l.isRoutable()) continue;
            sortedLayers.add(l);
        }
        if (sortedLayers.isEmpty()) {
            ALog.logWarn((String)"Cannot find routable layer on '%s'. Please define layers with route/signal/power/mixed type.", (Object[])new Object[]{s});
            return;
        }
        Collections.sort(sortedLayers);
        Collections.reverse(sortedLayers);
        for (Layer l : sortedLayers) {
            box.addItem(l);
        }
        box.addItem(null);
    }

    protected static void updateRuleSetCombo(Substrate s, JComboBox<Object> box) {
        ArrayList<RuleSet> sortedRuleSets = new ArrayList<RuleSet>();
        for (RuleSet rs : s.getDb().getObjects(RuleSet.class)) {
            if (!rs.isTopLevel() || s != rs.getSubstrate()) continue;
            sortedRuleSets.add(rs);
        }
        box.addItem("Choose a rule Set");
        for (RuleSet rs : sortedRuleSets) {
            box.addItem(rs);
        }
    }

    protected void loadComboBoxes(RouterRuleSetDlg.DialogMode mode) {
        if (mode == RouterRuleSetDlg.DialogMode.CreateARule) {
            RDLRuleSetDlg.updateRuleSetCombo(this.substrate, this.cloneFrom);
        } else if (mode == RouterRuleSetDlg.DialogMode.EditAnyRule) {
            RDLRuleSetDlg.updateRuleSetCombo(this.substrate, this.editRuleSetCombo);
        }
        RDLRuleSetDlg.updateLayerCombo(this.substrate, this.pLayer);
        RDLRuleSetDlg.updateLayerCombo(this.substrate, this.sLayer);
        if (this.mSingleLayerMode) {
            this.lStrategy.addItem(Constraint.LayerUseStrategy.JustPrimary);
        } else {
            RDLRuleSetDlg.updateEnumCombo(this.lStrategy, Constraint.LAYER_USE_STRATEGY);
        }
        RDLRuleSetDlg.updateEnumCombo(this.maxRoutesPerBump, Constraint.MAX_WIRE_PER_PIN);
        this.pAngle.addItem(Constraint.RouteAngle.FortyFive);
        this.pAngle.addItem(Constraint.RouteAngle.Ninety);
        this.pAngle.setRenderer(new RouteAngleCellRenderer());
        this.sAngle.addItem(Constraint.RouteAngle.FortyFive);
        this.sAngle.addItem(Constraint.RouteAngle.Ninety);
        this.sAngle.setRenderer(new RouteAngleCellRenderer());
        RDLRuleSetDlg.updateEnumCombo(this.pFinishingFunction, Constraint.FINISHING_FUNCTION);
        RDLRuleSetDlg.updateEnumCombo(this.sFinishingFunction, Constraint.FINISHING_FUNCTION);
    }

    protected void putDbToUI(RuleSet rs) {
        Constraint.MaxRoutesPerBump mbpr;
        Db db = rs.getDb();
        DbHistory history = db.getHistory();
        Unit unit = Design.getUnit((Db)db);
        List layers = RuleSet.getRoutingLayers((RuleSet)rs);
        Layer thisLayer = null;
        boolean secondLayerDefind = false;
        Constraint.LayerUseStrategy lus = (Constraint.LayerUseStrategy)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.LAYER_USE_STRATEGY, null);
        if (lus != null) {
            this.lStrategy.setSelectedItem(lus);
        }
        if ((mbpr = (Constraint.MaxRoutesPerBump)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.MAX_WIRE_PER_PIN, null)) == null) {
            try (DbHistory.DbTransaction transaction = history.newDbTransaction("[Auto] Set Default One Wire Per Bump");){
                Cp.exec((String)"RuleSetMgr.setConstraintValue(\"%s\", \"%s\", %s, \"%s\")", (Object[])new Object[]{rs.getKeyStr(), "Maximum Wires Per Bump", null, "One"});
            }
            mbpr = (Constraint.MaxRoutesPerBump)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.MAX_WIRE_PER_PIN, null);
        }
        if (mbpr != null) {
            this.maxRoutesPerBump.setSelectedItem(mbpr);
        }
        for (int layer = 0; layer < 2 && layer < layers.size(); ++layer) {
            Constraint.FinishingFunction ff;
            Constraint.RouteAngle ra;
            Long ww;
            thisLayer = (Layer)layers.get(layer);
            if (layer == 0) {
                this.pLayer.setSelectedItem(thisLayer);
            } else {
                secondLayerDefind = true;
                this.sLayer.setSelectedItem(thisLayer);
            }
            if (thisLayer == null) continue;
            AExpression e = (AExpression)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.WIRE_WIDTH, (Layer)thisLayer);
            if (e == null) {
                e = (AExpression)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.WIRE_WIDTH, null);
            }
            if (e != null) {
                if (layer == 0) {
                    this.pDefWidth.setText(e.getExpression(false));
                } else {
                    this.sDefWidth.setText(e.getExpression(false));
                }
            }
            if ((ww = (Long)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.MAX_WIRE_WIDTH, (Layer)thisLayer)) == null) {
                ww = (Long)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.MAX_WIRE_WIDTH, null);
            }
            if (ww != null) {
                if (layer == 0) {
                    this.pMaxWidth.setText(unit.toUserStr(ww.longValue()));
                } else {
                    this.sMaxWidth.setText(unit.toUserStr(ww.longValue()));
                }
            }
            if ((ww = (Long)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.WIRE_CLEAR, (Layer)thisLayer)) == null) {
                ww = (Long)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.WIRE_CLEAR, null);
            }
            if (ww != null) {
                if (layer == 0) {
                    this.pDefClr.setText(unit.toUserStr(ww.longValue()));
                } else {
                    this.sDefClr.setText(unit.toUserStr(ww.longValue()));
                }
            }
            if ((ww = (Long)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.DEF_TRACE_TO_BUMP_CLEAR, (Layer)thisLayer)) == null) {
                ww = (Long)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.DEF_TRACE_TO_BUMP_CLEAR, null);
            }
            if (ww != null) {
                if (layer == 0) {
                    this.pDefTPClr.setText(unit.toUserStr(ww.longValue()));
                } else {
                    this.sDefTPClr.setText(unit.toUserStr(ww.longValue()));
                }
            }
            if ((ra = (Constraint.RouteAngle)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.ROUTE_ANGLE, (Layer)thisLayer)) == null) {
                ra = (Constraint.RouteAngle)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.ROUTE_ANGLE, null);
            }
            if (ra != null) {
                if (layer == 0) {
                    this.pAngle.setSelectedItem(ra);
                } else {
                    this.sAngle.setSelectedItem(ra);
                }
            }
            if ((ff = (Constraint.FinishingFunction)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.FINISHING_FUNCTION, (Layer)thisLayer)) == null) {
                ff = (Constraint.FinishingFunction)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.FINISHING_FUNCTION, null);
            }
            if (ff == null) continue;
            if (layer == 0) {
                this.pFinishingFunction.setSelectedItem(ff);
                continue;
            }
            this.sFinishingFunction.setSelectedItem(ff);
        }
        if (!secondLayerDefind) {
            this.sLayer.setSelectedItem(null);
            this.sDefWidth.setEnabled(false);
            this.sMaxWidth.setEnabled(false);
            this.sDefClr.setEnabled(false);
            this.sDefTPClr.setEnabled(false);
            this.sFinishingFunction.setEnabled(false);
            this.sAngle.setEnabled(false);
        } else {
            this.sDefWidth.setEnabled(true);
            this.sMaxWidth.setEnabled(true);
            this.sDefClr.setEnabled(true);
            this.sDefTPClr.setEnabled(false);
            this.sFinishingFunction.setEnabled(true);
            this.sAngle.setEnabled(true);
        }
        this.mIconColor.setColor(rs.getColor());
        this.getContentPane().invalidate();
    }

    protected boolean conflictingRuleName(String name) {
        return RuleSet.get((Db)OrbitIO.getCurDb(), (String)name, (Substrate)this.substrate) != null;
    }

    protected void updateGrid() {
        Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
        AGrid grid = null;
        NamedGrid g = NamedGrid.get((Substrate)this.substrate, (String)"Manufacturing Grid");
        if (g != null) {
            grid = g.getGrid();
        }
        if (g == null || grid == null) {
            this.gridDef.setForeground(Color.RED);
            this.gridDef.setText("Manufacturing Grid: Undefined");
        } else {
            this.gridDef.setForeground(Color.BLUE);
            String ds = unit.toUserStr(grid.getDeltaX());
            this.gridDef.setText("Manufacturing Grid: " + ds);
        }
    }

    protected void validateInput() {
        boolean valid = true;
        this.messageLabel.setForeground(Color.RED);
        if (this.pLayer.getSelectedItem() == null) {
            valid = false;
            this.messageLabel.setText("Primary layer must be specified");
        } else if (this.sLayer.getSelectedItem() == this.pLayer.getSelectedItem()) {
            valid = false;
            this.messageLabel.setText("Primary and Seconday Layers can not be the same");
        }
        if (this.ruleName != null) {
            boolean validRuleName = true;
            if (this.ruleName.getText().isEmpty()) {
                validRuleName = false;
                this.messageLabel.setText("The Name of The Rule Set Can Not Be Blank");
            }
            if (this.conflictingRuleName(this.ruleName.getText())) {
                validRuleName = false;
                this.messageLabel.setText("Conflicting Rule Name");
            }
            if (!validRuleName) {
                this.ruleName.setBackground(Color.PINK);
                valid = false;
            } else {
                this.ruleName.setBackground(Color.WHITE);
            }
        }
        for (JTextField doubleField : this.doubleFields) {
            String s = doubleField.getText().replace(" ", "");
            if (s.isEmpty()) {
                doubleField.setBackground(Color.WHITE);
                continue;
            }
            if (!AFieldValidator.isValidDouble((String)s)) {
                valid = false;
                doubleField.setBackground(Color.PINK);
                this.messageLabel.setText("Invalid Number");
                continue;
            }
            doubleField.setBackground(Color.WHITE);
        }
        if (valid) {
            this.btnApply.setEnabled(true);
            this.messageLabel.setText("");
        } else {
            this.btnApply.setEnabled(false);
        }
        if (this.sLayer.getSelectedItem() == null) {
            this.sDefWidth.setEnabled(false);
            this.sMaxWidth.setEnabled(false);
            this.sDefClr.setEnabled(false);
            this.sFinishingFunction.setEnabled(false);
            this.sDefTPClr.setEnabled(false);
            this.sAngle.setEnabled(false);
        } else {
            this.sDefWidth.setEnabled(true);
            this.sMaxWidth.setEnabled(true);
            this.sDefClr.setEnabled(true);
            this.sFinishingFunction.setEnabled(true);
            this.sDefTPClr.setEnabled(true);
            this.sAngle.setEnabled(true);
        }
        this.getContentPane().invalidate();
    }

    protected void scheduleFilteredDataUpdate() {
        if (this.mUpdateTimer == null) {
            this.mUpdateTimer = new Timer(1000, this.mUpdateAction);
            this.mUpdateTimer.setRepeats(false);
        }
        if (this.mUpdateTimer.isRunning()) {
            this.mUpdateTimer.restart();
        } else {
            this.mUpdateTimer.start();
        }
    }

    public static class RouteAngleCellRenderer
    implements ListCellRenderer<Constraint.RouteAngle> {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        @Override
        public Component getListCellRendererComponent(JList<? extends Constraint.RouteAngle> list, Constraint.RouteAngle value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            renderer.setText(value.getUserName());
            return renderer;
        }
    }

    class RuleSetRenderer
    extends DefaultListCellRenderer {
        RuleSetRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof RuleSet) {
                RuleSet rs = (RuleSet)value;
                this.setText(rs.getName());
                this.setIcon((Icon)new AColorIcon(16, 16, rs.getColor()));
            } else if (value instanceof String) {
                this.setText((String)value);
            }
            return c;
        }
    }
}

