/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.RegexFilterField;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.SimpleConstraintFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class RouteGroupNameEditor
extends ADialog {
    protected AAppView mView;
    protected Personality mPersonality = null;
    protected JTextField mTxtName;
    protected JTextField mFingerWidth;
    protected AColorIcon mIconColor;
    protected JRadioButton mMetalRing;
    protected JRadioButton mFingerRing;
    protected boolean mAccepted = false;
    protected SimpleConstraintFrame simpleConstraintFrame;
    protected boolean mSaveOnlyChanged;
    protected Substrate mSubstrate = null;
    protected JButton mSynButton;
    protected JButton mEditAreaButton;
    protected boolean mRDL = false;
    protected JTable mNetTable;
    protected RegexFilterField mFilterField;
    static final int netNameColumn = 0;
    static final int maxRoutesPerBumpColumn = 1;
    static final int wireWidthColumn = 2;
    static final String COLNET = "Net Name";
    static final String COLMAXROUTES = "Max Routes Per Bump";
    static final String COLWIDTH = "Wire Width";
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AFieldValidator.validateText((JTextComponent)RouteGroupNameEditor.this.mTxtName);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return;
            }
            RouteGroupNameEditor.this.mAccepted = true;
            UIUtil.closeWindow((Window)((Object)RouteGroupNameEditor.this));
        }
    };

    public static RouteGroupNameEditor createDialog(Window owner, String title, Personality personality, Substrate substrate, boolean saveOnlyChanged) {
        RouteGroupNameEditor dlg = null;
        dlg = new RouteGroupNameEditor(owner);
        dlg.setTitle(title);
        dlg.init(personality, substrate, saveOnlyChanged);
        return dlg;
    }

    public RouteGroupNameEditor(Window owner) {
        super(owner);
    }

    public boolean getAccepted() {
        return this.mAccepted;
    }

    public String getPersonalityName() {
        return this.mTxtName.getText();
    }

    public Color getPersonalityColor() {
        return this.mIconColor.getColor();
    }

    protected void init(Personality personality, Substrate substrate, boolean saveOnlyChanged) {
        this.mView = OrbitIO.getCurView();
        this.mPersonality = personality;
        this.mSaveOnlyChanged = saveOnlyChanged;
        this.mSubstrate = substrate;
        this.setModal(true);
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.add("Name:");
        this.mTxtName = new JTextField(20);
        l.add((Component)this.mTxtName, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        this.mTxtName.setMinimumSize(this.mTxtName.getPreferredSize());
        l.newline();
        l.pop();
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.addFillX();
        JButton btnOk = new JButton("OK");
        l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
        btnOk.addActionListener(this.mOk);
        JButton btnClose = new JButton("Cancel");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
        this.pack();
        this.setMinimumSize(this.getMinimumSize());
        UIUtil.center((Component)((Object)this));
    }
}

